/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.AchievementList;
import net.minecraft.server.Block;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.LocaleI18n;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;

public class EntityItem
extends Entity {
    public int age;
    public int pickupDelay;
    private int d = 5;
    public float c = (float)(Math.random() * Math.PI * 2.0);

    public EntityItem(World world, double d, double d2, double d3) {
        super(world);
        this.a(0.25f, 0.25f);
        this.height = this.length / 2.0f;
        this.setPosition(d, d2, d3);
        this.yaw = (float)(Math.random() * 360.0);
        this.motX = (float)(Math.random() * (double)0.2f - (double)0.1f);
        this.motY = 0.2f;
        this.motZ = (float)(Math.random() * (double)0.2f - (double)0.1f);
    }

    public EntityItem(World world, double d, double d2, double d3, ItemStack itemStack) {
        this(world, d, d2, d3);
        this.setItemStack(itemStack);
    }

    @Override
    protected boolean e_() {
        return false;
    }

    public EntityItem(World world) {
        super(world);
        this.a(0.25f, 0.25f);
        this.height = this.length / 2.0f;
    }

    @Override
    protected void a() {
        this.getDataWatcher().a(10, 5);
    }

    @Override
    public void l_() {
        boolean bl;
        super.l_();
        if (this.pickupDelay > 0) {
            --this.pickupDelay;
        }
        this.lastX = this.locX;
        this.lastY = this.locY;
        this.lastZ = this.locZ;
        this.motY -= (double)0.04f;
        this.Z = this.i(this.locX, (this.boundingBox.b + this.boundingBox.e) / 2.0, this.locZ);
        this.move(this.motX, this.motY, this.motZ);
        boolean bl2 = bl = (int)this.lastX != (int)this.locX || (int)this.lastY != (int)this.locY || (int)this.lastZ != (int)this.locZ;
        if (bl || this.ticksLived % 25 == 0) {
            if (this.world.getMaterial(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ)) == Material.LAVA) {
                this.motY = 0.2f;
                this.motX = (this.random.nextFloat() - this.random.nextFloat()) * 0.2f;
                this.motZ = (this.random.nextFloat() - this.random.nextFloat()) * 0.2f;
                this.makeSound("random.fizz", 0.4f, 2.0f + this.random.nextFloat() * 0.4f);
            }
            if (!this.world.isStatic) {
                this.e();
            }
        }
        float f = 0.98f;
        if (this.onGround) {
            f = 0.58800006f;
            int n = this.world.getTypeId(MathHelper.floor(this.locX), MathHelper.floor(this.boundingBox.b) - 1, MathHelper.floor(this.locZ));
            if (n > 0) {
                f = Block.byId[n].frictionFactor * 0.98f;
            }
        }
        this.motX *= (double)f;
        this.motY *= (double)0.98f;
        this.motZ *= (double)f;
        if (this.onGround) {
            this.motY *= -0.5;
        }
        ++this.age;
        if (!this.world.isStatic && this.age >= 6000) {
            this.die();
        }
    }

    private void e() {
        for (EntityItem entityItem : this.world.a(EntityItem.class, this.boundingBox.grow(0.5, 0.0, 0.5))) {
            this.a(entityItem);
        }
    }

    public boolean a(EntityItem entityItem) {
        if (entityItem == this) {
            return false;
        }
        if (!entityItem.isAlive() || !this.isAlive()) {
            return false;
        }
        ItemStack itemStack = this.getItemStack();
        ItemStack itemStack2 = entityItem.getItemStack();
        if (itemStack2.getItem() != itemStack.getItem()) {
            return false;
        }
        if (itemStack2.hasTag() ^ itemStack.hasTag()) {
            return false;
        }
        if (itemStack2.hasTag() && !itemStack2.getTag().equals(itemStack.getTag())) {
            return false;
        }
        if (itemStack2.getItem().n() && itemStack2.getData() != itemStack.getData()) {
            return false;
        }
        if (itemStack2.count < itemStack.count) {
            return entityItem.a(this);
        }
        if (itemStack2.count + itemStack.count > itemStack2.getMaxStackSize()) {
            return false;
        }
        itemStack2.count += itemStack.count;
        entityItem.pickupDelay = Math.max(entityItem.pickupDelay, this.pickupDelay);
        entityItem.age = Math.min(entityItem.age, this.age);
        entityItem.setItemStack(itemStack2);
        this.die();
        return true;
    }

    public void c() {
        this.age = 4800;
    }

    @Override
    public boolean I() {
        return this.world.a(this.boundingBox, Material.WATER, (Entity)this);
    }

    @Override
    protected void burn(int n) {
        this.damageEntity(DamageSource.FIRE, n);
    }

    @Override
    public boolean damageEntity(DamageSource damageSource, float f) {
        if (this.isInvulnerable()) {
            return false;
        }
        if (this.getItemStack() != null && this.getItemStack().id == Item.NETHER_STAR.id && damageSource.c()) {
            return false;
        }
        this.K();
        this.d = (int)((float)this.d - f);
        if (this.d <= 0) {
            this.die();
        }
        return false;
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.setShort("Health", (byte)this.d);
        nBTTagCompound.setShort("Age", (short)this.age);
        if (this.getItemStack() != null) {
            nBTTagCompound.setCompound("Item", this.getItemStack().save(new NBTTagCompound()));
        }
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        this.d = nBTTagCompound.getShort("Health") & 0xFF;
        this.age = nBTTagCompound.getShort("Age");
        NBTTagCompound nBTTagCompound2 = nBTTagCompound.getCompound("Item");
        this.setItemStack(ItemStack.createStack(nBTTagCompound2));
        if (this.getItemStack() == null) {
            this.die();
        }
    }

    @Override
    public void b_(EntityHuman entityHuman) {
        if (this.world.isStatic) {
            return;
        }
        ItemStack itemStack = this.getItemStack();
        int n = itemStack.count;
        if (this.pickupDelay == 0 && entityHuman.inventory.pickup(itemStack)) {
            if (itemStack.id == Block.LOG.id) {
                entityHuman.a(AchievementList.g);
            }
            if (itemStack.id == Item.LEATHER.id) {
                entityHuman.a(AchievementList.t);
            }
            if (itemStack.id == Item.DIAMOND.id) {
                entityHuman.a(AchievementList.w);
            }
            if (itemStack.id == Item.BLAZE_ROD.id) {
                entityHuman.a(AchievementList.z);
            }
            this.makeSound("random.pop", 0.2f, ((this.random.nextFloat() - this.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            entityHuman.receive(this, n);
            if (itemStack.count <= 0) {
                this.die();
            }
        }
    }

    @Override
    public String getLocalizedName() {
        return LocaleI18n.get("item." + this.getItemStack().a());
    }

    @Override
    public boolean aq() {
        return false;
    }

    @Override
    public void b(int n) {
        super.b(n);
        if (!this.world.isStatic) {
            this.e();
        }
    }

    public ItemStack getItemStack() {
        ItemStack itemStack = this.getDataWatcher().getItemStack(10);
        if (itemStack == null) {
            if (this.world != null) {
                this.world.getLogger().severe("Item entity " + this.id + " has no item?!");
            }
            return new ItemStack(Block.STONE);
        }
        return itemStack;
    }

    public void setItemStack(ItemStack itemStack) {
        this.getDataWatcher().watch(10, itemStack);
        this.getDataWatcher().h(10);
    }
}

