/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Block;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityGolem;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityInsentient;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.GenericAttributes;
import net.minecraft.server.IMonster;
import net.minecraft.server.Item;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.PathfinderGoalDefendVillage;
import net.minecraft.server.PathfinderGoalHurtByTarget;
import net.minecraft.server.PathfinderGoalLookAtPlayer;
import net.minecraft.server.PathfinderGoalMeleeAttack;
import net.minecraft.server.PathfinderGoalMoveThroughVillage;
import net.minecraft.server.PathfinderGoalMoveTowardsRestriction;
import net.minecraft.server.PathfinderGoalMoveTowardsTarget;
import net.minecraft.server.PathfinderGoalNearestAttackableTarget;
import net.minecraft.server.PathfinderGoalOfferFlower;
import net.minecraft.server.PathfinderGoalRandomLookaround;
import net.minecraft.server.PathfinderGoalRandomStroll;
import net.minecraft.server.Village;
import net.minecraft.server.World;

public class EntityIronGolem
extends EntityGolem {
    private int bq;
    Village bp;
    private int br;
    private int bs;

    public EntityIronGolem(World world) {
        super(world);
        this.a(1.4f, 2.9f);
        this.getNavigation().a(true);
        this.goalSelector.a(1, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.goalSelector.a(2, new PathfinderGoalMoveTowardsTarget(this, 0.9, 32.0f));
        this.goalSelector.a(3, new PathfinderGoalMoveThroughVillage(this, 0.6, true));
        this.goalSelector.a(4, new PathfinderGoalMoveTowardsRestriction(this, 1.0));
        this.goalSelector.a(5, new PathfinderGoalOfferFlower(this));
        this.goalSelector.a(6, new PathfinderGoalRandomStroll(this, 0.6));
        this.goalSelector.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.goalSelector.a(8, new PathfinderGoalRandomLookaround(this));
        this.targetSelector.a(1, new PathfinderGoalDefendVillage(this));
        this.targetSelector.a(2, new PathfinderGoalHurtByTarget(this, false));
        this.targetSelector.a(3, new PathfinderGoalNearestAttackableTarget(this, EntityInsentient.class, 0, false, true, IMonster.a));
    }

    @Override
    protected void a() {
        super.a();
        this.datawatcher.a(16, (Object)0);
    }

    @Override
    public boolean bf() {
        return true;
    }

    @Override
    protected void bk() {
        if (--this.bq <= 0) {
            this.bq = 70 + this.random.nextInt(50);
            this.bp = this.world.villages.getClosestVillage(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ), 32);
            if (this.bp == null) {
                this.bR();
            } else {
                ChunkCoordinates chunkCoordinates = this.bp.getCenter();
                this.b(chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z, (int)((float)this.bp.getSize() * 0.6f));
            }
        }
        super.bk();
    }

    @Override
    protected void az() {
        super.az();
        this.getAttributeInstance(GenericAttributes.a).setValue(100.0);
        this.getAttributeInstance(GenericAttributes.d).setValue(0.25);
    }

    @Override
    protected int h(int n) {
        return n;
    }

    @Override
    protected void n(Entity entity) {
        if (entity instanceof IMonster && this.aD().nextInt(20) == 0) {
            this.setGoalTarget((EntityLiving)entity);
        }
        super.n(entity);
    }

    @Override
    public void c() {
        int n;
        int n2;
        int n3;
        int n4;
        super.c();
        if (this.br > 0) {
            --this.br;
        }
        if (this.bs > 0) {
            --this.bs;
        }
        if (this.motX * this.motX + this.motZ * this.motZ > 2.500000277905201E-7 && this.random.nextInt(5) == 0 && (n4 = this.world.getTypeId(n3 = MathHelper.floor(this.locX), n2 = MathHelper.floor(this.locY - (double)0.2f - (double)this.height), n = MathHelper.floor(this.locZ))) > 0) {
            this.world.addParticle("tilecrack_" + n4 + "_" + this.world.getData(n3, n2, n), this.locX + ((double)this.random.nextFloat() - 0.5) * (double)this.width, this.boundingBox.b + 0.1, this.locZ + ((double)this.random.nextFloat() - 0.5) * (double)this.width, 4.0 * ((double)this.random.nextFloat() - 0.5), 0.5, ((double)this.random.nextFloat() - 0.5) * 4.0);
        }
    }

    @Override
    public boolean a(Class clazz) {
        if (this.isPlayerCreated() && EntityHuman.class.isAssignableFrom(clazz)) {
            return false;
        }
        return super.a(clazz);
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.setBoolean("PlayerCreated", this.isPlayerCreated());
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.setPlayerCreated(nBTTagCompound.getBoolean("PlayerCreated"));
    }

    @Override
    public boolean m(Entity entity) {
        this.br = 10;
        this.world.broadcastEntityEffect(this, (byte)4);
        boolean bl = entity.damageEntity(DamageSource.mobAttack(this), 7 + this.random.nextInt(15));
        if (bl) {
            entity.motY += (double)0.4f;
        }
        this.makeSound("mob.irongolem.throw", 1.0f, 1.0f);
        return bl;
    }

    public Village bT() {
        return this.bp;
    }

    public void a(boolean bl) {
        this.bs = bl ? 400 : 0;
        this.world.broadcastEntityEffect(this, (byte)11);
    }

    @Override
    protected String r() {
        return "none";
    }

    @Override
    protected String aO() {
        return "mob.irongolem.hit";
    }

    @Override
    protected String aP() {
        return "mob.irongolem.death";
    }

    @Override
    protected void a(int n, int n2, int n3, int n4) {
        this.makeSound("mob.irongolem.walk", 1.0f, 1.0f);
    }

    @Override
    protected void dropDeathLoot(boolean bl, int n) {
        int n2;
        int n3 = this.random.nextInt(3);
        for (n2 = 0; n2 < n3; ++n2) {
            this.b(Block.RED_ROSE.id, 1);
        }
        n2 = 3 + this.random.nextInt(3);
        for (int i = 0; i < n2; ++i) {
            this.b(Item.IRON_INGOT.id, 1);
        }
    }

    public int bV() {
        return this.bs;
    }

    public boolean isPlayerCreated() {
        return (this.datawatcher.getByte(16) & 1) != 0;
    }

    public void setPlayerCreated(boolean bl) {
        byte by = this.datawatcher.getByte(16);
        if (bl) {
            this.datawatcher.watch(16, (byte)(by | 1));
        } else {
            this.datawatcher.watch(16, (byte)(by & 0xFFFFFFFE));
        }
    }

    @Override
    public void die(DamageSource damageSource) {
        if (!this.isPlayerCreated() && this.killer != null && this.bp != null) {
            this.bp.a(this.killer.getName(), -5);
        }
        super.die(damageSource);
    }
}

