/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import java.util.UUID;
import net.minecraft.server.AttributeModifier;
import net.minecraft.server.Block;
import net.minecraft.server.ControllerJump;
import net.minecraft.server.ControllerLook;
import net.minecraft.server.ControllerMove;
import net.minecraft.server.EnchantmentManager;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityAIBodyControl;
import net.minecraft.server.EntityCreeper;
import net.minecraft.server.EntityGhast;
import net.minecraft.server.EntityHanging;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EntityLeash;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntitySenses;
import net.minecraft.server.EntityTameableAnimal;
import net.minecraft.server.GenericAttributes;
import net.minecraft.server.GroupDataEntity;
import net.minecraft.server.IMonster;
import net.minecraft.server.Item;
import net.minecraft.server.ItemArmor;
import net.minecraft.server.ItemStack;
import net.minecraft.server.ItemSword;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagFloat;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.Navigation;
import net.minecraft.server.Packet39AttachEntity;
import net.minecraft.server.PathfinderGoalSelector;
import net.minecraft.server.World;
import net.minecraft.server.WorldServer;

public abstract class EntityInsentient
extends EntityLiving {
    public int a_;
    protected int b;
    private ControllerLook h;
    private ControllerMove moveController;
    private ControllerJump lookController;
    private EntityAIBodyControl bn;
    private Navigation navigation;
    protected final PathfinderGoalSelector goalSelector;
    protected final PathfinderGoalSelector targetSelector;
    private EntityLiving goalTarget;
    private EntitySenses bq;
    private ItemStack[] equipment = new ItemStack[5];
    protected float[] dropChances = new float[5];
    private boolean canPickUpLoot;
    private boolean persistent;
    protected float f;
    private Entity bu;
    protected int g;
    private boolean bv;
    private Entity bw;
    private NBTTagCompound bx;

    public EntityInsentient(World world) {
        super(world);
        this.goalSelector = new PathfinderGoalSelector(world == null || world.methodProfiler == null ? null : world.methodProfiler);
        this.targetSelector = new PathfinderGoalSelector(world == null || world.methodProfiler == null ? null : world.methodProfiler);
        this.h = new ControllerLook(this);
        this.moveController = new ControllerMove(this);
        this.lookController = new ControllerJump(this);
        this.bn = new EntityAIBodyControl(this);
        this.navigation = new Navigation(this, world);
        this.bq = new EntitySenses(this);
        for (int i = 0; i < this.dropChances.length; ++i) {
            this.dropChances[i] = 0.085f;
        }
    }

    @Override
    protected void az() {
        super.az();
        this.aX().b(GenericAttributes.b).setValue(16.0);
    }

    public ControllerLook getControllerLook() {
        return this.h;
    }

    public ControllerMove getControllerMove() {
        return this.moveController;
    }

    public ControllerJump getControllerJump() {
        return this.lookController;
    }

    public Navigation getNavigation() {
        return this.navigation;
    }

    public EntitySenses getEntitySenses() {
        return this.bq;
    }

    public EntityLiving getGoalTarget() {
        return this.goalTarget;
    }

    public void setGoalTarget(EntityLiving entityLiving) {
        this.goalTarget = entityLiving;
    }

    public boolean a(Class clazz) {
        return EntityCreeper.class != clazz && EntityGhast.class != clazz;
    }

    public void n() {
    }

    @Override
    protected void a() {
        super.a();
        this.datawatcher.a(11, (Object)0);
        this.datawatcher.a(10, "");
    }

    public int o() {
        return 80;
    }

    public void p() {
        String string = this.r();
        if (string != null) {
            this.makeSound(string, this.ba(), this.bb());
        }
    }

    @Override
    public void y() {
        super.y();
        this.world.methodProfiler.a("mobBaseTick");
        if (this.isAlive() && this.random.nextInt(1000) < this.a_++) {
            this.a_ = -this.o();
            this.p();
        }
        this.world.methodProfiler.b();
    }

    @Override
    protected int getExpValue(EntityHuman entityHuman) {
        if (this.b > 0) {
            int n = this.b;
            ItemStack[] itemStackArray = this.getEquipment();
            for (int i = 0; i < itemStackArray.length; ++i) {
                if (itemStackArray[i] == null || !(this.dropChances[i] <= 1.0f)) continue;
                n += 1 + this.random.nextInt(3);
            }
            return n;
        }
        return this.b;
    }

    public void q() {
        for (int i = 0; i < 20; ++i) {
            double d = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            double d3 = this.random.nextGaussian() * 0.02;
            double d4 = 10.0;
            this.world.addParticle("explode", this.locX + (double)(this.random.nextFloat() * this.width * 2.0f) - (double)this.width - d * d4, this.locY + (double)(this.random.nextFloat() * this.length) - d2 * d4, this.locZ + (double)(this.random.nextFloat() * this.width * 2.0f) - (double)this.width - d3 * d4, d, d2, d3);
        }
    }

    @Override
    public void l_() {
        super.l_();
        if (!this.world.isStatic) {
            this.bF();
        }
    }

    @Override
    protected float f(float f, float f2) {
        if (this.bf()) {
            this.bn.a();
            return f2;
        }
        return super.f(f, f2);
    }

    protected String r() {
        return null;
    }

    protected int getLootId() {
        return 0;
    }

    @Override
    protected void dropDeathLoot(boolean bl, int n) {
        int n2 = this.getLootId();
        if (n2 > 0) {
            int n3 = this.random.nextInt(3);
            if (n > 0) {
                n3 += this.random.nextInt(n + 1);
            }
            for (int i = 0; i < n3; ++i) {
                this.b(n2, 1);
            }
        }
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.setBoolean("CanPickUpLoot", this.bD());
        nBTTagCompound.setBoolean("PersistenceRequired", this.persistent);
        NBTTagList nBTTagList = new NBTTagList();
        for (int i = 0; i < this.equipment.length; ++i) {
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            if (this.equipment[i] != null) {
                this.equipment[i].save(nBTTagCompound2);
            }
            nBTTagList.add(nBTTagCompound2);
        }
        nBTTagCompound.set("Equipment", nBTTagList);
        NBTTagList nBTTagList2 = new NBTTagList();
        for (int i = 0; i < this.dropChances.length; ++i) {
            nBTTagList2.add(new NBTTagFloat(i + "", this.dropChances[i]));
        }
        nBTTagCompound.set("DropChances", nBTTagList2);
        nBTTagCompound.setString("CustomName", this.getCustomName());
        nBTTagCompound.setBoolean("CustomNameVisible", this.getCustomNameVisible());
        nBTTagCompound.setBoolean("Leashed", this.bv);
        if (this.bw != null) {
            NBTTagCompound nBTTagCompound3 = new NBTTagCompound("Leash");
            if (this.bw instanceof EntityLiving) {
                nBTTagCompound3.setLong("UUIDMost", this.bw.getUniqueID().getMostSignificantBits());
                nBTTagCompound3.setLong("UUIDLeast", this.bw.getUniqueID().getLeastSignificantBits());
            } else if (this.bw instanceof EntityHanging) {
                EntityHanging entityHanging = (EntityHanging)this.bw;
                nBTTagCompound3.setInt("X", entityHanging.x);
                nBTTagCompound3.setInt("Y", entityHanging.y);
                nBTTagCompound3.setInt("Z", entityHanging.z);
            }
            nBTTagCompound.set("Leash", nBTTagCompound3);
        }
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        int n;
        NBTTagList nBTTagList;
        super.a(nBTTagCompound);
        this.h(nBTTagCompound.getBoolean("CanPickUpLoot"));
        this.persistent = nBTTagCompound.getBoolean("PersistenceRequired");
        if (nBTTagCompound.hasKey("CustomName") && nBTTagCompound.getString("CustomName").length() > 0) {
            this.setCustomName(nBTTagCompound.getString("CustomName"));
        }
        this.setCustomNameVisible(nBTTagCompound.getBoolean("CustomNameVisible"));
        if (nBTTagCompound.hasKey("Equipment")) {
            nBTTagList = nBTTagCompound.getList("Equipment");
            for (n = 0; n < this.equipment.length; ++n) {
                this.equipment[n] = ItemStack.createStack((NBTTagCompound)nBTTagList.get(n));
            }
        }
        if (nBTTagCompound.hasKey("DropChances")) {
            nBTTagList = nBTTagCompound.getList("DropChances");
            for (n = 0; n < nBTTagList.size(); ++n) {
                this.dropChances[n] = ((NBTTagFloat)nBTTagList.get((int)n)).data;
            }
        }
        this.bv = nBTTagCompound.getBoolean("Leashed");
        if (this.bv && nBTTagCompound.hasKey("Leash")) {
            this.bx = nBTTagCompound.getCompound("Leash");
        }
    }

    public void n(float f) {
        this.bf = f;
    }

    @Override
    public void i(float f) {
        super.i(f);
        this.n(f);
    }

    @Override
    public void c() {
        super.c();
        this.world.methodProfiler.a("looting");
        if (!this.world.isStatic && this.bD() && !this.aU && this.world.getGameRules().getBoolean("mobGriefing")) {
            List list = this.world.a(EntityItem.class, this.boundingBox.grow(1.0, 0.0, 1.0));
            for (EntityItem entityItem : list) {
                ItemStack itemStack;
                int n;
                if (entityItem.dead || entityItem.getItemStack() == null || (n = EntityInsentient.b(itemStack = entityItem.getItemStack())) <= -1) continue;
                boolean bl = true;
                ItemStack itemStack2 = this.getEquipment(n);
                if (itemStack2 != null) {
                    Item item;
                    Item item2;
                    if (n == 0) {
                        if (itemStack.getItem() instanceof ItemSword && !(itemStack2.getItem() instanceof ItemSword)) {
                            bl = true;
                        } else if (itemStack.getItem() instanceof ItemSword && itemStack2.getItem() instanceof ItemSword) {
                            item2 = (ItemSword)itemStack.getItem();
                            item = (ItemSword)itemStack2.getItem();
                            bl = ((ItemSword)item2).g() == ((ItemSword)item).g() ? itemStack.getData() > itemStack2.getData() || itemStack.hasTag() && !itemStack2.hasTag() : ((ItemSword)item2).g() > ((ItemSword)item).g();
                        } else {
                            bl = false;
                        }
                    } else if (itemStack.getItem() instanceof ItemArmor && !(itemStack2.getItem() instanceof ItemArmor)) {
                        bl = true;
                    } else if (itemStack.getItem() instanceof ItemArmor && itemStack2.getItem() instanceof ItemArmor) {
                        item2 = (ItemArmor)itemStack.getItem();
                        item = (ItemArmor)itemStack2.getItem();
                        bl = ((ItemArmor)item2).c == ((ItemArmor)item).c ? itemStack.getData() > itemStack2.getData() || itemStack.hasTag() && !itemStack2.hasTag() : ((ItemArmor)item2).c > ((ItemArmor)item).c;
                    } else {
                        bl = false;
                    }
                }
                if (!bl) continue;
                if (itemStack2 != null && this.random.nextFloat() - 0.1f < this.dropChances[n]) {
                    this.a(itemStack2, 0.0f);
                }
                this.setEquipment(n, itemStack);
                this.dropChances[n] = 2.0f;
                this.persistent = true;
                this.receive(entityItem, 1);
                entityItem.die();
            }
        }
        this.world.methodProfiler.b();
    }

    @Override
    protected boolean bf() {
        return false;
    }

    protected boolean isTypeNotPersistent() {
        return true;
    }

    protected void u() {
        if (this.persistent) {
            this.aV = 0;
            return;
        }
        EntityHuman entityHuman = this.world.findNearbyPlayer(this, -1.0);
        if (entityHuman != null) {
            double d = entityHuman.locX - this.locX;
            double d2 = entityHuman.locY - this.locY;
            double d3 = entityHuman.locZ - this.locZ;
            double d4 = d * d + d2 * d2 + d3 * d3;
            if (this.isTypeNotPersistent() && d4 > 16384.0) {
                this.die();
            }
            if (this.aV > 600 && this.random.nextInt(800) == 0 && d4 > 1024.0 && this.isTypeNotPersistent()) {
                this.die();
            } else if (d4 < 1024.0) {
                this.aV = 0;
            }
        }
    }

    @Override
    protected void bi() {
        ++this.aV;
        this.world.methodProfiler.a("checkDespawn");
        this.u();
        this.world.methodProfiler.b();
        this.world.methodProfiler.a("sensing");
        this.bq.a();
        this.world.methodProfiler.b();
        this.world.methodProfiler.a("targetSelector");
        this.targetSelector.a();
        this.world.methodProfiler.b();
        this.world.methodProfiler.a("goalSelector");
        this.goalSelector.a();
        this.world.methodProfiler.b();
        this.world.methodProfiler.a("navigation");
        this.navigation.f();
        this.world.methodProfiler.b();
        this.world.methodProfiler.a("mob tick");
        this.bk();
        this.world.methodProfiler.b();
        this.world.methodProfiler.a("controls");
        this.world.methodProfiler.a("move");
        this.moveController.c();
        this.world.methodProfiler.c("look");
        this.h.a();
        this.world.methodProfiler.c("jump");
        this.lookController.b();
        this.world.methodProfiler.b();
        this.world.methodProfiler.b();
    }

    @Override
    protected void bl() {
        super.bl();
        this.be = 0.0f;
        this.bf = 0.0f;
        this.u();
        float f = 8.0f;
        if (this.random.nextFloat() < 0.02f) {
            EntityHuman entityHuman = this.world.findNearbyPlayer(this, f);
            if (entityHuman != null) {
                this.bu = entityHuman;
                this.g = 10 + this.random.nextInt(20);
            } else {
                this.bg = (this.random.nextFloat() - 0.5f) * 20.0f;
            }
        }
        if (this.bu != null) {
            this.a(this.bu, 10.0f, (float)this.bp());
            if (this.g-- <= 0 || this.bu.dead || this.bu.e(this) > (double)(f * f)) {
                this.bu = null;
            }
        } else {
            if (this.random.nextFloat() < 0.05f) {
                this.bg = (this.random.nextFloat() - 0.5f) * 20.0f;
            }
            this.yaw += this.bg;
            this.pitch = this.f;
        }
        boolean bl = this.H();
        boolean bl2 = this.J();
        if (bl || bl2) {
            this.bd = this.random.nextFloat() < 0.8f;
        }
    }

    public int bp() {
        return 40;
    }

    public void a(Entity entity, float f, float f2) {
        double d;
        double d2 = entity.locX - this.locX;
        double d3 = entity.locZ - this.locZ;
        if (entity instanceof EntityLiving) {
            EntityLiving entityLiving = (EntityLiving)entity;
            d = entityLiving.locY + (double)entityLiving.getHeadHeight() - (this.locY + (double)this.getHeadHeight());
        } else {
            d = (entity.boundingBox.b + entity.boundingBox.e) / 2.0 - (this.locY + (double)this.getHeadHeight());
        }
        double d4 = MathHelper.sqrt(d2 * d2 + d3 * d3);
        float f3 = (float)(Math.atan2(d3, d2) * 180.0 / 3.1415927410125732) - 90.0f;
        float f4 = (float)(-(Math.atan2(d, d4) * 180.0 / 3.1415927410125732));
        this.pitch = this.b(this.pitch, f4, f2);
        this.yaw = this.b(this.yaw, f3, f);
    }

    private float b(float f, float f2, float f3) {
        float f4 = MathHelper.g(f2 - f);
        if (f4 > f3) {
            f4 = f3;
        }
        if (f4 < -f3) {
            f4 = -f3;
        }
        return f + f4;
    }

    public boolean canSpawn() {
        return this.world.b(this.boundingBox) && this.world.getCubes(this, this.boundingBox).isEmpty() && !this.world.containsLiquid(this.boundingBox);
    }

    public int bv() {
        return 4;
    }

    @Override
    public int as() {
        if (this.getGoalTarget() == null) {
            return 3;
        }
        int n = (int)(this.getHealth() - this.getMaxHealth() * 0.33f);
        if ((n -= (3 - this.world.difficulty) * 4) < 0) {
            n = 0;
        }
        return n + 3;
    }

    @Override
    public ItemStack aZ() {
        return this.equipment[0];
    }

    @Override
    public ItemStack getEquipment(int n) {
        return this.equipment[n];
    }

    public ItemStack o(int n) {
        return this.equipment[n + 1];
    }

    @Override
    public void setEquipment(int n, ItemStack itemStack) {
        this.equipment[n] = itemStack;
    }

    @Override
    public ItemStack[] getEquipment() {
        return this.equipment;
    }

    @Override
    protected void dropEquipment(boolean bl, int n) {
        for (int i = 0; i < this.getEquipment().length; ++i) {
            boolean bl2;
            ItemStack itemStack = this.getEquipment(i);
            boolean bl3 = bl2 = this.dropChances[i] > 1.0f;
            if (itemStack == null || !bl && !bl2 || !(this.random.nextFloat() - (float)n * 0.01f < this.dropChances[i])) continue;
            if (!bl2 && itemStack.g()) {
                int n2 = Math.max(itemStack.l() - 25, 1);
                int n3 = itemStack.l() - this.random.nextInt(this.random.nextInt(n2) + 1);
                if (n3 > n2) {
                    n3 = n2;
                }
                if (n3 < 1) {
                    n3 = 1;
                }
                itemStack.setData(n3);
            }
            this.a(itemStack, 0.0f);
        }
    }

    protected void bw() {
        if (this.random.nextFloat() < 0.15f * this.world.b(this.locX, this.locY, this.locZ)) {
            float f;
            int n = this.random.nextInt(2);
            float f2 = f = this.world.difficulty == 3 ? 0.1f : 0.25f;
            if (this.random.nextFloat() < 0.095f) {
                ++n;
            }
            if (this.random.nextFloat() < 0.095f) {
                ++n;
            }
            if (this.random.nextFloat() < 0.095f) {
                ++n;
            }
            for (int i = 3; i >= 0; --i) {
                Item item;
                ItemStack itemStack = this.o(i);
                if (i < 3 && this.random.nextFloat() < f) break;
                if (itemStack != null || (item = EntityInsentient.a(i + 1, n)) == null) continue;
                this.setEquipment(i + 1, new ItemStack(item));
            }
        }
    }

    public static int b(ItemStack itemStack) {
        if (itemStack.id == Block.PUMPKIN.id || itemStack.id == Item.SKULL.id) {
            return 4;
        }
        if (itemStack.getItem() instanceof ItemArmor) {
            switch (((ItemArmor)itemStack.getItem()).b) {
                case 3: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 1: {
                    return 3;
                }
                case 0: {
                    return 4;
                }
            }
        }
        return 0;
    }

    public static Item a(int n, int n2) {
        switch (n) {
            case 4: {
                if (n2 == 0) {
                    return Item.LEATHER_HELMET;
                }
                if (n2 == 1) {
                    return Item.GOLD_HELMET;
                }
                if (n2 == 2) {
                    return Item.CHAINMAIL_HELMET;
                }
                if (n2 == 3) {
                    return Item.IRON_HELMET;
                }
                if (n2 == 4) {
                    return Item.DIAMOND_HELMET;
                }
            }
            case 3: {
                if (n2 == 0) {
                    return Item.LEATHER_CHESTPLATE;
                }
                if (n2 == 1) {
                    return Item.GOLD_CHESTPLATE;
                }
                if (n2 == 2) {
                    return Item.CHAINMAIL_CHESTPLATE;
                }
                if (n2 == 3) {
                    return Item.IRON_CHESTPLATE;
                }
                if (n2 == 4) {
                    return Item.DIAMOND_CHESTPLATE;
                }
            }
            case 2: {
                if (n2 == 0) {
                    return Item.LEATHER_LEGGINGS;
                }
                if (n2 == 1) {
                    return Item.GOLD_LEGGINGS;
                }
                if (n2 == 2) {
                    return Item.CHAINMAIL_LEGGINGS;
                }
                if (n2 == 3) {
                    return Item.IRON_LEGGINGS;
                }
                if (n2 == 4) {
                    return Item.DIAMOND_LEGGINGS;
                }
            }
            case 1: {
                if (n2 == 0) {
                    return Item.LEATHER_BOOTS;
                }
                if (n2 == 1) {
                    return Item.GOLD_BOOTS;
                }
                if (n2 == 2) {
                    return Item.CHAINMAIL_BOOTS;
                }
                if (n2 == 3) {
                    return Item.IRON_BOOTS;
                }
                if (n2 != 4) break;
                return Item.DIAMOND_BOOTS;
            }
        }
        return null;
    }

    protected void bx() {
        float f = this.world.b(this.locX, this.locY, this.locZ);
        if (this.aZ() != null && this.random.nextFloat() < 0.25f * f) {
            EnchantmentManager.a(this.random, this.aZ(), (int)(5.0f + f * (float)this.random.nextInt(18)));
        }
        for (int i = 0; i < 4; ++i) {
            ItemStack itemStack = this.o(i);
            if (itemStack == null || !(this.random.nextFloat() < 0.5f * f)) continue;
            EnchantmentManager.a(this.random, itemStack, (int)(5.0f + f * (float)this.random.nextInt(18)));
        }
    }

    public GroupDataEntity a(GroupDataEntity groupDataEntity) {
        this.getAttributeInstance(GenericAttributes.b).a(new AttributeModifier("Random spawn bonus", this.random.nextGaussian() * 0.05, 1));
        return groupDataEntity;
    }

    public boolean by() {
        return false;
    }

    @Override
    public String getLocalizedName() {
        if (this.hasCustomName()) {
            return this.getCustomName();
        }
        return super.getLocalizedName();
    }

    public void bz() {
        this.persistent = true;
    }

    public void setCustomName(String string) {
        this.datawatcher.watch(10, string);
    }

    public String getCustomName() {
        return this.datawatcher.getString(10);
    }

    public boolean hasCustomName() {
        return this.datawatcher.getString(10).length() > 0;
    }

    public void setCustomNameVisible(boolean bl) {
        this.datawatcher.watch(11, bl ? (byte)1 : 0);
    }

    public boolean getCustomNameVisible() {
        return this.datawatcher.getByte(11) == 1;
    }

    public void a(int n, float f) {
        this.dropChances[n] = f;
    }

    public boolean bD() {
        return this.canPickUpLoot;
    }

    public void h(boolean bl) {
        this.canPickUpLoot = bl;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    @Override
    public final boolean c(EntityHuman entityHuman) {
        if (this.bH() && this.getLeashHolder() == entityHuman) {
            this.unleash(true, !entityHuman.abilities.canInstantlyBuild);
            return true;
        }
        ItemStack itemStack = entityHuman.inventory.getItemInHand();
        if (itemStack != null && itemStack.id == Item.LEASH.id && this.bG()) {
            if (this instanceof EntityTameableAnimal && ((EntityTameableAnimal)this).isTamed()) {
                if (entityHuman.getName().equalsIgnoreCase(((EntityTameableAnimal)this).getOwnerName())) {
                    this.setLeashHolder(entityHuman, true);
                    --itemStack.count;
                    return true;
                }
            } else {
                this.setLeashHolder(entityHuman, true);
                --itemStack.count;
                return true;
            }
        }
        if (this.a(entityHuman)) {
            return true;
        }
        return super.c(entityHuman);
    }

    protected boolean a(EntityHuman entityHuman) {
        return false;
    }

    protected void bF() {
        if (this.bx != null) {
            this.bJ();
        }
        if (!this.bv) {
            return;
        }
        if (this.bw == null || this.bw.dead) {
            this.unleash(true, true);
            return;
        }
    }

    public void unleash(boolean bl, boolean bl2) {
        if (this.bv) {
            this.bv = false;
            this.bw = null;
            if (!this.world.isStatic && bl2) {
                this.b(Item.LEASH.id, 1);
            }
            if (!this.world.isStatic && bl && this.world instanceof WorldServer) {
                ((WorldServer)this.world).getTracker().a(this, new Packet39AttachEntity(1, this, null));
            }
        }
    }

    public boolean bG() {
        return !this.bH() && !(this instanceof IMonster);
    }

    public boolean bH() {
        return this.bv;
    }

    public Entity getLeashHolder() {
        return this.bw;
    }

    public void setLeashHolder(Entity entity, boolean bl) {
        this.bv = true;
        this.bw = entity;
        if (!this.world.isStatic && bl && this.world instanceof WorldServer) {
            ((WorldServer)this.world).getTracker().a(this, new Packet39AttachEntity(1, this, this.bw));
        }
    }

    private void bJ() {
        if (this.bv && this.bx != null) {
            if (this.bx.hasKey("UUIDMost") && this.bx.hasKey("UUIDLeast")) {
                UUID uUID = new UUID(this.bx.getLong("UUIDMost"), this.bx.getLong("UUIDLeast"));
                List list = this.world.a(EntityLiving.class, this.boundingBox.grow(10.0, 10.0, 10.0));
                for (EntityLiving entityLiving : list) {
                    if (!entityLiving.getUniqueID().equals(uUID)) continue;
                    this.bw = entityLiving;
                    break;
                }
            } else if (this.bx.hasKey("X") && this.bx.hasKey("Y") && this.bx.hasKey("Z")) {
                int n;
                int n2;
                int n3 = this.bx.getInt("X");
                EntityLeash entityLeash = EntityLeash.b(this.world, n3, n2 = this.bx.getInt("Y"), n = this.bx.getInt("Z"));
                if (entityLeash == null) {
                    entityLeash = EntityLeash.a(this.world, n3, n2, n);
                }
                this.bw = entityLeash;
            } else {
                this.unleash(false, true);
            }
        }
        this.bx = null;
    }
}

