/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Collection;
import java.util.List;
import net.minecraft.server.AchievementList;
import net.minecraft.server.AttributeInstance;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.BlockBed;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.Container;
import net.minecraft.server.ContainerPlayer;
import net.minecraft.server.DamageSource;
import net.minecraft.server.EnchantmentManager;
import net.minecraft.server.EnchantmentThorns;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityArrow;
import net.minecraft.server.EntityBoat;
import net.minecraft.server.EntityComplexPart;
import net.minecraft.server.EntityFishingHook;
import net.minecraft.server.EntityHorse;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityMinecartAbstract;
import net.minecraft.server.EntityMinecartHopper;
import net.minecraft.server.EntityMonster;
import net.minecraft.server.EntityPig;
import net.minecraft.server.EnumAnimation;
import net.minecraft.server.EnumBedResult;
import net.minecraft.server.EnumGamemode;
import net.minecraft.server.FoodMetaData;
import net.minecraft.server.GenericAttributes;
import net.minecraft.server.IChunkProvider;
import net.minecraft.server.ICommandListener;
import net.minecraft.server.IComplex;
import net.minecraft.server.IInventory;
import net.minecraft.server.IMerchant;
import net.minecraft.server.IMonster;
import net.minecraft.server.IScoreboardCriteria;
import net.minecraft.server.InventoryEnderChest;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MobEffectList;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.PlayerAbilities;
import net.minecraft.server.PlayerInventory;
import net.minecraft.server.Scoreboard;
import net.minecraft.server.ScoreboardObjective;
import net.minecraft.server.ScoreboardScore;
import net.minecraft.server.ScoreboardTeam;
import net.minecraft.server.ScoreboardTeamBase;
import net.minecraft.server.Statistic;
import net.minecraft.server.StatisticList;
import net.minecraft.server.TileEntity;
import net.minecraft.server.TileEntityBeacon;
import net.minecraft.server.TileEntityBrewingStand;
import net.minecraft.server.TileEntityDispenser;
import net.minecraft.server.TileEntityFurnace;
import net.minecraft.server.TileEntityHopper;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

public abstract class EntityHuman
extends EntityLiving
implements ICommandListener {
    public PlayerInventory inventory = new PlayerInventory(this);
    private InventoryEnderChest enderChest = new InventoryEnderChest();
    public Container defaultContainer;
    public Container activeContainer;
    protected FoodMetaData foodData = new FoodMetaData();
    protected int br;
    public float bs;
    public float bt;
    protected final String name;
    public int bv;
    public double bw;
    public double bx;
    public double by;
    public double bz;
    public double bA;
    public double bB;
    protected boolean sleeping;
    public ChunkCoordinates bD;
    private int sleepTicks;
    public float bE;
    public float bF;
    private ChunkCoordinates c;
    private boolean d;
    private ChunkCoordinates e;
    public PlayerAbilities abilities = new PlayerAbilities();
    public int expLevel;
    public int expTotal;
    public float exp;
    private ItemStack f;
    private int g;
    protected float bK = 0.1f;
    protected float bL = 0.02f;
    private int h;
    public EntityFishingHook hookedFish;

    public EntityHuman(World world, String string) {
        super(world);
        this.name = string;
        this.activeContainer = this.defaultContainer = new ContainerPlayer(this.inventory, !world.isStatic, this);
        this.height = 1.62f;
        ChunkCoordinates chunkCoordinates = world.getSpawn();
        this.setPositionRotation((double)chunkCoordinates.x + 0.5, chunkCoordinates.y + 1, (double)chunkCoordinates.z + 0.5, 0.0f, 0.0f);
        this.ba = 180.0f;
        this.maxFireTicks = 20;
    }

    @Override
    protected void az() {
        super.az();
        this.aX().b(GenericAttributes.e).setValue(1.0);
    }

    @Override
    protected void a() {
        super.a();
        this.datawatcher.a(16, (Object)0);
        this.datawatcher.a(17, Float.valueOf(0.0f));
        this.datawatcher.a(18, (Object)0);
    }

    public boolean br() {
        return this.f != null;
    }

    public void bt() {
        if (this.f != null) {
            this.f.b(this.world, this, this.g);
        }
        this.bu();
    }

    public void bu() {
        this.f = null;
        this.g = 0;
        if (!this.world.isStatic) {
            this.e(false);
        }
    }

    public boolean isBlocking() {
        return this.br() && Item.byId[this.f.id].c_(this.f) == EnumAnimation.BLOCK;
    }

    @Override
    public void l_() {
        if (this.f != null) {
            ItemStack itemStack = this.inventory.getItemInHand();
            if (itemStack == this.f) {
                if (this.g <= 25 && this.g % 4 == 0) {
                    this.c(itemStack, 5);
                }
                if (--this.g == 0 && !this.world.isStatic) {
                    this.n();
                }
            } else {
                this.bu();
            }
        }
        if (this.bv > 0) {
            --this.bv;
        }
        if (this.isSleeping()) {
            ++this.sleepTicks;
            if (this.sleepTicks > 100) {
                this.sleepTicks = 100;
            }
            if (!this.world.isStatic) {
                if (!this.h()) {
                    this.a(true, true, false);
                } else if (this.world.v()) {
                    this.a(false, true, true);
                }
            }
        } else if (this.sleepTicks > 0) {
            ++this.sleepTicks;
            if (this.sleepTicks >= 110) {
                this.sleepTicks = 0;
            }
        }
        super.l_();
        if (!this.world.isStatic && this.activeContainer != null && !this.activeContainer.a(this)) {
            this.closeInventory();
            this.activeContainer = this.defaultContainer;
        }
        if (this.isBurning() && this.abilities.isInvulnerable) {
            this.extinguish();
        }
        this.bw = this.bz;
        this.bx = this.bA;
        this.by = this.bB;
        double d = this.locX - this.bz;
        double d2 = this.locY - this.bA;
        double d3 = this.locZ - this.bB;
        double d4 = 10.0;
        if (d > d4) {
            this.bw = this.bz = this.locX;
        }
        if (d3 > d4) {
            this.by = this.bB = this.locZ;
        }
        if (d2 > d4) {
            this.bx = this.bA = this.locY;
        }
        if (d < -d4) {
            this.bw = this.bz = this.locX;
        }
        if (d3 < -d4) {
            this.by = this.bB = this.locZ;
        }
        if (d2 < -d4) {
            this.bx = this.bA = this.locY;
        }
        this.bz += d * 0.25;
        this.bB += d3 * 0.25;
        this.bA += d2 * 0.25;
        this.a(StatisticList.k, 1);
        if (this.vehicle == null) {
            this.e = null;
        }
        if (!this.world.isStatic) {
            this.foodData.a(this);
        }
    }

    @Override
    public int z() {
        return this.abilities.isInvulnerable ? 0 : 80;
    }

    @Override
    public int ac() {
        return 10;
    }

    @Override
    public void makeSound(String string, float f, float f2) {
        this.world.a(this, string, f, f2);
    }

    protected void c(ItemStack itemStack, int n) {
        if (itemStack.o() == EnumAnimation.DRINK) {
            this.makeSound("random.drink", 0.5f, this.world.random.nextFloat() * 0.1f + 0.9f);
        }
        if (itemStack.o() == EnumAnimation.EAT) {
            for (int i = 0; i < n; ++i) {
                Vec3D vec3D = this.world.getVec3DPool().create(((double)this.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                vec3D.a(-this.pitch * (float)Math.PI / 180.0f);
                vec3D.b(-this.yaw * (float)Math.PI / 180.0f);
                Vec3D vec3D2 = this.world.getVec3DPool().create(((double)this.random.nextFloat() - 0.5) * 0.3, (double)(-this.random.nextFloat()) * 0.6 - 0.3, 0.6);
                vec3D2.a(-this.pitch * (float)Math.PI / 180.0f);
                vec3D2.b(-this.yaw * (float)Math.PI / 180.0f);
                vec3D2 = vec3D2.add(this.locX, this.locY + (double)this.getHeadHeight(), this.locZ);
                this.world.addParticle("iconcrack_" + itemStack.getItem().id, vec3D2.c, vec3D2.d, vec3D2.e, vec3D.c, vec3D.d + 0.05, vec3D.e);
            }
            this.makeSound("random.eat", 0.5f + 0.5f * (float)this.random.nextInt(2), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
    }

    protected void n() {
        if (this.f != null) {
            this.c(this.f, 16);
            int n = this.f.count;
            ItemStack itemStack = this.f.b(this.world, this);
            if (itemStack != this.f || itemStack != null && itemStack.count != n) {
                this.inventory.items[this.inventory.itemInHandIndex] = itemStack;
                if (itemStack.count == 0) {
                    this.inventory.items[this.inventory.itemInHandIndex] = null;
                }
            }
            this.bu();
        }
    }

    @Override
    protected boolean bc() {
        return this.getHealth() <= 0.0f || this.isSleeping();
    }

    protected void closeInventory() {
        this.activeContainer = this.defaultContainer;
    }

    @Override
    public void mount(Entity entity) {
        if (this.vehicle != null && entity == null) {
            if (!this.world.isStatic) {
                this.l(this.vehicle);
            }
            if (this.vehicle != null) {
                this.vehicle.passenger = null;
            }
            this.vehicle = null;
            return;
        }
        super.mount(entity);
    }

    @Override
    public void V() {
        if (!this.world.isStatic && this.isSneaking()) {
            this.mount(null);
            this.setSneaking(false);
            return;
        }
        double d = this.locX;
        double d2 = this.locY;
        double d3 = this.locZ;
        float f = this.yaw;
        float f2 = this.pitch;
        super.V();
        this.bs = this.bt;
        this.bt = 0.0f;
        this.k(this.locX - d, this.locY - d2, this.locZ - d3);
        if (this.vehicle instanceof EntityPig) {
            this.pitch = f2;
            this.yaw = f;
            this.aN = ((EntityPig)this.vehicle).aN;
        }
    }

    @Override
    protected void bl() {
        super.bl();
        this.aW();
    }

    @Override
    public void c() {
        if (this.br > 0) {
            --this.br;
        }
        if (this.world.difficulty == 0 && this.getHealth() < this.getMaxHealth() && this.world.getGameRules().getBoolean("naturalRegeneration") && this.ticksLived % 20 * 12 == 0) {
            this.heal(1.0f);
        }
        this.inventory.k();
        this.bs = this.bt;
        super.c();
        AttributeInstance attributeInstance = this.getAttributeInstance(GenericAttributes.d);
        if (!this.world.isStatic) {
            attributeInstance.setValue(this.abilities.b());
        }
        this.aR = this.bL;
        if (this.isSprinting()) {
            this.aR = (float)((double)this.aR + (double)this.bL * 0.3);
        }
        this.i((float)attributeInstance.getValue());
        float f = MathHelper.sqrt(this.motX * this.motX + this.motZ * this.motZ);
        float f2 = (float)Math.atan(-this.motY * (double)0.2f) * 15.0f;
        if (f > 0.1f) {
            f = 0.1f;
        }
        if (!this.onGround || this.getHealth() <= 0.0f) {
            f = 0.0f;
        }
        if (this.onGround || this.getHealth() <= 0.0f) {
            f2 = 0.0f;
        }
        this.bt += (f - this.bt) * 0.4f;
        this.aK += (f2 - this.aK) * 0.8f;
        if (this.getHealth() > 0.0f) {
            AxisAlignedBB axisAlignedBB = null;
            axisAlignedBB = this.vehicle != null && !this.vehicle.dead ? this.boundingBox.a(this.vehicle.boundingBox).grow(1.0, 0.0, 1.0) : this.boundingBox.grow(1.0, 0.5, 1.0);
            List list = this.world.getEntities(this, axisAlignedBB);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Entity entity = (Entity)list.get(i);
                    if (entity.dead) continue;
                    this.r(entity);
                }
            }
        }
    }

    private void r(Entity entity) {
        entity.b_(this);
    }

    public int getScore() {
        return this.datawatcher.getInt(18);
    }

    public void setScore(int n) {
        this.datawatcher.watch(18, n);
    }

    public void addScore(int n) {
        int n2 = this.getScore();
        this.datawatcher.watch(18, n2 + n);
    }

    @Override
    public void die(DamageSource damageSource) {
        super.die(damageSource);
        this.a(0.2f, 0.2f);
        this.setPosition(this.locX, this.locY, this.locZ);
        this.motY = 0.1f;
        if (this.name.equals("Notch")) {
            this.a(new ItemStack(Item.APPLE, 1), true);
        }
        if (!this.world.getGameRules().getBoolean("keepInventory")) {
            this.inventory.m();
        }
        if (damageSource != null) {
            this.motX = -MathHelper.cos((this.aA + this.yaw) * (float)Math.PI / 180.0f) * 0.1f;
            this.motZ = -MathHelper.sin((this.aA + this.yaw) * (float)Math.PI / 180.0f) * 0.1f;
        } else {
            this.motZ = 0.0;
            this.motX = 0.0;
        }
        this.height = 0.1f;
        this.a(StatisticList.y, 1);
    }

    @Override
    public void b(Entity entity, int n) {
        this.addScore(n);
        Collection collection = this.getScoreboard().getObjectivesForCriteria(IScoreboardCriteria.e);
        if (entity instanceof EntityHuman) {
            this.a(StatisticList.A, 1);
            collection.addAll(this.getScoreboard().getObjectivesForCriteria(IScoreboardCriteria.d));
        } else {
            this.a(StatisticList.z, 1);
        }
        for (ScoreboardObjective scoreboardObjective : collection) {
            ScoreboardScore scoreboardScore = this.getScoreboard().getPlayerScoreForObjective(this.getLocalizedName(), scoreboardObjective);
            scoreboardScore.incrementScore();
        }
    }

    public EntityItem a(boolean bl) {
        return this.a(this.inventory.splitStack(this.inventory.itemInHandIndex, bl && this.inventory.getItemInHand() != null ? this.inventory.getItemInHand().count : 1), false);
    }

    public EntityItem drop(ItemStack itemStack) {
        return this.a(itemStack, false);
    }

    public EntityItem a(ItemStack itemStack, boolean bl) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.count == 0) {
            return null;
        }
        EntityItem entityItem = new EntityItem(this.world, this.locX, this.locY - (double)0.3f + (double)this.getHeadHeight(), this.locZ, itemStack);
        entityItem.pickupDelay = 40;
        float f = 0.1f;
        if (bl) {
            float f2 = this.random.nextFloat() * 0.5f;
            float f3 = this.random.nextFloat() * (float)Math.PI * 2.0f;
            entityItem.motX = -MathHelper.sin(f3) * f2;
            entityItem.motZ = MathHelper.cos(f3) * f2;
            entityItem.motY = 0.2f;
        } else {
            f = 0.3f;
            entityItem.motX = -MathHelper.sin(this.yaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.pitch / 180.0f * (float)Math.PI) * f;
            entityItem.motZ = MathHelper.cos(this.yaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.pitch / 180.0f * (float)Math.PI) * f;
            entityItem.motY = -MathHelper.sin(this.pitch / 180.0f * (float)Math.PI) * f + 0.1f;
            f = 0.02f;
            float f4 = this.random.nextFloat() * (float)Math.PI * 2.0f;
            entityItem.motX += Math.cos(f4) * (double)(f *= this.random.nextFloat());
            entityItem.motY += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
            entityItem.motZ += Math.sin(f4) * (double)f;
        }
        this.a(entityItem);
        this.a(StatisticList.v, 1);
        return entityItem;
    }

    protected void a(EntityItem entityItem) {
        this.world.addEntity(entityItem);
    }

    public float a(Block block, boolean bl) {
        float f = this.inventory.a(block);
        if (f > 1.0f) {
            int n = EnchantmentManager.getDigSpeedEnchantmentLevel(this);
            ItemStack itemStack = this.inventory.getItemInHand();
            if (n > 0 && itemStack != null) {
                float f2 = n * n + 1;
                f = itemStack.b(block) || f > 1.0f ? (f += f2) : (f += f2 * 0.08f);
            }
        }
        if (this.hasEffect(MobEffectList.FASTER_DIG)) {
            f *= 1.0f + (float)(this.getEffect(MobEffectList.FASTER_DIG).getAmplifier() + 1) * 0.2f;
        }
        if (this.hasEffect(MobEffectList.SLOWER_DIG)) {
            f *= 1.0f - (float)(this.getEffect(MobEffectList.SLOWER_DIG).getAmplifier() + 1) * 0.2f;
        }
        if (this.a(Material.WATER) && !EnchantmentManager.hasWaterWorkerEnchantment(this)) {
            f /= 5.0f;
        }
        if (!this.onGround) {
            f /= 5.0f;
        }
        return f;
    }

    public boolean a(Block block) {
        return this.inventory.b(block);
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        NBTTagList nBTTagList = nBTTagCompound.getList("Inventory");
        this.inventory.b(nBTTagList);
        this.inventory.itemInHandIndex = nBTTagCompound.getInt("SelectedItemSlot");
        this.sleeping = nBTTagCompound.getBoolean("Sleeping");
        this.sleepTicks = nBTTagCompound.getShort("SleepTimer");
        this.exp = nBTTagCompound.getFloat("XpP");
        this.expLevel = nBTTagCompound.getInt("XpLevel");
        this.expTotal = nBTTagCompound.getInt("XpTotal");
        this.setScore(nBTTagCompound.getInt("Score"));
        if (this.sleeping) {
            this.bD = new ChunkCoordinates(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ));
            this.a(true, true, false);
        }
        if (nBTTagCompound.hasKey("SpawnX") && nBTTagCompound.hasKey("SpawnY") && nBTTagCompound.hasKey("SpawnZ")) {
            this.c = new ChunkCoordinates(nBTTagCompound.getInt("SpawnX"), nBTTagCompound.getInt("SpawnY"), nBTTagCompound.getInt("SpawnZ"));
            this.d = nBTTagCompound.getBoolean("SpawnForced");
        }
        this.foodData.a(nBTTagCompound);
        this.abilities.b(nBTTagCompound);
        if (nBTTagCompound.hasKey("EnderItems")) {
            NBTTagList nBTTagList2 = nBTTagCompound.getList("EnderItems");
            this.enderChest.a(nBTTagList2);
        }
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.set("Inventory", this.inventory.a(new NBTTagList()));
        nBTTagCompound.setInt("SelectedItemSlot", this.inventory.itemInHandIndex);
        nBTTagCompound.setBoolean("Sleeping", this.sleeping);
        nBTTagCompound.setShort("SleepTimer", (short)this.sleepTicks);
        nBTTagCompound.setFloat("XpP", this.exp);
        nBTTagCompound.setInt("XpLevel", this.expLevel);
        nBTTagCompound.setInt("XpTotal", this.expTotal);
        nBTTagCompound.setInt("Score", this.getScore());
        if (this.c != null) {
            nBTTagCompound.setInt("SpawnX", this.c.x);
            nBTTagCompound.setInt("SpawnY", this.c.y);
            nBTTagCompound.setInt("SpawnZ", this.c.z);
            nBTTagCompound.setBoolean("SpawnForced", this.d);
        }
        this.foodData.b(nBTTagCompound);
        this.abilities.a(nBTTagCompound);
        nBTTagCompound.set("EnderItems", this.enderChest.h());
    }

    public void openContainer(IInventory iInventory) {
    }

    public void openHopper(TileEntityHopper tileEntityHopper) {
    }

    public void openMinecartHopper(EntityMinecartHopper entityMinecartHopper) {
    }

    public void openHorseInventory(EntityHorse entityHorse, IInventory iInventory) {
    }

    public void startEnchanting(int n, int n2, int n3, String string) {
    }

    public void openAnvil(int n, int n2, int n3) {
    }

    public void startCrafting(int n, int n2, int n3) {
    }

    @Override
    public float getHeadHeight() {
        return 0.12f;
    }

    protected void d_() {
        this.height = 1.62f;
    }

    @Override
    public boolean damageEntity(DamageSource damageSource, float f) {
        if (this.isInvulnerable()) {
            return false;
        }
        if (this.abilities.isInvulnerable && !damageSource.ignoresInvulnerability()) {
            return false;
        }
        this.aV = 0;
        if (this.getHealth() <= 0.0f) {
            return false;
        }
        if (this.isSleeping() && !this.world.isStatic) {
            this.a(true, true, false);
        }
        if (damageSource.p()) {
            if (this.world.difficulty == 0) {
                f = 0.0f;
            }
            if (this.world.difficulty == 1) {
                f = f / 2.0f + 1.0f;
            }
            if (this.world.difficulty == 3) {
                f = f * 3.0f / 2.0f;
            }
        }
        if (f == 0.0f) {
            return false;
        }
        Entity entity = damageSource.getEntity();
        if (entity instanceof EntityArrow && ((EntityArrow)entity).shooter != null) {
            entity = ((EntityArrow)entity).shooter;
        }
        this.a(StatisticList.x, Math.round(f * 10.0f));
        return super.damageEntity(damageSource, f);
    }

    public boolean a(EntityHuman entityHuman) {
        ScoreboardTeamBase scoreboardTeamBase = this.getScoreboardTeam();
        ScoreboardTeamBase scoreboardTeamBase2 = entityHuman.getScoreboardTeam();
        if (scoreboardTeamBase == null) {
            return true;
        }
        if (!scoreboardTeamBase.isAlly(scoreboardTeamBase2)) {
            return true;
        }
        return scoreboardTeamBase.allowFriendlyFire();
    }

    @Override
    protected void h(float f) {
        this.inventory.a(f);
    }

    @Override
    public int aQ() {
        return this.inventory.l();
    }

    public float bx() {
        int n = 0;
        for (ItemStack itemStack : this.inventory.armor) {
            if (itemStack == null) continue;
            ++n;
        }
        return (float)n / (float)this.inventory.armor.length;
    }

    @Override
    protected void d(DamageSource damageSource, float f) {
        if (this.isInvulnerable()) {
            return;
        }
        if (!damageSource.ignoresArmor() && this.isBlocking() && f > 0.0f) {
            f = (1.0f + f) * 0.5f;
        }
        f = this.b(damageSource, f);
        float f2 = f = this.c(damageSource, f);
        f = Math.max(f - this.bn(), 0.0f);
        this.m(this.bn() - (f2 - f));
        if (f == 0.0f) {
            return;
        }
        this.a(damageSource.f());
        float f3 = this.getHealth();
        this.setHealth(this.getHealth() - f);
        this.aR().a(damageSource, f3, f);
    }

    public void openFurnace(TileEntityFurnace tileEntityFurnace) {
    }

    public void openDispenser(TileEntityDispenser tileEntityDispenser) {
    }

    public void a(TileEntity tileEntity) {
    }

    public void openBrewingStand(TileEntityBrewingStand tileEntityBrewingStand) {
    }

    public void openBeacon(TileEntityBeacon tileEntityBeacon) {
    }

    public void openTrade(IMerchant iMerchant, String string) {
    }

    public void c(ItemStack itemStack) {
    }

    public boolean p(Entity entity) {
        ItemStack itemStack;
        ItemStack itemStack2 = this.by();
        ItemStack itemStack3 = itemStack = itemStack2 != null ? itemStack2.cloneItemStack() : null;
        if (entity.c(this)) {
            if (itemStack2 != null && itemStack2 == this.by()) {
                if (itemStack2.count <= 0 && !this.abilities.canInstantlyBuild) {
                    this.bz();
                } else if (itemStack2.count < itemStack.count && this.abilities.canInstantlyBuild) {
                    itemStack2.count = itemStack.count;
                }
            }
            return true;
        }
        if (itemStack2 != null && entity instanceof EntityLiving) {
            if (this.abilities.canInstantlyBuild) {
                itemStack2 = itemStack;
            }
            if (itemStack2.a(this, (EntityLiving)entity)) {
                if (itemStack2.count <= 0 && !this.abilities.canInstantlyBuild) {
                    this.bz();
                }
                return true;
            }
        }
        return false;
    }

    public ItemStack by() {
        return this.inventory.getItemInHand();
    }

    public void bz() {
        this.inventory.setItem(this.inventory.itemInHandIndex, null);
    }

    @Override
    public double X() {
        return this.height - 0.5f;
    }

    public void attack(Entity entity) {
        if (!entity.aq()) {
            return;
        }
        if (entity.i(this)) {
            return;
        }
        float f = (float)this.getAttributeInstance(GenericAttributes.e).getValue();
        int n = 0;
        float f2 = 0.0f;
        if (entity instanceof EntityLiving) {
            f2 = EnchantmentManager.a(this, (EntityLiving)entity);
            n += EnchantmentManager.getKnockbackEnchantmentLevel(this, (EntityLiving)entity);
        }
        if (this.isSprinting()) {
            ++n;
        }
        if (f > 0.0f || f2 > 0.0f) {
            IComplex iComplex;
            boolean bl;
            boolean bl2;
            boolean bl3 = bl2 = this.fallDistance > 0.0f && !this.onGround && !this.e() && !this.H() && !this.hasEffect(MobEffectList.BLINDNESS) && this.vehicle == null && entity instanceof EntityLiving;
            if (bl2 && f > 0.0f) {
                f *= 1.5f;
            }
            f += f2;
            boolean bl4 = false;
            int n2 = EnchantmentManager.getFireAspectEnchantmentLevel(this);
            if (entity instanceof EntityLiving && n2 > 0 && !entity.isBurning()) {
                bl4 = true;
                entity.setOnFire(1);
            }
            if (bl = entity.damageEntity(DamageSource.playerAttack(this), f)) {
                if (n > 0) {
                    entity.g(-MathHelper.sin(this.yaw * (float)Math.PI / 180.0f) * (float)n * 0.5f, 0.1, MathHelper.cos(this.yaw * (float)Math.PI / 180.0f) * (float)n * 0.5f);
                    this.motX *= 0.6;
                    this.motZ *= 0.6;
                    this.setSprinting(false);
                }
                if (bl2) {
                    this.b(entity);
                }
                if (f2 > 0.0f) {
                    this.c(entity);
                }
                if (f >= 18.0f) {
                    this.a(AchievementList.E);
                }
                this.k(entity);
                if (entity instanceof EntityLiving) {
                    EnchantmentThorns.a(this, (EntityLiving)entity, this.random);
                }
            }
            ItemStack itemStack = this.by();
            Entity entity2 = entity;
            if (entity instanceof EntityComplexPart && (iComplex = ((EntityComplexPart)entity).owner) != null && iComplex instanceof EntityLiving) {
                entity2 = (EntityLiving)((Object)iComplex);
            }
            if (itemStack != null && entity2 instanceof EntityLiving) {
                itemStack.a((EntityLiving)entity2, this);
                if (itemStack.count <= 0) {
                    this.bz();
                }
            }
            if (entity instanceof EntityLiving) {
                this.a(StatisticList.w, Math.round(f * 10.0f));
                if (n2 > 0 && bl) {
                    entity.setOnFire(n2 * 4);
                } else if (bl4) {
                    entity.extinguish();
                }
            }
            this.a(0.3f);
        }
    }

    public void b(Entity entity) {
    }

    public void c(Entity entity) {
    }

    @Override
    public void die() {
        super.die();
        this.defaultContainer.b(this);
        if (this.activeContainer != null) {
            this.activeContainer.b(this);
        }
    }

    @Override
    public boolean inBlock() {
        return !this.sleeping && super.inBlock();
    }

    public EnumBedResult a(int n, int n2, int n3) {
        if (!this.world.isStatic) {
            if (this.isSleeping() || !this.isAlive()) {
                return EnumBedResult.OTHER_PROBLEM;
            }
            if (!this.world.worldProvider.d()) {
                return EnumBedResult.NOT_POSSIBLE_HERE;
            }
            if (this.world.v()) {
                return EnumBedResult.NOT_POSSIBLE_NOW;
            }
            if (Math.abs(this.locX - (double)n) > 3.0 || Math.abs(this.locY - (double)n2) > 2.0 || Math.abs(this.locZ - (double)n3) > 3.0) {
                return EnumBedResult.TOO_FAR_AWAY;
            }
            double d = 8.0;
            double d2 = 5.0;
            List list = this.world.a(EntityMonster.class, AxisAlignedBB.a().a((double)n - d, (double)n2 - d2, (double)n3 - d, (double)n + d, (double)n2 + d2, (double)n3 + d));
            if (!list.isEmpty()) {
                return EnumBedResult.NOT_SAFE;
            }
        }
        if (this.ag()) {
            this.mount(null);
        }
        this.a(0.2f, 0.2f);
        this.height = 0.2f;
        if (this.world.isLoaded(n, n2, n3)) {
            int n4 = this.world.getData(n, n2, n3);
            int n5 = BlockBed.j(n4);
            float f = 0.5f;
            float f2 = 0.5f;
            switch (n5) {
                case 0: {
                    f2 = 0.9f;
                    break;
                }
                case 2: {
                    f2 = 0.1f;
                    break;
                }
                case 1: {
                    f = 0.1f;
                    break;
                }
                case 3: {
                    f = 0.9f;
                }
            }
            this.t(n5);
            this.setPosition((float)n + f, (float)n2 + 0.9375f, (float)n3 + f2);
        } else {
            this.setPosition((float)n + 0.5f, (float)n2 + 0.9375f, (float)n3 + 0.5f);
        }
        this.sleeping = true;
        this.sleepTicks = 0;
        this.bD = new ChunkCoordinates(n, n2, n3);
        this.motY = 0.0;
        this.motZ = 0.0;
        this.motX = 0.0;
        if (!this.world.isStatic) {
            this.world.everyoneSleeping();
        }
        return EnumBedResult.OK;
    }

    private void t(int n) {
        this.bE = 0.0f;
        this.bF = 0.0f;
        switch (n) {
            case 0: {
                this.bF = -1.8f;
                break;
            }
            case 2: {
                this.bF = 1.8f;
                break;
            }
            case 1: {
                this.bE = 1.8f;
                break;
            }
            case 3: {
                this.bE = -1.8f;
            }
        }
    }

    public void a(boolean bl, boolean bl2, boolean bl3) {
        this.a(0.6f, 1.8f);
        this.d_();
        ChunkCoordinates chunkCoordinates = this.bD;
        ChunkCoordinates chunkCoordinates2 = this.bD;
        if (chunkCoordinates != null && this.world.getTypeId(chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z) == Block.BED.id) {
            BlockBed.a(this.world, chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z, false);
            chunkCoordinates2 = BlockBed.b(this.world, chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z, 0);
            if (chunkCoordinates2 == null) {
                chunkCoordinates2 = new ChunkCoordinates(chunkCoordinates.x, chunkCoordinates.y + 1, chunkCoordinates.z);
            }
            this.setPosition((float)chunkCoordinates2.x + 0.5f, (float)chunkCoordinates2.y + this.height + 0.1f, (float)chunkCoordinates2.z + 0.5f);
        }
        this.sleeping = false;
        if (!this.world.isStatic && bl2) {
            this.world.everyoneSleeping();
        }
        this.sleepTicks = bl ? 0 : 100;
        if (bl3) {
            this.setRespawnPosition(this.bD, false);
        }
    }

    private boolean h() {
        return this.world.getTypeId(this.bD.x, this.bD.y, this.bD.z) == Block.BED.id;
    }

    public static ChunkCoordinates getBed(World world, ChunkCoordinates chunkCoordinates, boolean bl) {
        IChunkProvider iChunkProvider = world.L();
        iChunkProvider.getChunkAt(chunkCoordinates.x - 3 >> 4, chunkCoordinates.z - 3 >> 4);
        iChunkProvider.getChunkAt(chunkCoordinates.x + 3 >> 4, chunkCoordinates.z - 3 >> 4);
        iChunkProvider.getChunkAt(chunkCoordinates.x - 3 >> 4, chunkCoordinates.z + 3 >> 4);
        iChunkProvider.getChunkAt(chunkCoordinates.x + 3 >> 4, chunkCoordinates.z + 3 >> 4);
        if (world.getTypeId(chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z) != Block.BED.id) {
            boolean bl2;
            Material material = world.getMaterial(chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z);
            Material material2 = world.getMaterial(chunkCoordinates.x, chunkCoordinates.y + 1, chunkCoordinates.z);
            boolean bl3 = !material.isBuildable() && !material.isLiquid();
            boolean bl4 = bl2 = !material2.isBuildable() && !material2.isLiquid();
            if (bl && bl3 && bl2) {
                return chunkCoordinates;
            }
            return null;
        }
        ChunkCoordinates chunkCoordinates2 = BlockBed.b(world, chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z, 0);
        return chunkCoordinates2;
    }

    @Override
    public boolean isSleeping() {
        return this.sleeping;
    }

    public boolean isDeeplySleeping() {
        return this.sleeping && this.sleepTicks >= 100;
    }

    protected void b(int n, boolean bl) {
        byte by = this.datawatcher.getByte(16);
        if (bl) {
            this.datawatcher.watch(16, (byte)(by | 1 << n));
        } else {
            this.datawatcher.watch(16, (byte)(by & ~(1 << n)));
        }
    }

    public void a(String string) {
    }

    public ChunkCoordinates getBed() {
        return this.c;
    }

    public boolean isRespawnForced() {
        return this.d;
    }

    public void setRespawnPosition(ChunkCoordinates chunkCoordinates, boolean bl) {
        if (chunkCoordinates != null) {
            this.c = new ChunkCoordinates(chunkCoordinates);
            this.d = bl;
        } else {
            this.c = null;
            this.d = false;
        }
    }

    public void a(Statistic statistic) {
        this.a(statistic, 1);
    }

    public void a(Statistic statistic, int n) {
    }

    @Override
    protected void be() {
        super.be();
        this.a(StatisticList.u, 1);
        if (this.isSprinting()) {
            this.a(0.8f);
        } else {
            this.a(0.2f);
        }
    }

    @Override
    public void e(float f, float f2) {
        double d = this.locX;
        double d2 = this.locY;
        double d3 = this.locZ;
        if (this.abilities.isFlying && this.vehicle == null) {
            double d4 = this.motY;
            float f3 = this.aR;
            this.aR = this.abilities.a();
            super.e(f, f2);
            this.motY = d4 * 0.6;
            this.aR = f3;
        } else {
            super.e(f, f2);
        }
        this.checkMovement(this.locX - d, this.locY - d2, this.locZ - d3);
    }

    @Override
    public float bg() {
        return (float)this.getAttributeInstance(GenericAttributes.d).getValue();
    }

    public void checkMovement(double d, double d2, double d3) {
        if (this.vehicle != null) {
            return;
        }
        if (this.a(Material.WATER)) {
            int n = Math.round(MathHelper.sqrt(d * d + d2 * d2 + d3 * d3) * 100.0f);
            if (n > 0) {
                this.a(StatisticList.q, n);
                this.a(0.015f * (float)n * 0.01f);
            }
        } else if (this.H()) {
            int n = Math.round(MathHelper.sqrt(d * d + d3 * d3) * 100.0f);
            if (n > 0) {
                this.a(StatisticList.m, n);
                this.a(0.015f * (float)n * 0.01f);
            }
        } else if (this.e()) {
            if (d2 > 0.0) {
                this.a(StatisticList.o, (int)Math.round(d2 * 100.0));
            }
        } else if (this.onGround) {
            int n = Math.round(MathHelper.sqrt(d * d + d3 * d3) * 100.0f);
            if (n > 0) {
                this.a(StatisticList.l, n);
                if (this.isSprinting()) {
                    this.a(0.099999994f * (float)n * 0.01f);
                } else {
                    this.a(0.01f * (float)n * 0.01f);
                }
            }
        } else {
            int n = Math.round(MathHelper.sqrt(d * d + d3 * d3) * 100.0f);
            if (n > 25) {
                this.a(StatisticList.p, n);
            }
        }
    }

    private void k(double d, double d2, double d3) {
        int n;
        if (this.vehicle != null && (n = Math.round(MathHelper.sqrt(d * d + d2 * d2 + d3 * d3) * 100.0f)) > 0) {
            if (this.vehicle instanceof EntityMinecartAbstract) {
                this.a(StatisticList.r, n);
                if (this.e == null) {
                    this.e = new ChunkCoordinates(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ));
                } else if ((double)this.e.e(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ)) >= 1000000.0) {
                    this.a(AchievementList.q, 1);
                }
            } else if (this.vehicle instanceof EntityBoat) {
                this.a(StatisticList.s, n);
            } else if (this.vehicle instanceof EntityPig) {
                this.a(StatisticList.t, n);
            }
        }
    }

    @Override
    protected void b(float f) {
        if (this.abilities.canFly) {
            return;
        }
        if (f >= 2.0f) {
            this.a(StatisticList.n, (int)Math.round((double)f * 100.0));
        }
        super.b(f);
    }

    @Override
    public void a(EntityLiving entityLiving) {
        if (entityLiving instanceof IMonster) {
            this.a(AchievementList.s);
        }
    }

    @Override
    public void am() {
        if (!this.abilities.isFlying) {
            super.am();
        }
    }

    public ItemStack o(int n) {
        return this.inventory.f(n);
    }

    public void giveExp(int n) {
        this.addScore(n);
        int n2 = Integer.MAX_VALUE - this.expTotal;
        if (n > n2) {
            n = n2;
        }
        this.exp += (float)n / (float)this.getExpToLevel();
        this.expTotal += n;
        while (this.exp >= 1.0f) {
            this.exp = (this.exp - 1.0f) * (float)this.getExpToLevel();
            this.levelDown(1);
            this.exp /= (float)this.getExpToLevel();
        }
    }

    public void levelDown(int n) {
        this.expLevel += n;
        if (this.expLevel < 0) {
            this.expLevel = 0;
            this.exp = 0.0f;
            this.expTotal = 0;
        }
        if (n > 0 && this.expLevel % 5 == 0 && (float)this.h < (float)this.ticksLived - 100.0f) {
            float f = this.expLevel > 30 ? 1.0f : (float)this.expLevel / 30.0f;
            this.world.makeSound(this, "random.levelup", f * 0.75f, 1.0f);
            this.h = this.ticksLived;
        }
    }

    public int getExpToLevel() {
        if (this.expLevel >= 30) {
            return 62 + (this.expLevel - 30) * 7;
        }
        if (this.expLevel >= 15) {
            return 17 + (this.expLevel - 15) * 3;
        }
        return 17;
    }

    public void a(float f) {
        if (this.abilities.isInvulnerable) {
            return;
        }
        if (!this.world.isStatic) {
            this.foodData.a(f);
        }
    }

    public FoodMetaData getFoodData() {
        return this.foodData;
    }

    public boolean g(boolean bl) {
        return (bl || this.foodData.c()) && !this.abilities.isInvulnerable;
    }

    public boolean bJ() {
        return this.getHealth() > 0.0f && this.getHealth() < this.getMaxHealth();
    }

    public void a(ItemStack itemStack, int n) {
        if (itemStack == this.f) {
            return;
        }
        this.f = itemStack;
        this.g = n;
        if (!this.world.isStatic) {
            this.e(true);
        }
    }

    public boolean d(int n, int n2, int n3) {
        if (this.abilities.mayBuild) {
            return true;
        }
        int n4 = this.world.getTypeId(n, n2, n3);
        if (n4 > 0) {
            ItemStack itemStack;
            Block block = Block.byId[n4];
            if (block.material.q()) {
                return true;
            }
            if (this.by() != null && ((itemStack = this.by()).b(block) || itemStack.a(block) > 1.0f)) {
                return true;
            }
        }
        return false;
    }

    public boolean a(int n, int n2, int n3, int n4, ItemStack itemStack) {
        if (this.abilities.mayBuild) {
            return true;
        }
        if (itemStack != null) {
            return itemStack.z();
        }
        return false;
    }

    @Override
    protected int getExpValue(EntityHuman entityHuman) {
        if (this.world.getGameRules().getBoolean("keepInventory")) {
            return 0;
        }
        int n = this.expLevel * 7;
        if (n > 100) {
            return 100;
        }
        return n;
    }

    @Override
    protected boolean alwaysGivesExp() {
        return true;
    }

    @Override
    public String getLocalizedName() {
        return this.name;
    }

    public void copyTo(EntityHuman entityHuman, boolean bl) {
        if (bl) {
            this.inventory.b(entityHuman.inventory);
            this.setHealth(entityHuman.getHealth());
            this.foodData = entityHuman.foodData;
            this.expLevel = entityHuman.expLevel;
            this.expTotal = entityHuman.expTotal;
            this.exp = entityHuman.exp;
            this.setScore(entityHuman.getScore());
            this.as = entityHuman.as;
        } else if (this.world.getGameRules().getBoolean("keepInventory")) {
            this.inventory.b(entityHuman.inventory);
            this.expLevel = entityHuman.expLevel;
            this.expTotal = entityHuman.expTotal;
            this.exp = entityHuman.exp;
            this.setScore(entityHuman.getScore());
        }
        this.enderChest = entityHuman.enderChest;
    }

    @Override
    protected boolean e_() {
        return !this.abilities.isFlying;
    }

    public void updateAbilities() {
    }

    public void a(EnumGamemode enumGamemode) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public World f_() {
        return this.world;
    }

    public InventoryEnderChest getEnderChest() {
        return this.enderChest;
    }

    @Override
    public ItemStack getEquipment(int n) {
        if (n == 0) {
            return this.inventory.getItemInHand();
        }
        return this.inventory.armor[n - 1];
    }

    @Override
    public ItemStack aZ() {
        return this.inventory.getItemInHand();
    }

    @Override
    public void setEquipment(int n, ItemStack itemStack) {
        this.inventory.armor[n] = itemStack;
    }

    @Override
    public ItemStack[] getEquipment() {
        return this.inventory.armor;
    }

    @Override
    public boolean ax() {
        return !this.abilities.isFlying;
    }

    public Scoreboard getScoreboard() {
        return this.world.getScoreboard();
    }

    @Override
    public ScoreboardTeamBase getScoreboardTeam() {
        return this.getScoreboard().getPlayerTeam(this.name);
    }

    @Override
    public String getScoreboardDisplayName() {
        return ScoreboardTeam.getPlayerDisplayName(this.getScoreboardTeam(), this.name);
    }

    @Override
    public void m(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        this.getDataWatcher().watch(17, Float.valueOf(f));
    }

    @Override
    public float bn() {
        return this.getDataWatcher().getFloat(17);
    }
}

