/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import net.minecraft.server.AttributeInstance;
import net.minecraft.server.AttributeRanged;
import net.minecraft.server.Block;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityAgeable;
import net.minecraft.server.EntityAnimal;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntitySelectorHorse;
import net.minecraft.server.GenericAttributes;
import net.minecraft.server.GroupDataEntity;
import net.minecraft.server.GroupDataHorse;
import net.minecraft.server.IAttribute;
import net.minecraft.server.IEntitySelector;
import net.minecraft.server.IInventoryListener;
import net.minecraft.server.InventoryHorseChest;
import net.minecraft.server.InventorySubcontainer;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.LocaleI18n;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MobEffectList;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.PathEntity;
import net.minecraft.server.PathfinderGoalBreed;
import net.minecraft.server.PathfinderGoalFloat;
import net.minecraft.server.PathfinderGoalFollowParent;
import net.minecraft.server.PathfinderGoalLookAtPlayer;
import net.minecraft.server.PathfinderGoalPanic;
import net.minecraft.server.PathfinderGoalRandomLookaround;
import net.minecraft.server.PathfinderGoalRandomStroll;
import net.minecraft.server.PathfinderGoalTame;
import net.minecraft.server.StepSound;
import net.minecraft.server.World;

public class EntityHorse
extends EntityAnimal
implements IInventoryListener {
    private static final IEntitySelector bu = new EntitySelectorHorse();
    private static final IAttribute attributeJumpStrength = new AttributeRanged("horse.jumpStrength", 0.7, 0.0, 2.0).a("Jump Strength").a(true);
    private static final String[] bw = new String[]{null, "textures/entity/horse/armor/horse_armor_iron.png", "textures/entity/horse/armor/horse_armor_gold.png", "textures/entity/horse/armor/horse_armor_diamond.png"};
    private static final String[] bx = new String[]{"", "meo", "goo", "dio"};
    private static final int[] by = new int[]{0, 5, 7, 11};
    private static final String[] bz = new String[]{"textures/entity/horse/horse_white.png", "textures/entity/horse/horse_creamy.png", "textures/entity/horse/horse_chestnut.png", "textures/entity/horse/horse_brown.png", "textures/entity/horse/horse_black.png", "textures/entity/horse/horse_gray.png", "textures/entity/horse/horse_darkbrown.png"};
    private static final String[] bA = new String[]{"hwh", "hcr", "hch", "hbr", "hbl", "hgr", "hdb"};
    private static final String[] bB = new String[]{null, "textures/entity/horse/horse_markings_white.png", "textures/entity/horse/horse_markings_whitefield.png", "textures/entity/horse/horse_markings_whitedots.png", "textures/entity/horse/horse_markings_blackdots.png"};
    private static final String[] bC = new String[]{"", "wo_", "wmo", "wdo", "bdo"};
    private int bD;
    private int bE;
    private int bF;
    public int bp;
    public int bq;
    protected boolean br;
    private InventoryHorseChest inventoryChest;
    private boolean bH;
    protected int bs;
    protected float bt;
    private boolean bI;
    private float bJ;
    private float bK;
    private float bL;
    private float bM;
    private float bN;
    private float bO;
    private int bP;
    private String bQ;
    private String[] bR = new String[3];

    public EntityHorse(World world) {
        super(world);
        this.a(1.4f, 1.6f);
        this.fireProof = false;
        this.setHasChest(false);
        this.getNavigation().a(true);
        this.goalSelector.a(0, new PathfinderGoalFloat(this));
        this.goalSelector.a(1, new PathfinderGoalPanic(this, 1.2));
        this.goalSelector.a(1, new PathfinderGoalTame(this, 1.2));
        this.goalSelector.a(2, new PathfinderGoalBreed(this, 1.0));
        this.goalSelector.a(4, new PathfinderGoalFollowParent(this, 1.0));
        this.goalSelector.a(6, new PathfinderGoalRandomStroll(this, 0.7));
        this.goalSelector.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.goalSelector.a(8, new PathfinderGoalRandomLookaround(this));
        this.loadChest();
    }

    @Override
    protected void a() {
        super.a();
        this.datawatcher.a(16, (Object)0);
        this.datawatcher.a(19, (Object)0);
        this.datawatcher.a(20, (Object)0);
        this.datawatcher.a(21, String.valueOf(""));
        this.datawatcher.a(22, (Object)0);
    }

    public void setType(int n) {
        this.datawatcher.watch(19, (byte)n);
        this.cJ();
    }

    public int getType() {
        return this.datawatcher.getByte(19);
    }

    public void setVariant(int n) {
        this.datawatcher.watch(20, n);
        this.cJ();
    }

    public int getVariant() {
        return this.datawatcher.getInt(20);
    }

    @Override
    public String getLocalizedName() {
        if (this.hasCustomName()) {
            return this.getCustomName();
        }
        int n = this.getType();
        switch (n) {
            default: {
                return LocaleI18n.get("entity.horse.name");
            }
            case 1: {
                return LocaleI18n.get("entity.donkey.name");
            }
            case 2: {
                return LocaleI18n.get("entity.mule.name");
            }
            case 4: {
                return LocaleI18n.get("entity.skeletonhorse.name");
            }
            case 3: 
        }
        return LocaleI18n.get("entity.zombiehorse.name");
    }

    private boolean w(int n) {
        return (this.datawatcher.getInt(16) & n) != 0;
    }

    private void b(int n, boolean bl) {
        int n2 = this.datawatcher.getInt(16);
        if (bl) {
            this.datawatcher.watch(16, n2 | n);
        } else {
            this.datawatcher.watch(16, n2 & ~n);
        }
    }

    public boolean bV() {
        return !this.isBaby();
    }

    public boolean isTame() {
        return this.w(2);
    }

    public boolean ca() {
        return this.bV();
    }

    public String getOwnerName() {
        return this.datawatcher.getString(21);
    }

    public void setOwnerName(String string) {
        this.datawatcher.watch(21, string);
    }

    public float cc() {
        int n = this.getAge();
        if (n >= 0) {
            return 1.0f;
        }
        return 0.5f + (float)(-24000 - n) / -24000.0f * 0.5f;
    }

    @Override
    public void a(boolean bl) {
        if (bl) {
            this.a(this.cc());
        } else {
            this.a(1.0f);
        }
    }

    public boolean cd() {
        return this.br;
    }

    public void setTame(boolean bl) {
        this.b(2, bl);
    }

    public void j(boolean bl) {
        this.br = bl;
    }

    @Override
    public boolean bG() {
        return !this.cy() && super.bG();
    }

    @Override
    protected void o(float f) {
        if (f > 6.0f && this.cg()) {
            this.o(false);
        }
    }

    public boolean hasChest() {
        return this.w(8);
    }

    public int cf() {
        return this.datawatcher.getInt(22);
    }

    public int d(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        if (itemStack.id == Item.HORSE_ARMOR_IRON.id) {
            return 1;
        }
        if (itemStack.id == Item.HORSE_ARMOR_GOLD.id) {
            return 2;
        }
        if (itemStack.id == Item.HORSE_ARMOR_DIAMOND.id) {
            return 3;
        }
        return 0;
    }

    public boolean cg() {
        return this.w(32);
    }

    public boolean ch() {
        return this.w(64);
    }

    public boolean ci() {
        return this.w(16);
    }

    public boolean cj() {
        return this.bH;
    }

    public void r(int n) {
        this.datawatcher.watch(22, n);
        this.cJ();
    }

    public void k(boolean bl) {
        this.b(16, bl);
    }

    public void setHasChest(boolean bl) {
        this.b(8, bl);
    }

    public void m(boolean bl) {
        this.bH = bl;
    }

    public void n(boolean bl) {
        this.b(4, bl);
    }

    public int getTemper() {
        return this.bs;
    }

    public void setTemper(int n) {
        this.bs = n;
    }

    public int t(int n) {
        int n2 = MathHelper.a(this.getTemper() + n, 0, this.getMaxDomestication());
        this.setTemper(n2);
        return n2;
    }

    @Override
    public boolean damageEntity(DamageSource damageSource, float f) {
        Entity entity = damageSource.getEntity();
        if (this.passenger != null && this.passenger.equals(entity)) {
            return false;
        }
        return super.damageEntity(damageSource, f);
    }

    @Override
    public int aQ() {
        return by[this.cf()];
    }

    @Override
    public boolean M() {
        return this.passenger == null;
    }

    public boolean cl() {
        int n = MathHelper.floor(this.locX);
        int n2 = MathHelper.floor(this.locZ);
        this.world.getBiome(n, n2);
        return true;
    }

    public void cm() {
        if (this.world.isStatic || !this.hasChest()) {
            return;
        }
        this.b(Block.CHEST.id, 1);
        this.setHasChest(false);
    }

    private void cF() {
        this.cM();
        this.world.makeSound(this, "eating", 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
    }

    @Override
    protected void b(float f) {
        int n;
        int n2;
        if (f > 1.0f) {
            this.makeSound("mob.horse.land", 0.4f, 1.0f);
        }
        if ((n2 = MathHelper.f(f * 0.5f - 3.0f)) <= 0) {
            return;
        }
        this.damageEntity(DamageSource.FALL, n2);
        if (this.passenger != null) {
            this.passenger.damageEntity(DamageSource.FALL, n2);
        }
        if ((n = this.world.getTypeId(MathHelper.floor(this.locX), MathHelper.floor(this.locY - 0.2 - (double)this.lastYaw), MathHelper.floor(this.locZ))) > 0) {
            StepSound stepSound = Block.byId[n].stepSound;
            this.world.makeSound(this, stepSound.getStepSound(), stepSound.getVolume1() * 0.5f, stepSound.getVolume2() * 0.75f);
        }
    }

    private int cG() {
        int n = this.getType();
        if (this.hasChest() && (n == 1 || n == 2)) {
            return 17;
        }
        return 2;
    }

    private void loadChest() {
        InventoryHorseChest inventoryHorseChest = this.inventoryChest;
        this.inventoryChest = new InventoryHorseChest("HorseChest", this.cG());
        this.inventoryChest.a(this.getLocalizedName());
        if (inventoryHorseChest != null) {
            inventoryHorseChest.b(this);
            int n = Math.min(inventoryHorseChest.getSize(), this.inventoryChest.getSize());
            for (int i = 0; i < n; ++i) {
                ItemStack itemStack = inventoryHorseChest.getItem(i);
                if (itemStack == null) continue;
                this.inventoryChest.setItem(i, itemStack.cloneItemStack());
            }
            inventoryHorseChest = null;
        }
        this.inventoryChest.a(this);
        this.cI();
    }

    private void cI() {
        if (!this.world.isStatic) {
            this.n(this.inventoryChest.getItem(0) != null);
            if (this.cv()) {
                this.r(this.d(this.inventoryChest.getItem(1)));
            }
        }
    }

    @Override
    public void a(InventorySubcontainer inventorySubcontainer) {
        int n = this.cf();
        boolean bl = this.co();
        this.cI();
        if (this.ticksLived > 20) {
            if (n == 0 && n != this.cf()) {
                this.makeSound("mob.horse.armor", 0.5f, 1.0f);
            }
            if (!bl && this.co()) {
                this.makeSound("mob.horse.leather", 0.5f, 1.0f);
            }
        }
    }

    @Override
    public boolean canSpawn() {
        this.cl();
        return super.canSpawn();
    }

    protected EntityHorse a(Entity entity, double d) {
        double d2 = Double.MAX_VALUE;
        Entity entity2 = null;
        List list = this.world.getEntities(entity, entity.boundingBox.a(d, d, d), bu);
        for (Entity entity3 : list) {
            double d3 = entity3.e(entity.locX, entity.locY, entity.locZ);
            if (!(d3 < d2)) continue;
            entity2 = entity3;
            d2 = d3;
        }
        return (EntityHorse)entity2;
    }

    public double getJumpStrength() {
        return this.getAttributeInstance(attributeJumpStrength).getValue();
    }

    @Override
    protected String aP() {
        this.cM();
        int n = this.getType();
        if (n == 3) {
            return "mob.horse.zombie.death";
        }
        if (n == 4) {
            return "mob.horse.skeleton.death";
        }
        if (n == 1 || n == 2) {
            return "mob.horse.donkey.death";
        }
        return "mob.horse.death";
    }

    @Override
    protected int getLootId() {
        boolean bl = this.random.nextInt(4) == 0;
        int n = this.getType();
        if (n == 4) {
            return Item.BONE.id;
        }
        if (n == 3) {
            if (bl) {
                return 0;
            }
            return Item.ROTTEN_FLESH.id;
        }
        return Item.LEATHER.id;
    }

    @Override
    protected String aO() {
        int n;
        this.cM();
        if (this.random.nextInt(3) == 0) {
            this.cO();
        }
        if ((n = this.getType()) == 3) {
            return "mob.horse.zombie.hit";
        }
        if (n == 4) {
            return "mob.horse.skeleton.hit";
        }
        if (n == 1 || n == 2) {
            return "mob.horse.donkey.hit";
        }
        return "mob.horse.hit";
    }

    public boolean co() {
        return this.w(4);
    }

    @Override
    protected String r() {
        int n;
        this.cM();
        if (this.random.nextInt(10) == 0 && !this.bc()) {
            this.cO();
        }
        if ((n = this.getType()) == 3) {
            return "mob.horse.zombie.idle";
        }
        if (n == 4) {
            return "mob.horse.skeleton.idle";
        }
        if (n == 1 || n == 2) {
            return "mob.horse.donkey.idle";
        }
        return "mob.horse.idle";
    }

    protected String cp() {
        this.cM();
        this.cO();
        int n = this.getType();
        if (n == 3 || n == 4) {
            return null;
        }
        if (n == 1 || n == 2) {
            return "mob.horse.donkey.angry";
        }
        return "mob.horse.angry";
    }

    @Override
    protected void a(int n, int n2, int n3, int n4) {
        StepSound stepSound = Block.byId[n4].stepSound;
        if (this.world.getTypeId(n, n2 + 1, n3) == Block.SNOW.id) {
            stepSound = Block.SNOW.stepSound;
        }
        if (!Block.byId[n4].material.isLiquid()) {
            int n5 = this.getType();
            if (this.passenger != null && n5 != 1 && n5 != 2) {
                ++this.bP;
                if (this.bP > 5 && this.bP % 3 == 0) {
                    this.makeSound("mob.horse.gallop", stepSound.getVolume1() * 0.15f, stepSound.getVolume2());
                    if (n5 == 0 && this.random.nextInt(10) == 0) {
                        this.makeSound("mob.horse.breathe", stepSound.getVolume1() * 0.6f, stepSound.getVolume2());
                    }
                } else if (this.bP <= 5) {
                    this.makeSound("mob.horse.wood", stepSound.getVolume1() * 0.15f, stepSound.getVolume2());
                }
            } else if (stepSound == Block.h) {
                this.makeSound("mob.horse.soft", stepSound.getVolume1() * 0.15f, stepSound.getVolume2());
            } else {
                this.makeSound("mob.horse.wood", stepSound.getVolume1() * 0.15f, stepSound.getVolume2());
            }
        }
    }

    @Override
    protected void az() {
        super.az();
        this.aX().b(attributeJumpStrength);
        this.getAttributeInstance(GenericAttributes.a).setValue(53.0);
        this.getAttributeInstance(GenericAttributes.d).setValue(0.225f);
    }

    @Override
    public int bv() {
        return 6;
    }

    public int getMaxDomestication() {
        return 100;
    }

    @Override
    protected float ba() {
        return 0.8f;
    }

    @Override
    public int o() {
        return 400;
    }

    private void cJ() {
        this.bQ = null;
    }

    public void f(EntityHuman entityHuman) {
        if (!this.world.isStatic && (this.passenger == null || this.passenger == entityHuman) && this.isTame()) {
            this.inventoryChest.a(this.getLocalizedName());
            entityHuman.openHorseInventory(this, this.inventoryChest);
        }
    }

    @Override
    public boolean a(EntityHuman entityHuman) {
        ItemStack itemStack = entityHuman.inventory.getItemInHand();
        if (itemStack != null && itemStack.id == Item.MONSTER_EGG.id) {
            return super.a(entityHuman);
        }
        if (!this.isTame() && this.cy()) {
            return false;
        }
        if (this.isTame() && this.bV() && entityHuman.isSneaking()) {
            this.f(entityHuman);
            return true;
        }
        if (this.ca() && this.passenger != null) {
            return super.a(entityHuman);
        }
        if (itemStack != null) {
            boolean bl = false;
            if (this.cv()) {
                int n = -1;
                if (itemStack.id == Item.HORSE_ARMOR_IRON.id) {
                    n = 1;
                } else if (itemStack.id == Item.HORSE_ARMOR_GOLD.id) {
                    n = 2;
                } else if (itemStack.id == Item.HORSE_ARMOR_DIAMOND.id) {
                    n = 3;
                }
                if (n >= 0) {
                    if (!this.isTame()) {
                        this.cD();
                        return true;
                    }
                    this.f(entityHuman);
                    return true;
                }
            }
            if (!bl && !this.cy()) {
                float f = 0.0f;
                int n = 0;
                int n2 = 0;
                if (itemStack.id == Item.WHEAT.id) {
                    f = 2.0f;
                    n = 60;
                    n2 = 3;
                } else if (itemStack.id == Item.SUGAR.id) {
                    f = 1.0f;
                    n = 30;
                    n2 = 3;
                } else if (itemStack.id == Item.BREAD.id) {
                    f = 7.0f;
                    n = 180;
                    n2 = 3;
                } else if (itemStack.id == Block.HAY_BLOCK.id) {
                    f = 20.0f;
                    n = 180;
                } else if (itemStack.id == Item.APPLE.id) {
                    f = 3.0f;
                    n = 60;
                    n2 = 3;
                } else if (itemStack.id == Item.CARROT_GOLDEN.id) {
                    f = 4.0f;
                    n = 60;
                    n2 = 5;
                    if (this.isTame() && this.getAge() == 0) {
                        bl = true;
                        this.bX();
                    }
                } else if (itemStack.id == Item.GOLDEN_APPLE.id) {
                    f = 10.0f;
                    n = 240;
                    n2 = 10;
                    if (this.isTame() && this.getAge() == 0) {
                        bl = true;
                        this.bX();
                    }
                }
                if (this.getHealth() < this.getMaxHealth() && f > 0.0f) {
                    this.heal(f);
                    bl = true;
                }
                if (!this.bV() && n > 0) {
                    this.a(n);
                    bl = true;
                }
                if (n2 > 0 && (bl || !this.isTame()) && n2 < this.getMaxDomestication()) {
                    bl = true;
                    this.t(n2);
                }
                if (bl) {
                    this.cF();
                }
            }
            if (!this.isTame() && !bl) {
                if (itemStack != null && itemStack.a(entityHuman, this)) {
                    return true;
                }
                this.cD();
                return true;
            }
            if (!bl && this.cw() && !this.hasChest() && itemStack.id == Block.CHEST.id) {
                this.setHasChest(true);
                this.makeSound("mob.chickenplop", 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                bl = true;
                this.loadChest();
            }
            if (!bl && this.ca() && !this.co() && itemStack.id == Item.SADDLE.id) {
                this.f(entityHuman);
                return true;
            }
            if (bl) {
                if (!entityHuman.abilities.canInstantlyBuild && --itemStack.count == 0) {
                    entityHuman.inventory.setItem(entityHuman.inventory.itemInHandIndex, null);
                }
                return true;
            }
        }
        if (this.ca() && this.passenger == null) {
            if (itemStack != null && itemStack.a(entityHuman, this)) {
                return true;
            }
            this.h(entityHuman);
            return true;
        }
        return super.a(entityHuman);
    }

    private void h(EntityHuman entityHuman) {
        entityHuman.yaw = this.yaw;
        entityHuman.pitch = this.pitch;
        this.o(false);
        this.p(false);
        if (!this.world.isStatic) {
            entityHuman.mount(this);
        }
    }

    public boolean cv() {
        return this.getType() == 0;
    }

    public boolean cw() {
        int n = this.getType();
        return n == 2 || n == 1;
    }

    @Override
    protected boolean bc() {
        if (this.passenger != null && this.co()) {
            return true;
        }
        return this.cg() || this.ch();
    }

    public boolean cy() {
        int n = this.getType();
        return n == 3 || n == 4;
    }

    public boolean cz() {
        return this.cy() || this.getType() == 2;
    }

    @Override
    public boolean c(ItemStack itemStack) {
        return false;
    }

    private void cL() {
        this.bp = 1;
    }

    @Override
    public void die(DamageSource damageSource) {
        super.die(damageSource);
        if (!this.world.isStatic) {
            this.cE();
        }
    }

    @Override
    public void c() {
        if (this.random.nextInt(200) == 0) {
            this.cL();
        }
        super.c();
        if (!this.world.isStatic) {
            EntityHorse entityHorse;
            if (this.random.nextInt(900) == 0 && this.deathTicks == 0) {
                this.heal(1.0f);
            }
            if (!this.cg() && this.passenger == null && this.random.nextInt(300) == 0 && this.world.getTypeId(MathHelper.floor(this.locX), MathHelper.floor(this.locY) - 1, MathHelper.floor(this.locZ)) == Block.GRASS.id) {
                this.o(true);
            }
            if (this.cg() && ++this.bD > 50) {
                this.bD = 0;
                this.o(false);
            }
            if (this.ci() && !this.bV() && !this.cg() && (entityHorse = this.a((Entity)this, 16.0)) != null && this.e(entityHorse) > 4.0) {
                PathEntity pathEntity = this.world.findPath(this, entityHorse, 16.0f, true, false, false, true);
                this.setPathEntity(pathEntity);
            }
        }
    }

    @Override
    public void l_() {
        super.l_();
        if (this.world.isStatic && this.datawatcher.a()) {
            this.datawatcher.e();
            this.cJ();
        }
        if (this.bE > 0 && ++this.bE > 30) {
            this.bE = 0;
            this.b(128, false);
        }
        if (!this.world.isStatic && this.bF > 0 && ++this.bF > 20) {
            this.bF = 0;
            this.p(false);
        }
        if (this.bp > 0 && ++this.bp > 8) {
            this.bp = 0;
        }
        if (this.bq > 0) {
            ++this.bq;
            if (this.bq > 300) {
                this.bq = 0;
            }
        }
        this.bK = this.bJ;
        if (this.cg()) {
            this.bJ += (1.0f - this.bJ) * 0.4f + 0.05f;
            if (this.bJ > 1.0f) {
                this.bJ = 1.0f;
            }
        } else {
            this.bJ += (0.0f - this.bJ) * 0.4f - 0.05f;
            if (this.bJ < 0.0f) {
                this.bJ = 0.0f;
            }
        }
        this.bM = this.bL;
        if (this.ch()) {
            this.bJ = 0.0f;
            this.bK = 0.0f;
            this.bL += (1.0f - this.bL) * 0.4f + 0.05f;
            if (this.bL > 1.0f) {
                this.bL = 1.0f;
            }
        } else {
            this.bI = false;
            this.bL += (0.8f * this.bL * this.bL * this.bL - this.bL) * 0.6f - 0.05f;
            if (this.bL < 0.0f) {
                this.bL = 0.0f;
            }
        }
        this.bO = this.bN;
        if (this.w(128)) {
            this.bN += (1.0f - this.bN) * 0.7f + 0.05f;
            if (this.bN > 1.0f) {
                this.bN = 1.0f;
            }
        } else {
            this.bN += (0.0f - this.bN) * 0.7f - 0.05f;
            if (this.bN < 0.0f) {
                this.bN = 0.0f;
            }
        }
    }

    private void cM() {
        if (!this.world.isStatic) {
            this.bE = 1;
            this.b(128, true);
        }
    }

    private boolean cN() {
        return this.passenger == null && this.vehicle == null && this.isTame() && this.bV() && !this.cz() && this.getHealth() >= this.getMaxHealth();
    }

    @Override
    public void e(boolean bl) {
        this.b(32, bl);
    }

    public void o(boolean bl) {
        this.e(bl);
    }

    public void p(boolean bl) {
        if (bl) {
            this.o(false);
        }
        this.b(64, bl);
    }

    private void cO() {
        if (!this.world.isStatic) {
            this.bF = 1;
            this.p(true);
        }
    }

    public void cD() {
        this.cO();
        String string = this.cp();
        if (string != null) {
            this.makeSound(string, this.ba(), this.bb());
        }
    }

    public void cE() {
        this.a((Entity)this, this.inventoryChest);
        this.cm();
    }

    private void a(Entity entity, InventoryHorseChest inventoryHorseChest) {
        if (inventoryHorseChest == null || this.world.isStatic) {
            return;
        }
        for (int i = 0; i < inventoryHorseChest.getSize(); ++i) {
            ItemStack itemStack = inventoryHorseChest.getItem(i);
            if (itemStack == null) continue;
            this.a(itemStack, 0.0f);
        }
    }

    public boolean g(EntityHuman entityHuman) {
        this.setOwnerName(entityHuman.getName());
        this.setTame(true);
        return true;
    }

    @Override
    public void e(float f, float f2) {
        if (this.passenger == null || !this.co()) {
            this.Y = 0.5f;
            this.aR = 0.02f;
            super.e(f, f2);
            return;
        }
        this.lastYaw = this.yaw = this.passenger.yaw;
        this.pitch = this.passenger.pitch * 0.5f;
        this.b(this.yaw, this.pitch);
        this.aP = this.aN = this.yaw;
        f = ((EntityLiving)this.passenger).be * 0.5f;
        f2 = ((EntityLiving)this.passenger).bf;
        if (f2 <= 0.0f) {
            f2 *= 0.25f;
            this.bP = 0;
        }
        if (this.onGround && this.bt == 0.0f && this.ch() && !this.bI) {
            f = 0.0f;
            f2 = 0.0f;
        }
        if (this.bt > 0.0f && !this.cd() && this.onGround) {
            this.motY = this.getJumpStrength() * (double)this.bt;
            if (this.hasEffect(MobEffectList.JUMP)) {
                this.motY += (double)((float)(this.getEffect(MobEffectList.JUMP).getAmplifier() + 1) * 0.1f);
            }
            this.j(true);
            this.an = true;
            if (f2 > 0.0f) {
                float f3 = MathHelper.sin(this.yaw * (float)Math.PI / 180.0f);
                float f4 = MathHelper.cos(this.yaw * (float)Math.PI / 180.0f);
                this.motX += (double)(-0.4f * f3 * this.bt);
                this.motZ += (double)(0.4f * f4 * this.bt);
                this.makeSound("mob.horse.jump", 0.4f, 1.0f);
            }
            this.bt = 0.0f;
        }
        this.Y = 1.0f;
        this.aR = this.bg() * 0.1f;
        if (!this.world.isStatic) {
            this.i((float)this.getAttributeInstance(GenericAttributes.d).getValue());
            super.e(f, f2);
        }
        if (this.onGround) {
            this.bt = 0.0f;
            this.j(false);
        }
        this.aF = this.aG;
        double d = this.locX - this.lastX;
        double d2 = this.locZ - this.lastZ;
        float f5 = MathHelper.sqrt(d * d + d2 * d2) * 4.0f;
        if (f5 > 1.0f) {
            f5 = 1.0f;
        }
        this.aG += (f5 - this.aG) * 0.4f;
        this.aH += this.aG;
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.setBoolean("EatingHaystack", this.cg());
        nBTTagCompound.setBoolean("ChestedHorse", this.hasChest());
        nBTTagCompound.setBoolean("HasReproduced", this.cj());
        nBTTagCompound.setBoolean("Bred", this.ci());
        nBTTagCompound.setInt("Type", this.getType());
        nBTTagCompound.setInt("Variant", this.getVariant());
        nBTTagCompound.setInt("Temper", this.getTemper());
        nBTTagCompound.setBoolean("Tame", this.isTame());
        nBTTagCompound.setString("OwnerName", this.getOwnerName());
        if (this.hasChest()) {
            NBTTagList nBTTagList = new NBTTagList();
            for (int i = 2; i < this.inventoryChest.getSize(); ++i) {
                ItemStack itemStack = this.inventoryChest.getItem(i);
                if (itemStack == null) continue;
                NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
                nBTTagCompound2.setByte("Slot", (byte)i);
                itemStack.save(nBTTagCompound2);
                nBTTagList.add(nBTTagCompound2);
            }
            nBTTagCompound.set("Items", nBTTagList);
        }
        if (this.inventoryChest.getItem(1) != null) {
            nBTTagCompound.set("ArmorItem", this.inventoryChest.getItem(1).save(new NBTTagCompound("ArmorItem")));
        }
        if (this.inventoryChest.getItem(0) != null) {
            nBTTagCompound.set("SaddleItem", this.inventoryChest.getItem(0).save(new NBTTagCompound("SaddleItem")));
        }
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        Object object;
        AttributeInstance attributeInstance;
        super.a(nBTTagCompound);
        this.o(nBTTagCompound.getBoolean("EatingHaystack"));
        this.k(nBTTagCompound.getBoolean("Bred"));
        this.setHasChest(nBTTagCompound.getBoolean("ChestedHorse"));
        this.m(nBTTagCompound.getBoolean("HasReproduced"));
        this.setType(nBTTagCompound.getInt("Type"));
        this.setVariant(nBTTagCompound.getInt("Variant"));
        this.setTemper(nBTTagCompound.getInt("Temper"));
        this.setTame(nBTTagCompound.getBoolean("Tame"));
        if (nBTTagCompound.hasKey("OwnerName")) {
            this.setOwnerName(nBTTagCompound.getString("OwnerName"));
        }
        if ((attributeInstance = this.aX().a("Speed")) != null) {
            this.getAttributeInstance(GenericAttributes.d).setValue(attributeInstance.b() * 0.25);
        }
        if (this.hasChest()) {
            object = nBTTagCompound.getList("Items");
            this.loadChest();
            for (int i = 0; i < ((NBTTagList)object).size(); ++i) {
                NBTTagCompound nBTTagCompound2 = (NBTTagCompound)((NBTTagList)object).get(i);
                int n = nBTTagCompound2.getByte("Slot") & 0xFF;
                if (n < 2 || n >= this.inventoryChest.getSize()) continue;
                this.inventoryChest.setItem(n, ItemStack.createStack(nBTTagCompound2));
            }
        }
        if (nBTTagCompound.hasKey("ArmorItem") && (object = ItemStack.createStack(nBTTagCompound.getCompound("ArmorItem"))) != null && EntityHorse.v(((ItemStack)object).id)) {
            this.inventoryChest.setItem(1, (ItemStack)object);
        }
        if (nBTTagCompound.hasKey("SaddleItem")) {
            object = ItemStack.createStack(nBTTagCompound.getCompound("SaddleItem"));
            if (object != null && ((ItemStack)object).id == Item.SADDLE.id) {
                this.inventoryChest.setItem(0, (ItemStack)object);
            }
        } else if (nBTTagCompound.getBoolean("Saddle")) {
            this.inventoryChest.setItem(0, new ItemStack(Item.SADDLE));
        }
        this.cI();
    }

    @Override
    public boolean mate(EntityAnimal entityAnimal) {
        int n;
        if (entityAnimal == this) {
            return false;
        }
        if (entityAnimal.getClass() != this.getClass()) {
            return false;
        }
        EntityHorse entityHorse = (EntityHorse)entityAnimal;
        if (!this.cN() || !entityHorse.cN()) {
            return false;
        }
        int n2 = this.getType();
        return n2 == (n = entityHorse.getType()) || n2 == 0 && n == 1 || n2 == 1 && n == 0;
    }

    @Override
    public EntityAgeable createChild(EntityAgeable entityAgeable) {
        EntityHorse entityHorse = (EntityHorse)entityAgeable;
        EntityHorse entityHorse2 = new EntityHorse(this.world);
        int n = this.getType();
        int n2 = entityHorse.getType();
        int n3 = 0;
        if (n == n2) {
            n3 = n;
        } else if (n == 0 && n2 == 1 || n == 1 && n2 == 0) {
            n3 = 2;
        }
        if (n3 == 0) {
            int n4 = this.random.nextInt(9);
            int n5 = n4 < 4 ? this.getVariant() & 0xFF : (n4 < 8 ? entityHorse.getVariant() & 0xFF : this.random.nextInt(7));
            int n6 = this.random.nextInt(5);
            n5 = n6 < 4 ? (n5 |= this.getVariant() & 0xFF00) : (n6 < 8 ? (n5 |= entityHorse.getVariant() & 0xFF00) : (n5 |= this.random.nextInt(5) << 8 & 0xFF00));
            entityHorse2.setVariant(n5);
        }
        entityHorse2.setType(n3);
        double d = this.getAttributeInstance(GenericAttributes.a).b() + entityAgeable.getAttributeInstance(GenericAttributes.a).b() + (double)this.cP();
        entityHorse2.getAttributeInstance(GenericAttributes.a).setValue(d / 3.0);
        double d2 = this.getAttributeInstance(attributeJumpStrength).b() + entityAgeable.getAttributeInstance(attributeJumpStrength).b() + this.cQ();
        entityHorse2.getAttributeInstance(attributeJumpStrength).setValue(d2 / 3.0);
        double d3 = this.getAttributeInstance(GenericAttributes.d).b() + entityAgeable.getAttributeInstance(GenericAttributes.d).b() + this.cR();
        entityHorse2.getAttributeInstance(GenericAttributes.d).setValue(d3 / 3.0);
        return entityHorse2;
    }

    @Override
    public GroupDataEntity a(GroupDataEntity groupDataEntity) {
        groupDataEntity = super.a(groupDataEntity);
        int n = 0;
        int n2 = 0;
        if (groupDataEntity instanceof GroupDataHorse) {
            n = ((GroupDataHorse)groupDataEntity).a;
            n2 = ((GroupDataHorse)groupDataEntity).b & 0xFF | this.random.nextInt(5) << 8;
        } else {
            if (this.random.nextInt(10) == 0) {
                n = 1;
            } else {
                int n3 = this.random.nextInt(7);
                int n4 = this.random.nextInt(5);
                n = 0;
                n2 = n3 | n4 << 8;
            }
            groupDataEntity = new GroupDataHorse(n, n2);
        }
        this.setType(n);
        this.setVariant(n2);
        if (this.random.nextInt(5) == 0) {
            this.setAge(-24000);
        }
        if (n == 4 || n == 3) {
            this.getAttributeInstance(GenericAttributes.a).setValue(15.0);
            this.getAttributeInstance(GenericAttributes.d).setValue(0.2f);
        } else {
            this.getAttributeInstance(GenericAttributes.a).setValue(this.cP());
            if (n == 0) {
                this.getAttributeInstance(GenericAttributes.d).setValue(this.cR());
            } else {
                this.getAttributeInstance(GenericAttributes.d).setValue(0.175f);
            }
        }
        if (n == 2 || n == 1) {
            this.getAttributeInstance(attributeJumpStrength).setValue(0.5);
        } else {
            this.getAttributeInstance(attributeJumpStrength).setValue(this.cQ());
        }
        this.setHealth(this.getMaxHealth());
        return groupDataEntity;
    }

    @Override
    protected boolean bf() {
        return true;
    }

    public void u(int n) {
        if (this.co()) {
            if (n < 0) {
                n = 0;
            } else {
                this.bI = true;
                this.cO();
            }
            this.bt = n >= 90 ? 1.0f : 0.4f + 0.4f * (float)n / 90.0f;
        }
    }

    @Override
    public void W() {
        super.W();
        if (this.bM > 0.0f) {
            float f = MathHelper.sin(this.aN * (float)Math.PI / 180.0f);
            float f2 = MathHelper.cos(this.aN * (float)Math.PI / 180.0f);
            float f3 = 0.7f * this.bM;
            float f4 = 0.15f * this.bM;
            this.passenger.setPosition(this.locX + (double)(f3 * f), this.locY + this.Y() + this.passenger.X() + (double)f4, this.locZ - (double)(f3 * f2));
            if (this.passenger instanceof EntityLiving) {
                ((EntityLiving)this.passenger).aN = this.aN;
            }
        }
    }

    private float cP() {
        return 15.0f + (float)this.random.nextInt(8) + (float)this.random.nextInt(9);
    }

    private double cQ() {
        return (double)0.4f + this.random.nextDouble() * 0.2 + this.random.nextDouble() * 0.2 + this.random.nextDouble() * 0.2;
    }

    private double cR() {
        return ((double)0.45f + this.random.nextDouble() * 0.3 + this.random.nextDouble() * 0.3 + this.random.nextDouble() * 0.3) * 0.25;
    }

    public static boolean v(int n) {
        return n == Item.HORSE_ARMOR_IRON.id || n == Item.HORSE_ARMOR_GOLD.id || n == Item.HORSE_ARMOR_DIAMOND.id;
    }

    @Override
    public boolean e() {
        return false;
    }
}

