/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Direction;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;

public abstract class EntityHanging
extends Entity {
    private int e;
    public int direction;
    public int x;
    public int y;
    public int z;

    public EntityHanging(World world) {
        super(world);
        this.height = 0.0f;
        this.a(0.5f, 0.5f);
    }

    public EntityHanging(World world, int n, int n2, int n3, int n4) {
        this(world);
        this.x = n;
        this.y = n2;
        this.z = n3;
    }

    @Override
    protected void a() {
    }

    public void setDirection(int n) {
        this.direction = n;
        this.lastYaw = this.yaw = (float)(n * 90);
        float f = this.d();
        float f2 = this.e();
        float f3 = this.d();
        if (n == 2 || n == 0) {
            f3 = 0.5f;
            this.yaw = this.lastYaw = (float)(Direction.f[n] * 90);
        } else {
            f = 0.5f;
        }
        f /= 32.0f;
        f2 /= 32.0f;
        f3 /= 32.0f;
        float f4 = (float)this.x + 0.5f;
        float f5 = (float)this.y + 0.5f;
        float f6 = (float)this.z + 0.5f;
        float f7 = 0.5625f;
        if (n == 2) {
            f6 -= f7;
        }
        if (n == 1) {
            f4 -= f7;
        }
        if (n == 0) {
            f6 += f7;
        }
        if (n == 3) {
            f4 += f7;
        }
        if (n == 2) {
            f4 -= this.c(this.d());
        }
        if (n == 1) {
            f6 += this.c(this.d());
        }
        if (n == 0) {
            f4 += this.c(this.d());
        }
        if (n == 3) {
            f6 -= this.c(this.d());
        }
        this.setPosition(f4, f5 += this.c(this.e()), f6);
        float f8 = -0.03125f;
        this.boundingBox.b(f4 - f - f8, f5 - f2 - f8, f6 - f3 - f8, f4 + f + f8, f5 + f2 + f8, f6 + f3 + f8);
    }

    private float c(int n) {
        if (n == 32) {
            return 0.5f;
        }
        if (n == 64) {
            return 0.5f;
        }
        return 0.0f;
    }

    @Override
    public void l_() {
        this.lastX = this.locX;
        this.lastY = this.locY;
        this.lastZ = this.locZ;
        if (this.e++ == 100 && !this.world.isStatic) {
            this.e = 0;
            if (!this.dead && !this.survives()) {
                this.die();
                this.b((Entity)null);
            }
        }
    }

    public boolean survives() {
        if (!this.world.getCubes(this, this.boundingBox).isEmpty()) {
            return false;
        }
        int n = Math.max(1, this.d() / 16);
        int n2 = Math.max(1, this.e() / 16);
        int n3 = this.x;
        int n4 = this.y;
        int n5 = this.z;
        if (this.direction == 2) {
            n3 = MathHelper.floor(this.locX - (double)((float)this.d() / 32.0f));
        }
        if (this.direction == 1) {
            n5 = MathHelper.floor(this.locZ - (double)((float)this.d() / 32.0f));
        }
        if (this.direction == 0) {
            n3 = MathHelper.floor(this.locX - (double)((float)this.d() / 32.0f));
        }
        if (this.direction == 3) {
            n5 = MathHelper.floor(this.locZ - (double)((float)this.d() / 32.0f));
        }
        n4 = MathHelper.floor(this.locY - (double)((float)this.e() / 32.0f));
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Object object = this.direction == 2 || this.direction == 0 ? this.world.getMaterial(n3 + i, n4 + j, this.z) : this.world.getMaterial(this.x, n4 + j, n5 + i);
                if (((Material)object).isBuildable()) continue;
                return false;
            }
        }
        List list = this.world.getEntities(this, this.boundingBox);
        for (Object object : list) {
            if (!(object instanceof EntityHanging)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean L() {
        return true;
    }

    @Override
    public boolean i(Entity entity) {
        if (entity instanceof EntityHuman) {
            return this.damageEntity(DamageSource.playerAttack((EntityHuman)entity), 0.0f);
        }
        return false;
    }

    @Override
    public boolean damageEntity(DamageSource damageSource, float f) {
        if (this.isInvulnerable()) {
            return false;
        }
        if (!this.dead && !this.world.isStatic) {
            this.die();
            this.K();
            this.b(damageSource.getEntity());
        }
        return true;
    }

    @Override
    public void move(double d, double d2, double d3) {
        if (!this.world.isStatic && !this.dead && d * d + d2 * d2 + d3 * d3 > 0.0) {
            this.die();
            this.b((Entity)null);
        }
    }

    @Override
    public void g(double d, double d2, double d3) {
        if (!this.world.isStatic && !this.dead && d * d + d2 * d2 + d3 * d3 > 0.0) {
            this.die();
            this.b((Entity)null);
        }
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.setByte("Direction", (byte)this.direction);
        nBTTagCompound.setInt("TileX", this.x);
        nBTTagCompound.setInt("TileY", this.y);
        nBTTagCompound.setInt("TileZ", this.z);
        switch (this.direction) {
            case 2: {
                nBTTagCompound.setByte("Dir", (byte)0);
                break;
            }
            case 1: {
                nBTTagCompound.setByte("Dir", (byte)1);
                break;
            }
            case 0: {
                nBTTagCompound.setByte("Dir", (byte)2);
                break;
            }
            case 3: {
                nBTTagCompound.setByte("Dir", (byte)3);
            }
        }
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        if (nBTTagCompound.hasKey("Direction")) {
            this.direction = nBTTagCompound.getByte("Direction");
        } else {
            switch (nBTTagCompound.getByte("Dir")) {
                case 0: {
                    this.direction = 2;
                    break;
                }
                case 1: {
                    this.direction = 1;
                    break;
                }
                case 2: {
                    this.direction = 0;
                    break;
                }
                case 3: {
                    this.direction = 3;
                }
            }
        }
        this.x = nBTTagCompound.getInt("TileX");
        this.y = nBTTagCompound.getInt("TileY");
        this.z = nBTTagCompound.getInt("TileZ");
        this.setDirection(this.direction);
    }

    public abstract int d();

    public abstract int e();

    public abstract void b(Entity var1);

    @Override
    protected boolean P() {
        return false;
    }
}

