/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.AchievementList;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityFlying;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLargeFireball;
import net.minecraft.server.GenericAttributes;
import net.minecraft.server.IMonster;
import net.minecraft.server.Item;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

public class EntityGhast
extends EntityFlying
implements IMonster {
    public int h;
    public double i;
    public double j;
    public double bn;
    private Entity target;
    private int br;
    public int bo;
    public int bp;
    private int explosionPower = 1;

    public EntityGhast(World world) {
        super(world);
        this.a(4.0f, 4.0f);
        this.fireProof = true;
        this.b = 5;
    }

    @Override
    public boolean damageEntity(DamageSource damageSource, float f) {
        if (this.isInvulnerable()) {
            return false;
        }
        if ("fireball".equals(damageSource.n()) && damageSource.getEntity() instanceof EntityHuman) {
            super.damageEntity(damageSource, 1000.0f);
            ((EntityHuman)damageSource.getEntity()).a(AchievementList.y);
            return true;
        }
        return super.damageEntity(damageSource, f);
    }

    @Override
    protected void a() {
        super.a();
        this.datawatcher.a(16, (Object)0);
    }

    @Override
    protected void az() {
        super.az();
        this.getAttributeInstance(GenericAttributes.a).setValue(10.0);
    }

    @Override
    protected void bl() {
        byte by;
        byte by2;
        if (!this.world.isStatic && this.world.difficulty == 0) {
            this.die();
        }
        this.u();
        this.bo = this.bp;
        double d = this.i - this.locX;
        double d2 = this.j - this.locY;
        double d3 = this.bn - this.locZ;
        double d4 = d * d + d2 * d2 + d3 * d3;
        if (d4 < 1.0 || d4 > 3600.0) {
            this.i = this.locX + (double)((this.random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.j = this.locY + (double)((this.random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.bn = this.locZ + (double)((this.random.nextFloat() * 2.0f - 1.0f) * 16.0f);
        }
        if (this.h-- <= 0) {
            this.h += this.random.nextInt(5) + 2;
            if (this.a(this.i, this.j, this.bn, d4 = (double)MathHelper.sqrt(d4))) {
                this.motX += d / d4 * 0.1;
                this.motY += d2 / d4 * 0.1;
                this.motZ += d3 / d4 * 0.1;
            } else {
                this.i = this.locX;
                this.j = this.locY;
                this.bn = this.locZ;
            }
        }
        if (this.target != null && this.target.dead) {
            this.target = null;
        }
        if (this.target == null || this.br-- <= 0) {
            this.target = this.world.findNearbyVulnerablePlayer(this, 100.0);
            if (this.target != null) {
                this.br = 20;
            }
        }
        double d5 = 64.0;
        if (this.target != null && this.target.e(this) < d5 * d5) {
            double d6 = this.target.locX - this.locX;
            double d7 = this.target.boundingBox.b + (double)(this.target.length / 2.0f) - (this.locY + (double)(this.length / 2.0f));
            double d8 = this.target.locZ - this.locZ;
            this.aN = this.yaw = -((float)Math.atan2(d6, d8)) * 180.0f / (float)Math.PI;
            if (this.o(this.target)) {
                if (this.bp == 10) {
                    this.world.a(null, 1007, (int)this.locX, (int)this.locY, (int)this.locZ, 0);
                }
                ++this.bp;
                if (this.bp == 20) {
                    this.world.a(null, 1008, (int)this.locX, (int)this.locY, (int)this.locZ, 0);
                    EntityLargeFireball entityLargeFireball = new EntityLargeFireball(this.world, this, d6, d7, d8);
                    entityLargeFireball.yield = this.explosionPower;
                    double d9 = 4.0;
                    Vec3D vec3D = this.j(1.0f);
                    entityLargeFireball.locX = this.locX + vec3D.c * d9;
                    entityLargeFireball.locY = this.locY + (double)(this.length / 2.0f) + 0.5;
                    entityLargeFireball.locZ = this.locZ + vec3D.e * d9;
                    this.world.addEntity(entityLargeFireball);
                    this.bp = -40;
                }
            } else if (this.bp > 0) {
                --this.bp;
            }
        } else {
            this.aN = this.yaw = -((float)Math.atan2(this.motX, this.motZ)) * 180.0f / (float)Math.PI;
            if (this.bp > 0) {
                --this.bp;
            }
        }
        if (!this.world.isStatic && (by2 = this.datawatcher.getByte(16)) != (by = (byte)(this.bp > 10 ? 1 : 0))) {
            this.datawatcher.watch(16, by);
        }
    }

    private boolean a(double d, double d2, double d3, double d4) {
        double d5 = (this.i - this.locX) / d4;
        double d6 = (this.j - this.locY) / d4;
        double d7 = (this.bn - this.locZ) / d4;
        AxisAlignedBB axisAlignedBB = this.boundingBox.clone();
        int n = 1;
        while ((double)n < d4) {
            axisAlignedBB.d(d5, d6, d7);
            if (!this.world.getCubes(this, axisAlignedBB).isEmpty()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    protected String r() {
        return "mob.ghast.moan";
    }

    @Override
    protected String aO() {
        return "mob.ghast.scream";
    }

    @Override
    protected String aP() {
        return "mob.ghast.death";
    }

    @Override
    protected int getLootId() {
        return Item.SULPHUR.id;
    }

    @Override
    protected void dropDeathLoot(boolean bl, int n) {
        int n2;
        int n3 = this.random.nextInt(2) + this.random.nextInt(1 + n);
        for (n2 = 0; n2 < n3; ++n2) {
            this.b(Item.GHAST_TEAR.id, 1);
        }
        n3 = this.random.nextInt(3) + this.random.nextInt(1 + n);
        for (n2 = 0; n2 < n3; ++n2) {
            this.b(Item.SULPHUR.id, 1);
        }
    }

    @Override
    protected float ba() {
        return 10.0f;
    }

    @Override
    public boolean canSpawn() {
        return this.random.nextInt(20) == 0 && super.canSpawn() && this.world.difficulty > 0;
    }

    @Override
    public int bv() {
        return 1;
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.setInt("ExplosionPower", this.explosionPower);
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        if (nBTTagCompound.hasKey("ExplosionPower")) {
            this.explosionPower = nBTTagCompound.getInt("ExplosionPower");
        }
    }
}

