/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityExperienceOrb;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MovingObjectPosition;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.StatisticList;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

public class EntityFishingHook
extends Entity {
    private int d = -1;
    private int e = -1;
    private int f = -1;
    private int g;
    private boolean h;
    public int a;
    public EntityHuman owner;
    private int i;
    private int j;
    private int au;
    public Entity hooked;
    private int av;
    private double aw;
    private double ax;
    private double ay;
    private double az;
    private double aA;

    public EntityFishingHook(World world) {
        super(world);
        this.a(0.25f, 0.25f);
        this.am = true;
    }

    public EntityFishingHook(World world, EntityHuman entityHuman) {
        super(world);
        this.am = true;
        this.owner = entityHuman;
        this.owner.hookedFish = this;
        this.a(0.25f, 0.25f);
        this.setPositionRotation(entityHuman.locX, entityHuman.locY + 1.62 - (double)entityHuman.height, entityHuman.locZ, entityHuman.yaw, entityHuman.pitch);
        this.locX -= (double)(MathHelper.cos(this.yaw / 180.0f * (float)Math.PI) * 0.16f);
        this.locY -= (double)0.1f;
        this.locZ -= (double)(MathHelper.sin(this.yaw / 180.0f * (float)Math.PI) * 0.16f);
        this.setPosition(this.locX, this.locY, this.locZ);
        this.height = 0.0f;
        float f = 0.4f;
        this.motX = -MathHelper.sin(this.yaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.pitch / 180.0f * (float)Math.PI) * f;
        this.motZ = MathHelper.cos(this.yaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.pitch / 180.0f * (float)Math.PI) * f;
        this.motY = -MathHelper.sin(this.pitch / 180.0f * (float)Math.PI) * f;
        this.c(this.motX, this.motY, this.motZ, 1.5f, 1.0f);
    }

    @Override
    protected void a() {
    }

    public void c(double d, double d2, double d3, float f, float f2) {
        float f3 = MathHelper.sqrt(d * d + d2 * d2 + d3 * d3);
        d /= (double)f3;
        d2 /= (double)f3;
        d3 /= (double)f3;
        d += this.random.nextGaussian() * (double)0.0075f * (double)f2;
        d2 += this.random.nextGaussian() * (double)0.0075f * (double)f2;
        d3 += this.random.nextGaussian() * (double)0.0075f * (double)f2;
        this.motX = d *= (double)f;
        this.motY = d2 *= (double)f;
        this.motZ = d3 *= (double)f;
        float f4 = MathHelper.sqrt(d * d + d3 * d3);
        this.lastYaw = this.yaw = (float)(Math.atan2(d, d3) * 180.0 / 3.1415927410125732);
        this.lastPitch = this.pitch = (float)(Math.atan2(d2, f4) * 180.0 / 3.1415927410125732);
        this.i = 0;
    }

    @Override
    public void l_() {
        int n;
        double d;
        super.l_();
        if (this.av > 0) {
            double d2 = this.locX + (this.aw - this.locX) / (double)this.av;
            double d3 = this.locY + (this.ax - this.locY) / (double)this.av;
            double d4 = this.locZ + (this.ay - this.locZ) / (double)this.av;
            double d5 = MathHelper.g(this.az - (double)this.yaw);
            this.yaw = (float)((double)this.yaw + d5 / (double)this.av);
            this.pitch = (float)((double)this.pitch + (this.aA - (double)this.pitch) / (double)this.av);
            --this.av;
            this.setPosition(d2, d3, d4);
            this.b(this.yaw, this.pitch);
            return;
        }
        if (!this.world.isStatic) {
            ItemStack itemStack = this.owner.by();
            if (this.owner.dead || !this.owner.isAlive() || itemStack == null || itemStack.getItem() != Item.FISHING_ROD || this.e(this.owner) > 1024.0) {
                this.die();
                this.owner.hookedFish = null;
                return;
            }
            if (this.hooked != null) {
                if (this.hooked.dead) {
                    this.hooked = null;
                } else {
                    this.locX = this.hooked.locX;
                    this.locY = this.hooked.boundingBox.b + (double)this.hooked.length * 0.8;
                    this.locZ = this.hooked.locZ;
                    return;
                }
            }
        }
        if (this.a > 0) {
            --this.a;
        }
        if (this.h) {
            int n2 = this.world.getTypeId(this.d, this.e, this.f);
            if (n2 == this.g) {
                ++this.i;
                if (this.i == 1200) {
                    this.die();
                }
                return;
            }
            this.h = false;
            this.motX *= (double)(this.random.nextFloat() * 0.2f);
            this.motY *= (double)(this.random.nextFloat() * 0.2f);
            this.motZ *= (double)(this.random.nextFloat() * 0.2f);
            this.i = 0;
            this.j = 0;
        } else {
            ++this.j;
        }
        Vec3D vec3D = this.world.getVec3DPool().create(this.locX, this.locY, this.locZ);
        Vec3D vec3D2 = this.world.getVec3DPool().create(this.locX + this.motX, this.locY + this.motY, this.locZ + this.motZ);
        MovingObjectPosition movingObjectPosition = this.world.a(vec3D, vec3D2);
        vec3D = this.world.getVec3DPool().create(this.locX, this.locY, this.locZ);
        vec3D2 = this.world.getVec3DPool().create(this.locX + this.motX, this.locY + this.motY, this.locZ + this.motZ);
        if (movingObjectPosition != null) {
            vec3D2 = this.world.getVec3DPool().create(movingObjectPosition.pos.c, movingObjectPosition.pos.d, movingObjectPosition.pos.e);
        }
        Entity entity = null;
        List list = this.world.getEntities(this, this.boundingBox.a(this.motX, this.motY, this.motZ).grow(1.0, 1.0, 1.0));
        double d6 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            float f;
            AxisAlignedBB axisAlignedBB;
            MovingObjectPosition movingObjectPosition2;
            Entity entity2 = (Entity)list.get(i);
            if (!entity2.L() || entity2 == this.owner && this.j < 5 || (movingObjectPosition2 = (axisAlignedBB = entity2.boundingBox.grow(f = 0.3f, f, f)).a(vec3D, vec3D2)) == null || !((d = vec3D.d(movingObjectPosition2.pos)) < d6) && d6 != 0.0) continue;
            entity = entity2;
            d6 = d;
        }
        if (entity != null) {
            movingObjectPosition = new MovingObjectPosition(entity);
        }
        if (movingObjectPosition != null) {
            if (movingObjectPosition.entity != null) {
                if (movingObjectPosition.entity.damageEntity(DamageSource.projectile(this, this.owner), 0.0f)) {
                    this.hooked = movingObjectPosition.entity;
                }
            } else {
                this.h = true;
            }
        }
        if (this.h) {
            return;
        }
        this.move(this.motX, this.motY, this.motZ);
        float f = MathHelper.sqrt(this.motX * this.motX + this.motZ * this.motZ);
        this.yaw = (float)(Math.atan2(this.motX, this.motZ) * 180.0 / 3.1415927410125732);
        this.pitch = (float)(Math.atan2(this.motY, f) * 180.0 / 3.1415927410125732);
        while (this.pitch - this.lastPitch < -180.0f) {
            this.lastPitch -= 360.0f;
        }
        while (this.pitch - this.lastPitch >= 180.0f) {
            this.lastPitch += 360.0f;
        }
        while (this.yaw - this.lastYaw < -180.0f) {
            this.lastYaw -= 360.0f;
        }
        while (this.yaw - this.lastYaw >= 180.0f) {
            this.lastYaw += 360.0f;
        }
        this.pitch = this.lastPitch + (this.pitch - this.lastPitch) * 0.2f;
        this.yaw = this.lastYaw + (this.yaw - this.lastYaw) * 0.2f;
        float f2 = 0.92f;
        if (this.onGround || this.positionChanged) {
            f2 = 0.5f;
        }
        int n3 = 5;
        double d7 = 0.0;
        for (n = 0; n < n3; ++n) {
            double d8 = this.boundingBox.b + (this.boundingBox.e - this.boundingBox.b) * (double)(n + 0) / (double)n3 - 0.125 + 0.125;
            double d9 = this.boundingBox.b + (this.boundingBox.e - this.boundingBox.b) * (double)(n + 1) / (double)n3 - 0.125 + 0.125;
            AxisAlignedBB axisAlignedBB = AxisAlignedBB.a().a(this.boundingBox.a, d8, this.boundingBox.c, this.boundingBox.d, d9, this.boundingBox.f);
            if (!this.world.b(axisAlignedBB, Material.WATER)) continue;
            d7 += 1.0 / (double)n3;
        }
        if (d7 > 0.0) {
            if (this.au > 0) {
                --this.au;
            } else {
                n = 500;
                if (this.world.isRainingAt(MathHelper.floor(this.locX), MathHelper.floor(this.locY) + 1, MathHelper.floor(this.locZ))) {
                    n = 300;
                }
                if (this.random.nextInt(n) == 0) {
                    float f3;
                    float f4;
                    this.au = this.random.nextInt(30) + 10;
                    this.motY -= (double)0.2f;
                    this.makeSound("random.splash", 0.25f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                    float f5 = MathHelper.floor(this.boundingBox.b);
                    int n4 = 0;
                    while ((float)n4 < 1.0f + this.width * 20.0f) {
                        f4 = (this.random.nextFloat() * 2.0f - 1.0f) * this.width;
                        f3 = (this.random.nextFloat() * 2.0f - 1.0f) * this.width;
                        this.world.addParticle("bubble", this.locX + (double)f4, f5 + 1.0f, this.locZ + (double)f3, this.motX, this.motY - (double)(this.random.nextFloat() * 0.2f), this.motZ);
                        ++n4;
                    }
                    n4 = 0;
                    while ((float)n4 < 1.0f + this.width * 20.0f) {
                        f4 = (this.random.nextFloat() * 2.0f - 1.0f) * this.width;
                        f3 = (this.random.nextFloat() * 2.0f - 1.0f) * this.width;
                        this.world.addParticle("splash", this.locX + (double)f4, f5 + 1.0f, this.locZ + (double)f3, this.motX, this.motY, this.motZ);
                        ++n4;
                    }
                }
            }
        }
        if (this.au > 0) {
            this.motY -= (double)(this.random.nextFloat() * this.random.nextFloat() * this.random.nextFloat()) * 0.2;
        }
        d = d7 * 2.0 - 1.0;
        this.motY += (double)0.04f * d;
        if (d7 > 0.0) {
            f2 = (float)((double)f2 * 0.9);
            this.motY *= 0.8;
        }
        this.motX *= (double)f2;
        this.motY *= (double)f2;
        this.motZ *= (double)f2;
        this.setPosition(this.locX, this.locY, this.locZ);
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.setShort("xTile", (short)this.d);
        nBTTagCompound.setShort("yTile", (short)this.e);
        nBTTagCompound.setShort("zTile", (short)this.f);
        nBTTagCompound.setByte("inTile", (byte)this.g);
        nBTTagCompound.setByte("shake", (byte)this.a);
        nBTTagCompound.setByte("inGround", (byte)(this.h ? 1 : 0));
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        this.d = nBTTagCompound.getShort("xTile");
        this.e = nBTTagCompound.getShort("yTile");
        this.f = nBTTagCompound.getShort("zTile");
        this.g = nBTTagCompound.getByte("inTile") & 0xFF;
        this.a = nBTTagCompound.getByte("shake") & 0xFF;
        this.h = nBTTagCompound.getByte("inGround") == 1;
    }

    public int c() {
        if (this.world.isStatic) {
            return 0;
        }
        int n = 0;
        if (this.hooked != null) {
            double d = this.owner.locX - this.locX;
            double d2 = this.owner.locY - this.locY;
            double d3 = this.owner.locZ - this.locZ;
            double d4 = MathHelper.sqrt(d * d + d2 * d2 + d3 * d3);
            double d5 = 0.1;
            this.hooked.motX += d * d5;
            this.hooked.motY += d2 * d5 + (double)MathHelper.sqrt(d4) * 0.08;
            this.hooked.motZ += d3 * d5;
            n = 3;
        } else if (this.au > 0) {
            EntityItem entityItem = new EntityItem(this.world, this.locX, this.locY, this.locZ, new ItemStack(Item.RAW_FISH));
            double d = this.owner.locX - this.locX;
            double d6 = this.owner.locY - this.locY;
            double d7 = this.owner.locZ - this.locZ;
            double d8 = MathHelper.sqrt(d * d + d6 * d6 + d7 * d7);
            double d9 = 0.1;
            entityItem.motX = d * d9;
            entityItem.motY = d6 * d9 + (double)MathHelper.sqrt(d8) * 0.08;
            entityItem.motZ = d7 * d9;
            this.world.addEntity(entityItem);
            this.owner.a(StatisticList.B, 1);
            this.owner.world.addEntity(new EntityExperienceOrb(this.owner.world, this.owner.locX, this.owner.locY + 0.5, this.owner.locZ + 0.5, this.random.nextInt(6) + 1));
            n = 1;
        }
        if (this.h) {
            n = 2;
        }
        this.die();
        this.owner.hookedFish = null;
        return n;
    }

    @Override
    public void die() {
        super.die();
        if (this.owner != null) {
            this.owner.hookedFish = null;
        }
    }
}

