/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Entity;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;

public class EntityFireworks
extends Entity {
    private int ticksFlown;
    private int expectedLifespan;

    public EntityFireworks(World world) {
        super(world);
        this.a(0.25f, 0.25f);
    }

    @Override
    protected void a() {
        this.datawatcher.a(8, 5);
    }

    public EntityFireworks(World world, double d, double d2, double d3, ItemStack itemStack) {
        super(world);
        this.ticksFlown = 0;
        this.a(0.25f, 0.25f);
        this.setPosition(d, d2, d3);
        this.height = 0.0f;
        int n = 1;
        if (itemStack != null && itemStack.hasTag()) {
            this.datawatcher.watch(8, itemStack);
            NBTTagCompound nBTTagCompound = itemStack.getTag();
            NBTTagCompound nBTTagCompound2 = nBTTagCompound.getCompound("Fireworks");
            if (nBTTagCompound2 != null) {
                n += nBTTagCompound2.getByte("Flight");
            }
        }
        this.motX = this.random.nextGaussian() * 0.001;
        this.motZ = this.random.nextGaussian() * 0.001;
        this.motY = 0.05;
        this.expectedLifespan = 10 * n + this.random.nextInt(6) + this.random.nextInt(7);
    }

    @Override
    public void l_() {
        this.U = this.locX;
        this.V = this.locY;
        this.W = this.locZ;
        super.l_();
        this.motX *= 1.15;
        this.motZ *= 1.15;
        this.motY += 0.04;
        this.move(this.motX, this.motY, this.motZ);
        float f = MathHelper.sqrt(this.motX * this.motX + this.motZ * this.motZ);
        this.yaw = (float)(Math.atan2(this.motX, this.motZ) * 180.0 / 3.1415927410125732);
        this.pitch = (float)(Math.atan2(this.motY, f) * 180.0 / 3.1415927410125732);
        while (this.pitch - this.lastPitch < -180.0f) {
            this.lastPitch -= 360.0f;
        }
        while (this.pitch - this.lastPitch >= 180.0f) {
            this.lastPitch += 360.0f;
        }
        while (this.yaw - this.lastYaw < -180.0f) {
            this.lastYaw -= 360.0f;
        }
        while (this.yaw - this.lastYaw >= 180.0f) {
            this.lastYaw += 360.0f;
        }
        this.pitch = this.lastPitch + (this.pitch - this.lastPitch) * 0.2f;
        this.yaw = this.lastYaw + (this.yaw - this.lastYaw) * 0.2f;
        if (this.ticksFlown == 0) {
            this.world.makeSound(this, "fireworks.launch", 3.0f, 1.0f);
        }
        ++this.ticksFlown;
        if (this.world.isStatic && this.ticksFlown % 2 < 2) {
            this.world.addParticle("fireworksSpark", this.locX, this.locY - 0.3, this.locZ, this.random.nextGaussian() * 0.05, -this.motY * 0.5, this.random.nextGaussian() * 0.05);
        }
        if (!this.world.isStatic && this.ticksFlown > this.expectedLifespan) {
            this.world.broadcastEntityEffect(this, (byte)17);
            this.die();
        }
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.setInt("Life", this.ticksFlown);
        nBTTagCompound.setInt("LifeTime", this.expectedLifespan);
        ItemStack itemStack = this.datawatcher.getItemStack(8);
        if (itemStack != null) {
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            itemStack.save(nBTTagCompound2);
            nBTTagCompound.setCompound("FireworksItem", nBTTagCompound2);
        }
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        ItemStack itemStack;
        this.ticksFlown = nBTTagCompound.getInt("Life");
        this.expectedLifespan = nBTTagCompound.getInt("LifeTime");
        NBTTagCompound nBTTagCompound2 = nBTTagCompound.getCompound("FireworksItem");
        if (nBTTagCompound2 != null && (itemStack = ItemStack.createStack(nBTTagCompound2)) != null) {
            this.datawatcher.watch(8, itemStack);
        }
    }

    @Override
    public float d(float f) {
        return super.d(f);
    }

    @Override
    public boolean aq() {
        return false;
    }
}

