/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import net.minecraft.server.Block;
import net.minecraft.server.BlockSand;
import net.minecraft.server.CrashReportSystemDetails;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.IContainer;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTBase;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.TileEntity;
import net.minecraft.server.World;

public class EntityFallingBlock
extends Entity {
    public int id;
    public int data;
    public int c;
    public boolean dropItem = true;
    private boolean f;
    private boolean hurtEntities;
    private int fallHurtMax = 40;
    private float fallHurtAmount = 2.0f;
    public NBTTagCompound tileEntityData;

    public EntityFallingBlock(World world) {
        super(world);
    }

    public EntityFallingBlock(World world, double d, double d2, double d3, int n) {
        this(world, d, d2, d3, n, 0);
    }

    public EntityFallingBlock(World world, double d, double d2, double d3, int n, int n2) {
        super(world);
        this.id = n;
        this.data = n2;
        this.m = true;
        this.a(0.98f, 0.98f);
        this.height = this.length / 2.0f;
        this.setPosition(d, d2, d3);
        this.motX = 0.0;
        this.motY = 0.0;
        this.motZ = 0.0;
        this.lastX = d;
        this.lastY = d2;
        this.lastZ = d3;
    }

    @Override
    protected boolean e_() {
        return false;
    }

    @Override
    protected void a() {
    }

    @Override
    public boolean L() {
        return !this.dead;
    }

    @Override
    public void l_() {
        if (this.id == 0) {
            this.die();
            return;
        }
        this.lastX = this.locX;
        this.lastY = this.locY;
        this.lastZ = this.locZ;
        ++this.c;
        this.motY -= (double)0.04f;
        this.move(this.motX, this.motY, this.motZ);
        this.motX *= (double)0.98f;
        this.motY *= (double)0.98f;
        this.motZ *= (double)0.98f;
        if (!this.world.isStatic) {
            int n = MathHelper.floor(this.locX);
            int n2 = MathHelper.floor(this.locY);
            int n3 = MathHelper.floor(this.locZ);
            if (this.c == 1) {
                if (this.world.getTypeId(n, n2, n3) == this.id) {
                    this.world.setAir(n, n2, n3);
                } else {
                    this.die();
                    return;
                }
            }
            if (this.onGround) {
                this.motX *= (double)0.7f;
                this.motZ *= (double)0.7f;
                this.motY *= -0.5;
                if (this.world.getTypeId(n, n2, n3) != Block.PISTON_MOVING.id) {
                    this.die();
                    if (!this.f && this.world.mayPlace(this.id, n, n2, n3, true, 1, null, null) && !BlockSand.canFall(this.world, n, n2 - 1, n3) && this.world.setTypeIdAndData(n, n2, n3, this.id, this.data, 3)) {
                        TileEntity tileEntity;
                        if (Block.byId[this.id] instanceof BlockSand) {
                            ((BlockSand)Block.byId[this.id]).a_(this.world, n, n2, n3, this.data);
                        }
                        if (this.tileEntityData != null && Block.byId[this.id] instanceof IContainer && (tileEntity = this.world.getTileEntity(n, n2, n3)) != null) {
                            NBTTagCompound nBTTagCompound = new NBTTagCompound();
                            tileEntity.b(nBTTagCompound);
                            for (NBTBase nBTBase : this.tileEntityData.c()) {
                                if (nBTBase.getName().equals("x") || nBTBase.getName().equals("y") || nBTBase.getName().equals("z")) continue;
                                nBTTagCompound.set(nBTBase.getName(), nBTBase.clone());
                            }
                            tileEntity.a(nBTTagCompound);
                            tileEntity.update();
                        }
                    } else if (this.dropItem && !this.f) {
                        this.a(new ItemStack(this.id, 1, Block.byId[this.id].getDropData(this.data)), 0.0f);
                    }
                }
            } else if (this.c > 100 && !this.world.isStatic && (n2 < 1 || n2 > 256) || this.c > 600) {
                if (this.dropItem) {
                    this.a(new ItemStack(this.id, 1, Block.byId[this.id].getDropData(this.data)), 0.0f);
                }
                this.die();
            }
        }
    }

    @Override
    protected void b(float f) {
        int n;
        if (this.hurtEntities && (n = MathHelper.f(f - 1.0f)) > 0) {
            ArrayList arrayList = new ArrayList(this.world.getEntities(this, this.boundingBox));
            DamageSource damageSource = this.id == Block.ANVIL.id ? DamageSource.ANVIL : DamageSource.FALLING_BLOCK;
            for (Entity entity : arrayList) {
                entity.damageEntity(damageSource, Math.min(MathHelper.d((float)n * this.fallHurtAmount), this.fallHurtMax));
            }
            if (this.id == Block.ANVIL.id && (double)this.random.nextFloat() < (double)0.05f + (double)n * 0.05) {
                int n2 = this.data >> 2;
                int n3 = this.data & 3;
                if (++n2 > 2) {
                    this.f = true;
                } else {
                    this.data = n3 | n2 << 2;
                }
            }
        }
    }

    @Override
    protected void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.setByte("Tile", (byte)this.id);
        nBTTagCompound.setInt("TileID", this.id);
        nBTTagCompound.setByte("Data", (byte)this.data);
        nBTTagCompound.setByte("Time", (byte)this.c);
        nBTTagCompound.setBoolean("DropItem", this.dropItem);
        nBTTagCompound.setBoolean("HurtEntities", this.hurtEntities);
        nBTTagCompound.setFloat("FallHurtAmount", this.fallHurtAmount);
        nBTTagCompound.setInt("FallHurtMax", this.fallHurtMax);
        if (this.tileEntityData != null) {
            nBTTagCompound.setCompound("TileEntityData", this.tileEntityData);
        }
    }

    @Override
    protected void a(NBTTagCompound nBTTagCompound) {
        this.id = nBTTagCompound.hasKey("TileID") ? nBTTagCompound.getInt("TileID") : nBTTagCompound.getByte("Tile") & 0xFF;
        this.data = nBTTagCompound.getByte("Data") & 0xFF;
        this.c = nBTTagCompound.getByte("Time") & 0xFF;
        if (nBTTagCompound.hasKey("HurtEntities")) {
            this.hurtEntities = nBTTagCompound.getBoolean("HurtEntities");
            this.fallHurtAmount = nBTTagCompound.getFloat("FallHurtAmount");
            this.fallHurtMax = nBTTagCompound.getInt("FallHurtMax");
        } else if (this.id == Block.ANVIL.id) {
            this.hurtEntities = true;
        }
        if (nBTTagCompound.hasKey("DropItem")) {
            this.dropItem = nBTTagCompound.getBoolean("DropItem");
        }
        if (nBTTagCompound.hasKey("TileEntityData")) {
            this.tileEntityData = nBTTagCompound.getCompound("TileEntityData");
        }
        if (this.id == 0) {
            this.id = Block.SAND.id;
        }
    }

    public void a(boolean bl) {
        this.hurtEntities = bl;
    }

    @Override
    public void a(CrashReportSystemDetails crashReportSystemDetails) {
        super.a(crashReportSystemDetails);
        crashReportSystemDetails.a("Immitating block ID", this.id);
        crashReportSystemDetails.a("Immitating block data", this.data);
    }
}

