/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Block;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;

public class EntityExperienceOrb
extends Entity {
    public int a;
    public int b;
    public int c;
    private int d = 5;
    private int value;
    private EntityHuman targetPlayer;
    private int targetTime;

    public EntityExperienceOrb(World world, double d, double d2, double d3, int n) {
        super(world);
        this.a(0.5f, 0.5f);
        this.height = this.length / 2.0f;
        this.setPosition(d, d2, d3);
        this.yaw = (float)(Math.random() * 360.0);
        this.motX = (float)(Math.random() * (double)0.2f - (double)0.1f) * 2.0f;
        this.motY = (float)(Math.random() * 0.2) * 2.0f;
        this.motZ = (float)(Math.random() * (double)0.2f - (double)0.1f) * 2.0f;
        this.value = n;
    }

    @Override
    protected boolean e_() {
        return false;
    }

    public EntityExperienceOrb(World world) {
        super(world);
        this.a(0.25f, 0.25f);
        this.height = this.length / 2.0f;
    }

    @Override
    protected void a() {
    }

    @Override
    public void l_() {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        super.l_();
        if (this.c > 0) {
            --this.c;
        }
        this.lastX = this.locX;
        this.lastY = this.locY;
        this.lastZ = this.locZ;
        this.motY -= (double)0.03f;
        if (this.world.getMaterial(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ)) == Material.LAVA) {
            this.motY = 0.2f;
            this.motX = (this.random.nextFloat() - this.random.nextFloat()) * 0.2f;
            this.motZ = (this.random.nextFloat() - this.random.nextFloat()) * 0.2f;
            this.makeSound("random.fizz", 0.4f, 2.0f + this.random.nextFloat() * 0.4f);
        }
        this.i(this.locX, (this.boundingBox.b + this.boundingBox.e) / 2.0, this.locZ);
        double d6 = 8.0;
        if (this.targetTime < this.a - 20 + this.id % 100) {
            if (this.targetPlayer == null || this.targetPlayer.e(this) > d6 * d6) {
                this.targetPlayer = this.world.findNearbyPlayer(this, d6);
            }
            this.targetTime = this.a;
        }
        if (this.targetPlayer != null && (d5 = 1.0 - (d4 = Math.sqrt((d3 = (this.targetPlayer.locX - this.locX) / d6) * d3 + (d2 = (this.targetPlayer.locY + (double)this.targetPlayer.getHeadHeight() - this.locY) / d6) * d2 + (d = (this.targetPlayer.locZ - this.locZ) / d6) * d))) > 0.0) {
            d5 *= d5;
            this.motX += d3 / d4 * d5 * 0.1;
            this.motY += d2 / d4 * d5 * 0.1;
            this.motZ += d / d4 * d5 * 0.1;
        }
        this.move(this.motX, this.motY, this.motZ);
        float f = 0.98f;
        if (this.onGround) {
            f = 0.58800006f;
            int n = this.world.getTypeId(MathHelper.floor(this.locX), MathHelper.floor(this.boundingBox.b) - 1, MathHelper.floor(this.locZ));
            if (n > 0) {
                f = Block.byId[n].frictionFactor * 0.98f;
            }
        }
        this.motX *= (double)f;
        this.motY *= (double)0.98f;
        this.motZ *= (double)f;
        if (this.onGround) {
            this.motY *= (double)-0.9f;
        }
        ++this.a;
        ++this.b;
        if (this.b >= 6000) {
            this.die();
        }
    }

    @Override
    public boolean I() {
        return this.world.a(this.boundingBox, Material.WATER, (Entity)this);
    }

    @Override
    protected void burn(int n) {
        this.damageEntity(DamageSource.FIRE, n);
    }

    @Override
    public boolean damageEntity(DamageSource damageSource, float f) {
        if (this.isInvulnerable()) {
            return false;
        }
        this.K();
        this.d = (int)((float)this.d - f);
        if (this.d <= 0) {
            this.die();
        }
        return false;
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.setShort("Health", (byte)this.d);
        nBTTagCompound.setShort("Age", (short)this.b);
        nBTTagCompound.setShort("Value", (short)this.value);
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        this.d = nBTTagCompound.getShort("Health") & 0xFF;
        this.b = nBTTagCompound.getShort("Age");
        this.value = nBTTagCompound.getShort("Value");
    }

    @Override
    public void b_(EntityHuman entityHuman) {
        if (this.world.isStatic) {
            return;
        }
        if (this.c == 0 && entityHuman.bv == 0) {
            entityHuman.bv = 2;
            this.makeSound("random.orb", 0.1f, 0.5f * ((this.random.nextFloat() - this.random.nextFloat()) * 0.7f + 1.8f));
            entityHuman.receive(this, 1);
            entityHuman.giveExp(this.value);
            this.die();
        }
    }

    public int c() {
        return this.value;
    }

    public static int getOrbValue(int n) {
        if (n >= 2477) {
            return 2477;
        }
        if (n >= 1237) {
            return 1237;
        }
        if (n >= 617) {
            return 617;
        }
        if (n >= 307) {
            return 307;
        }
        if (n >= 149) {
            return 149;
        }
        if (n >= 73) {
            return 73;
        }
        if (n >= 37) {
            return 37;
        }
        if (n >= 17) {
            return 17;
        }
        if (n >= 7) {
            return 7;
        }
        if (n >= 3) {
            return 3;
        }
        return 1;
    }

    @Override
    public boolean aq() {
        return false;
    }
}

