/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.UUID;
import net.minecraft.server.AttributeInstance;
import net.minecraft.server.AttributeModifier;
import net.minecraft.server.Block;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityDamageSource;
import net.minecraft.server.EntityDamageSourceIndirect;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityMonster;
import net.minecraft.server.GenericAttributes;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

public class EntityEnderman
extends EntityMonster {
    private static final UUID bp = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier bq = new AttributeModifier(bp, "Attacking speed boost", 6.2f, 0).a(false);
    private static boolean[] br = new boolean[256];
    private int bs;
    private int bt;
    private Entity bu;
    private boolean bv;

    public EntityEnderman(World world) {
        super(world);
        this.a(0.6f, 2.9f);
        this.Y = 1.0f;
    }

    @Override
    protected void az() {
        super.az();
        this.getAttributeInstance(GenericAttributes.a).setValue(40.0);
        this.getAttributeInstance(GenericAttributes.d).setValue(0.3f);
        this.getAttributeInstance(GenericAttributes.e).setValue(7.0);
    }

    @Override
    protected void a() {
        super.a();
        this.datawatcher.a(16, new Byte(0));
        this.datawatcher.a(17, new Byte(0));
        this.datawatcher.a(18, new Byte(0));
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.setShort("carried", (short)this.getCarriedId());
        nBTTagCompound.setShort("carriedData", (short)this.getCarriedData());
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.setCarriedId(nBTTagCompound.getShort("carried"));
        this.setCarriedData(nBTTagCompound.getShort("carriedData"));
    }

    @Override
    protected Entity findTarget() {
        EntityHuman entityHuman = this.world.findNearbyVulnerablePlayer(this, 64.0);
        if (entityHuman != null) {
            if (this.f(entityHuman)) {
                this.bv = true;
                if (this.bt == 0) {
                    this.world.makeSound(entityHuman, "mob.endermen.stare", 1.0f, 1.0f);
                }
                if (this.bt++ == 5) {
                    this.bt = 0;
                    this.a(true);
                    return entityHuman;
                }
            } else {
                this.bt = 0;
            }
        }
        return null;
    }

    private boolean f(EntityHuman entityHuman) {
        ItemStack itemStack = entityHuman.inventory.armor[3];
        if (itemStack != null && itemStack.id == Block.PUMPKIN.id) {
            return false;
        }
        Vec3D vec3D = entityHuman.j(1.0f).a();
        Vec3D vec3D2 = this.world.getVec3DPool().create(this.locX - entityHuman.locX, this.boundingBox.b + (double)(this.length / 2.0f) - (entityHuman.locY + (double)entityHuman.getHeadHeight()), this.locZ - entityHuman.locZ);
        double d = vec3D2.b();
        double d2 = vec3D.b(vec3D2 = vec3D2.a());
        if (d2 > 1.0 - 0.025 / d) {
            return entityHuman.o(this);
        }
        return false;
    }

    @Override
    public void c() {
        float f;
        if (this.G()) {
            this.damageEntity(DamageSource.DROWN, 1.0f);
        }
        if (this.bu != this.target) {
            AttributeInstance attributeInstance = this.getAttributeInstance(GenericAttributes.d);
            attributeInstance.b(bq);
            if (this.target != null) {
                attributeInstance.a(bq);
            }
        }
        this.bu = this.target;
        if (!this.world.isStatic && this.world.getGameRules().getBoolean("mobGriefing")) {
            int n;
            int n2;
            int n3;
            if (this.getCarriedId() == 0) {
                int n4;
                if (this.random.nextInt(20) == 0 && br[n3 = this.world.getTypeId(n4 = MathHelper.floor(this.locX - 2.0 + this.random.nextDouble() * 4.0), n2 = MathHelper.floor(this.locY + this.random.nextDouble() * 3.0), n = MathHelper.floor(this.locZ - 2.0 + this.random.nextDouble() * 4.0))]) {
                    this.setCarriedId(this.world.getTypeId(n4, n2, n));
                    this.setCarriedData(this.world.getData(n4, n2, n));
                    this.world.setTypeIdUpdate(n4, n2, n, 0);
                }
            } else if (this.random.nextInt(2000) == 0) {
                int n5 = MathHelper.floor(this.locX - 1.0 + this.random.nextDouble() * 2.0);
                n2 = MathHelper.floor(this.locY + this.random.nextDouble() * 2.0);
                n = MathHelper.floor(this.locZ - 1.0 + this.random.nextDouble() * 2.0);
                n3 = this.world.getTypeId(n5, n2, n);
                int n6 = this.world.getTypeId(n5, n2 - 1, n);
                if (n3 == 0 && n6 > 0 && Block.byId[n6].b()) {
                    this.world.setTypeIdAndData(n5, n2, n, this.getCarriedId(), this.getCarriedData(), 3);
                    this.setCarriedId(0);
                }
            }
        }
        for (int i = 0; i < 2; ++i) {
            this.world.addParticle("portal", this.locX + (this.random.nextDouble() - 0.5) * (double)this.width, this.locY + this.random.nextDouble() * (double)this.length - 0.25, this.locZ + (this.random.nextDouble() - 0.5) * (double)this.width, (this.random.nextDouble() - 0.5) * 2.0, -this.random.nextDouble(), (this.random.nextDouble() - 0.5) * 2.0);
        }
        if (this.world.v() && !this.world.isStatic && (f = this.d(1.0f)) > 0.5f && this.world.l(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ)) && this.random.nextFloat() * 30.0f < (f - 0.4f) * 2.0f) {
            this.target = null;
            this.a(false);
            this.bv = false;
            this.bT();
        }
        if (this.G() || this.isBurning()) {
            this.target = null;
            this.a(false);
            this.bv = false;
            this.bT();
        }
        if (this.bX() && !this.bv && this.random.nextInt(100) == 0) {
            this.a(false);
        }
        this.bd = false;
        if (this.target != null) {
            this.a(this.target, 100.0f, 100.0f);
        }
        if (!this.world.isStatic && this.isAlive()) {
            if (this.target != null) {
                if (this.target instanceof EntityHuman && this.f((EntityHuman)this.target)) {
                    if (this.target.e(this) < 16.0) {
                        this.bT();
                    }
                    this.bs = 0;
                } else if (this.target.e(this) > 256.0 && this.bs++ >= 30 && this.c(this.target)) {
                    this.bs = 0;
                }
            } else {
                this.a(false);
                this.bs = 0;
            }
        }
        super.c();
    }

    protected boolean bT() {
        double d = this.locX + (this.random.nextDouble() - 0.5) * 64.0;
        double d2 = this.locY + (double)(this.random.nextInt(64) - 32);
        double d3 = this.locZ + (this.random.nextDouble() - 0.5) * 64.0;
        return this.j(d, d2, d3);
    }

    protected boolean c(Entity entity) {
        Vec3D vec3D = this.world.getVec3DPool().create(this.locX - entity.locX, this.boundingBox.b + (double)(this.length / 2.0f) - entity.locY + (double)entity.getHeadHeight(), this.locZ - entity.locZ);
        vec3D = vec3D.a();
        double d = 16.0;
        double d2 = this.locX + (this.random.nextDouble() - 0.5) * 8.0 - vec3D.c * d;
        double d3 = this.locY + (double)(this.random.nextInt(16) - 8) - vec3D.d * d;
        double d4 = this.locZ + (this.random.nextDouble() - 0.5) * 8.0 - vec3D.e * d;
        return this.j(d2, d3, d4);
    }

    protected boolean j(double d, double d2, double d3) {
        int n;
        int n2;
        int n3;
        int n4;
        double d4 = this.locX;
        double d5 = this.locY;
        double d6 = this.locZ;
        this.locX = d;
        this.locY = d2;
        this.locZ = d3;
        boolean bl = false;
        int n5 = MathHelper.floor(this.locX);
        if (this.world.isLoaded(n5, n4 = MathHelper.floor(this.locY), n3 = MathHelper.floor(this.locZ))) {
            n2 = 0;
            while (n2 == 0 && n4 > 0) {
                n = this.world.getTypeId(n5, n4 - 1, n3);
                if (n == 0 || !Block.byId[n].material.isSolid()) {
                    this.locY -= 1.0;
                    --n4;
                    continue;
                }
                n2 = 1;
            }
            if (n2 != 0) {
                this.setPosition(this.locX, this.locY, this.locZ);
                if (this.world.getCubes(this, this.boundingBox).isEmpty() && !this.world.containsLiquid(this.boundingBox)) {
                    bl = true;
                }
            }
        }
        if (bl) {
            n2 = 128;
            for (n = 0; n < n2; ++n) {
                double d7 = (double)n / ((double)n2 - 1.0);
                float f = (this.random.nextFloat() - 0.5f) * 0.2f;
                float f2 = (this.random.nextFloat() - 0.5f) * 0.2f;
                float f3 = (this.random.nextFloat() - 0.5f) * 0.2f;
                double d8 = d4 + (this.locX - d4) * d7 + (this.random.nextDouble() - 0.5) * (double)this.width * 2.0;
                double d9 = d5 + (this.locY - d5) * d7 + this.random.nextDouble() * (double)this.length;
                double d10 = d6 + (this.locZ - d6) * d7 + (this.random.nextDouble() - 0.5) * (double)this.width * 2.0;
                this.world.addParticle("portal", d8, d9, d10, f, f2, f3);
            }
            this.world.makeSound(d4, d5, d6, "mob.endermen.portal", 1.0f, 1.0f);
            this.makeSound("mob.endermen.portal", 1.0f, 1.0f);
            return true;
        }
        this.setPosition(d4, d5, d6);
        return false;
    }

    @Override
    protected String r() {
        return this.bX() ? "mob.endermen.scream" : "mob.endermen.idle";
    }

    @Override
    protected String aO() {
        return "mob.endermen.hit";
    }

    @Override
    protected String aP() {
        return "mob.endermen.death";
    }

    @Override
    protected int getLootId() {
        return Item.ENDER_PEARL.id;
    }

    @Override
    protected void dropDeathLoot(boolean bl, int n) {
        int n2 = this.getLootId();
        if (n2 > 0) {
            int n3 = this.random.nextInt(2 + n);
            for (int i = 0; i < n3; ++i) {
                this.b(n2, 1);
            }
        }
    }

    public void setCarriedId(int n) {
        this.datawatcher.watch(16, (byte)(n & 0xFF));
    }

    public int getCarriedId() {
        return this.datawatcher.getByte(16);
    }

    public void setCarriedData(int n) {
        this.datawatcher.watch(17, (byte)(n & 0xFF));
    }

    public int getCarriedData() {
        return this.datawatcher.getByte(17);
    }

    @Override
    public boolean damageEntity(DamageSource damageSource, float f) {
        if (this.isInvulnerable()) {
            return false;
        }
        this.a(true);
        if (damageSource instanceof EntityDamageSource && damageSource.getEntity() instanceof EntityHuman) {
            this.bv = true;
        }
        if (damageSource instanceof EntityDamageSourceIndirect) {
            this.bv = false;
            for (int i = 0; i < 64; ++i) {
                if (!this.bT()) continue;
                return true;
            }
            return false;
        }
        return super.damageEntity(damageSource, f);
    }

    public boolean bX() {
        return this.datawatcher.getByte(18) > 0;
    }

    public void a(boolean bl) {
        this.datawatcher.watch(18, (byte)(bl ? 1 : 0));
    }

    static {
        EntityEnderman.br[Block.GRASS.id] = true;
        EntityEnderman.br[Block.DIRT.id] = true;
        EntityEnderman.br[Block.SAND.id] = true;
        EntityEnderman.br[Block.GRAVEL.id] = true;
        EntityEnderman.br[Block.YELLOW_FLOWER.id] = true;
        EntityEnderman.br[Block.RED_ROSE.id] = true;
        EntityEnderman.br[Block.BROWN_MUSHROOM.id] = true;
        EntityEnderman.br[Block.RED_MUSHROOM.id] = true;
        EntityEnderman.br[Block.TNT.id] = true;
        EntityEnderman.br[Block.CACTUS.id] = true;
        EntityEnderman.br[Block.CLAY.id] = true;
        EntityEnderman.br[Block.PUMPKIN.id] = true;
        EntityEnderman.br[Block.MELON.id] = true;
        EntityEnderman.br[Block.MYCEL.id] = true;
    }
}

