/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.BlockEnderPortal;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityComplexPart;
import net.minecraft.server.EntityEnderCrystal;
import net.minecraft.server.EntityExperienceOrb;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityInsentient;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.GenericAttributes;
import net.minecraft.server.IComplex;
import net.minecraft.server.IMonster;
import net.minecraft.server.MathHelper;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

public class EntityEnderDragon
extends EntityInsentient
implements IComplex,
IMonster {
    public double h;
    public double i;
    public double j;
    public double[][] bn = new double[64][3];
    public int bo = -1;
    public EntityComplexPart[] children;
    public EntityComplexPart bq = new EntityComplexPart(this, "head", 6.0f, 6.0f);
    public EntityComplexPart br = new EntityComplexPart(this, "body", 8.0f, 8.0f);
    public EntityComplexPart bs = new EntityComplexPart(this, "tail", 4.0f, 4.0f);
    public EntityComplexPart bt = new EntityComplexPart(this, "tail", 4.0f, 4.0f);
    public EntityComplexPart bu = new EntityComplexPart(this, "tail", 4.0f, 4.0f);
    public EntityComplexPart bv = new EntityComplexPart(this, "wing", 4.0f, 4.0f);
    public EntityComplexPart bw = new EntityComplexPart(this, "wing", 4.0f, 4.0f);
    public float bx;
    public float by;
    public boolean bz;
    public boolean bA;
    private Entity bD;
    public int bB;
    public EntityEnderCrystal bC;

    public EntityEnderDragon(World world) {
        super(world);
        this.children = new EntityComplexPart[]{this.bq, this.br, this.bs, this.bt, this.bu, this.bv, this.bw};
        this.setHealth(this.getMaxHealth());
        this.a(16.0f, 8.0f);
        this.Z = true;
        this.fireProof = true;
        this.i = 100.0;
        this.am = true;
    }

    @Override
    protected void az() {
        super.az();
        this.getAttributeInstance(GenericAttributes.a).setValue(200.0);
    }

    @Override
    protected void a() {
        super.a();
    }

    public double[] b(int n, float f) {
        if (this.getHealth() <= 0.0f) {
            f = 0.0f;
        }
        f = 1.0f - f;
        int n2 = this.bo - n * 1 & 0x3F;
        int n3 = this.bo - n * 1 - 1 & 0x3F;
        double[] dArray = new double[3];
        double d = this.bn[n2][0];
        double d2 = MathHelper.g(this.bn[n3][0] - d);
        dArray[0] = d + d2 * (double)f;
        d = this.bn[n2][1];
        d2 = this.bn[n3][1] - d;
        dArray[1] = d + d2 * (double)f;
        dArray[2] = this.bn[n2][2] + (this.bn[n3][2] - this.bn[n2][2]) * (double)f;
        return dArray;
    }

    @Override
    public void c() {
        float f;
        double d;
        double d2;
        double d3;
        double d4;
        float f2;
        float f3;
        if (this.world.isStatic) {
            f3 = MathHelper.cos(this.by * (float)Math.PI * 2.0f);
            f2 = MathHelper.cos(this.bx * (float)Math.PI * 2.0f);
            if (f2 <= -0.3f && f3 >= -0.3f) {
                this.world.a(this.locX, this.locY, this.locZ, "mob.enderdragon.wings", 5.0f, 0.8f + this.random.nextFloat() * 0.3f, false);
            }
        }
        this.bx = this.by;
        if (this.getHealth() <= 0.0f) {
            f3 = (this.random.nextFloat() - 0.5f) * 8.0f;
            f2 = (this.random.nextFloat() - 0.5f) * 4.0f;
            float f4 = (this.random.nextFloat() - 0.5f) * 8.0f;
            this.world.addParticle("largeexplode", this.locX + (double)f3, this.locY + 2.0 + (double)f2, this.locZ + (double)f4, 0.0, 0.0, 0.0);
            return;
        }
        this.bJ();
        f3 = 0.2f / (MathHelper.sqrt(this.motX * this.motX + this.motZ * this.motZ) * 10.0f + 1.0f);
        this.by = this.bA ? (this.by += f3 * 0.5f) : (this.by += (f3 *= (float)Math.pow(2.0, this.motY)));
        this.yaw = MathHelper.g(this.yaw);
        if (this.bo < 0) {
            for (int i = 0; i < this.bn.length; ++i) {
                this.bn[i][0] = this.yaw;
                this.bn[i][1] = this.locY;
            }
        }
        if (++this.bo == this.bn.length) {
            this.bo = 0;
        }
        this.bn[this.bo][0] = this.yaw;
        this.bn[this.bo][1] = this.locY;
        if (this.world.isStatic) {
            if (this.bh > 0) {
                d4 = this.locX + (this.bi - this.locX) / (double)this.bh;
                d3 = this.locY + (this.bj - this.locY) / (double)this.bh;
                d2 = this.locZ + (this.bk - this.locZ) / (double)this.bh;
                d = MathHelper.g(this.bl - (double)this.yaw);
                this.yaw = (float)((double)this.yaw + d / (double)this.bh);
                this.pitch = (float)((double)this.pitch + (this.bm - (double)this.pitch) / (double)this.bh);
                --this.bh;
                this.setPosition(d4, d3, d2);
                this.b(this.yaw, this.pitch);
            }
        } else {
            d4 = this.h - this.locX;
            d3 = this.i - this.locY;
            d2 = this.j - this.locZ;
            d = d4 * d4 + d3 * d3 + d2 * d2;
            if (this.bD != null) {
                this.h = this.bD.locX;
                this.j = this.bD.locZ;
                double d5 = this.h - this.locX;
                double d6 = this.j - this.locZ;
                double d7 = Math.sqrt(d5 * d5 + d6 * d6);
                double d8 = (double)0.4f + d7 / 80.0 - 1.0;
                if (d8 > 10.0) {
                    d8 = 10.0;
                }
                this.i = this.bD.boundingBox.b + d8;
            } else {
                this.h += this.random.nextGaussian() * 2.0;
                this.j += this.random.nextGaussian() * 2.0;
            }
            if (this.bz || d < 100.0 || d > 22500.0 || this.positionChanged || this.H) {
                this.bK();
            }
            if ((d3 /= (double)MathHelper.sqrt(d4 * d4 + d2 * d2)) < (double)(-(f = 0.6f))) {
                d3 = -f;
            }
            if (d3 > (double)f) {
                d3 = f;
            }
            this.motY += d3 * (double)0.1f;
            this.yaw = MathHelper.g(this.yaw);
            double d9 = 180.0 - Math.atan2(d4, d2) * 180.0 / 3.1415927410125732;
            double d10 = MathHelper.g(d9 - (double)this.yaw);
            if (d10 > 50.0) {
                d10 = 50.0;
            }
            if (d10 < -50.0) {
                d10 = -50.0;
            }
            Vec3D vec3D = this.world.getVec3DPool().create(this.h - this.locX, this.i - this.locY, this.j - this.locZ).a();
            Vec3D vec3D2 = this.world.getVec3DPool().create(MathHelper.sin(this.yaw * (float)Math.PI / 180.0f), this.motY, -MathHelper.cos(this.yaw * (float)Math.PI / 180.0f)).a();
            float f5 = (float)(vec3D2.b(vec3D) + 0.5) / 1.5f;
            if (f5 < 0.0f) {
                f5 = 0.0f;
            }
            this.bg *= 0.8f;
            float f6 = MathHelper.sqrt(this.motX * this.motX + this.motZ * this.motZ) * 1.0f + 1.0f;
            double d11 = Math.sqrt(this.motX * this.motX + this.motZ * this.motZ) * 1.0 + 1.0;
            if (d11 > 40.0) {
                d11 = 40.0;
            }
            this.bg = (float)((double)this.bg + d10 * ((double)0.7f / d11 / (double)f6));
            this.yaw += this.bg * 0.1f;
            float f7 = (float)(2.0 / (d11 + 1.0));
            float f8 = 0.06f;
            this.a(0.0f, -1.0f, f8 * (f5 * f7 + (1.0f - f7)));
            if (this.bA) {
                this.move(this.motX * (double)0.8f, this.motY * (double)0.8f, this.motZ * (double)0.8f);
            } else {
                this.move(this.motX, this.motY, this.motZ);
            }
            Vec3D vec3D3 = this.world.getVec3DPool().create(this.motX, this.motY, this.motZ).a();
            float f9 = (float)(vec3D3.b(vec3D2) + 1.0) / 2.0f;
            f9 = 0.8f + 0.15f * f9;
            this.motX *= (double)f9;
            this.motZ *= (double)f9;
            this.motY *= (double)0.91f;
        }
        this.aN = this.yaw;
        this.bq.length = 3.0f;
        this.bq.width = 3.0f;
        this.bs.length = 2.0f;
        this.bs.width = 2.0f;
        this.bt.length = 2.0f;
        this.bt.width = 2.0f;
        this.bu.length = 2.0f;
        this.bu.width = 2.0f;
        this.br.length = 3.0f;
        this.br.width = 5.0f;
        this.bv.length = 2.0f;
        this.bv.width = 4.0f;
        this.bw.length = 3.0f;
        this.bw.width = 4.0f;
        f2 = (float)(this.b(5, 1.0f)[1] - this.b(10, 1.0f)[1]) * 10.0f / 180.0f * (float)Math.PI;
        float f10 = MathHelper.cos(f2);
        float f11 = -MathHelper.sin(f2);
        float f12 = this.yaw * (float)Math.PI / 180.0f;
        float f13 = MathHelper.sin(f12);
        float f14 = MathHelper.cos(f12);
        this.br.l_();
        this.br.setPositionRotation(this.locX + (double)(f13 * 0.5f), this.locY, this.locZ - (double)(f14 * 0.5f), 0.0f, 0.0f);
        this.bv.l_();
        this.bv.setPositionRotation(this.locX + (double)(f14 * 4.5f), this.locY + 2.0, this.locZ + (double)(f13 * 4.5f), 0.0f, 0.0f);
        this.bw.l_();
        this.bw.setPositionRotation(this.locX - (double)(f14 * 4.5f), this.locY + 2.0, this.locZ - (double)(f13 * 4.5f), 0.0f, 0.0f);
        if (!this.world.isStatic && this.hurtTicks == 0) {
            this.a(this.world.getEntities(this, this.bv.boundingBox.grow(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0)));
            this.a(this.world.getEntities(this, this.bw.boundingBox.grow(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0)));
            this.b(this.world.getEntities(this, this.bq.boundingBox.grow(1.0, 1.0, 1.0)));
        }
        double[] dArray = this.b(5, 1.0f);
        double[] dArray2 = this.b(0, 1.0f);
        f = MathHelper.sin(this.yaw * (float)Math.PI / 180.0f - this.bg * 0.01f);
        float f15 = MathHelper.cos(this.yaw * (float)Math.PI / 180.0f - this.bg * 0.01f);
        this.bq.l_();
        this.bq.setPositionRotation(this.locX + (double)(f * 5.5f * f10), this.locY + (dArray2[1] - dArray[1]) * 1.0 + (double)(f11 * 5.5f), this.locZ - (double)(f15 * 5.5f * f10), 0.0f, 0.0f);
        for (int i = 0; i < 3; ++i) {
            EntityComplexPart entityComplexPart = null;
            if (i == 0) {
                entityComplexPart = this.bs;
            }
            if (i == 1) {
                entityComplexPart = this.bt;
            }
            if (i == 2) {
                entityComplexPart = this.bu;
            }
            double[] dArray3 = this.b(12 + i * 2, 1.0f);
            float f16 = this.yaw * (float)Math.PI / 180.0f + this.b(dArray3[0] - dArray[0]) * (float)Math.PI / 180.0f * 1.0f;
            float f17 = MathHelper.sin(f16);
            float f18 = MathHelper.cos(f16);
            float f19 = 1.5f;
            float f20 = (float)(i + 1) * 2.0f;
            entityComplexPart.l_();
            entityComplexPart.setPositionRotation(this.locX - (double)((f13 * f19 + f17 * f20) * f10), this.locY + (dArray3[1] - dArray[1]) * 1.0 - (double)((f20 + f19) * f11) + 1.5, this.locZ + (double)((f14 * f19 + f18 * f20) * f10), 0.0f, 0.0f);
        }
        if (!this.world.isStatic) {
            this.bA = this.a(this.bq.boundingBox) | this.a(this.br.boundingBox);
        }
    }

    private void bJ() {
        if (this.bC != null) {
            if (this.bC.dead) {
                if (!this.world.isStatic) {
                    this.a(this.bq, DamageSource.explosion(null), 10.0f);
                }
                this.bC = null;
            } else if (this.ticksLived % 10 == 0 && this.getHealth() < this.getMaxHealth()) {
                this.setHealth(this.getHealth() + 1.0f);
            }
        }
        if (this.random.nextInt(10) == 0) {
            float f = 32.0f;
            List list = this.world.a(EntityEnderCrystal.class, this.boundingBox.grow(f, f, f));
            EntityEnderCrystal entityEnderCrystal = null;
            double d = Double.MAX_VALUE;
            for (EntityEnderCrystal entityEnderCrystal2 : list) {
                double d2 = entityEnderCrystal2.e(this);
                if (!(d2 < d)) continue;
                d = d2;
                entityEnderCrystal = entityEnderCrystal2;
            }
            this.bC = entityEnderCrystal;
        }
    }

    private void a(List list) {
        double d = (this.br.boundingBox.a + this.br.boundingBox.d) / 2.0;
        double d2 = (this.br.boundingBox.c + this.br.boundingBox.f) / 2.0;
        for (Entity entity : list) {
            if (!(entity instanceof EntityLiving)) continue;
            double d3 = entity.locX - d;
            double d4 = entity.locZ - d2;
            double d5 = d3 * d3 + d4 * d4;
            entity.g(d3 / d5 * 4.0, 0.2f, d4 / d5 * 4.0);
        }
    }

    private void b(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!(entity instanceof EntityLiving)) continue;
            entity.damageEntity(DamageSource.mobAttack(this), 10.0f);
        }
    }

    private void bK() {
        this.bz = false;
        if (this.random.nextInt(2) == 0 && !this.world.players.isEmpty()) {
            this.bD = (Entity)this.world.players.get(this.random.nextInt(this.world.players.size()));
        } else {
            double d;
            double d2;
            double d3;
            boolean bl = false;
            do {
                this.h = 0.0;
                this.i = 70.0f + this.random.nextFloat() * 50.0f;
                this.j = 0.0;
                this.h += (double)(this.random.nextFloat() * 120.0f - 60.0f);
                this.j += (double)(this.random.nextFloat() * 120.0f - 60.0f);
            } while (!(bl = (d3 = this.locX - this.h) * d3 + (d2 = this.locY - this.i) * d2 + (d = this.locZ - this.j) * d > 100.0));
            this.bD = null;
        }
    }

    private float b(double d) {
        return (float)MathHelper.g(d);
    }

    private boolean a(AxisAlignedBB axisAlignedBB) {
        int n = MathHelper.floor(axisAlignedBB.a);
        int n2 = MathHelper.floor(axisAlignedBB.b);
        int n3 = MathHelper.floor(axisAlignedBB.c);
        int n4 = MathHelper.floor(axisAlignedBB.d);
        int n5 = MathHelper.floor(axisAlignedBB.e);
        int n6 = MathHelper.floor(axisAlignedBB.f);
        boolean bl = false;
        boolean bl2 = false;
        for (int i = n; i <= n4; ++i) {
            for (int j = n2; j <= n5; ++j) {
                for (int k = n3; k <= n6; ++k) {
                    int n7 = this.world.getTypeId(i, j, k);
                    if (n7 == 0) continue;
                    if (n7 == Block.OBSIDIAN.id || n7 == Block.WHITESTONE.id || n7 == Block.BEDROCK.id || !this.world.getGameRules().getBoolean("mobGriefing")) {
                        bl = true;
                        continue;
                    }
                    bl2 = this.world.setAir(i, j, k) || bl2;
                }
            }
        }
        if (bl2) {
            double d = axisAlignedBB.a + (axisAlignedBB.d - axisAlignedBB.a) * (double)this.random.nextFloat();
            double d2 = axisAlignedBB.b + (axisAlignedBB.e - axisAlignedBB.b) * (double)this.random.nextFloat();
            double d3 = axisAlignedBB.c + (axisAlignedBB.f - axisAlignedBB.c) * (double)this.random.nextFloat();
            this.world.addParticle("largeexplode", d, d2, d3, 0.0, 0.0, 0.0);
        }
        return bl;
    }

    @Override
    public boolean a(EntityComplexPart entityComplexPart, DamageSource damageSource, float f) {
        if (entityComplexPart != this.bq) {
            f = f / 4.0f + 1.0f;
        }
        float f2 = this.yaw * (float)Math.PI / 180.0f;
        float f3 = MathHelper.sin(f2);
        float f4 = MathHelper.cos(f2);
        this.h = this.locX + (double)(f3 * 5.0f) + (double)((this.random.nextFloat() - 0.5f) * 2.0f);
        this.i = this.locY + (double)(this.random.nextFloat() * 3.0f) + 1.0;
        this.j = this.locZ - (double)(f4 * 5.0f) + (double)((this.random.nextFloat() - 0.5f) * 2.0f);
        this.bD = null;
        if (damageSource.getEntity() instanceof EntityHuman || damageSource.c()) {
            this.dealDamage(damageSource, f);
        }
        return true;
    }

    @Override
    public boolean damageEntity(DamageSource damageSource, float f) {
        return false;
    }

    protected boolean dealDamage(DamageSource damageSource, float f) {
        return super.damageEntity(damageSource, f);
    }

    @Override
    protected void aB() {
        ++this.bB;
        if (this.bB >= 180 && this.bB <= 200) {
            float f = (this.random.nextFloat() - 0.5f) * 8.0f;
            float f2 = (this.random.nextFloat() - 0.5f) * 4.0f;
            float f3 = (this.random.nextFloat() - 0.5f) * 8.0f;
            this.world.addParticle("hugeexplosion", this.locX + (double)f, this.locY + 2.0 + (double)f2, this.locZ + (double)f3, 0.0, 0.0, 0.0);
        }
        if (!this.world.isStatic) {
            if (this.bB > 150 && this.bB % 5 == 0) {
                int n;
                for (int i = 1000; i > 0; i -= n) {
                    n = EntityExperienceOrb.getOrbValue(i);
                    this.world.addEntity(new EntityExperienceOrb(this.world, this.locX, this.locY, this.locZ, n));
                }
            }
            if (this.bB == 1) {
                this.world.d(1018, (int)this.locX, (int)this.locY, (int)this.locZ, 0);
            }
        }
        this.move(0.0, 0.1f, 0.0);
        this.aN = this.yaw += 20.0f;
        if (this.bB == 200 && !this.world.isStatic) {
            int n;
            for (int i = 2000; i > 0; i -= n) {
                n = EntityExperienceOrb.getOrbValue(i);
                this.world.addEntity(new EntityExperienceOrb(this.world, this.locX, this.locY, this.locZ, n));
            }
            this.c(MathHelper.floor(this.locX), MathHelper.floor(this.locZ));
            this.die();
        }
    }

    private void c(int n, int n2) {
        int n3 = 64;
        BlockEnderPortal.a = true;
        int n4 = 4;
        for (int i = n3 - 1; i <= n3 + 32; ++i) {
            for (int j = n - n4; j <= n + n4; ++j) {
                for (int k = n2 - n4; k <= n2 + n4; ++k) {
                    double d = j - n;
                    double d2 = k - n2;
                    double d3 = d * d + d2 * d2;
                    if (!(d3 <= ((double)n4 - 0.5) * ((double)n4 - 0.5))) continue;
                    if (i < n3) {
                        if (!(d3 <= ((double)(n4 - 1) - 0.5) * ((double)(n4 - 1) - 0.5))) continue;
                        this.world.setTypeIdUpdate(j, i, k, Block.BEDROCK.id);
                        continue;
                    }
                    if (i > n3) {
                        this.world.setTypeIdUpdate(j, i, k, 0);
                        continue;
                    }
                    if (d3 > ((double)(n4 - 1) - 0.5) * ((double)(n4 - 1) - 0.5)) {
                        this.world.setTypeIdUpdate(j, i, k, Block.BEDROCK.id);
                        continue;
                    }
                    this.world.setTypeIdUpdate(j, i, k, Block.ENDER_PORTAL.id);
                }
            }
        }
        this.world.setTypeIdUpdate(n, n3 + 0, n2, Block.BEDROCK.id);
        this.world.setTypeIdUpdate(n, n3 + 1, n2, Block.BEDROCK.id);
        this.world.setTypeIdUpdate(n, n3 + 2, n2, Block.BEDROCK.id);
        this.world.setTypeIdUpdate(n - 1, n3 + 2, n2, Block.TORCH.id);
        this.world.setTypeIdUpdate(n + 1, n3 + 2, n2, Block.TORCH.id);
        this.world.setTypeIdUpdate(n, n3 + 2, n2 - 1, Block.TORCH.id);
        this.world.setTypeIdUpdate(n, n3 + 2, n2 + 1, Block.TORCH.id);
        this.world.setTypeIdUpdate(n, n3 + 3, n2, Block.BEDROCK.id);
        this.world.setTypeIdUpdate(n, n3 + 4, n2, Block.DRAGON_EGG.id);
        BlockEnderPortal.a = false;
    }

    @Override
    protected void u() {
    }

    @Override
    public Entity[] ao() {
        return this.children;
    }

    @Override
    public boolean L() {
        return false;
    }

    @Override
    public World b() {
        return this.world;
    }

    @Override
    protected String r() {
        return "mob.enderdragon.growl";
    }

    @Override
    protected String aO() {
        return "mob.enderdragon.hit";
    }

    @Override
    protected float ba() {
        return 5.0f;
    }
}

