/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.ChatMessage;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.ItemStack;
import net.minecraft.server.LocaleI18n;

public class EntityDamageSource
extends DamageSource {
    protected Entity p;

    public EntityDamageSource(String string, Entity entity) {
        super(string);
        this.p = entity;
    }

    @Override
    public Entity getEntity() {
        return this.p;
    }

    @Override
    public ChatMessage getLocalizedDeathMessage(EntityLiving entityLiving) {
        ItemStack itemStack = this.p instanceof EntityLiving ? ((EntityLiving)this.p).aZ() : null;
        String string = "death.attack." + this.translationIndex;
        String string2 = string + ".item";
        if (itemStack != null && itemStack.hasName() && LocaleI18n.b(string2)) {
            return ChatMessage.b(string2, entityLiving.getScoreboardDisplayName(), this.p.getScoreboardDisplayName(), itemStack.getName());
        }
        return ChatMessage.b(string, entityLiving.getScoreboardDisplayName(), this.p.getScoreboardDisplayName());
    }

    @Override
    public boolean p() {
        return this.p != null && this.p instanceof EntityLiving && !(this.p instanceof EntityHuman);
    }
}

