/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLightning;
import net.minecraft.server.EntityMonster;
import net.minecraft.server.EntityOcelot;
import net.minecraft.server.EntitySkeleton;
import net.minecraft.server.GenericAttributes;
import net.minecraft.server.Item;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.PathfinderGoalAvoidPlayer;
import net.minecraft.server.PathfinderGoalFloat;
import net.minecraft.server.PathfinderGoalHurtByTarget;
import net.minecraft.server.PathfinderGoalLookAtPlayer;
import net.minecraft.server.PathfinderGoalMeleeAttack;
import net.minecraft.server.PathfinderGoalNearestAttackableTarget;
import net.minecraft.server.PathfinderGoalRandomLookaround;
import net.minecraft.server.PathfinderGoalRandomStroll;
import net.minecraft.server.PathfinderGoalSwell;
import net.minecraft.server.World;

public class EntityCreeper
extends EntityMonster {
    private int bp;
    private int fuseTicks;
    private int maxFuseTicks = 30;
    private int explosionRadius = 3;

    public EntityCreeper(World world) {
        super(world);
        this.goalSelector.a(1, new PathfinderGoalFloat(this));
        this.goalSelector.a(2, new PathfinderGoalSwell(this));
        this.goalSelector.a(3, new PathfinderGoalAvoidPlayer(this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.goalSelector.a(4, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.goalSelector.a(5, new PathfinderGoalRandomStroll(this, 0.8));
        this.goalSelector.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.goalSelector.a(6, new PathfinderGoalRandomLookaround(this));
        this.targetSelector.a(1, new PathfinderGoalNearestAttackableTarget(this, EntityHuman.class, 0, true));
        this.targetSelector.a(2, new PathfinderGoalHurtByTarget(this, false));
    }

    @Override
    protected void az() {
        super.az();
        this.getAttributeInstance(GenericAttributes.d).setValue(0.25);
    }

    @Override
    public boolean bf() {
        return true;
    }

    @Override
    public int as() {
        if (this.getGoalTarget() == null) {
            return 3;
        }
        return 3 + (int)(this.getHealth() - 1.0f);
    }

    @Override
    protected void b(float f) {
        super.b(f);
        this.fuseTicks = (int)((float)this.fuseTicks + f * 1.5f);
        if (this.fuseTicks > this.maxFuseTicks - 5) {
            this.fuseTicks = this.maxFuseTicks - 5;
        }
    }

    @Override
    protected void a() {
        super.a();
        this.datawatcher.a(16, (Object)-1);
        this.datawatcher.a(17, (Object)0);
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        if (this.datawatcher.getByte(17) == 1) {
            nBTTagCompound.setBoolean("powered", true);
        }
        nBTTagCompound.setShort("Fuse", (short)this.maxFuseTicks);
        nBTTagCompound.setByte("ExplosionRadius", (byte)this.explosionRadius);
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.datawatcher.watch(17, (byte)(nBTTagCompound.getBoolean("powered") ? 1 : 0));
        if (nBTTagCompound.hasKey("Fuse")) {
            this.maxFuseTicks = nBTTagCompound.getShort("Fuse");
        }
        if (nBTTagCompound.hasKey("ExplosionRadius")) {
            this.explosionRadius = nBTTagCompound.getByte("ExplosionRadius");
        }
    }

    @Override
    public void l_() {
        if (this.isAlive()) {
            this.bp = this.fuseTicks;
            int n = this.bV();
            if (n > 0 && this.fuseTicks == 0) {
                this.makeSound("random.fuse", 1.0f, 0.5f);
            }
            this.fuseTicks += n;
            if (this.fuseTicks < 0) {
                this.fuseTicks = 0;
            }
            if (this.fuseTicks >= this.maxFuseTicks) {
                this.fuseTicks = this.maxFuseTicks;
                if (!this.world.isStatic) {
                    boolean bl = this.world.getGameRules().getBoolean("mobGriefing");
                    if (this.isPowered()) {
                        this.world.explode(this, this.locX, this.locY, this.locZ, this.explosionRadius * 2, bl);
                    } else {
                        this.world.explode(this, this.locX, this.locY, this.locZ, this.explosionRadius, bl);
                    }
                    this.die();
                }
            }
        }
        super.l_();
    }

    @Override
    protected String aO() {
        return "mob.creeper.say";
    }

    @Override
    protected String aP() {
        return "mob.creeper.death";
    }

    @Override
    public void die(DamageSource damageSource) {
        super.die(damageSource);
        if (damageSource.getEntity() instanceof EntitySkeleton) {
            int n = Item.RECORD_1.id + this.random.nextInt(Item.RECORD_12.id - Item.RECORD_1.id + 1);
            this.b(n, 1);
        }
    }

    @Override
    public boolean m(Entity entity) {
        return true;
    }

    public boolean isPowered() {
        return this.datawatcher.getByte(17) == 1;
    }

    @Override
    protected int getLootId() {
        return Item.SULPHUR.id;
    }

    public int bV() {
        return this.datawatcher.getByte(16);
    }

    public void a(int n) {
        this.datawatcher.watch(16, (byte)n);
    }

    @Override
    public void a(EntityLightning entityLightning) {
        super.a(entityLightning);
        this.datawatcher.watch(17, (byte)1);
    }
}

