/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.EntityAgeable;
import net.minecraft.server.EntityAnimal;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.GenericAttributes;
import net.minecraft.server.Item;
import net.minecraft.server.ItemSeeds;
import net.minecraft.server.ItemStack;
import net.minecraft.server.PathfinderGoalBreed;
import net.minecraft.server.PathfinderGoalFloat;
import net.minecraft.server.PathfinderGoalFollowParent;
import net.minecraft.server.PathfinderGoalLookAtPlayer;
import net.minecraft.server.PathfinderGoalPanic;
import net.minecraft.server.PathfinderGoalRandomLookaround;
import net.minecraft.server.PathfinderGoalRandomStroll;
import net.minecraft.server.PathfinderGoalTempt;
import net.minecraft.server.World;

public class EntityChicken
extends EntityAnimal {
    public float bp;
    public float bq;
    public float br;
    public float bs;
    public float bt = 1.0f;
    public int bu;

    public EntityChicken(World world) {
        super(world);
        this.a(0.3f, 0.7f);
        this.bu = this.random.nextInt(6000) + 6000;
        this.goalSelector.a(0, new PathfinderGoalFloat(this));
        this.goalSelector.a(1, new PathfinderGoalPanic(this, 1.4));
        this.goalSelector.a(2, new PathfinderGoalBreed(this, 1.0));
        this.goalSelector.a(3, new PathfinderGoalTempt(this, 1.0, Item.SEEDS.id, false));
        this.goalSelector.a(4, new PathfinderGoalFollowParent(this, 1.1));
        this.goalSelector.a(5, new PathfinderGoalRandomStroll(this, 1.0));
        this.goalSelector.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.goalSelector.a(7, new PathfinderGoalRandomLookaround(this));
    }

    @Override
    public boolean bf() {
        return true;
    }

    @Override
    protected void az() {
        super.az();
        this.getAttributeInstance(GenericAttributes.a).setValue(4.0);
        this.getAttributeInstance(GenericAttributes.d).setValue(0.25);
    }

    @Override
    public void c() {
        super.c();
        this.bs = this.bp;
        this.br = this.bq;
        this.bq = (float)((double)this.bq + (double)(this.onGround ? -1 : 4) * 0.3);
        if (this.bq < 0.0f) {
            this.bq = 0.0f;
        }
        if (this.bq > 1.0f) {
            this.bq = 1.0f;
        }
        if (!this.onGround && this.bt < 1.0f) {
            this.bt = 1.0f;
        }
        this.bt = (float)((double)this.bt * 0.9);
        if (!this.onGround && this.motY < 0.0) {
            this.motY *= 0.6;
        }
        this.bp += this.bt * 2.0f;
        if (!this.isBaby() && !this.world.isStatic && --this.bu <= 0) {
            this.makeSound("mob.chicken.plop", 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            this.b(Item.EGG.id, 1);
            this.bu = this.random.nextInt(6000) + 6000;
        }
    }

    @Override
    protected void b(float f) {
    }

    @Override
    protected String r() {
        return "mob.chicken.say";
    }

    @Override
    protected String aO() {
        return "mob.chicken.hurt";
    }

    @Override
    protected String aP() {
        return "mob.chicken.hurt";
    }

    @Override
    protected void a(int n, int n2, int n3, int n4) {
        this.makeSound("mob.chicken.step", 0.15f, 1.0f);
    }

    @Override
    protected int getLootId() {
        return Item.FEATHER.id;
    }

    @Override
    protected void dropDeathLoot(boolean bl, int n) {
        int n2 = this.random.nextInt(3) + this.random.nextInt(1 + n);
        for (int i = 0; i < n2; ++i) {
            this.b(Item.FEATHER.id, 1);
        }
        if (this.isBurning()) {
            this.b(Item.COOKED_CHICKEN.id, 1);
        } else {
            this.b(Item.RAW_CHICKEN.id, 1);
        }
    }

    public EntityChicken b(EntityAgeable entityAgeable) {
        return new EntityChicken(this.world);
    }

    @Override
    public boolean c(ItemStack itemStack) {
        return itemStack != null && itemStack.getItem() instanceof ItemSeeds;
    }

    @Override
    public /* synthetic */ EntityAgeable createChild(EntityAgeable entityAgeable) {
        return this.b(entityAgeable);
    }
}

