/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.Item;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;

public class EntityBoat
extends Entity {
    private boolean a = true;
    private double b = 0.07;
    private int c;
    private double d;
    private double e;
    private double f;
    private double g;
    private double h;

    public EntityBoat(World world) {
        super(world);
        this.m = true;
        this.a(1.5f, 0.6f);
        this.height = this.length / 2.0f;
    }

    @Override
    protected boolean e_() {
        return false;
    }

    @Override
    protected void a() {
        this.datawatcher.a(17, new Integer(0));
        this.datawatcher.a(18, new Integer(1));
        this.datawatcher.a(19, new Float(0.0f));
    }

    @Override
    public AxisAlignedBB g(Entity entity) {
        return entity.boundingBox;
    }

    @Override
    public AxisAlignedBB E() {
        return this.boundingBox;
    }

    @Override
    public boolean M() {
        return true;
    }

    public EntityBoat(World world, double d, double d2, double d3) {
        this(world);
        this.setPosition(d, d2 + (double)this.height, d3);
        this.motX = 0.0;
        this.motY = 0.0;
        this.motZ = 0.0;
        this.lastX = d;
        this.lastY = d2;
        this.lastZ = d3;
    }

    @Override
    public double Y() {
        return (double)this.length * 0.0 - (double)0.3f;
    }

    @Override
    public boolean damageEntity(DamageSource damageSource, float f) {
        boolean bl;
        if (this.isInvulnerable()) {
            return false;
        }
        if (this.world.isStatic || this.dead) {
            return true;
        }
        this.c(-this.h());
        this.a(10);
        this.setDamage(this.getDamage() + f * 10.0f);
        this.K();
        boolean bl2 = bl = damageSource.getEntity() instanceof EntityHuman && ((EntityHuman)damageSource.getEntity()).abilities.canInstantlyBuild;
        if (bl || this.getDamage() > 40.0f) {
            if (this.passenger != null) {
                this.passenger.mount(this);
            }
            if (!bl) {
                this.a(Item.BOAT.id, 1, 0.0f);
            }
            this.die();
        }
        return true;
    }

    @Override
    public boolean L() {
        return !this.dead;
    }

    @Override
    public void l_() {
        int n;
        double d;
        double d2;
        double d3;
        double d4;
        super.l_();
        if (this.e() > 0) {
            this.a(this.e() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        this.lastX = this.locX;
        this.lastY = this.locY;
        this.lastZ = this.locZ;
        int n2 = 5;
        double d5 = 0.0;
        for (int i = 0; i < n2; ++i) {
            double d6 = this.boundingBox.b + (this.boundingBox.e - this.boundingBox.b) * (double)(i + 0) / (double)n2 - 0.125;
            double d7 = this.boundingBox.b + (this.boundingBox.e - this.boundingBox.b) * (double)(i + 1) / (double)n2 - 0.125;
            AxisAlignedBB axisAlignedBB = AxisAlignedBB.a().a(this.boundingBox.a, d6, this.boundingBox.c, this.boundingBox.d, d7, this.boundingBox.f);
            if (!this.world.b(axisAlignedBB, Material.WATER)) continue;
            d5 += 1.0 / (double)n2;
        }
        double d8 = Math.sqrt(this.motX * this.motX + this.motZ * this.motZ);
        if (d8 > 0.26249999999999996) {
            d4 = Math.cos((double)this.yaw * Math.PI / 180.0);
            d3 = Math.sin((double)this.yaw * Math.PI / 180.0);
            int n3 = 0;
            while ((double)n3 < 1.0 + d8 * 60.0) {
                double d9;
                double d10;
                double d11 = this.random.nextFloat() * 2.0f - 1.0f;
                double d12 = (double)(this.random.nextInt(2) * 2 - 1) * 0.7;
                if (this.random.nextBoolean()) {
                    d10 = this.locX - d4 * d11 * 0.8 + d3 * d12;
                    d9 = this.locZ - d3 * d11 * 0.8 - d4 * d12;
                    this.world.addParticle("splash", d10, this.locY - 0.125, d9, this.motX, this.motY, this.motZ);
                } else {
                    d10 = this.locX + d4 + d3 * d11 * 0.7;
                    d9 = this.locZ + d3 - d4 * d11 * 0.7;
                    this.world.addParticle("splash", d10, this.locY - 0.125, d9, this.motX, this.motY, this.motZ);
                }
                ++n3;
            }
        }
        if (this.world.isStatic && this.a) {
            if (this.c > 0) {
                d4 = this.locX + (this.d - this.locX) / (double)this.c;
                d3 = this.locY + (this.e - this.locY) / (double)this.c;
                double d13 = this.locZ + (this.f - this.locZ) / (double)this.c;
                double d14 = MathHelper.g(this.g - (double)this.yaw);
                this.yaw = (float)((double)this.yaw + d14 / (double)this.c);
                this.pitch = (float)((double)this.pitch + (this.h - (double)this.pitch) / (double)this.c);
                --this.c;
                this.setPosition(d4, d3, d13);
                this.b(this.yaw, this.pitch);
            } else {
                d4 = this.locX + this.motX;
                d3 = this.locY + this.motY;
                double d15 = this.locZ + this.motZ;
                this.setPosition(d4, d3, d15);
                if (this.onGround) {
                    this.motX *= 0.5;
                    this.motY *= 0.5;
                    this.motZ *= 0.5;
                }
                this.motX *= (double)0.99f;
                this.motY *= (double)0.95f;
                this.motZ *= (double)0.99f;
            }
            return;
        }
        if (d5 < 1.0) {
            d4 = d5 * 2.0 - 1.0;
            this.motY += (double)0.04f * d4;
        } else {
            if (this.motY < 0.0) {
                this.motY /= 2.0;
            }
            this.motY += (double)0.007f;
        }
        if (this.passenger != null && this.passenger instanceof EntityLiving && (d4 = (double)((EntityLiving)this.passenger).bf) > 0.0) {
            d3 = -Math.sin(this.passenger.yaw * (float)Math.PI / 180.0f);
            d2 = Math.cos(this.passenger.yaw * (float)Math.PI / 180.0f);
            this.motX += d3 * this.b * (double)0.05f;
            this.motZ += d2 * this.b * (double)0.05f;
        }
        if ((d4 = Math.sqrt(this.motX * this.motX + this.motZ * this.motZ)) > 0.35) {
            d3 = 0.35 / d4;
            this.motX *= d3;
            this.motZ *= d3;
            d4 = 0.35;
        }
        if (d4 > d8 && this.b < 0.35) {
            this.b += (0.35 - this.b) / 35.0;
            if (this.b > 0.35) {
                this.b = 0.35;
            }
        } else {
            this.b -= (this.b - 0.07) / 35.0;
            if (this.b < 0.07) {
                this.b = 0.07;
            }
        }
        if (this.onGround) {
            this.motX *= 0.5;
            this.motY *= 0.5;
            this.motZ *= 0.5;
        }
        this.move(this.motX, this.motY, this.motZ);
        if (this.positionChanged && d8 > 0.2) {
            if (!this.world.isStatic && !this.dead) {
                int n4;
                this.die();
                for (n4 = 0; n4 < 3; ++n4) {
                    this.a(Block.WOOD.id, 1, 0.0f);
                }
                for (n4 = 0; n4 < 2; ++n4) {
                    this.a(Item.STICK.id, 1, 0.0f);
                }
            }
        } else {
            this.motX *= (double)0.99f;
            this.motY *= (double)0.95f;
            this.motZ *= (double)0.99f;
        }
        this.pitch = 0.0f;
        d3 = this.yaw;
        d2 = this.lastX - this.locX;
        double d16 = this.lastZ - this.locZ;
        if (d2 * d2 + d16 * d16 > 0.001) {
            d3 = (float)(Math.atan2(d16, d2) * 180.0 / Math.PI);
        }
        if ((d = MathHelper.g(d3 - (double)this.yaw)) > 20.0) {
            d = 20.0;
        }
        if (d < -20.0) {
            d = -20.0;
        }
        this.yaw = (float)((double)this.yaw + d);
        this.b(this.yaw, this.pitch);
        if (this.world.isStatic) {
            return;
        }
        List list = this.world.getEntities(this, this.boundingBox.grow(0.2f, 0.0, 0.2f));
        if (list != null && !list.isEmpty()) {
            for (n = 0; n < list.size(); ++n) {
                Entity entity = (Entity)list.get(n);
                if (entity == this.passenger || !entity.M() || !(entity instanceof EntityBoat)) continue;
                entity.collide(this);
            }
        }
        for (n = 0; n < 4; ++n) {
            int n5 = MathHelper.floor(this.locX + ((double)(n % 2) - 0.5) * 0.8);
            int n6 = MathHelper.floor(this.locZ + ((double)(n / 2) - 0.5) * 0.8);
            for (int i = 0; i < 2; ++i) {
                int n7 = MathHelper.floor(this.locY) + i;
                int n8 = this.world.getTypeId(n5, n7, n6);
                if (n8 == Block.SNOW.id) {
                    this.world.setAir(n5, n7, n6);
                    continue;
                }
                if (n8 != Block.WATER_LILY.id) continue;
                this.world.setAir(n5, n7, n6, true);
            }
        }
        if (this.passenger != null && this.passenger.dead) {
            this.passenger = null;
        }
    }

    @Override
    public void W() {
        if (this.passenger == null) {
            return;
        }
        double d = Math.cos((double)this.yaw * Math.PI / 180.0) * 0.4;
        double d2 = Math.sin((double)this.yaw * Math.PI / 180.0) * 0.4;
        this.passenger.setPosition(this.locX + d, this.locY + this.Y() + this.passenger.X(), this.locZ + d2);
    }

    @Override
    protected void b(NBTTagCompound nBTTagCompound) {
    }

    @Override
    protected void a(NBTTagCompound nBTTagCompound) {
    }

    @Override
    public boolean c(EntityHuman entityHuman) {
        if (this.passenger != null && this.passenger instanceof EntityHuman && this.passenger != entityHuman) {
            return true;
        }
        if (!this.world.isStatic) {
            entityHuman.mount(this);
        }
        return true;
    }

    public void setDamage(float f) {
        this.datawatcher.watch(19, Float.valueOf(f));
    }

    public float getDamage() {
        return this.datawatcher.getFloat(19);
    }

    public void a(int n) {
        this.datawatcher.watch(17, n);
    }

    public int e() {
        return this.datawatcher.getInt(17);
    }

    public void c(int n) {
        this.datawatcher.watch(18, n);
    }

    public int h() {
        return this.datawatcher.getInt(18);
    }
}

