/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityMonster;
import net.minecraft.server.EntitySmallFireball;
import net.minecraft.server.GenericAttributes;
import net.minecraft.server.Item;
import net.minecraft.server.MathHelper;
import net.minecraft.server.World;

public class EntityBlaze
extends EntityMonster {
    private float bp = 0.5f;
    private int bq;
    private int br;

    public EntityBlaze(World world) {
        super(world);
        this.fireProof = true;
        this.b = 10;
    }

    @Override
    protected void az() {
        super.az();
        this.getAttributeInstance(GenericAttributes.e).setValue(6.0);
    }

    @Override
    protected void a() {
        super.a();
        this.datawatcher.a(16, new Byte(0));
    }

    @Override
    protected String r() {
        return "mob.blaze.breathe";
    }

    @Override
    protected String aO() {
        return "mob.blaze.hit";
    }

    @Override
    protected String aP() {
        return "mob.blaze.death";
    }

    @Override
    public float d(float f) {
        return 1.0f;
    }

    @Override
    public void c() {
        if (!this.world.isStatic) {
            if (this.G()) {
                this.damageEntity(DamageSource.DROWN, 1.0f);
            }
            --this.bq;
            if (this.bq <= 0) {
                this.bq = 100;
                this.bp = 0.5f + (float)this.random.nextGaussian() * 3.0f;
            }
            if (this.bN() != null && this.bN().locY + (double)this.bN().getHeadHeight() > this.locY + (double)this.getHeadHeight() + (double)this.bp) {
                this.motY += ((double)0.3f - this.motY) * (double)0.3f;
            }
        }
        if (this.random.nextInt(24) == 0) {
            this.world.makeSound(this.locX + 0.5, this.locY + 0.5, this.locZ + 0.5, "fire.fire", 1.0f + this.random.nextFloat(), this.random.nextFloat() * 0.7f + 0.3f);
        }
        if (!this.onGround && this.motY < 0.0) {
            this.motY *= 0.6;
        }
        for (int i = 0; i < 2; ++i) {
            this.world.addParticle("largesmoke", this.locX + (this.random.nextDouble() - 0.5) * (double)this.width, this.locY + this.random.nextDouble() * (double)this.length, this.locZ + (this.random.nextDouble() - 0.5) * (double)this.width, 0.0, 0.0, 0.0);
        }
        super.c();
    }

    @Override
    protected void a(Entity entity, float f) {
        if (this.attackTicks <= 0 && f < 2.0f && entity.boundingBox.e > this.boundingBox.b && entity.boundingBox.b < this.boundingBox.e) {
            this.attackTicks = 20;
            this.m(entity);
        } else if (f < 30.0f) {
            double d = entity.locX - this.locX;
            double d2 = entity.boundingBox.b + (double)(entity.length / 2.0f) - (this.locY + (double)(this.length / 2.0f));
            double d3 = entity.locZ - this.locZ;
            if (this.attackTicks == 0) {
                ++this.br;
                if (this.br == 1) {
                    this.attackTicks = 60;
                    this.a(true);
                } else if (this.br <= 4) {
                    this.attackTicks = 6;
                } else {
                    this.attackTicks = 100;
                    this.br = 0;
                    this.a(false);
                }
                if (this.br > 1) {
                    float f2 = MathHelper.c(f) * 0.5f;
                    this.world.a(null, 1009, (int)this.locX, (int)this.locY, (int)this.locZ, 0);
                    for (int i = 0; i < 1; ++i) {
                        EntitySmallFireball entitySmallFireball = new EntitySmallFireball(this.world, this, d + this.random.nextGaussian() * (double)f2, d2, d3 + this.random.nextGaussian() * (double)f2);
                        entitySmallFireball.locY = this.locY + (double)(this.length / 2.0f) + 0.5;
                        this.world.addEntity(entitySmallFireball);
                    }
                }
            }
            this.yaw = (float)(Math.atan2(d3, d) * 180.0 / 3.1415927410125732) - 90.0f;
            this.bn = true;
        }
    }

    @Override
    protected void b(float f) {
    }

    @Override
    protected int getLootId() {
        return Item.BLAZE_ROD.id;
    }

    @Override
    public boolean isBurning() {
        return this.bT();
    }

    @Override
    protected void dropDeathLoot(boolean bl, int n) {
        if (bl) {
            int n2 = this.random.nextInt(2 + n);
            for (int i = 0; i < n2; ++i) {
                this.b(Item.BLAZE_ROD.id, 1);
            }
        }
    }

    public boolean bT() {
        return (this.datawatcher.getByte(16) & 1) != 0;
    }

    public void a(boolean bl) {
        byte by = this.datawatcher.getByte(16);
        by = bl ? (byte)(by | 1) : (byte)(by & 0xFFFFFFFE);
        this.datawatcher.watch(16, by);
    }

    @Override
    protected boolean i_() {
        return true;
    }
}

