/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.DamageSource;
import net.minecraft.server.EnchantmentThorns;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityEnderman;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.IProjectile;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MovingObjectPosition;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.Packet70Bed;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

public class EntityArrow
extends Entity
implements IProjectile {
    private int d = -1;
    private int e = -1;
    private int f = -1;
    private int g;
    private int h;
    private boolean inGround;
    public int fromPlayer;
    public int shake;
    public Entity shooter;
    private int j;
    private int au;
    private double damage = 2.0;
    private int aw;

    public EntityArrow(World world) {
        super(world);
        this.l = 10.0;
        this.a(0.5f, 0.5f);
    }

    public EntityArrow(World world, double d, double d2, double d3) {
        super(world);
        this.l = 10.0;
        this.a(0.5f, 0.5f);
        this.setPosition(d, d2, d3);
        this.height = 0.0f;
    }

    public EntityArrow(World world, EntityLiving entityLiving, EntityLiving entityLiving2, float f, float f2) {
        super(world);
        this.l = 10.0;
        this.shooter = entityLiving;
        if (entityLiving instanceof EntityHuman) {
            this.fromPlayer = 1;
        }
        this.locY = entityLiving.locY + (double)entityLiving.getHeadHeight() - (double)0.1f;
        double d = entityLiving2.locX - entityLiving.locX;
        double d2 = entityLiving2.boundingBox.b + (double)(entityLiving2.length / 3.0f) - this.locY;
        double d3 = entityLiving2.locZ - entityLiving.locZ;
        double d4 = MathHelper.sqrt(d * d + d3 * d3);
        if (d4 < 1.0E-7) {
            return;
        }
        float f3 = (float)(Math.atan2(d3, d) * 180.0 / 3.1415927410125732) - 90.0f;
        float f4 = (float)(-(Math.atan2(d2, d4) * 180.0 / 3.1415927410125732));
        double d5 = d / d4;
        double d6 = d3 / d4;
        this.setPositionRotation(entityLiving.locX + d5, this.locY, entityLiving.locZ + d6, f3, f4);
        this.height = 0.0f;
        float f5 = (float)d4 * 0.2f;
        this.shoot(d, d2 + (double)f5, d3, f, f2);
    }

    public EntityArrow(World world, EntityLiving entityLiving, float f) {
        super(world);
        this.l = 10.0;
        this.shooter = entityLiving;
        if (entityLiving instanceof EntityHuman) {
            this.fromPlayer = 1;
        }
        this.a(0.5f, 0.5f);
        this.setPositionRotation(entityLiving.locX, entityLiving.locY + (double)entityLiving.getHeadHeight(), entityLiving.locZ, entityLiving.yaw, entityLiving.pitch);
        this.locX -= (double)(MathHelper.cos(this.yaw / 180.0f * (float)Math.PI) * 0.16f);
        this.locY -= (double)0.1f;
        this.locZ -= (double)(MathHelper.sin(this.yaw / 180.0f * (float)Math.PI) * 0.16f);
        this.setPosition(this.locX, this.locY, this.locZ);
        this.height = 0.0f;
        this.motX = -MathHelper.sin(this.yaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.pitch / 180.0f * (float)Math.PI);
        this.motZ = MathHelper.cos(this.yaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.pitch / 180.0f * (float)Math.PI);
        this.motY = -MathHelper.sin(this.pitch / 180.0f * (float)Math.PI);
        this.shoot(this.motX, this.motY, this.motZ, f * 1.5f, 1.0f);
    }

    @Override
    protected void a() {
        this.datawatcher.a(16, (Object)0);
    }

    @Override
    public void shoot(double d, double d2, double d3, float f, float f2) {
        float f3 = MathHelper.sqrt(d * d + d2 * d2 + d3 * d3);
        d /= (double)f3;
        d2 /= (double)f3;
        d3 /= (double)f3;
        d += this.random.nextGaussian() * (double)(this.random.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)f2;
        d2 += this.random.nextGaussian() * (double)(this.random.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)f2;
        d3 += this.random.nextGaussian() * (double)(this.random.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)f2;
        this.motX = d *= (double)f;
        this.motY = d2 *= (double)f;
        this.motZ = d3 *= (double)f;
        float f4 = MathHelper.sqrt(d * d + d3 * d3);
        this.lastYaw = this.yaw = (float)(Math.atan2(d, d3) * 180.0 / 3.1415927410125732);
        this.lastPitch = this.pitch = (float)(Math.atan2(d2, f4) * 180.0 / 3.1415927410125732);
        this.j = 0;
    }

    @Override
    public void l_() {
        Object object;
        int n;
        Object object2;
        int n2;
        super.l_();
        if (this.lastPitch == 0.0f && this.lastYaw == 0.0f) {
            float f = MathHelper.sqrt(this.motX * this.motX + this.motZ * this.motZ);
            this.lastYaw = this.yaw = (float)(Math.atan2(this.motX, this.motZ) * 180.0 / 3.1415927410125732);
            this.lastPitch = this.pitch = (float)(Math.atan2(this.motY, f) * 180.0 / 3.1415927410125732);
        }
        if ((n2 = this.world.getTypeId(this.d, this.e, this.f)) > 0) {
            Block.byId[n2].updateShape(this.world, this.d, this.e, this.f);
            object2 = Block.byId[n2].b(this.world, this.d, this.e, this.f);
            if (object2 != null && ((AxisAlignedBB)object2).a(this.world.getVec3DPool().create(this.locX, this.locY, this.locZ))) {
                this.inGround = true;
            }
        }
        if (this.shake > 0) {
            --this.shake;
        }
        if (this.inGround) {
            int n3 = this.world.getTypeId(this.d, this.e, this.f);
            int n4 = this.world.getData(this.d, this.e, this.f);
            if (n3 != this.g || n4 != this.h) {
                this.inGround = false;
                this.motX *= (double)(this.random.nextFloat() * 0.2f);
                this.motY *= (double)(this.random.nextFloat() * 0.2f);
                this.motZ *= (double)(this.random.nextFloat() * 0.2f);
                this.j = 0;
                this.au = 0;
                return;
            }
            ++this.j;
            if (this.j == 1200) {
                this.die();
            }
            return;
        }
        ++this.au;
        object2 = this.world.getVec3DPool().create(this.locX, this.locY, this.locZ);
        Vec3D vec3D = this.world.getVec3DPool().create(this.locX + this.motX, this.locY + this.motY, this.locZ + this.motZ);
        MovingObjectPosition movingObjectPosition = this.world.rayTrace((Vec3D)object2, vec3D, false, true);
        object2 = this.world.getVec3DPool().create(this.locX, this.locY, this.locZ);
        vec3D = this.world.getVec3DPool().create(this.locX + this.motX, this.locY + this.motY, this.locZ + this.motZ);
        if (movingObjectPosition != null) {
            vec3D = this.world.getVec3DPool().create(movingObjectPosition.pos.c, movingObjectPosition.pos.d, movingObjectPosition.pos.e);
        }
        Entity entity = null;
        List list = this.world.getEntities(this, this.boundingBox.a(this.motX, this.motY, this.motZ).grow(1.0, 1.0, 1.0));
        double d = 0.0;
        for (n = 0; n < list.size(); ++n) {
            double d2;
            float f;
            MovingObjectPosition movingObjectPosition2;
            Entity entity2 = (Entity)list.get(n);
            if (!entity2.L() || entity2 == this.shooter && this.au < 5 || (movingObjectPosition2 = ((AxisAlignedBB)(object = entity2.boundingBox.grow(f = 0.3f, f, f))).a((Vec3D)object2, vec3D)) == null || !((d2 = ((Vec3D)object2).d(movingObjectPosition2.pos)) < d) && d != 0.0) continue;
            entity = entity2;
            d = d2;
        }
        if (entity != null) {
            movingObjectPosition = new MovingObjectPosition(entity);
        }
        if (movingObjectPosition != null && movingObjectPosition.entity != null && movingObjectPosition.entity instanceof EntityHuman) {
            EntityHuman entityHuman = (EntityHuman)movingObjectPosition.entity;
            if (entityHuman.abilities.isInvulnerable || this.shooter instanceof EntityHuman && !((EntityHuman)this.shooter).a(entityHuman)) {
                movingObjectPosition = null;
            }
        }
        if (movingObjectPosition != null) {
            if (movingObjectPosition.entity != null) {
                float f = MathHelper.sqrt(this.motX * this.motX + this.motY * this.motY + this.motZ * this.motZ);
                int n5 = MathHelper.f((double)f * this.damage);
                if (this.d()) {
                    n5 += this.random.nextInt(n5 / 2 + 2);
                }
                DamageSource damageSource = null;
                damageSource = this.shooter == null ? DamageSource.arrow(this, this) : DamageSource.arrow(this, this.shooter);
                if (this.isBurning() && !(movingObjectPosition.entity instanceof EntityEnderman)) {
                    movingObjectPosition.entity.setOnFire(5);
                }
                if (movingObjectPosition.entity.damageEntity(damageSource, n5)) {
                    if (movingObjectPosition.entity instanceof EntityLiving) {
                        float f2;
                        object = (EntityLiving)movingObjectPosition.entity;
                        if (!this.world.isStatic) {
                            ((EntityLiving)object).m(((EntityLiving)object).aU() + 1);
                        }
                        if (this.aw > 0 && (f2 = MathHelper.sqrt(this.motX * this.motX + this.motZ * this.motZ)) > 0.0f) {
                            movingObjectPosition.entity.g(this.motX * (double)this.aw * (double)0.6f / (double)f2, 0.1, this.motZ * (double)this.aw * (double)0.6f / (double)f2);
                        }
                        if (this.shooter != null) {
                            EnchantmentThorns.a(this.shooter, (EntityLiving)object, this.random);
                        }
                        if (this.shooter != null && movingObjectPosition.entity != this.shooter && movingObjectPosition.entity instanceof EntityHuman && this.shooter instanceof EntityPlayer) {
                            ((EntityPlayer)this.shooter).playerConnection.sendPacket(new Packet70Bed(6, 0));
                        }
                    }
                    this.makeSound("random.bowhit", 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
                    if (!(movingObjectPosition.entity instanceof EntityEnderman)) {
                        this.die();
                    }
                } else {
                    this.motX *= (double)-0.1f;
                    this.motY *= (double)-0.1f;
                    this.motZ *= (double)-0.1f;
                    this.yaw += 180.0f;
                    this.lastYaw += 180.0f;
                    this.au = 0;
                }
            } else {
                this.d = movingObjectPosition.b;
                this.e = movingObjectPosition.c;
                this.f = movingObjectPosition.d;
                this.g = this.world.getTypeId(this.d, this.e, this.f);
                this.h = this.world.getData(this.d, this.e, this.f);
                this.motX = (float)(movingObjectPosition.pos.c - this.locX);
                this.motY = (float)(movingObjectPosition.pos.d - this.locY);
                this.motZ = (float)(movingObjectPosition.pos.e - this.locZ);
                float f = MathHelper.sqrt(this.motX * this.motX + this.motY * this.motY + this.motZ * this.motZ);
                this.locX -= this.motX / (double)f * (double)0.05f;
                this.locY -= this.motY / (double)f * (double)0.05f;
                this.locZ -= this.motZ / (double)f * (double)0.05f;
                this.makeSound("random.bowhit", 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
                this.inGround = true;
                this.shake = 7;
                this.a(false);
                if (this.g != 0) {
                    Block.byId[this.g].a(this.world, this.d, this.e, this.f, this);
                }
            }
        }
        if (this.d()) {
            for (n = 0; n < 4; ++n) {
                this.world.addParticle("crit", this.locX + this.motX * (double)n / 4.0, this.locY + this.motY * (double)n / 4.0, this.locZ + this.motZ * (double)n / 4.0, -this.motX, -this.motY + 0.2, -this.motZ);
            }
        }
        this.locX += this.motX;
        this.locY += this.motY;
        this.locZ += this.motZ;
        float f = MathHelper.sqrt(this.motX * this.motX + this.motZ * this.motZ);
        this.yaw = (float)(Math.atan2(this.motX, this.motZ) * 180.0 / 3.1415927410125732);
        this.pitch = (float)(Math.atan2(this.motY, f) * 180.0 / 3.1415927410125732);
        while (this.pitch - this.lastPitch < -180.0f) {
            this.lastPitch -= 360.0f;
        }
        while (this.pitch - this.lastPitch >= 180.0f) {
            this.lastPitch += 360.0f;
        }
        while (this.yaw - this.lastYaw < -180.0f) {
            this.lastYaw -= 360.0f;
        }
        while (this.yaw - this.lastYaw >= 180.0f) {
            this.lastYaw += 360.0f;
        }
        this.pitch = this.lastPitch + (this.pitch - this.lastPitch) * 0.2f;
        this.yaw = this.lastYaw + (this.yaw - this.lastYaw) * 0.2f;
        float f3 = 0.99f;
        float f4 = 0.05f;
        if (this.H()) {
            for (int i = 0; i < 4; ++i) {
                float f5 = 0.25f;
                this.world.addParticle("bubble", this.locX - this.motX * (double)f5, this.locY - this.motY * (double)f5, this.locZ - this.motZ * (double)f5, this.motX, this.motY, this.motZ);
            }
            f3 = 0.8f;
        }
        this.motX *= (double)f3;
        this.motY *= (double)f3;
        this.motZ *= (double)f3;
        this.motY -= (double)f4;
        this.setPosition(this.locX, this.locY, this.locZ);
        this.D();
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.setShort("xTile", (short)this.d);
        nBTTagCompound.setShort("yTile", (short)this.e);
        nBTTagCompound.setShort("zTile", (short)this.f);
        nBTTagCompound.setByte("inTile", (byte)this.g);
        nBTTagCompound.setByte("inData", (byte)this.h);
        nBTTagCompound.setByte("shake", (byte)this.shake);
        nBTTagCompound.setByte("inGround", (byte)(this.inGround ? 1 : 0));
        nBTTagCompound.setByte("pickup", (byte)this.fromPlayer);
        nBTTagCompound.setDouble("damage", this.damage);
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        this.d = nBTTagCompound.getShort("xTile");
        this.e = nBTTagCompound.getShort("yTile");
        this.f = nBTTagCompound.getShort("zTile");
        this.g = nBTTagCompound.getByte("inTile") & 0xFF;
        this.h = nBTTagCompound.getByte("inData") & 0xFF;
        this.shake = nBTTagCompound.getByte("shake") & 0xFF;
        boolean bl = this.inGround = nBTTagCompound.getByte("inGround") == 1;
        if (nBTTagCompound.hasKey("damage")) {
            this.damage = nBTTagCompound.getDouble("damage");
        }
        if (nBTTagCompound.hasKey("pickup")) {
            this.fromPlayer = nBTTagCompound.getByte("pickup");
        } else if (nBTTagCompound.hasKey("player")) {
            this.fromPlayer = nBTTagCompound.getBoolean("player") ? 1 : 0;
        }
    }

    @Override
    public void b_(EntityHuman entityHuman) {
        boolean bl;
        if (this.world.isStatic || !this.inGround || this.shake > 0) {
            return;
        }
        boolean bl2 = bl = this.fromPlayer == 1 || this.fromPlayer == 2 && entityHuman.abilities.canInstantlyBuild;
        if (this.fromPlayer == 1 && !entityHuman.inventory.pickup(new ItemStack(Item.ARROW, 1))) {
            bl = false;
        }
        if (bl) {
            this.makeSound("random.pop", 0.2f, ((this.random.nextFloat() - this.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            entityHuman.receive(this, 1);
            this.die();
        }
    }

    @Override
    protected boolean e_() {
        return false;
    }

    public void b(double d) {
        this.damage = d;
    }

    public double c() {
        return this.damage;
    }

    public void a(int n) {
        this.aw = n;
    }

    @Override
    public boolean aq() {
        return false;
    }

    public void a(boolean bl) {
        byte by = this.datawatcher.getByte(16);
        if (bl) {
            this.datawatcher.watch(16, (byte)(by | 1));
        } else {
            this.datawatcher.watch(16, (byte)(by & 0xFFFFFFFE));
        }
    }

    public boolean d() {
        byte by = this.datawatcher.getByte(16);
        return (by & 1) != 0;
    }
}

