/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import net.minecraft.server.AttributeInstance;
import net.minecraft.server.Block;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityAgeable;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.GenericAttributes;
import net.minecraft.server.IAnimal;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;

public abstract class EntityAnimal
extends EntityAgeable
implements IAnimal {
    private int love;
    private int bq;

    public EntityAnimal(World world) {
        super(world);
    }

    @Override
    protected void bk() {
        if (this.getAge() != 0) {
            this.love = 0;
        }
        super.bk();
    }

    @Override
    public void c() {
        super.c();
        if (this.getAge() != 0) {
            this.love = 0;
        }
        if (this.love > 0) {
            --this.love;
            String string = "heart";
            if (this.love % 10 == 0) {
                double d = this.random.nextGaussian() * 0.02;
                double d2 = this.random.nextGaussian() * 0.02;
                double d3 = this.random.nextGaussian() * 0.02;
                this.world.addParticle(string, this.locX + (double)(this.random.nextFloat() * this.width * 2.0f) - (double)this.width, this.locY + 0.5 + (double)(this.random.nextFloat() * this.length), this.locZ + (double)(this.random.nextFloat() * this.width * 2.0f) - (double)this.width, d, d2, d3);
            }
        } else {
            this.bq = 0;
        }
    }

    @Override
    protected void a(Entity entity, float f) {
        if (entity instanceof EntityHuman) {
            EntityHuman entityHuman;
            if (f < 3.0f) {
                double d = entity.locX - this.locX;
                double d2 = entity.locZ - this.locZ;
                this.yaw = (float)(Math.atan2(d2, d) * 180.0 / 3.1415927410125732) - 90.0f;
                this.bn = true;
            }
            if ((entityHuman = (EntityHuman)entity).by() == null || !this.c(entityHuman.by())) {
                this.target = null;
            }
        } else if (entity instanceof EntityAnimal) {
            EntityAnimal entityAnimal = (EntityAnimal)entity;
            if (this.getAge() > 0 && entityAnimal.getAge() < 0) {
                if ((double)f < 2.5) {
                    this.bn = true;
                }
            } else if (this.love > 0 && entityAnimal.love > 0) {
                if (entityAnimal.target == null) {
                    entityAnimal.target = this;
                }
                if (entityAnimal.target == this && (double)f < 3.5) {
                    ++entityAnimal.love;
                    ++this.love;
                    ++this.bq;
                    if (this.bq % 4 == 0) {
                        this.world.addParticle("heart", this.locX + (double)(this.random.nextFloat() * this.width * 2.0f) - (double)this.width, this.locY + 0.5 + (double)(this.random.nextFloat() * this.length), this.locZ + (double)(this.random.nextFloat() * this.width * 2.0f) - (double)this.width, 0.0, 0.0, 0.0);
                    }
                    if (this.bq == 60) {
                        this.b((EntityAnimal)entity);
                    }
                } else {
                    this.bq = 0;
                }
            } else {
                this.bq = 0;
                this.target = null;
            }
        }
    }

    private void b(EntityAnimal entityAnimal) {
        EntityAgeable entityAgeable = this.createChild(entityAnimal);
        if (entityAgeable != null) {
            this.setAge(6000);
            entityAnimal.setAge(6000);
            this.love = 0;
            this.bq = 0;
            this.target = null;
            entityAnimal.target = null;
            entityAnimal.bq = 0;
            entityAnimal.love = 0;
            entityAgeable.setAge(-24000);
            entityAgeable.setPositionRotation(this.locX, this.locY, this.locZ, this.yaw, this.pitch);
            for (int i = 0; i < 7; ++i) {
                double d = this.random.nextGaussian() * 0.02;
                double d2 = this.random.nextGaussian() * 0.02;
                double d3 = this.random.nextGaussian() * 0.02;
                this.world.addParticle("heart", this.locX + (double)(this.random.nextFloat() * this.width * 2.0f) - (double)this.width, this.locY + 0.5 + (double)(this.random.nextFloat() * this.length), this.locZ + (double)(this.random.nextFloat() * this.width * 2.0f) - (double)this.width, d, d2, d3);
            }
            this.world.addEntity(entityAgeable);
        }
    }

    @Override
    public boolean damageEntity(DamageSource damageSource, float f) {
        AttributeInstance attributeInstance;
        if (this.isInvulnerable()) {
            return false;
        }
        this.bo = 60;
        if (!this.bf() && (attributeInstance = this.getAttributeInstance(GenericAttributes.d)).a(h) == null) {
            attributeInstance.a(i);
        }
        this.target = null;
        this.love = 0;
        return super.damageEntity(damageSource, f);
    }

    @Override
    public float a(int n, int n2, int n3) {
        if (this.world.getTypeId(n, n2 - 1, n3) == Block.GRASS.id) {
            return 10.0f;
        }
        return this.world.q(n, n2, n3) - 0.5f;
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.setInt("InLove", this.love);
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.love = nBTTagCompound.getInt("InLove");
    }

    @Override
    protected Entity findTarget() {
        block5: {
            float f;
            block6: {
                block4: {
                    if (this.bo > 0) {
                        return null;
                    }
                    f = 8.0f;
                    if (this.love <= 0) break block4;
                    List list = this.world.a(this.getClass(), this.boundingBox.grow(f, f, f));
                    for (int i = 0; i < list.size(); ++i) {
                        EntityAnimal entityAnimal = (EntityAnimal)list.get(i);
                        if (entityAnimal == this || entityAnimal.love <= 0) continue;
                        return entityAnimal;
                    }
                    break block5;
                }
                if (this.getAge() != 0) break block6;
                List list = this.world.a(EntityHuman.class, this.boundingBox.grow(f, f, f));
                for (int i = 0; i < list.size(); ++i) {
                    EntityHuman entityHuman = (EntityHuman)list.get(i);
                    if (entityHuman.by() == null || !this.c(entityHuman.by())) continue;
                    return entityHuman;
                }
                break block5;
            }
            if (this.getAge() <= 0) break block5;
            List list = this.world.a(this.getClass(), this.boundingBox.grow(f, f, f));
            for (int i = 0; i < list.size(); ++i) {
                EntityAnimal entityAnimal = (EntityAnimal)list.get(i);
                if (entityAnimal == this || entityAnimal.getAge() >= 0) continue;
                return entityAnimal;
            }
        }
        return null;
    }

    @Override
    public boolean canSpawn() {
        int n;
        int n2;
        int n3 = MathHelper.floor(this.locX);
        return this.world.getTypeId(n3, (n2 = MathHelper.floor(this.boundingBox.b)) - 1, n = MathHelper.floor(this.locZ)) == Block.GRASS.id && this.world.m(n3, n2, n) > 8 && super.canSpawn();
    }

    @Override
    public int o() {
        return 120;
    }

    @Override
    protected boolean isTypeNotPersistent() {
        return false;
    }

    @Override
    protected int getExpValue(EntityHuman entityHuman) {
        return 1 + this.world.random.nextInt(3);
    }

    public boolean c(ItemStack itemStack) {
        return itemStack.id == Item.WHEAT.id;
    }

    @Override
    public boolean a(EntityHuman entityHuman) {
        ItemStack itemStack = entityHuman.inventory.getItemInHand();
        if (itemStack != null && this.c(itemStack) && this.getAge() == 0 && this.love <= 0) {
            if (!entityHuman.abilities.canInstantlyBuild) {
                --itemStack.count;
                if (itemStack.count <= 0) {
                    entityHuman.inventory.setItem(entityHuman.inventory.itemInHandIndex, null);
                }
            }
            this.bX();
            return true;
        }
        return super.a(entityHuman);
    }

    public void bX() {
        this.love = 600;
        this.target = null;
        this.world.broadcastEntityEffect(this, (byte)18);
    }

    public boolean bY() {
        return this.love > 0;
    }

    public void bZ() {
        this.love = 0;
    }

    public boolean mate(EntityAnimal entityAnimal) {
        if (entityAnimal == this) {
            return false;
        }
        if (entityAnimal.getClass() != this.getClass()) {
            return false;
        }
        return this.bY() && entityAnimal.bY();
    }
}

