/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.EntityCreature;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityTypes;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;

public abstract class EntityAgeable
extends EntityCreature {
    private float bp = -1.0f;
    private float bq;

    public EntityAgeable(World world) {
        super(world);
    }

    public abstract EntityAgeable createChild(EntityAgeable var1);

    @Override
    public boolean a(EntityHuman entityHuman) {
        ItemStack itemStack = entityHuman.inventory.getItemInHand();
        if (itemStack != null && itemStack.id == Item.MONSTER_EGG.id) {
            EntityAgeable entityAgeable;
            Class clazz;
            if (!this.world.isStatic && (clazz = EntityTypes.a(itemStack.getData())) != null && clazz.isAssignableFrom(this.getClass()) && (entityAgeable = this.createChild(this)) != null) {
                entityAgeable.setAge(-24000);
                entityAgeable.setPositionRotation(this.locX, this.locY, this.locZ, 0.0f, 0.0f);
                this.world.addEntity(entityAgeable);
                if (itemStack.hasName()) {
                    entityAgeable.setCustomName(itemStack.getName());
                }
                if (!entityHuman.abilities.canInstantlyBuild) {
                    --itemStack.count;
                    if (itemStack.count <= 0) {
                        entityHuman.inventory.setItem(entityHuman.inventory.itemInHandIndex, null);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected void a() {
        super.a();
        this.datawatcher.a(12, new Integer(0));
    }

    public int getAge() {
        return this.datawatcher.getInt(12);
    }

    public void a(int n) {
        int n2 = this.getAge();
        if ((n2 += n * 20) > 0) {
            n2 = 0;
        }
        this.setAge(n2);
    }

    public void setAge(int n) {
        this.datawatcher.watch(12, n);
        this.a(this.isBaby());
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.setInt("Age", this.getAge());
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.setAge(nBTTagCompound.getInt("Age"));
    }

    @Override
    public void c() {
        super.c();
        if (this.world.isStatic) {
            this.a(this.isBaby());
        } else {
            int n = this.getAge();
            if (n < 0) {
                this.setAge(++n);
            } else if (n > 0) {
                this.setAge(--n);
            }
        }
    }

    @Override
    public boolean isBaby() {
        return this.getAge() < 0;
    }

    public void a(boolean bl) {
        this.a(bl ? 0.5f : 1.0f);
    }

    @Override
    protected final void a(float f, float f2) {
        boolean bl = this.bp > 0.0f;
        this.bp = f;
        this.bq = f2;
        if (!bl) {
            this.a(1.0f);
        }
    }

    protected final void a(float f) {
        super.a(this.bp * f, this.bq * f);
    }
}

