/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.BlockFluids;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.CrashReport;
import net.minecraft.server.CrashReportEntityName;
import net.minecraft.server.CrashReportEntityType;
import net.minecraft.server.CrashReportSystemDetails;
import net.minecraft.server.DamageSource;
import net.minecraft.server.DataWatcher;
import net.minecraft.server.Direction;
import net.minecraft.server.EnchantmentProtection;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EntityLightning;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityTypes;
import net.minecraft.server.EnumEntitySize;
import net.minecraft.server.Explosion;
import net.minecraft.server.ItemStack;
import net.minecraft.server.LocaleI18n;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagDouble;
import net.minecraft.server.NBTTagFloat;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.ReportedException;
import net.minecraft.server.StepSound;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;
import net.minecraft.server.WorldServer;

public abstract class Entity {
    private static int entityCount;
    public int id = entityCount++;
    public double l = 1.0;
    public boolean m;
    public Entity passenger;
    public Entity vehicle;
    public boolean p;
    public World world;
    public double lastX;
    public double lastY;
    public double lastZ;
    public double locX;
    public double locY;
    public double locZ;
    public double motX;
    public double motY;
    public double motZ;
    public float yaw;
    public float pitch;
    public float lastYaw;
    public float lastPitch;
    public final AxisAlignedBB boundingBox = AxisAlignedBB.a(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public boolean onGround;
    public boolean positionChanged;
    public boolean H;
    public boolean I;
    public boolean velocityChanged;
    protected boolean K;
    public boolean L = true;
    public boolean dead;
    public float height;
    public float width = 0.6f;
    public float length = 1.8f;
    public float Q;
    public float R;
    public float S;
    public float fallDistance;
    private int c = 1;
    public double U;
    public double V;
    public double W;
    public float X;
    public float Y;
    public boolean Z;
    public float aa;
    protected Random random = new Random();
    public int ticksLived;
    public int maxFireTicks = 1;
    private int fireTicks;
    protected boolean inWater;
    public int noDamageTicks;
    private boolean justCreated = true;
    protected boolean fireProof;
    protected DataWatcher datawatcher = new DataWatcher();
    private double f;
    private double g;
    public boolean ai;
    public int aj;
    public int ak;
    public int al;
    public boolean am;
    public boolean an;
    public int portalCooldown;
    protected boolean ap;
    protected int aq;
    public int dimension;
    protected int as;
    private boolean invulnerable;
    private UUID uniqueID = UUID.randomUUID();
    public EnumEntitySize at = EnumEntitySize.SIZE_2;

    public Entity(World world) {
        this.world = world;
        this.setPosition(0.0, 0.0, 0.0);
        if (world != null) {
            this.dimension = world.worldProvider.dimension;
        }
        this.datawatcher.a(0, (Object)0);
        this.datawatcher.a(1, (Object)300);
        this.a();
    }

    protected abstract void a();

    public DataWatcher getDataWatcher() {
        return this.datawatcher;
    }

    public boolean equals(Object object) {
        if (object instanceof Entity) {
            return ((Entity)object).id == this.id;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public void die() {
        this.dead = true;
    }

    protected void a(float f, float f2) {
        float f3;
        if (f != this.width || f2 != this.length) {
            f3 = this.width;
            this.width = f;
            this.length = f2;
            this.boundingBox.d = this.boundingBox.a + (double)this.width;
            this.boundingBox.f = this.boundingBox.c + (double)this.width;
            this.boundingBox.e = this.boundingBox.b + (double)this.length;
            if (this.width > f3 && !this.justCreated && !this.world.isStatic) {
                this.move(f3 - this.width, 0.0, f3 - this.width);
            }
        }
        this.at = (double)(f3 = f % 2.0f) < 0.375 ? EnumEntitySize.SIZE_1 : ((double)f3 < 0.75 ? EnumEntitySize.SIZE_2 : ((double)f3 < 1.0 ? EnumEntitySize.SIZE_3 : ((double)f3 < 1.375 ? EnumEntitySize.SIZE_4 : ((double)f3 < 1.75 ? EnumEntitySize.SIZE_5 : EnumEntitySize.SIZE_6))));
    }

    protected void b(float f, float f2) {
        this.yaw = f % 360.0f;
        this.pitch = f2 % 360.0f;
    }

    public void setPosition(double d, double d2, double d3) {
        this.locX = d;
        this.locY = d2;
        this.locZ = d3;
        float f = this.width / 2.0f;
        float f2 = this.length;
        this.boundingBox.b(d - (double)f, d2 - (double)this.height + (double)this.X, d3 - (double)f, d + (double)f, d2 - (double)this.height + (double)this.X + (double)f2, d3 + (double)f);
    }

    public void l_() {
        this.y();
    }

    public void y() {
        int n;
        int n2;
        int n3;
        int n4;
        this.world.methodProfiler.a("entityBaseTick");
        if (this.vehicle != null && this.vehicle.dead) {
            this.vehicle = null;
        }
        this.Q = this.R;
        this.lastX = this.locX;
        this.lastY = this.locY;
        this.lastZ = this.locZ;
        this.lastPitch = this.pitch;
        this.lastYaw = this.yaw;
        if (!this.world.isStatic && this.world instanceof WorldServer) {
            this.world.methodProfiler.a("portal");
            MinecraftServer minecraftServer = ((WorldServer)this.world).getMinecraftServer();
            n4 = this.z();
            if (this.ap) {
                if (minecraftServer.getAllowNether()) {
                    if (this.vehicle == null && this.aq++ >= n4) {
                        this.aq = n4;
                        this.portalCooldown = this.ac();
                        n3 = this.world.worldProvider.dimension == -1 ? 0 : -1;
                        this.b(n3);
                    }
                    this.ap = false;
                }
            } else {
                if (this.aq > 0) {
                    this.aq -= 4;
                }
                if (this.aq < 0) {
                    this.aq = 0;
                }
            }
            if (this.portalCooldown > 0) {
                --this.portalCooldown;
            }
            this.world.methodProfiler.b();
        }
        if (this.isSprinting() && !this.H() && (n2 = this.world.getTypeId(n = MathHelper.floor(this.locX), n4 = MathHelper.floor(this.locY - (double)0.2f - (double)this.height), n3 = MathHelper.floor(this.locZ))) > 0) {
            this.world.addParticle("tilecrack_" + n2 + "_" + this.world.getData(n, n4, n3), this.locX + ((double)this.random.nextFloat() - 0.5) * (double)this.width, this.boundingBox.b + 0.1, this.locZ + ((double)this.random.nextFloat() - 0.5) * (double)this.width, -this.motX * 4.0, 1.5, -this.motZ * 4.0);
        }
        this.I();
        if (this.world.isStatic) {
            this.fireTicks = 0;
        } else if (this.fireTicks > 0) {
            if (this.fireProof) {
                this.fireTicks -= 4;
                if (this.fireTicks < 0) {
                    this.fireTicks = 0;
                }
            } else {
                if (this.fireTicks % 20 == 0) {
                    this.damageEntity(DamageSource.BURN, 1.0f);
                }
                --this.fireTicks;
            }
        }
        if (this.J()) {
            this.A();
            this.fallDistance *= 0.5f;
        }
        if (this.locY < -64.0) {
            this.C();
        }
        if (!this.world.isStatic) {
            this.a(0, this.fireTicks > 0);
        }
        this.justCreated = false;
        this.world.methodProfiler.b();
    }

    public int z() {
        return 0;
    }

    protected void A() {
        if (!this.fireProof) {
            this.damageEntity(DamageSource.LAVA, 4.0f);
            this.setOnFire(15);
        }
    }

    public void setOnFire(int n) {
        int n2 = n * 20;
        if (this.fireTicks < (n2 = EnchantmentProtection.a(this, n2))) {
            this.fireTicks = n2;
        }
    }

    public void extinguish() {
        this.fireTicks = 0;
    }

    protected void C() {
        this.die();
    }

    public boolean c(double d, double d2, double d3) {
        AxisAlignedBB axisAlignedBB = this.boundingBox.c(d, d2, d3);
        List list = this.world.getCubes(this, axisAlignedBB);
        if (!list.isEmpty()) {
            return false;
        }
        return !this.world.containsLiquid(axisAlignedBB);
    }

    public void move(double d, double d2, double d3) {
        int n;
        double d4;
        double d5;
        double d6;
        int n2;
        int n3;
        boolean bl;
        if (this.Z) {
            this.boundingBox.d(d, d2, d3);
            this.locX = (this.boundingBox.a + this.boundingBox.d) / 2.0;
            this.locY = this.boundingBox.b + (double)this.height - (double)this.X;
            this.locZ = (this.boundingBox.c + this.boundingBox.f) / 2.0;
            return;
        }
        this.world.methodProfiler.a("move");
        this.X *= 0.4f;
        double d7 = this.locX;
        double d8 = this.locY;
        double d9 = this.locZ;
        if (this.K) {
            this.K = false;
            d *= 0.25;
            d2 *= (double)0.05f;
            d3 *= 0.25;
            this.motX = 0.0;
            this.motY = 0.0;
            this.motZ = 0.0;
        }
        double d10 = d;
        double d11 = d2;
        double d12 = d3;
        AxisAlignedBB axisAlignedBB = this.boundingBox.clone();
        boolean bl2 = bl = this.onGround && this.isSneaking() && this instanceof EntityHuman;
        if (bl) {
            double d13 = 0.05;
            while (d != 0.0 && this.world.getCubes(this, this.boundingBox.c(d, -1.0, 0.0)).isEmpty()) {
                d = d < d13 && d >= -d13 ? 0.0 : (d > 0.0 ? (d -= d13) : (d += d13));
                d10 = d;
            }
            while (d3 != 0.0 && this.world.getCubes(this, this.boundingBox.c(0.0, -1.0, d3)).isEmpty()) {
                d3 = d3 < d13 && d3 >= -d13 ? 0.0 : (d3 > 0.0 ? (d3 -= d13) : (d3 += d13));
                d12 = d3;
            }
            while (d != 0.0 && d3 != 0.0 && this.world.getCubes(this, this.boundingBox.c(d, -1.0, d3)).isEmpty()) {
                d = d < d13 && d >= -d13 ? 0.0 : (d > 0.0 ? (d -= d13) : (d += d13));
                d3 = d3 < d13 && d3 >= -d13 ? 0.0 : (d3 > 0.0 ? (d3 -= d13) : (d3 += d13));
                d10 = d;
                d12 = d3;
            }
        }
        List list = this.world.getCubes(this, this.boundingBox.a(d, d2, d3));
        for (n3 = 0; n3 < list.size(); ++n3) {
            d2 = ((AxisAlignedBB)list.get(n3)).b(this.boundingBox, d2);
        }
        this.boundingBox.d(0.0, d2, 0.0);
        if (!this.L && d11 != d2) {
            d3 = 0.0;
            d2 = 0.0;
            d = 0.0;
        }
        n3 = this.onGround || d11 != d2 && d11 < 0.0 ? 1 : 0;
        for (n2 = 0; n2 < list.size(); ++n2) {
            d = ((AxisAlignedBB)list.get(n2)).a(this.boundingBox, d);
        }
        this.boundingBox.d(d, 0.0, 0.0);
        if (!this.L && d10 != d) {
            d3 = 0.0;
            d2 = 0.0;
            d = 0.0;
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            d3 = ((AxisAlignedBB)list.get(n2)).c(this.boundingBox, d3);
        }
        this.boundingBox.d(0.0, 0.0, d3);
        if (!this.L && d12 != d3) {
            d3 = 0.0;
            d2 = 0.0;
            d = 0.0;
        }
        if (this.Y > 0.0f && n3 != 0 && (bl || this.X < 0.05f) && (d10 != d || d12 != d3)) {
            d6 = d;
            d5 = d2;
            d4 = d3;
            d = d10;
            d2 = this.Y;
            d3 = d12;
            AxisAlignedBB axisAlignedBB2 = this.boundingBox.clone();
            this.boundingBox.d(axisAlignedBB);
            list = this.world.getCubes(this, this.boundingBox.a(d, d2, d3));
            for (n = 0; n < list.size(); ++n) {
                d2 = ((AxisAlignedBB)list.get(n)).b(this.boundingBox, d2);
            }
            this.boundingBox.d(0.0, d2, 0.0);
            if (!this.L && d11 != d2) {
                d3 = 0.0;
                d2 = 0.0;
                d = 0.0;
            }
            for (n = 0; n < list.size(); ++n) {
                d = ((AxisAlignedBB)list.get(n)).a(this.boundingBox, d);
            }
            this.boundingBox.d(d, 0.0, 0.0);
            if (!this.L && d10 != d) {
                d3 = 0.0;
                d2 = 0.0;
                d = 0.0;
            }
            for (n = 0; n < list.size(); ++n) {
                d3 = ((AxisAlignedBB)list.get(n)).c(this.boundingBox, d3);
            }
            this.boundingBox.d(0.0, 0.0, d3);
            if (!this.L && d12 != d3) {
                d3 = 0.0;
                d2 = 0.0;
                d = 0.0;
            }
            if (!this.L && d11 != d2) {
                d3 = 0.0;
                d2 = 0.0;
                d = 0.0;
            } else {
                d2 = -this.Y;
                for (n = 0; n < list.size(); ++n) {
                    d2 = ((AxisAlignedBB)list.get(n)).b(this.boundingBox, d2);
                }
                this.boundingBox.d(0.0, d2, 0.0);
            }
            if (d6 * d6 + d4 * d4 >= d * d + d3 * d3) {
                d = d6;
                d2 = d5;
                d3 = d4;
                this.boundingBox.d(axisAlignedBB2);
            }
        }
        this.world.methodProfiler.b();
        this.world.methodProfiler.a("rest");
        this.locX = (this.boundingBox.a + this.boundingBox.d) / 2.0;
        this.locY = this.boundingBox.b + (double)this.height - (double)this.X;
        this.locZ = (this.boundingBox.c + this.boundingBox.f) / 2.0;
        this.positionChanged = d10 != d || d12 != d3;
        this.H = d11 != d2;
        this.onGround = d11 != d2 && d11 < 0.0;
        this.I = this.positionChanged || this.H;
        this.a(d2, this.onGround);
        if (d10 != d) {
            this.motX = 0.0;
        }
        if (d11 != d2) {
            this.motY = 0.0;
        }
        if (d12 != d3) {
            this.motZ = 0.0;
        }
        d6 = this.locX - d7;
        d5 = this.locY - d8;
        d4 = this.locZ - d9;
        if (this.e_() && !bl && this.vehicle == null) {
            int n4;
            int n5;
            int n6 = MathHelper.floor(this.locX);
            int n7 = this.world.getTypeId(n6, n = MathHelper.floor(this.locY - (double)0.2f - (double)this.height), n5 = MathHelper.floor(this.locZ));
            if (n7 == 0 && ((n4 = this.world.e(n6, n - 1, n5)) == 11 || n4 == 32 || n4 == 21)) {
                n7 = this.world.getTypeId(n6, n - 1, n5);
            }
            if (n7 != Block.LADDER.id) {
                d5 = 0.0;
            }
            this.R = (float)((double)this.R + (double)MathHelper.sqrt(d6 * d6 + d4 * d4) * 0.6);
            this.S = (float)((double)this.S + (double)MathHelper.sqrt(d6 * d6 + d5 * d5 + d4 * d4) * 0.6);
            if (this.S > (float)this.c && n7 > 0) {
                this.c = (int)this.S + 1;
                if (this.H()) {
                    float f = MathHelper.sqrt(this.motX * this.motX * (double)0.2f + this.motY * this.motY + this.motZ * this.motZ * (double)0.2f) * 0.35f;
                    if (f > 1.0f) {
                        f = 1.0f;
                    }
                    this.makeSound("liquid.swim", f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                }
                this.a(n6, n, n5, n7);
                Block.byId[n7].b(this.world, n6, n, n5, this);
            }
        }
        try {
            this.D();
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.a(throwable, "Checking entity tile collision");
            CrashReportSystemDetails crashReportSystemDetails = crashReport.a("Entity being checked for collision");
            this.a(crashReportSystemDetails);
            throw new ReportedException(crashReport);
        }
        boolean bl3 = this.G();
        if (this.world.e(this.boundingBox.shrink(0.001, 0.001, 0.001))) {
            this.burn(1);
            if (!bl3) {
                ++this.fireTicks;
                if (this.fireTicks == 0) {
                    this.setOnFire(8);
                }
            }
        } else if (this.fireTicks <= 0) {
            this.fireTicks = -this.maxFireTicks;
        }
        if (bl3 && this.fireTicks > 0) {
            this.makeSound("random.fizz", 0.7f, 1.6f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
            this.fireTicks = -this.maxFireTicks;
        }
        this.world.methodProfiler.b();
    }

    protected void D() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = MathHelper.floor(this.boundingBox.a + 0.001);
        if (this.world.e(n6, n5 = MathHelper.floor(this.boundingBox.b + 0.001), n4 = MathHelper.floor(this.boundingBox.c + 0.001), n3 = MathHelper.floor(this.boundingBox.d - 0.001), n2 = MathHelper.floor(this.boundingBox.e - 0.001), n = MathHelper.floor(this.boundingBox.f - 0.001))) {
            for (int i = n6; i <= n3; ++i) {
                for (int j = n5; j <= n2; ++j) {
                    for (int k = n4; k <= n; ++k) {
                        int n7 = this.world.getTypeId(i, j, k);
                        if (n7 <= 0) continue;
                        try {
                            Block.byId[n7].a(this.world, i, j, k, this);
                            continue;
                        }
                        catch (Throwable throwable) {
                            CrashReport crashReport = CrashReport.a(throwable, "Colliding entity with tile");
                            CrashReportSystemDetails crashReportSystemDetails = crashReport.a("Tile being collided with");
                            CrashReportSystemDetails.a(crashReportSystemDetails, i, j, k, n7, this.world.getData(i, j, k));
                            throw new ReportedException(crashReport);
                        }
                    }
                }
            }
        }
    }

    protected void a(int n, int n2, int n3, int n4) {
        StepSound stepSound = Block.byId[n4].stepSound;
        if (this.world.getTypeId(n, n2 + 1, n3) == Block.SNOW.id) {
            stepSound = Block.SNOW.stepSound;
            this.makeSound(stepSound.getStepSound(), stepSound.getVolume1() * 0.15f, stepSound.getVolume2());
        } else if (!Block.byId[n4].material.isLiquid()) {
            this.makeSound(stepSound.getStepSound(), stepSound.getVolume1() * 0.15f, stepSound.getVolume2());
        }
    }

    public void makeSound(String string, float f, float f2) {
        this.world.makeSound(this, string, f, f2);
    }

    protected boolean e_() {
        return true;
    }

    protected void a(double d, boolean bl) {
        if (bl) {
            if (this.fallDistance > 0.0f) {
                this.b(this.fallDistance);
                this.fallDistance = 0.0f;
            }
        } else if (d < 0.0) {
            this.fallDistance = (float)((double)this.fallDistance - d);
        }
    }

    public AxisAlignedBB E() {
        return null;
    }

    protected void burn(int n) {
        if (!this.fireProof) {
            this.damageEntity(DamageSource.FIRE, n);
        }
    }

    public final boolean isFireproof() {
        return this.fireProof;
    }

    protected void b(float f) {
        if (this.passenger != null) {
            this.passenger.b(f);
        }
    }

    public boolean G() {
        return this.inWater || this.world.isRainingAt(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ)) || this.world.isRainingAt(MathHelper.floor(this.locX), MathHelper.floor(this.locY + (double)this.length), MathHelper.floor(this.locZ));
    }

    public boolean H() {
        return this.inWater;
    }

    public boolean I() {
        if (this.world.a(this.boundingBox.grow(0.0, -0.4f, 0.0).shrink(0.001, 0.001, 0.001), Material.WATER, this)) {
            if (!this.inWater && !this.justCreated) {
                float f;
                float f2;
                float f3 = MathHelper.sqrt(this.motX * this.motX * (double)0.2f + this.motY * this.motY + this.motZ * this.motZ * (double)0.2f) * 0.2f;
                if (f3 > 1.0f) {
                    f3 = 1.0f;
                }
                this.makeSound("liquid.splash", f3, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                float f4 = MathHelper.floor(this.boundingBox.b);
                int n = 0;
                while ((float)n < 1.0f + this.width * 20.0f) {
                    f2 = (this.random.nextFloat() * 2.0f - 1.0f) * this.width;
                    f = (this.random.nextFloat() * 2.0f - 1.0f) * this.width;
                    this.world.addParticle("bubble", this.locX + (double)f2, f4 + 1.0f, this.locZ + (double)f, this.motX, this.motY - (double)(this.random.nextFloat() * 0.2f), this.motZ);
                    ++n;
                }
                n = 0;
                while ((float)n < 1.0f + this.width * 20.0f) {
                    f2 = (this.random.nextFloat() * 2.0f - 1.0f) * this.width;
                    f = (this.random.nextFloat() * 2.0f - 1.0f) * this.width;
                    this.world.addParticle("splash", this.locX + (double)f2, f4 + 1.0f, this.locZ + (double)f, this.motX, this.motY, this.motZ);
                    ++n;
                }
            }
            this.fallDistance = 0.0f;
            this.inWater = true;
            this.fireTicks = 0;
        } else {
            this.inWater = false;
        }
        return this.inWater;
    }

    public boolean a(Material material) {
        int n;
        int n2;
        double d = this.locY + (double)this.getHeadHeight();
        int n3 = MathHelper.floor(this.locX);
        int n4 = this.world.getTypeId(n3, n2 = MathHelper.d(MathHelper.floor(d)), n = MathHelper.floor(this.locZ));
        if (n4 != 0 && Block.byId[n4].material == material) {
            float f = BlockFluids.d(this.world.getData(n3, n2, n)) - 0.11111111f;
            float f2 = (float)(n2 + 1) - f;
            return d < (double)f2;
        }
        return false;
    }

    public float getHeadHeight() {
        return 0.0f;
    }

    public boolean J() {
        return this.world.a(this.boundingBox.grow(-0.1f, -0.4f, -0.1f), Material.LAVA);
    }

    public void a(float f, float f2, float f3) {
        float f4 = f * f + f2 * f2;
        if (f4 < 1.0E-4f) {
            return;
        }
        if ((f4 = MathHelper.c(f4)) < 1.0f) {
            f4 = 1.0f;
        }
        f4 = f3 / f4;
        float f5 = MathHelper.sin(this.yaw * (float)Math.PI / 180.0f);
        float f6 = MathHelper.cos(this.yaw * (float)Math.PI / 180.0f);
        this.motX += (double)((f *= f4) * f6 - (f2 *= f4) * f5);
        this.motZ += (double)(f2 * f6 + f * f5);
    }

    public float d(float f) {
        int n;
        int n2 = MathHelper.floor(this.locX);
        if (this.world.isLoaded(n2, 0, n = MathHelper.floor(this.locZ))) {
            double d = (this.boundingBox.e - this.boundingBox.b) * 0.66;
            int n3 = MathHelper.floor(this.locY - (double)this.height + d);
            return this.world.q(n2, n3, n);
        }
        return 0.0f;
    }

    public void spawnIn(World world) {
        this.world = world;
    }

    public void setLocation(double d, double d2, double d3, float f, float f2) {
        this.lastX = this.locX = d;
        this.lastY = this.locY = d2;
        this.lastZ = this.locZ = d3;
        this.lastYaw = this.yaw = f;
        this.lastPitch = this.pitch = f2;
        this.X = 0.0f;
        double d4 = this.lastYaw - f;
        if (d4 < -180.0) {
            this.lastYaw += 360.0f;
        }
        if (d4 >= 180.0) {
            this.lastYaw -= 360.0f;
        }
        this.setPosition(this.locX, this.locY, this.locZ);
        this.b(f, f2);
    }

    public void setPositionRotation(double d, double d2, double d3, float f, float f2) {
        this.lastX = this.locX = d;
        this.U = this.locX;
        this.lastY = this.locY = d2 + (double)this.height;
        this.V = this.locY;
        this.lastZ = this.locZ = d3;
        this.W = this.locZ;
        this.yaw = f;
        this.pitch = f2;
        this.setPosition(this.locX, this.locY, this.locZ);
    }

    public float d(Entity entity) {
        float f = (float)(this.locX - entity.locX);
        float f2 = (float)(this.locY - entity.locY);
        float f3 = (float)(this.locZ - entity.locZ);
        return MathHelper.c(f * f + f2 * f2 + f3 * f3);
    }

    public double e(double d, double d2, double d3) {
        double d4 = this.locX - d;
        double d5 = this.locY - d2;
        double d6 = this.locZ - d3;
        return d4 * d4 + d5 * d5 + d6 * d6;
    }

    public double f(double d, double d2, double d3) {
        double d4 = this.locX - d;
        double d5 = this.locY - d2;
        double d6 = this.locZ - d3;
        return MathHelper.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
    }

    public double e(Entity entity) {
        double d = this.locX - entity.locX;
        double d2 = this.locY - entity.locY;
        double d3 = this.locZ - entity.locZ;
        return d * d + d2 * d2 + d3 * d3;
    }

    public void b_(EntityHuman entityHuman) {
    }

    public void collide(Entity entity) {
        if (entity.passenger == this || entity.vehicle == this) {
            return;
        }
        double d = entity.locX - this.locX;
        double d2 = entity.locZ - this.locZ;
        double d3 = MathHelper.a(d, d2);
        if (d3 >= (double)0.01f) {
            d3 = MathHelper.sqrt(d3);
            d /= d3;
            d2 /= d3;
            double d4 = 1.0 / d3;
            if (d4 > 1.0) {
                d4 = 1.0;
            }
            d *= d4;
            d2 *= d4;
            d *= (double)0.05f;
            d2 *= (double)0.05f;
            this.g(-(d *= (double)(1.0f - this.aa)), 0.0, -(d2 *= (double)(1.0f - this.aa)));
            entity.g(d, 0.0, d2);
        }
    }

    public void g(double d, double d2, double d3) {
        this.motX += d;
        this.motY += d2;
        this.motZ += d3;
        this.an = true;
    }

    protected void K() {
        this.velocityChanged = true;
    }

    public boolean damageEntity(DamageSource damageSource, float f) {
        if (this.isInvulnerable()) {
            return false;
        }
        this.K();
        return false;
    }

    public boolean L() {
        return false;
    }

    public boolean M() {
        return false;
    }

    public void b(Entity entity, int n) {
    }

    public boolean c(NBTTagCompound nBTTagCompound) {
        String string = this.Q();
        if (this.dead || string == null) {
            return false;
        }
        nBTTagCompound.setString("id", string);
        this.e(nBTTagCompound);
        return true;
    }

    public boolean d(NBTTagCompound nBTTagCompound) {
        String string = this.Q();
        if (this.dead || string == null || this.passenger != null) {
            return false;
        }
        nBTTagCompound.setString("id", string);
        this.e(nBTTagCompound);
        return true;
    }

    public void e(NBTTagCompound nBTTagCompound) {
        try {
            NBTTagCompound nBTTagCompound2;
            nBTTagCompound.set("Pos", this.a(this.locX, this.locY + (double)this.X, this.locZ));
            nBTTagCompound.set("Motion", this.a(this.motX, this.motY, this.motZ));
            nBTTagCompound.set("Rotation", this.a(new float[]{this.yaw, this.pitch}));
            nBTTagCompound.setFloat("FallDistance", this.fallDistance);
            nBTTagCompound.setShort("Fire", (short)this.fireTicks);
            nBTTagCompound.setShort("Air", (short)this.getAirTicks());
            nBTTagCompound.setBoolean("OnGround", this.onGround);
            nBTTagCompound.setInt("Dimension", this.dimension);
            nBTTagCompound.setBoolean("Invulnerable", this.invulnerable);
            nBTTagCompound.setInt("PortalCooldown", this.portalCooldown);
            nBTTagCompound.setLong("UUIDMost", this.uniqueID.getMostSignificantBits());
            nBTTagCompound.setLong("UUIDLeast", this.uniqueID.getLeastSignificantBits());
            this.b(nBTTagCompound);
            if (this.vehicle != null && this.vehicle.c(nBTTagCompound2 = new NBTTagCompound("Riding"))) {
                nBTTagCompound.set("Riding", nBTTagCompound2);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.a(throwable, "Saving entity NBT");
            CrashReportSystemDetails crashReportSystemDetails = crashReport.a("Entity being saved");
            this.a(crashReportSystemDetails);
            throw new ReportedException(crashReport);
        }
    }

    public void f(NBTTagCompound nBTTagCompound) {
        try {
            NBTTagList nBTTagList = nBTTagCompound.getList("Pos");
            NBTTagList nBTTagList2 = nBTTagCompound.getList("Motion");
            NBTTagList nBTTagList3 = nBTTagCompound.getList("Rotation");
            this.motX = ((NBTTagDouble)nBTTagList2.get((int)0)).data;
            this.motY = ((NBTTagDouble)nBTTagList2.get((int)1)).data;
            this.motZ = ((NBTTagDouble)nBTTagList2.get((int)2)).data;
            if (Math.abs(this.motX) > 10.0) {
                this.motX = 0.0;
            }
            if (Math.abs(this.motY) > 10.0) {
                this.motY = 0.0;
            }
            if (Math.abs(this.motZ) > 10.0) {
                this.motZ = 0.0;
            }
            this.U = this.locX = ((NBTTagDouble)nBTTagList.get((int)0)).data;
            this.lastX = this.locX;
            this.V = this.locY = ((NBTTagDouble)nBTTagList.get((int)1)).data;
            this.lastY = this.locY;
            this.W = this.locZ = ((NBTTagDouble)nBTTagList.get((int)2)).data;
            this.lastZ = this.locZ;
            this.lastYaw = this.yaw = ((NBTTagFloat)nBTTagList3.get((int)0)).data;
            this.lastPitch = this.pitch = ((NBTTagFloat)nBTTagList3.get((int)1)).data;
            this.fallDistance = nBTTagCompound.getFloat("FallDistance");
            this.fireTicks = nBTTagCompound.getShort("Fire");
            this.setAirTicks(nBTTagCompound.getShort("Air"));
            this.onGround = nBTTagCompound.getBoolean("OnGround");
            this.dimension = nBTTagCompound.getInt("Dimension");
            this.invulnerable = nBTTagCompound.getBoolean("Invulnerable");
            this.portalCooldown = nBTTagCompound.getInt("PortalCooldown");
            if (nBTTagCompound.hasKey("UUIDMost") && nBTTagCompound.hasKey("UUIDLeast")) {
                this.uniqueID = new UUID(nBTTagCompound.getLong("UUIDMost"), nBTTagCompound.getLong("UUIDLeast"));
            }
            this.setPosition(this.locX, this.locY, this.locZ);
            this.b(this.yaw, this.pitch);
            this.a(nBTTagCompound);
            if (this.P()) {
                this.setPosition(this.locX, this.locY, this.locZ);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.a(throwable, "Loading entity NBT");
            CrashReportSystemDetails crashReportSystemDetails = crashReport.a("Entity being loaded");
            this.a(crashReportSystemDetails);
            throw new ReportedException(crashReport);
        }
    }

    protected boolean P() {
        return true;
    }

    protected final String Q() {
        return EntityTypes.b(this);
    }

    protected abstract void a(NBTTagCompound var1);

    protected abstract void b(NBTTagCompound var1);

    public void R() {
    }

    protected NBTTagList a(double ... dArray) {
        NBTTagList nBTTagList = new NBTTagList();
        for (double d : dArray) {
            nBTTagList.add(new NBTTagDouble(null, d));
        }
        return nBTTagList;
    }

    protected NBTTagList a(float ... fArray) {
        NBTTagList nBTTagList = new NBTTagList();
        for (float f : fArray) {
            nBTTagList.add(new NBTTagFloat(null, f));
        }
        return nBTTagList;
    }

    public EntityItem b(int n, int n2) {
        return this.a(n, n2, 0.0f);
    }

    public EntityItem a(int n, int n2, float f) {
        return this.a(new ItemStack(n, n2, 0), f);
    }

    public EntityItem a(ItemStack itemStack, float f) {
        if (itemStack.count == 0) {
            return null;
        }
        EntityItem entityItem = new EntityItem(this.world, this.locX, this.locY + (double)f, this.locZ, itemStack);
        entityItem.pickupDelay = 10;
        this.world.addEntity(entityItem);
        return entityItem;
    }

    public boolean isAlive() {
        return !this.dead;
    }

    public boolean inBlock() {
        for (int i = 0; i < 8; ++i) {
            int n;
            int n2;
            float f = ((float)((i >> 0) % 2) - 0.5f) * this.width * 0.8f;
            float f2 = ((float)((i >> 1) % 2) - 0.5f) * 0.1f;
            float f3 = ((float)((i >> 2) % 2) - 0.5f) * this.width * 0.8f;
            int n3 = MathHelper.floor(this.locX + (double)f);
            if (!this.world.u(n3, n2 = MathHelper.floor(this.locY + (double)this.getHeadHeight() + (double)f2), n = MathHelper.floor(this.locZ + (double)f3))) continue;
            return true;
        }
        return false;
    }

    public boolean c(EntityHuman entityHuman) {
        return false;
    }

    public AxisAlignedBB g(Entity entity) {
        return null;
    }

    public void V() {
        if (this.vehicle.dead) {
            this.vehicle = null;
            return;
        }
        this.motX = 0.0;
        this.motY = 0.0;
        this.motZ = 0.0;
        this.l_();
        if (this.vehicle == null) {
            return;
        }
        this.vehicle.W();
        this.g += (double)(this.vehicle.yaw - this.vehicle.lastYaw);
        this.f += (double)(this.vehicle.pitch - this.vehicle.lastPitch);
        while (this.g >= 180.0) {
            this.g -= 360.0;
        }
        while (this.g < -180.0) {
            this.g += 360.0;
        }
        while (this.f >= 180.0) {
            this.f -= 360.0;
        }
        while (this.f < -180.0) {
            this.f += 360.0;
        }
        double d = this.g * 0.5;
        double d2 = this.f * 0.5;
        float f = 10.0f;
        if (d > (double)f) {
            d = f;
        }
        if (d < (double)(-f)) {
            d = -f;
        }
        if (d2 > (double)f) {
            d2 = f;
        }
        if (d2 < (double)(-f)) {
            d2 = -f;
        }
        this.g -= d;
        this.f -= d2;
    }

    public void W() {
        if (this.passenger == null) {
            return;
        }
        this.passenger.setPosition(this.locX, this.locY + this.Y() + this.passenger.X(), this.locZ);
    }

    public double X() {
        return this.height;
    }

    public double Y() {
        return (double)this.length * 0.75;
    }

    public void mount(Entity entity) {
        this.f = 0.0;
        this.g = 0.0;
        if (entity == null) {
            if (this.vehicle != null) {
                this.setPositionRotation(this.vehicle.locX, this.vehicle.boundingBox.b + (double)this.vehicle.length, this.vehicle.locZ, this.yaw, this.pitch);
                this.vehicle.passenger = null;
            }
            this.vehicle = null;
            return;
        }
        if (this.vehicle != null) {
            this.vehicle.passenger = null;
        }
        this.vehicle = entity;
        entity.passenger = this;
    }

    public float Z() {
        return 0.1f;
    }

    public Vec3D aa() {
        return null;
    }

    public void ab() {
        if (this.portalCooldown > 0) {
            this.portalCooldown = this.ac();
            return;
        }
        double d = this.lastX - this.locX;
        double d2 = this.lastZ - this.locZ;
        if (!this.world.isStatic && !this.ap) {
            this.as = Direction.a(d, d2);
        }
        this.ap = true;
    }

    public int ac() {
        return 900;
    }

    public ItemStack[] getEquipment() {
        return null;
    }

    public void setEquipment(int n, ItemStack itemStack) {
    }

    public boolean isBurning() {
        return !this.fireProof && (this.fireTicks > 0 || this.f(0));
    }

    public boolean ag() {
        return this.vehicle != null;
    }

    public boolean isSneaking() {
        return this.f(1);
    }

    public void setSneaking(boolean bl) {
        this.a(1, bl);
    }

    public boolean isSprinting() {
        return this.f(3);
    }

    public void setSprinting(boolean bl) {
        this.a(3, bl);
    }

    public boolean isInvisible() {
        return this.f(5);
    }

    public void setInvisible(boolean bl) {
        this.a(5, bl);
    }

    public void e(boolean bl) {
        this.a(4, bl);
    }

    protected boolean f(int n) {
        return (this.datawatcher.getByte(0) & 1 << n) != 0;
    }

    protected void a(int n, boolean bl) {
        byte by = this.datawatcher.getByte(0);
        if (bl) {
            this.datawatcher.watch(0, (byte)(by | 1 << n));
        } else {
            this.datawatcher.watch(0, (byte)(by & ~(1 << n)));
        }
    }

    public int getAirTicks() {
        return this.datawatcher.getShort(1);
    }

    public void setAirTicks(int n) {
        this.datawatcher.watch(1, (short)n);
    }

    public void a(EntityLightning entityLightning) {
        this.burn(5);
        ++this.fireTicks;
        if (this.fireTicks == 0) {
            this.setOnFire(8);
        }
    }

    public void a(EntityLiving entityLiving) {
    }

    protected boolean i(double d, double d2, double d3) {
        int n = MathHelper.floor(d);
        int n2 = MathHelper.floor(d2);
        int n3 = MathHelper.floor(d3);
        double d4 = d - (double)n;
        double d5 = d2 - (double)n2;
        double d6 = d3 - (double)n3;
        List list = this.world.a(this.boundingBox);
        if (!list.isEmpty() || this.world.v(n, n2, n3)) {
            boolean bl = !this.world.v(n - 1, n2, n3);
            boolean bl2 = !this.world.v(n + 1, n2, n3);
            boolean bl3 = !this.world.v(n, n2 - 1, n3);
            boolean bl4 = !this.world.v(n, n2 + 1, n3);
            boolean bl5 = !this.world.v(n, n2, n3 - 1);
            boolean bl6 = !this.world.v(n, n2, n3 + 1);
            int n4 = 3;
            double d7 = 9999.0;
            if (bl && d4 < d7) {
                d7 = d4;
                n4 = 0;
            }
            if (bl2 && 1.0 - d4 < d7) {
                d7 = 1.0 - d4;
                n4 = 1;
            }
            if (bl4 && 1.0 - d5 < d7) {
                d7 = 1.0 - d5;
                n4 = 3;
            }
            if (bl5 && d6 < d7) {
                d7 = d6;
                n4 = 4;
            }
            if (bl6 && 1.0 - d6 < d7) {
                d7 = 1.0 - d6;
                n4 = 5;
            }
            float f = this.random.nextFloat() * 0.2f + 0.1f;
            if (n4 == 0) {
                this.motX = -f;
            }
            if (n4 == 1) {
                this.motX = f;
            }
            if (n4 == 2) {
                this.motY = -f;
            }
            if (n4 == 3) {
                this.motY = f;
            }
            if (n4 == 4) {
                this.motZ = -f;
            }
            if (n4 == 5) {
                this.motZ = f;
            }
            return true;
        }
        return false;
    }

    public void am() {
        this.K = true;
        this.fallDistance = 0.0f;
    }

    public String getLocalizedName() {
        String string = EntityTypes.b(this);
        if (string == null) {
            string = "generic";
        }
        return LocaleI18n.get("entity." + string + ".name");
    }

    public Entity[] ao() {
        return null;
    }

    public boolean h(Entity entity) {
        return this == entity;
    }

    public float getHeadRotation() {
        return 0.0f;
    }

    public boolean aq() {
        return true;
    }

    public boolean i(Entity entity) {
        return false;
    }

    public String toString() {
        return String.format("%s['%s'/%d, l='%s', x=%.2f, y=%.2f, z=%.2f]", this.getClass().getSimpleName(), this.getLocalizedName(), this.id, this.world == null ? "~NULL~" : this.world.getWorldData().getName(), this.locX, this.locY, this.locZ);
    }

    public boolean isInvulnerable() {
        return this.invulnerable;
    }

    public void j(Entity entity) {
        this.setPositionRotation(entity.locX, entity.locY, entity.locZ, entity.yaw, entity.pitch);
    }

    public void a(Entity entity, boolean bl) {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        entity.e(nBTTagCompound);
        this.f(nBTTagCompound);
        this.portalCooldown = entity.portalCooldown;
        this.as = entity.as;
    }

    public void b(int n) {
        if (this.world.isStatic || this.dead) {
            return;
        }
        this.world.methodProfiler.a("changeDimension");
        MinecraftServer minecraftServer = MinecraftServer.getServer();
        int n2 = this.dimension;
        WorldServer worldServer = minecraftServer.getWorldServer(n2);
        WorldServer worldServer2 = minecraftServer.getWorldServer(n);
        this.dimension = n;
        if (n2 == 1 && n == 1) {
            worldServer2 = minecraftServer.getWorldServer(0);
            this.dimension = 0;
        }
        this.world.kill(this);
        this.dead = false;
        this.world.methodProfiler.a("reposition");
        minecraftServer.getPlayerList().a(this, n2, worldServer, worldServer2);
        this.world.methodProfiler.c("reloading");
        Entity entity = EntityTypes.createEntityByName(EntityTypes.b(this), worldServer2);
        if (entity != null) {
            entity.a(this, true);
            if (n2 == 1 && n == 1) {
                ChunkCoordinates chunkCoordinates = worldServer2.getSpawn();
                chunkCoordinates.y = this.world.i(chunkCoordinates.x, chunkCoordinates.z);
                entity.setPositionRotation(chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z, entity.yaw, entity.pitch);
            }
            worldServer2.addEntity(entity);
        }
        this.dead = true;
        this.world.methodProfiler.b();
        worldServer.i();
        worldServer2.i();
        this.world.methodProfiler.b();
    }

    public float a(Explosion explosion, World world, int n, int n2, int n3, Block block) {
        return block.a(this);
    }

    public boolean a(Explosion explosion, World world, int n, int n2, int n3, int n4, float f) {
        return true;
    }

    public int as() {
        return 3;
    }

    public int at() {
        return this.as;
    }

    public boolean au() {
        return false;
    }

    public void a(CrashReportSystemDetails crashReportSystemDetails) {
        crashReportSystemDetails.a("Entity Type", new CrashReportEntityType(this));
        crashReportSystemDetails.a("Entity ID", this.id);
        crashReportSystemDetails.a("Entity Name", new CrashReportEntityName(this));
        crashReportSystemDetails.a("Entity's Exact location", String.format("%.2f, %.2f, %.2f", this.locX, this.locY, this.locZ));
        crashReportSystemDetails.a("Entity's Block location", CrashReportSystemDetails.a(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ)));
        crashReportSystemDetails.a("Entity's Momentum", String.format("%.2f, %.2f, %.2f", this.motX, this.motY, this.motZ));
    }

    public UUID getUniqueID() {
        return this.uniqueID;
    }

    public boolean ax() {
        return true;
    }

    public String getScoreboardDisplayName() {
        return this.getLocalizedName();
    }
}

