/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Enchantment;
import net.minecraft.server.EnchantmentInstance;
import net.minecraft.server.EnchantmentModifier;
import net.minecraft.server.EnchantmentModifierDamage;
import net.minecraft.server.EnchantmentModifierProtection;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.WeightedRandom;

public class EnchantmentManager {
    private static final Random random = new Random();
    private static final EnchantmentModifierProtection b = new EnchantmentModifierProtection(null);
    private static final EnchantmentModifierDamage c = new EnchantmentModifierDamage(null);

    public static int getEnchantmentLevel(int n, ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        NBTTagList nBTTagList = itemStack.getEnchantments();
        if (nBTTagList == null) {
            return 0;
        }
        for (int i = 0; i < nBTTagList.size(); ++i) {
            short s = ((NBTTagCompound)nBTTagList.get(i)).getShort("id");
            short s2 = ((NBTTagCompound)nBTTagList.get(i)).getShort("lvl");
            if (s != n) continue;
            return s2;
        }
        return 0;
    }

    public static Map a(ItemStack itemStack) {
        NBTTagList nBTTagList;
        LinkedHashMap<Integer, Integer> linkedHashMap = new LinkedHashMap<Integer, Integer>();
        NBTTagList nBTTagList2 = nBTTagList = itemStack.id == Item.ENCHANTED_BOOK.id ? Item.ENCHANTED_BOOK.g(itemStack) : itemStack.getEnchantments();
        if (nBTTagList != null) {
            for (int i = 0; i < nBTTagList.size(); ++i) {
                short s = ((NBTTagCompound)nBTTagList.get(i)).getShort("id");
                short s2 = ((NBTTagCompound)nBTTagList.get(i)).getShort("lvl");
                linkedHashMap.put(Integer.valueOf(s), Integer.valueOf(s2));
            }
        }
        return linkedHashMap;
    }

    public static void a(Map map, ItemStack itemStack) {
        NBTTagList nBTTagList = new NBTTagList();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.setShort("id", (short)n);
            nBTTagCompound.setShort("lvl", (short)((Integer)map.get(n)).intValue());
            nBTTagList.add(nBTTagCompound);
            if (itemStack.id != Item.ENCHANTED_BOOK.id) continue;
            Item.ENCHANTED_BOOK.a(itemStack, new EnchantmentInstance(n, (int)((Integer)map.get(n))));
        }
        if (nBTTagList.size() > 0) {
            if (itemStack.id != Item.ENCHANTED_BOOK.id) {
                itemStack.a("ench", nBTTagList);
            }
        } else if (itemStack.hasTag()) {
            itemStack.getTag().remove("ench");
        }
    }

    public static int getEnchantmentLevel(int n, ItemStack[] itemStackArray) {
        if (itemStackArray == null) {
            return 0;
        }
        int n2 = 0;
        for (ItemStack itemStack : itemStackArray) {
            int n3 = EnchantmentManager.getEnchantmentLevel(n, itemStack);
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    private static void a(EnchantmentModifier enchantmentModifier, ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        NBTTagList nBTTagList = itemStack.getEnchantments();
        if (nBTTagList == null) {
            return;
        }
        for (int i = 0; i < nBTTagList.size(); ++i) {
            short s = ((NBTTagCompound)nBTTagList.get(i)).getShort("id");
            short s2 = ((NBTTagCompound)nBTTagList.get(i)).getShort("lvl");
            if (Enchantment.byId[s] == null) continue;
            enchantmentModifier.a(Enchantment.byId[s], s2);
        }
    }

    private static void a(EnchantmentModifier enchantmentModifier, ItemStack[] itemStackArray) {
        for (ItemStack itemStack : itemStackArray) {
            EnchantmentManager.a(enchantmentModifier, itemStack);
        }
    }

    public static int a(ItemStack[] itemStackArray, DamageSource damageSource) {
        EnchantmentManager.b.a = 0;
        EnchantmentManager.b.b = damageSource;
        EnchantmentManager.a((EnchantmentModifier)b, itemStackArray);
        if (EnchantmentManager.b.a > 25) {
            EnchantmentManager.b.a = 25;
        }
        return (EnchantmentManager.b.a + 1 >> 1) + random.nextInt((EnchantmentManager.b.a >> 1) + 1);
    }

    public static float a(EntityLiving entityLiving, EntityLiving entityLiving2) {
        EnchantmentManager.c.a = 0.0f;
        EnchantmentManager.c.b = entityLiving2;
        EnchantmentManager.a((EnchantmentModifier)c, entityLiving.aZ());
        return EnchantmentManager.c.a;
    }

    public static int getKnockbackEnchantmentLevel(EntityLiving entityLiving, EntityLiving entityLiving2) {
        return EnchantmentManager.getEnchantmentLevel(Enchantment.KNOCKBACK.id, entityLiving.aZ());
    }

    public static int getFireAspectEnchantmentLevel(EntityLiving entityLiving) {
        return EnchantmentManager.getEnchantmentLevel(Enchantment.FIRE_ASPECT.id, entityLiving.aZ());
    }

    public static int getOxygenEnchantmentLevel(EntityLiving entityLiving) {
        return EnchantmentManager.getEnchantmentLevel(Enchantment.OXYGEN.id, entityLiving.getEquipment());
    }

    public static int getDigSpeedEnchantmentLevel(EntityLiving entityLiving) {
        return EnchantmentManager.getEnchantmentLevel(Enchantment.DIG_SPEED.id, entityLiving.aZ());
    }

    public static boolean hasSilkTouchEnchantment(EntityLiving entityLiving) {
        return EnchantmentManager.getEnchantmentLevel(Enchantment.SILK_TOUCH.id, entityLiving.aZ()) > 0;
    }

    public static int getBonusBlockLootEnchantmentLevel(EntityLiving entityLiving) {
        return EnchantmentManager.getEnchantmentLevel(Enchantment.LOOT_BONUS_BLOCKS.id, entityLiving.aZ());
    }

    public static int getBonusMonsterLootEnchantmentLevel(EntityLiving entityLiving) {
        return EnchantmentManager.getEnchantmentLevel(Enchantment.LOOT_BONUS_MOBS.id, entityLiving.aZ());
    }

    public static boolean hasWaterWorkerEnchantment(EntityLiving entityLiving) {
        return EnchantmentManager.getEnchantmentLevel(Enchantment.WATER_WORKER.id, entityLiving.getEquipment()) > 0;
    }

    public static int getThornsEnchantmentLevel(EntityLiving entityLiving) {
        return EnchantmentManager.getEnchantmentLevel(Enchantment.THORNS.id, entityLiving.getEquipment());
    }

    public static ItemStack a(Enchantment enchantment, EntityLiving entityLiving) {
        for (ItemStack itemStack : entityLiving.getEquipment()) {
            if (itemStack == null || EnchantmentManager.getEnchantmentLevel(enchantment.id, itemStack) <= 0) continue;
            return itemStack;
        }
        return null;
    }

    public static int a(Random random, int n, int n2, ItemStack itemStack) {
        Item item = itemStack.getItem();
        int n3 = item.c();
        if (n3 <= 0) {
            return 0;
        }
        if (n2 > 15) {
            n2 = 15;
        }
        int n4 = random.nextInt(8) + 1 + (n2 >> 1) + random.nextInt(n2 + 1);
        if (n == 0) {
            return Math.max(n4 / 3, 1);
        }
        if (n == 1) {
            return n4 * 2 / 3 + 1;
        }
        return Math.max(n4, n2 * 2);
    }

    public static ItemStack a(Random random, ItemStack itemStack, int n) {
        boolean bl;
        List list = EnchantmentManager.b(random, itemStack, n);
        boolean bl2 = bl = itemStack.id == Item.BOOK.id;
        if (bl) {
            itemStack.id = Item.ENCHANTED_BOOK.id;
        }
        if (list != null) {
            for (EnchantmentInstance enchantmentInstance : list) {
                if (bl) {
                    Item.ENCHANTED_BOOK.a(itemStack, enchantmentInstance);
                    continue;
                }
                itemStack.addEnchantment(enchantmentInstance.enchantment, enchantmentInstance.level);
            }
        }
        return itemStack;
    }

    public static List b(Random random, ItemStack itemStack, int n) {
        EnchantmentInstance enchantmentInstance;
        float f;
        Item item = itemStack.getItem();
        int n2 = item.c();
        if (n2 <= 0) {
            return null;
        }
        n2 /= 2;
        int n3 = (n2 = 1 + random.nextInt((n2 >> 1) + 1) + random.nextInt((n2 >> 1) + 1)) + n;
        int n4 = (int)((float)n3 * (1.0f + (f = (random.nextFloat() + random.nextFloat() - 1.0f) * 0.15f)) + 0.5f);
        if (n4 < 1) {
            n4 = 1;
        }
        ArrayList<Object> arrayList = null;
        Map map = EnchantmentManager.b(n4, itemStack);
        if (map != null && !map.isEmpty() && (enchantmentInstance = (EnchantmentInstance)WeightedRandom.a(random, map.values())) != null) {
            arrayList = new ArrayList<Object>();
            arrayList.add(enchantmentInstance);
            for (int i = n4; random.nextInt(50) <= i; i >>= 1) {
                Object object;
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    object = (Integer)iterator.next();
                    boolean bl = true;
                    for (EnchantmentInstance enchantmentInstance2 : arrayList) {
                        if (enchantmentInstance2.enchantment.a(Enchantment.byId[(Integer)object])) continue;
                        bl = false;
                        break;
                    }
                    if (bl) continue;
                    iterator.remove();
                }
                if (map.isEmpty()) continue;
                object = (EnchantmentInstance)WeightedRandom.a(random, map.values());
                arrayList.add(object);
            }
        }
        return arrayList;
    }

    public static Map b(int n, ItemStack itemStack) {
        Item item = itemStack.getItem();
        HashMap<Integer, EnchantmentInstance> hashMap = null;
        boolean bl = itemStack.id == Item.BOOK.id;
        for (Enchantment enchantment : Enchantment.byId) {
            if (enchantment == null || !enchantment.slot.canEnchant(item) && !bl) continue;
            for (int i = enchantment.getStartLevel(); i <= enchantment.getMaxLevel(); ++i) {
                if (n < enchantment.a(i) || n > enchantment.b(i)) continue;
                if (hashMap == null) {
                    hashMap = new HashMap<Integer, EnchantmentInstance>();
                }
                hashMap.put(enchantment.id, new EnchantmentInstance(enchantment, i));
            }
        }
        return hashMap;
    }
}

