/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import net.minecraft.server.DamageSource;
import net.minecraft.server.EnchantmentArrowDamage;
import net.minecraft.server.EnchantmentArrowKnockback;
import net.minecraft.server.EnchantmentDigging;
import net.minecraft.server.EnchantmentDurability;
import net.minecraft.server.EnchantmentFire;
import net.minecraft.server.EnchantmentFlameArrows;
import net.minecraft.server.EnchantmentInfiniteArrows;
import net.minecraft.server.EnchantmentKnockback;
import net.minecraft.server.EnchantmentLootBonus;
import net.minecraft.server.EnchantmentOxygen;
import net.minecraft.server.EnchantmentProtection;
import net.minecraft.server.EnchantmentSilkTouch;
import net.minecraft.server.EnchantmentSlotType;
import net.minecraft.server.EnchantmentThorns;
import net.minecraft.server.EnchantmentWaterWorker;
import net.minecraft.server.EnchantmentWeaponDamage;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.ItemStack;
import net.minecraft.server.LocaleI18n;

public abstract class Enchantment {
    public static final Enchantment[] byId = new Enchantment[256];
    public static final Enchantment[] c;
    public static final Enchantment PROTECTION_ENVIRONMENTAL;
    public static final Enchantment PROTECTION_FIRE;
    public static final Enchantment PROTECTION_FALL;
    public static final Enchantment PROTECTION_EXPLOSIONS;
    public static final Enchantment PROTECTION_PROJECTILE;
    public static final Enchantment OXYGEN;
    public static final Enchantment WATER_WORKER;
    public static final Enchantment THORNS;
    public static final Enchantment DAMAGE_ALL;
    public static final Enchantment DAMAGE_UNDEAD;
    public static final Enchantment DAMAGE_ARTHROPODS;
    public static final Enchantment KNOCKBACK;
    public static final Enchantment FIRE_ASPECT;
    public static final Enchantment LOOT_BONUS_MOBS;
    public static final Enchantment DIG_SPEED;
    public static final Enchantment SILK_TOUCH;
    public static final Enchantment DURABILITY;
    public static final Enchantment LOOT_BONUS_BLOCKS;
    public static final Enchantment ARROW_DAMAGE;
    public static final Enchantment ARROW_KNOCKBACK;
    public static final Enchantment ARROW_FIRE;
    public static final Enchantment ARROW_INFINITE;
    public final int id;
    private final int weight;
    public EnchantmentSlotType slot;
    protected String name;

    protected Enchantment(int n, int n2, EnchantmentSlotType enchantmentSlotType) {
        this.id = n;
        this.weight = n2;
        this.slot = enchantmentSlotType;
        if (byId[n] != null) {
            throw new IllegalArgumentException("Duplicate enchantment id!");
        }
        Enchantment.byId[n] = this;
    }

    public int getRandomWeight() {
        return this.weight;
    }

    public int getStartLevel() {
        return 1;
    }

    public int getMaxLevel() {
        return 1;
    }

    public int a(int n) {
        return 1 + n * 10;
    }

    public int b(int n) {
        return this.a(n) + 5;
    }

    public int a(int n, DamageSource damageSource) {
        return 0;
    }

    public float a(int n, EntityLiving entityLiving) {
        return 0.0f;
    }

    public boolean a(Enchantment enchantment) {
        return this != enchantment;
    }

    public Enchantment b(String string) {
        this.name = string;
        return this;
    }

    public String a() {
        return "enchantment." + this.name;
    }

    public String c(int n) {
        String string = LocaleI18n.get(this.a());
        return string + " " + LocaleI18n.get("enchantment.level." + n);
    }

    public boolean canEnchant(ItemStack itemStack) {
        return this.slot.canEnchant(itemStack.getItem());
    }

    static {
        PROTECTION_ENVIRONMENTAL = new EnchantmentProtection(0, 10, 0);
        PROTECTION_FIRE = new EnchantmentProtection(1, 5, 1);
        PROTECTION_FALL = new EnchantmentProtection(2, 5, 2);
        PROTECTION_EXPLOSIONS = new EnchantmentProtection(3, 2, 3);
        PROTECTION_PROJECTILE = new EnchantmentProtection(4, 5, 4);
        OXYGEN = new EnchantmentOxygen(5, 2);
        WATER_WORKER = new EnchantmentWaterWorker(6, 2);
        THORNS = new EnchantmentThorns(7, 1);
        DAMAGE_ALL = new EnchantmentWeaponDamage(16, 10, 0);
        DAMAGE_UNDEAD = new EnchantmentWeaponDamage(17, 5, 1);
        DAMAGE_ARTHROPODS = new EnchantmentWeaponDamage(18, 5, 2);
        KNOCKBACK = new EnchantmentKnockback(19, 5);
        FIRE_ASPECT = new EnchantmentFire(20, 2);
        LOOT_BONUS_MOBS = new EnchantmentLootBonus(21, 2, EnchantmentSlotType.WEAPON);
        DIG_SPEED = new EnchantmentDigging(32, 10);
        SILK_TOUCH = new EnchantmentSilkTouch(33, 1);
        DURABILITY = new EnchantmentDurability(34, 5);
        LOOT_BONUS_BLOCKS = new EnchantmentLootBonus(35, 2, EnchantmentSlotType.DIGGER);
        ARROW_DAMAGE = new EnchantmentArrowDamage(48, 10);
        ARROW_KNOCKBACK = new EnchantmentArrowKnockback(49, 2);
        ARROW_FIRE = new EnchantmentFlameArrows(50, 2);
        ARROW_INFINITE = new EnchantmentInfiniteArrows(51, 1);
        ArrayList<Enchantment> arrayList = new ArrayList<Enchantment>();
        for (Enchantment enchantment : byId) {
            if (enchantment == null) continue;
            arrayList.add(enchantment);
        }
        c = arrayList.toArray(new Enchantment[0]);
    }
}

