/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.ConsoleLogManager;
import net.minecraft.server.CrashReport;
import net.minecraft.server.CrashReportModded;
import net.minecraft.server.CrashReportType;
import net.minecraft.server.DedicatedPlayerList;
import net.minecraft.server.DedicatedServerConnection;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EnumGamemode;
import net.minecraft.server.ICommandListener;
import net.minecraft.server.IConsoleLogManager;
import net.minecraft.server.IMinecraftServer;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MinecraftEncryption;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.MojangStatisticsGenerator;
import net.minecraft.server.PlayerList;
import net.minecraft.server.PropertyManager;
import net.minecraft.server.RemoteControlListener;
import net.minecraft.server.RemoteStatusListener;
import net.minecraft.server.ServerCommand;
import net.minecraft.server.ServerConnection;
import net.minecraft.server.ServerGUI;
import net.minecraft.server.ThreadCommandReader;
import net.minecraft.server.ThreadSleepForever;
import net.minecraft.server.World;
import net.minecraft.server.WorldSettings;
import net.minecraft.server.WorldType;

public class DedicatedServer
extends MinecraftServer
implements IMinecraftServer {
    private final List l = Collections.synchronizedList(new ArrayList());
    private final IConsoleLogManager m;
    private RemoteStatusListener n;
    private RemoteControlListener o;
    private PropertyManager propertyManager;
    private boolean generateStructures;
    private EnumGamemode r;
    private ServerConnection s;
    private boolean t;

    public DedicatedServer(File file) {
        super(file);
        this.m = new ConsoleLogManager("Minecraft-Server", null, new File(file, "server.log").getAbsolutePath());
        new ThreadSleepForever(this);
    }

    @Override
    protected boolean init() {
        WorldType worldType;
        ThreadCommandReader threadCommandReader = new ThreadCommandReader(this);
        threadCommandReader.setDaemon(true);
        threadCommandReader.start();
        this.getLogger().info("Starting minecraft server version 1.6.4");
        if (Runtime.getRuntime().maxMemory() / 1024L / 1024L < 512L) {
            this.getLogger().warning("To start the server with more ram, launch it as \"java -Xmx1024M -Xms1024M -jar minecraft_server.jar\"");
        }
        this.getLogger().info("Loading properties");
        this.propertyManager = new PropertyManager(new File("server.properties"), this.getLogger());
        if (this.K()) {
            this.c("127.0.0.1");
        } else {
            this.setOnlineMode(this.propertyManager.getBoolean("online-mode", true));
            this.c(this.propertyManager.getString("server-ip", ""));
        }
        this.setSpawnAnimals(this.propertyManager.getBoolean("spawn-animals", true));
        this.setSpawnNPCs(this.propertyManager.getBoolean("spawn-npcs", true));
        this.setPvP(this.propertyManager.getBoolean("pvp", true));
        this.setAllowFlight(this.propertyManager.getBoolean("allow-flight", false));
        this.setTexturePack(this.propertyManager.getString("texture-pack", ""));
        this.setMotd(this.propertyManager.getString("motd", "A Minecraft Server"));
        this.setForceGamemode(this.propertyManager.getBoolean("force-gamemode", false));
        this.e(this.propertyManager.getInt("player-idle-timeout", 0));
        if (this.propertyManager.getInt("difficulty", 1) < 0) {
            this.propertyManager.a("difficulty", 0);
        } else if (this.propertyManager.getInt("difficulty", 1) > 3) {
            this.propertyManager.a("difficulty", 3);
        }
        this.generateStructures = this.propertyManager.getBoolean("generate-structures", true);
        int n = this.propertyManager.getInt("gamemode", EnumGamemode.SURVIVAL.a());
        this.r = WorldSettings.a(n);
        this.getLogger().info("Default game type: " + (Object)((Object)this.r));
        InetAddress inetAddress = null;
        if (this.getServerIp().length() > 0) {
            inetAddress = InetAddress.getByName(this.getServerIp());
        }
        if (this.I() < 0) {
            this.setPort(this.propertyManager.getInt("server-port", 25565));
        }
        this.getLogger().info("Generating keypair");
        this.a(MinecraftEncryption.b());
        this.getLogger().info("Starting Minecraft server on " + (this.getServerIp().length() == 0 ? "*" : this.getServerIp()) + ":" + this.I());
        try {
            this.s = new DedicatedServerConnection(this, inetAddress, this.I());
        }
        catch (IOException iOException) {
            this.getLogger().warning("**** FAILED TO BIND TO PORT!");
            this.getLogger().warning("The exception was: {0}", iOException.toString());
            this.getLogger().warning("Perhaps a server is already running on that port?");
            return false;
        }
        if (!this.getOnlineMode()) {
            this.getLogger().warning("**** SERVER IS RUNNING IN OFFLINE/INSECURE MODE!");
            this.getLogger().warning("The server will make no attempt to authenticate usernames. Beware.");
            this.getLogger().warning("While this makes the game possible to play without internet access, it also opens up the ability for hackers to connect with any username they choose.");
            this.getLogger().warning("To change this, set \"online-mode\" to \"true\" in the server.properties file.");
        }
        this.a(new DedicatedPlayerList(this));
        long l = System.nanoTime();
        if (this.L() == null) {
            this.k(this.propertyManager.getString("level-name", "world"));
        }
        String string = this.propertyManager.getString("level-seed", "");
        String string2 = this.propertyManager.getString("level-type", "DEFAULT");
        String string3 = this.propertyManager.getString("generator-settings", "");
        long l2 = new Random().nextLong();
        if (string.length() > 0) {
            try {
                long l3 = Long.parseLong(string);
                if (l3 != 0L) {
                    l2 = l3;
                }
            }
            catch (NumberFormatException numberFormatException) {
                l2 = string.hashCode();
            }
        }
        if ((worldType = WorldType.getType(string2)) == null) {
            worldType = WorldType.NORMAL;
        }
        this.d(this.propertyManager.getInt("max-build-height", 256));
        this.d((this.getMaxBuildHeight() + 8) / 16 * 16);
        this.d(MathHelper.a(this.getMaxBuildHeight(), 64, 256));
        this.propertyManager.a("max-build-height", this.getMaxBuildHeight());
        this.getLogger().info("Preparing level \"" + this.L() + "\"");
        this.a(this.L(), this.L(), l2, worldType, string3);
        long l4 = System.nanoTime() - l;
        String string4 = String.format("%.3fs", (double)l4 / 1.0E9);
        this.getLogger().info("Done (" + string4 + ")! For help, type \"help\" or \"?\"");
        if (this.propertyManager.getBoolean("enable-query", false)) {
            this.getLogger().info("Starting GS4 status listener");
            this.n = new RemoteStatusListener(this);
            this.n.a();
        }
        if (this.propertyManager.getBoolean("enable-rcon", false)) {
            this.getLogger().info("Starting remote control listener");
            this.o = new RemoteControlListener(this);
            this.o.a();
        }
        return true;
    }

    @Override
    public boolean getGenerateStructures() {
        return this.generateStructures;
    }

    @Override
    public EnumGamemode getGamemode() {
        return this.r;
    }

    @Override
    public int getDifficulty() {
        return this.propertyManager.getInt("difficulty", 1);
    }

    @Override
    public boolean isHardcore() {
        return this.propertyManager.getBoolean("hardcore", false);
    }

    @Override
    protected void a(CrashReport crashReport) {
        while (this.isRunning()) {
            this.as();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    @Override
    public CrashReport b(CrashReport crashReport) {
        crashReport = super.b(crashReport);
        crashReport.g().a("Is Modded", new CrashReportModded(this));
        crashReport.g().a("Type", new CrashReportType(this));
        return crashReport;
    }

    @Override
    protected void r() {
        System.exit(0);
    }

    @Override
    protected void t() {
        super.t();
        this.as();
    }

    @Override
    public boolean getAllowNether() {
        return this.propertyManager.getBoolean("allow-nether", true);
    }

    @Override
    public boolean getSpawnMonsters() {
        return this.propertyManager.getBoolean("spawn-monsters", true);
    }

    @Override
    public void a(MojangStatisticsGenerator mojangStatisticsGenerator) {
        mojangStatisticsGenerator.a("whitelist_enabled", this.at().getHasWhitelist());
        mojangStatisticsGenerator.a("whitelist_count", this.at().getWhitelisted().size());
        super.a(mojangStatisticsGenerator);
    }

    @Override
    public boolean getSnooperEnabled() {
        return this.propertyManager.getBoolean("snooper-enabled", true);
    }

    public void issueCommand(String string, ICommandListener iCommandListener) {
        this.l.add(new ServerCommand(string, iCommandListener));
    }

    public void as() {
        while (!this.l.isEmpty()) {
            ServerCommand serverCommand = (ServerCommand)this.l.remove(0);
            this.getCommandHandler().a(serverCommand.source, serverCommand.command);
        }
    }

    @Override
    public boolean V() {
        return true;
    }

    public DedicatedPlayerList at() {
        return (DedicatedPlayerList)super.getPlayerList();
    }

    @Override
    public ServerConnection ag() {
        return this.s;
    }

    @Override
    public int a(String string, int n) {
        return this.propertyManager.getInt(string, n);
    }

    @Override
    public String a(String string, String string2) {
        return this.propertyManager.getString(string, string2);
    }

    public boolean a(String string, boolean bl) {
        return this.propertyManager.getBoolean(string, bl);
    }

    @Override
    public void a(String string, Object object) {
        this.propertyManager.a(string, object);
    }

    @Override
    public void a() {
        this.propertyManager.savePropertiesFile();
    }

    @Override
    public String b_() {
        File file = this.propertyManager.c();
        if (file != null) {
            return file.getAbsolutePath();
        }
        return "No settings file";
    }

    public void au() {
        ServerGUI.a(this);
        this.t = true;
    }

    @Override
    public boolean ai() {
        return this.t;
    }

    @Override
    public String a(EnumGamemode enumGamemode, boolean bl) {
        return "";
    }

    @Override
    public boolean getEnableCommandBlock() {
        return this.propertyManager.getBoolean("enable-command-block", false);
    }

    @Override
    public int getSpawnProtection() {
        return this.propertyManager.getInt("spawn-protection", super.getSpawnProtection());
    }

    @Override
    public boolean a(World world, int n, int n2, int n3, EntityHuman entityHuman) {
        int n4;
        if (world.worldProvider.dimension != 0) {
            return false;
        }
        if (this.at().getOPs().isEmpty()) {
            return false;
        }
        if (this.at().isOp(entityHuman.getName())) {
            return false;
        }
        if (this.getSpawnProtection() <= 0) {
            return false;
        }
        ChunkCoordinates chunkCoordinates = world.getSpawn();
        int n5 = MathHelper.a(n - chunkCoordinates.x);
        int n6 = Math.max(n5, n4 = MathHelper.a(n3 - chunkCoordinates.z));
        return n6 <= this.getSpawnProtection();
    }

    @Override
    public IConsoleLogManager getLogger() {
        return this.m;
    }

    @Override
    public int k() {
        return this.propertyManager.getInt("op-permission-level", 4);
    }

    @Override
    public void e(int n) {
        super.e(n);
        this.propertyManager.a("player-idle-timeout", n);
        this.a();
    }

    @Override
    public /* synthetic */ PlayerList getPlayerList() {
        return this.at();
    }
}

