/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.CrashReport;
import net.minecraft.server.CrashReportSystemDetails;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Packet;
import net.minecraft.server.ReportedException;
import net.minecraft.server.WatchableObject;

public class DataWatcher {
    private boolean a = true;
    private static final HashMap b = new HashMap();
    private final Map c = new HashMap();
    private boolean d;
    private ReadWriteLock e = new ReentrantReadWriteLock();

    public void a(int n, Object object) {
        Integer n2 = (Integer)b.get(object.getClass());
        if (n2 == null) {
            throw new IllegalArgumentException("Unknown data type: " + object.getClass());
        }
        if (n > 31) {
            throw new IllegalArgumentException("Data value id is too big with " + n + "! (Max is " + 31 + ")");
        }
        if (this.c.containsKey(n)) {
            throw new IllegalArgumentException("Duplicate id value for " + n + "!");
        }
        WatchableObject watchableObject = new WatchableObject(n2, n, object);
        this.e.writeLock().lock();
        this.c.put(n, watchableObject);
        this.e.writeLock().unlock();
        this.a = false;
    }

    public void a(int n, int n2) {
        WatchableObject watchableObject = new WatchableObject(n2, n, null);
        this.e.writeLock().lock();
        this.c.put(n, watchableObject);
        this.e.writeLock().unlock();
        this.a = false;
    }

    public byte getByte(int n) {
        return (Byte)this.i(n).b();
    }

    public short getShort(int n) {
        return (Short)this.i(n).b();
    }

    public int getInt(int n) {
        return (Integer)this.i(n).b();
    }

    public float getFloat(int n) {
        return ((Float)this.i(n).b()).floatValue();
    }

    public String getString(int n) {
        return (String)this.i(n).b();
    }

    public ItemStack getItemStack(int n) {
        return (ItemStack)this.i(n).b();
    }

    private WatchableObject i(int n) {
        WatchableObject watchableObject;
        this.e.readLock().lock();
        try {
            watchableObject = (WatchableObject)this.c.get(n);
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.a(throwable, "Getting synched entity data");
            CrashReportSystemDetails crashReportSystemDetails = crashReport.a("Synched entity data");
            crashReportSystemDetails.a("Data ID", n);
            throw new ReportedException(crashReport);
        }
        this.e.readLock().unlock();
        return watchableObject;
    }

    public void watch(int n, Object object) {
        WatchableObject watchableObject = this.i(n);
        if (!object.equals(watchableObject.b())) {
            watchableObject.a(object);
            watchableObject.a(true);
            this.d = true;
        }
    }

    public void h(int n) {
        WatchableObject.a(this.i(n), true);
        this.d = true;
    }

    public boolean a() {
        return this.d;
    }

    public static void a(List list, DataOutput dataOutput) {
        if (list != null) {
            for (WatchableObject watchableObject : list) {
                DataWatcher.a(dataOutput, watchableObject);
            }
        }
        dataOutput.writeByte(127);
    }

    public List b() {
        ArrayList<WatchableObject> arrayList = null;
        if (this.d) {
            this.e.readLock().lock();
            for (WatchableObject watchableObject : this.c.values()) {
                if (!watchableObject.d()) continue;
                watchableObject.a(false);
                if (arrayList == null) {
                    arrayList = new ArrayList<WatchableObject>();
                }
                arrayList.add(watchableObject);
            }
            this.e.readLock().unlock();
        }
        this.d = false;
        return arrayList;
    }

    public void a(DataOutput dataOutput) {
        this.e.readLock().lock();
        for (WatchableObject watchableObject : this.c.values()) {
            DataWatcher.a(dataOutput, watchableObject);
        }
        this.e.readLock().unlock();
        dataOutput.writeByte(127);
    }

    public List c() {
        ArrayList<WatchableObject> arrayList = null;
        this.e.readLock().lock();
        for (WatchableObject watchableObject : this.c.values()) {
            if (arrayList == null) {
                arrayList = new ArrayList<WatchableObject>();
            }
            arrayList.add(watchableObject);
        }
        this.e.readLock().unlock();
        return arrayList;
    }

    private static void a(DataOutput dataOutput, WatchableObject watchableObject) {
        int n = (watchableObject.c() << 5 | watchableObject.a() & 0x1F) & 0xFF;
        dataOutput.writeByte(n);
        switch (watchableObject.c()) {
            case 0: {
                dataOutput.writeByte(((Byte)watchableObject.b()).byteValue());
                break;
            }
            case 1: {
                dataOutput.writeShort(((Short)watchableObject.b()).shortValue());
                break;
            }
            case 2: {
                dataOutput.writeInt((Integer)watchableObject.b());
                break;
            }
            case 3: {
                dataOutput.writeFloat(((Float)watchableObject.b()).floatValue());
                break;
            }
            case 4: {
                Packet.a((String)watchableObject.b(), dataOutput);
                break;
            }
            case 5: {
                ItemStack itemStack = (ItemStack)watchableObject.b();
                Packet.a(itemStack, dataOutput);
                break;
            }
            case 6: {
                ChunkCoordinates chunkCoordinates = (ChunkCoordinates)watchableObject.b();
                dataOutput.writeInt(chunkCoordinates.x);
                dataOutput.writeInt(chunkCoordinates.y);
                dataOutput.writeInt(chunkCoordinates.z);
            }
        }
    }

    public static List a(DataInput dataInput) {
        ArrayList<WatchableObject> arrayList = null;
        byte by = dataInput.readByte();
        while (by != 127) {
            if (arrayList == null) {
                arrayList = new ArrayList<WatchableObject>();
            }
            int n = (by & 0xE0) >> 5;
            int n2 = by & 0x1F;
            WatchableObject watchableObject = null;
            switch (n) {
                case 0: {
                    watchableObject = new WatchableObject(n, n2, dataInput.readByte());
                    break;
                }
                case 1: {
                    watchableObject = new WatchableObject(n, n2, dataInput.readShort());
                    break;
                }
                case 2: {
                    watchableObject = new WatchableObject(n, n2, dataInput.readInt());
                    break;
                }
                case 3: {
                    watchableObject = new WatchableObject(n, n2, Float.valueOf(dataInput.readFloat()));
                    break;
                }
                case 4: {
                    watchableObject = new WatchableObject(n, n2, Packet.a(dataInput, 64));
                    break;
                }
                case 5: {
                    watchableObject = new WatchableObject(n, n2, Packet.c(dataInput));
                    break;
                }
                case 6: {
                    int n3 = dataInput.readInt();
                    int n4 = dataInput.readInt();
                    int n5 = dataInput.readInt();
                    watchableObject = new WatchableObject(n, n2, new ChunkCoordinates(n3, n4, n5));
                }
            }
            arrayList.add(watchableObject);
            by = dataInput.readByte();
        }
        return arrayList;
    }

    public boolean d() {
        return this.a;
    }

    public void e() {
        this.d = false;
    }

    static {
        b.put(Byte.class, 0);
        b.put(Short.class, 1);
        b.put(Integer.class, 2);
        b.put(Float.class, 3);
        b.put(String.class, 4);
        b.put(ItemStack.class, 5);
        b.put(ChunkCoordinates.class, 6);
    }
}

