/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.ChatMessage;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityArrow;
import net.minecraft.server.EntityDamageSource;
import net.minecraft.server.EntityDamageSourceIndirect;
import net.minecraft.server.EntityFireball;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.Explosion;
import net.minecraft.server.LocaleI18n;

public class DamageSource {
    public static DamageSource FIRE = new DamageSource("inFire").l();
    public static DamageSource BURN = new DamageSource("onFire").j().l();
    public static DamageSource LAVA = new DamageSource("lava").l();
    public static DamageSource STUCK = new DamageSource("inWall").j();
    public static DamageSource DROWN = new DamageSource("drown").j();
    public static DamageSource STARVE = new DamageSource("starve").j();
    public static DamageSource CACTUS = new DamageSource("cactus");
    public static DamageSource FALL = new DamageSource("fall").j();
    public static DamageSource OUT_OF_WORLD = new DamageSource("outOfWorld").j().k();
    public static DamageSource GENERIC = new DamageSource("generic").j();
    public static DamageSource MAGIC = new DamageSource("magic").j().r();
    public static DamageSource WITHER = new DamageSource("wither").j();
    public static DamageSource ANVIL = new DamageSource("anvil");
    public static DamageSource FALLING_BLOCK = new DamageSource("fallingBlock");
    private boolean p;
    private boolean q;
    private float r = 0.3f;
    private boolean s;
    private boolean t;
    private boolean u;
    private boolean v;
    private boolean w;
    public String translationIndex;

    public static DamageSource mobAttack(EntityLiving entityLiving) {
        return new EntityDamageSource("mob", entityLiving);
    }

    public static DamageSource playerAttack(EntityHuman entityHuman) {
        return new EntityDamageSource("player", entityHuman);
    }

    public static DamageSource arrow(EntityArrow entityArrow, Entity entity) {
        return new EntityDamageSourceIndirect("arrow", entityArrow, entity).b();
    }

    public static DamageSource fireball(EntityFireball entityFireball, Entity entity) {
        if (entity == null) {
            return new EntityDamageSourceIndirect("onFire", entityFireball, entityFireball).l().b();
        }
        return new EntityDamageSourceIndirect("fireball", entityFireball, entity).l().b();
    }

    public static DamageSource projectile(Entity entity, Entity entity2) {
        return new EntityDamageSourceIndirect("thrown", entity, entity2).b();
    }

    public static DamageSource b(Entity entity, Entity entity2) {
        return new EntityDamageSourceIndirect("indirectMagic", entity, entity2).j().r();
    }

    public static DamageSource a(Entity entity) {
        return new EntityDamageSource("thorns", entity).r();
    }

    public static DamageSource explosion(Explosion explosion) {
        if (explosion != null && explosion.c() != null) {
            return new EntityDamageSource("explosion.player", explosion.c()).o().d();
        }
        return new DamageSource("explosion").o().d();
    }

    public boolean a() {
        return this.t;
    }

    public DamageSource b() {
        this.t = true;
        return this;
    }

    public boolean c() {
        return this.w;
    }

    public DamageSource d() {
        this.w = true;
        return this;
    }

    public boolean ignoresArmor() {
        return this.p;
    }

    public float f() {
        return this.r;
    }

    public boolean ignoresInvulnerability() {
        return this.q;
    }

    protected DamageSource(String string) {
        this.translationIndex = string;
    }

    public Entity h() {
        return this.getEntity();
    }

    public Entity getEntity() {
        return null;
    }

    protected DamageSource j() {
        this.p = true;
        this.r = 0.0f;
        return this;
    }

    protected DamageSource k() {
        this.q = true;
        return this;
    }

    protected DamageSource l() {
        this.s = true;
        return this;
    }

    public ChatMessage getLocalizedDeathMessage(EntityLiving entityLiving) {
        EntityLiving entityLiving2 = entityLiving.aS();
        String string = "death.attack." + this.translationIndex;
        String string2 = string + ".player";
        if (entityLiving2 != null && LocaleI18n.b(string2)) {
            return ChatMessage.b(string2, entityLiving.getScoreboardDisplayName(), entityLiving2.getScoreboardDisplayName());
        }
        return ChatMessage.b(string, entityLiving.getScoreboardDisplayName());
    }

    public boolean m() {
        return this.s;
    }

    public String n() {
        return this.translationIndex;
    }

    public DamageSource o() {
        this.u = true;
        return this;
    }

    public boolean p() {
        return this.u;
    }

    public boolean q() {
        return this.v;
    }

    public DamageSource r() {
        this.v = true;
        return this;
    }
}

