/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.server.Block;
import net.minecraft.server.IRecipe;
import net.minecraft.server.InventoryCrafting;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.RecipeArmorDye;
import net.minecraft.server.RecipeFireworks;
import net.minecraft.server.RecipeIngots;
import net.minecraft.server.RecipeMapClone;
import net.minecraft.server.RecipeMapExtend;
import net.minecraft.server.RecipeSorter;
import net.minecraft.server.RecipesArmor;
import net.minecraft.server.RecipesCrafting;
import net.minecraft.server.RecipesDyes;
import net.minecraft.server.RecipesFood;
import net.minecraft.server.RecipesTools;
import net.minecraft.server.RecipesWeapons;
import net.minecraft.server.ShapedRecipes;
import net.minecraft.server.ShapelessRecipes;
import net.minecraft.server.World;

public class CraftingManager {
    private static final CraftingManager a = new CraftingManager();
    private List recipes = new ArrayList();

    public static final CraftingManager getInstance() {
        return a;
    }

    private CraftingManager() {
        new RecipesTools().a(this);
        new RecipesWeapons().a(this);
        new RecipeIngots().a(this);
        new RecipesFood().a(this);
        new RecipesCrafting().a(this);
        new RecipesArmor().a(this);
        new RecipesDyes().a(this);
        this.recipes.add(new RecipeArmorDye());
        this.recipes.add(new RecipeMapClone());
        this.recipes.add(new RecipeMapExtend());
        this.recipes.add(new RecipeFireworks());
        this.registerShapedRecipe(new ItemStack(Item.PAPER, 3), "###", Character.valueOf('#'), Item.SUGAR_CANE);
        this.registerShapelessRecipe(new ItemStack(Item.BOOK, 1), Item.PAPER, Item.PAPER, Item.PAPER, Item.LEATHER);
        this.registerShapelessRecipe(new ItemStack(Item.BOOK_AND_QUILL, 1), Item.BOOK, new ItemStack(Item.INK_SACK, 1, 0), Item.FEATHER);
        this.registerShapedRecipe(new ItemStack(Block.FENCE, 2), "###", "###", Character.valueOf('#'), Item.STICK);
        this.registerShapedRecipe(new ItemStack(Block.COBBLE_WALL, 6, 0), "###", "###", Character.valueOf('#'), Block.COBBLESTONE);
        this.registerShapedRecipe(new ItemStack(Block.COBBLE_WALL, 6, 1), "###", "###", Character.valueOf('#'), Block.MOSSY_COBBLESTONE);
        this.registerShapedRecipe(new ItemStack(Block.NETHER_FENCE, 6), "###", "###", Character.valueOf('#'), Block.NETHER_BRICK);
        this.registerShapedRecipe(new ItemStack(Block.FENCE_GATE, 1), "#W#", "#W#", Character.valueOf('#'), Item.STICK, Character.valueOf('W'), Block.WOOD);
        this.registerShapedRecipe(new ItemStack(Block.JUKEBOX, 1), "###", "#X#", "###", Character.valueOf('#'), Block.WOOD, Character.valueOf('X'), Item.DIAMOND);
        this.registerShapedRecipe(new ItemStack(Item.LEASH, 2), "~~ ", "~O ", "  ~", Character.valueOf('~'), Item.STRING, Character.valueOf('O'), Item.SLIME_BALL);
        this.registerShapedRecipe(new ItemStack(Block.NOTE_BLOCK, 1), "###", "#X#", "###", Character.valueOf('#'), Block.WOOD, Character.valueOf('X'), Item.REDSTONE);
        this.registerShapedRecipe(new ItemStack(Block.BOOKSHELF, 1), "###", "XXX", "###", Character.valueOf('#'), Block.WOOD, Character.valueOf('X'), Item.BOOK);
        this.registerShapedRecipe(new ItemStack(Block.SNOW_BLOCK, 1), "##", "##", Character.valueOf('#'), Item.SNOW_BALL);
        this.registerShapedRecipe(new ItemStack(Block.SNOW, 6), "###", Character.valueOf('#'), Block.SNOW_BLOCK);
        this.registerShapedRecipe(new ItemStack(Block.CLAY, 1), "##", "##", Character.valueOf('#'), Item.CLAY_BALL);
        this.registerShapedRecipe(new ItemStack(Block.BRICK, 1), "##", "##", Character.valueOf('#'), Item.CLAY_BRICK);
        this.registerShapedRecipe(new ItemStack(Block.GLOWSTONE, 1), "##", "##", Character.valueOf('#'), Item.GLOWSTONE_DUST);
        this.registerShapedRecipe(new ItemStack(Block.QUARTZ_BLOCK, 1), "##", "##", Character.valueOf('#'), Item.QUARTZ);
        this.registerShapedRecipe(new ItemStack(Block.WOOL, 1), "##", "##", Character.valueOf('#'), Item.STRING);
        this.registerShapedRecipe(new ItemStack(Block.TNT, 1), "X#X", "#X#", "X#X", Character.valueOf('X'), Item.SULPHUR, Character.valueOf('#'), Block.SAND);
        this.registerShapedRecipe(new ItemStack(Block.STEP, 6, 3), "###", Character.valueOf('#'), Block.COBBLESTONE);
        this.registerShapedRecipe(new ItemStack(Block.STEP, 6, 0), "###", Character.valueOf('#'), Block.STONE);
        this.registerShapedRecipe(new ItemStack(Block.STEP, 6, 1), "###", Character.valueOf('#'), Block.SANDSTONE);
        this.registerShapedRecipe(new ItemStack(Block.STEP, 6, 4), "###", Character.valueOf('#'), Block.BRICK);
        this.registerShapedRecipe(new ItemStack(Block.STEP, 6, 5), "###", Character.valueOf('#'), Block.SMOOTH_BRICK);
        this.registerShapedRecipe(new ItemStack(Block.STEP, 6, 6), "###", Character.valueOf('#'), Block.NETHER_BRICK);
        this.registerShapedRecipe(new ItemStack(Block.STEP, 6, 7), "###", Character.valueOf('#'), Block.QUARTZ_BLOCK);
        this.registerShapedRecipe(new ItemStack(Block.WOOD_STEP, 6, 0), "###", Character.valueOf('#'), new ItemStack(Block.WOOD, 1, 0));
        this.registerShapedRecipe(new ItemStack(Block.WOOD_STEP, 6, 2), "###", Character.valueOf('#'), new ItemStack(Block.WOOD, 1, 2));
        this.registerShapedRecipe(new ItemStack(Block.WOOD_STEP, 6, 1), "###", Character.valueOf('#'), new ItemStack(Block.WOOD, 1, 1));
        this.registerShapedRecipe(new ItemStack(Block.WOOD_STEP, 6, 3), "###", Character.valueOf('#'), new ItemStack(Block.WOOD, 1, 3));
        this.registerShapedRecipe(new ItemStack(Block.LADDER, 3), "# #", "###", "# #", Character.valueOf('#'), Item.STICK);
        this.registerShapedRecipe(new ItemStack(Item.WOOD_DOOR, 1), "##", "##", "##", Character.valueOf('#'), Block.WOOD);
        this.registerShapedRecipe(new ItemStack(Block.TRAP_DOOR, 2), "###", "###", Character.valueOf('#'), Block.WOOD);
        this.registerShapedRecipe(new ItemStack(Item.IRON_DOOR, 1), "##", "##", "##", Character.valueOf('#'), Item.IRON_INGOT);
        this.registerShapedRecipe(new ItemStack(Item.SIGN, 3), "###", "###", " X ", Character.valueOf('#'), Block.WOOD, Character.valueOf('X'), Item.STICK);
        this.registerShapedRecipe(new ItemStack(Item.CAKE, 1), "AAA", "BEB", "CCC", Character.valueOf('A'), Item.MILK_BUCKET, Character.valueOf('B'), Item.SUGAR, Character.valueOf('C'), Item.WHEAT, Character.valueOf('E'), Item.EGG);
        this.registerShapedRecipe(new ItemStack(Item.SUGAR, 1), "#", Character.valueOf('#'), Item.SUGAR_CANE);
        this.registerShapedRecipe(new ItemStack(Block.WOOD, 4, 0), "#", Character.valueOf('#'), new ItemStack(Block.LOG, 1, 0));
        this.registerShapedRecipe(new ItemStack(Block.WOOD, 4, 1), "#", Character.valueOf('#'), new ItemStack(Block.LOG, 1, 1));
        this.registerShapedRecipe(new ItemStack(Block.WOOD, 4, 2), "#", Character.valueOf('#'), new ItemStack(Block.LOG, 1, 2));
        this.registerShapedRecipe(new ItemStack(Block.WOOD, 4, 3), "#", Character.valueOf('#'), new ItemStack(Block.LOG, 1, 3));
        this.registerShapedRecipe(new ItemStack(Item.STICK, 4), "#", "#", Character.valueOf('#'), Block.WOOD);
        this.registerShapedRecipe(new ItemStack(Block.TORCH, 4), "X", "#", Character.valueOf('X'), Item.COAL, Character.valueOf('#'), Item.STICK);
        this.registerShapedRecipe(new ItemStack(Block.TORCH, 4), "X", "#", Character.valueOf('X'), new ItemStack(Item.COAL, 1, 1), Character.valueOf('#'), Item.STICK);
        this.registerShapedRecipe(new ItemStack(Item.BOWL, 4), "# #", " # ", Character.valueOf('#'), Block.WOOD);
        this.registerShapedRecipe(new ItemStack(Item.GLASS_BOTTLE, 3), "# #", " # ", Character.valueOf('#'), Block.GLASS);
        this.registerShapedRecipe(new ItemStack(Block.RAILS, 16), "X X", "X#X", "X X", Character.valueOf('X'), Item.IRON_INGOT, Character.valueOf('#'), Item.STICK);
        this.registerShapedRecipe(new ItemStack(Block.GOLDEN_RAIL, 6), "X X", "X#X", "XRX", Character.valueOf('X'), Item.GOLD_INGOT, Character.valueOf('R'), Item.REDSTONE, Character.valueOf('#'), Item.STICK);
        this.registerShapedRecipe(new ItemStack(Block.ACTIVATOR_RAIL, 6), "XSX", "X#X", "XSX", Character.valueOf('X'), Item.IRON_INGOT, Character.valueOf('#'), Block.REDSTONE_TORCH_ON, Character.valueOf('S'), Item.STICK);
        this.registerShapedRecipe(new ItemStack(Block.DETECTOR_RAIL, 6), "X X", "X#X", "XRX", Character.valueOf('X'), Item.IRON_INGOT, Character.valueOf('R'), Item.REDSTONE, Character.valueOf('#'), Block.STONE_PLATE);
        this.registerShapedRecipe(new ItemStack(Item.MINECART, 1), "# #", "###", Character.valueOf('#'), Item.IRON_INGOT);
        this.registerShapedRecipe(new ItemStack(Item.CAULDRON, 1), "# #", "# #", "###", Character.valueOf('#'), Item.IRON_INGOT);
        this.registerShapedRecipe(new ItemStack(Item.BREWING_STAND, 1), " B ", "###", Character.valueOf('#'), Block.COBBLESTONE, Character.valueOf('B'), Item.BLAZE_ROD);
        this.registerShapedRecipe(new ItemStack(Block.JACK_O_LANTERN, 1), "A", "B", Character.valueOf('A'), Block.PUMPKIN, Character.valueOf('B'), Block.TORCH);
        this.registerShapedRecipe(new ItemStack(Item.STORAGE_MINECART, 1), "A", "B", Character.valueOf('A'), Block.CHEST, Character.valueOf('B'), Item.MINECART);
        this.registerShapedRecipe(new ItemStack(Item.POWERED_MINECART, 1), "A", "B", Character.valueOf('A'), Block.FURNACE, Character.valueOf('B'), Item.MINECART);
        this.registerShapedRecipe(new ItemStack(Item.MINECART_TNT, 1), "A", "B", Character.valueOf('A'), Block.TNT, Character.valueOf('B'), Item.MINECART);
        this.registerShapedRecipe(new ItemStack(Item.MINECART_HOPPER, 1), "A", "B", Character.valueOf('A'), Block.HOPPER, Character.valueOf('B'), Item.MINECART);
        this.registerShapedRecipe(new ItemStack(Item.BOAT, 1), "# #", "###", Character.valueOf('#'), Block.WOOD);
        this.registerShapedRecipe(new ItemStack(Item.BUCKET, 1), "# #", " # ", Character.valueOf('#'), Item.IRON_INGOT);
        this.registerShapedRecipe(new ItemStack(Item.FLOWER_POT, 1), "# #", " # ", Character.valueOf('#'), Item.CLAY_BRICK);
        this.registerShapedRecipe(new ItemStack(Item.FLINT_AND_STEEL, 1), "A ", " B", Character.valueOf('A'), Item.IRON_INGOT, Character.valueOf('B'), Item.FLINT);
        this.registerShapedRecipe(new ItemStack(Item.BREAD, 1), "###", Character.valueOf('#'), Item.WHEAT);
        this.registerShapedRecipe(new ItemStack(Block.WOOD_STAIRS, 4), "#  ", "## ", "###", Character.valueOf('#'), new ItemStack(Block.WOOD, 1, 0));
        this.registerShapedRecipe(new ItemStack(Block.BIRCH_WOOD_STAIRS, 4), "#  ", "## ", "###", Character.valueOf('#'), new ItemStack(Block.WOOD, 1, 2));
        this.registerShapedRecipe(new ItemStack(Block.SPRUCE_WOOD_STAIRS, 4), "#  ", "## ", "###", Character.valueOf('#'), new ItemStack(Block.WOOD, 1, 1));
        this.registerShapedRecipe(new ItemStack(Block.JUNGLE_WOOD_STAIRS, 4), "#  ", "## ", "###", Character.valueOf('#'), new ItemStack(Block.WOOD, 1, 3));
        this.registerShapedRecipe(new ItemStack(Item.FISHING_ROD, 1), "  #", " #X", "# X", Character.valueOf('#'), Item.STICK, Character.valueOf('X'), Item.STRING);
        this.registerShapedRecipe(new ItemStack(Item.CARROT_STICK, 1), "# ", " X", Character.valueOf('#'), Item.FISHING_ROD, Character.valueOf('X'), Item.CARROT).c();
        this.registerShapedRecipe(new ItemStack(Block.COBBLESTONE_STAIRS, 4), "#  ", "## ", "###", Character.valueOf('#'), Block.COBBLESTONE);
        this.registerShapedRecipe(new ItemStack(Block.BRICK_STAIRS, 4), "#  ", "## ", "###", Character.valueOf('#'), Block.BRICK);
        this.registerShapedRecipe(new ItemStack(Block.STONE_STAIRS, 4), "#  ", "## ", "###", Character.valueOf('#'), Block.SMOOTH_BRICK);
        this.registerShapedRecipe(new ItemStack(Block.NETHER_BRICK_STAIRS, 4), "#  ", "## ", "###", Character.valueOf('#'), Block.NETHER_BRICK);
        this.registerShapedRecipe(new ItemStack(Block.SANDSTONE_STAIRS, 4), "#  ", "## ", "###", Character.valueOf('#'), Block.SANDSTONE);
        this.registerShapedRecipe(new ItemStack(Block.QUARTZ_STAIRS, 4), "#  ", "## ", "###", Character.valueOf('#'), Block.QUARTZ_BLOCK);
        this.registerShapedRecipe(new ItemStack(Item.PAINTING, 1), "###", "#X#", "###", Character.valueOf('#'), Item.STICK, Character.valueOf('X'), Block.WOOL);
        this.registerShapedRecipe(new ItemStack(Item.ITEM_FRAME, 1), "###", "#X#", "###", Character.valueOf('#'), Item.STICK, Character.valueOf('X'), Item.LEATHER);
        this.registerShapedRecipe(new ItemStack(Item.GOLDEN_APPLE, 1, 0), "###", "#X#", "###", Character.valueOf('#'), Item.GOLD_INGOT, Character.valueOf('X'), Item.APPLE);
        this.registerShapedRecipe(new ItemStack(Item.GOLDEN_APPLE, 1, 1), "###", "#X#", "###", Character.valueOf('#'), Block.GOLD_BLOCK, Character.valueOf('X'), Item.APPLE);
        this.registerShapedRecipe(new ItemStack(Item.CARROT_GOLDEN, 1, 0), "###", "#X#", "###", Character.valueOf('#'), Item.GOLD_NUGGET, Character.valueOf('X'), Item.CARROT);
        this.registerShapedRecipe(new ItemStack(Item.SPECKLED_MELON, 1), "###", "#X#", "###", Character.valueOf('#'), Item.GOLD_NUGGET, Character.valueOf('X'), Item.MELON);
        this.registerShapedRecipe(new ItemStack(Block.LEVER, 1), "X", "#", Character.valueOf('#'), Block.COBBLESTONE, Character.valueOf('X'), Item.STICK);
        this.registerShapedRecipe(new ItemStack(Block.TRIPWIRE_SOURCE, 2), "I", "S", "#", Character.valueOf('#'), Block.WOOD, Character.valueOf('S'), Item.STICK, Character.valueOf('I'), Item.IRON_INGOT);
        this.registerShapedRecipe(new ItemStack(Block.REDSTONE_TORCH_ON, 1), "X", "#", Character.valueOf('#'), Item.STICK, Character.valueOf('X'), Item.REDSTONE);
        this.registerShapedRecipe(new ItemStack(Item.DIODE, 1), "#X#", "III", Character.valueOf('#'), Block.REDSTONE_TORCH_ON, Character.valueOf('X'), Item.REDSTONE, Character.valueOf('I'), Block.STONE);
        this.registerShapedRecipe(new ItemStack(Item.REDSTONE_COMPARATOR, 1), " # ", "#X#", "III", Character.valueOf('#'), Block.REDSTONE_TORCH_ON, Character.valueOf('X'), Item.QUARTZ, Character.valueOf('I'), Block.STONE);
        this.registerShapedRecipe(new ItemStack(Item.WATCH, 1), " # ", "#X#", " # ", Character.valueOf('#'), Item.GOLD_INGOT, Character.valueOf('X'), Item.REDSTONE);
        this.registerShapedRecipe(new ItemStack(Item.COMPASS, 1), " # ", "#X#", " # ", Character.valueOf('#'), Item.IRON_INGOT, Character.valueOf('X'), Item.REDSTONE);
        this.registerShapedRecipe(new ItemStack(Item.MAP_EMPTY, 1), "###", "#X#", "###", Character.valueOf('#'), Item.PAPER, Character.valueOf('X'), Item.COMPASS);
        this.registerShapedRecipe(new ItemStack(Block.STONE_BUTTON, 1), "#", Character.valueOf('#'), Block.STONE);
        this.registerShapedRecipe(new ItemStack(Block.WOOD_BUTTON, 1), "#", Character.valueOf('#'), Block.WOOD);
        this.registerShapedRecipe(new ItemStack(Block.STONE_PLATE, 1), "##", Character.valueOf('#'), Block.STONE);
        this.registerShapedRecipe(new ItemStack(Block.WOOD_PLATE, 1), "##", Character.valueOf('#'), Block.WOOD);
        this.registerShapedRecipe(new ItemStack(Block.IRON_PLATE, 1), "##", Character.valueOf('#'), Item.IRON_INGOT);
        this.registerShapedRecipe(new ItemStack(Block.GOLD_PLATE, 1), "##", Character.valueOf('#'), Item.GOLD_INGOT);
        this.registerShapedRecipe(new ItemStack(Block.DISPENSER, 1), "###", "#X#", "#R#", Character.valueOf('#'), Block.COBBLESTONE, Character.valueOf('X'), Item.BOW, Character.valueOf('R'), Item.REDSTONE);
        this.registerShapedRecipe(new ItemStack(Block.DROPPER, 1), "###", "# #", "#R#", Character.valueOf('#'), Block.COBBLESTONE, Character.valueOf('R'), Item.REDSTONE);
        this.registerShapedRecipe(new ItemStack(Block.PISTON, 1), "TTT", "#X#", "#R#", Character.valueOf('#'), Block.COBBLESTONE, Character.valueOf('X'), Item.IRON_INGOT, Character.valueOf('R'), Item.REDSTONE, Character.valueOf('T'), Block.WOOD);
        this.registerShapedRecipe(new ItemStack(Block.PISTON_STICKY, 1), "S", "P", Character.valueOf('S'), Item.SLIME_BALL, Character.valueOf('P'), Block.PISTON);
        this.registerShapedRecipe(new ItemStack(Item.BED, 1), "###", "XXX", Character.valueOf('#'), Block.WOOL, Character.valueOf('X'), Block.WOOD);
        this.registerShapedRecipe(new ItemStack(Block.ENCHANTMENT_TABLE, 1), " B ", "D#D", "###", Character.valueOf('#'), Block.OBSIDIAN, Character.valueOf('B'), Item.BOOK, Character.valueOf('D'), Item.DIAMOND);
        this.registerShapedRecipe(new ItemStack(Block.ANVIL, 1), "III", " i ", "iii", Character.valueOf('I'), Block.IRON_BLOCK, Character.valueOf('i'), Item.IRON_INGOT);
        this.registerShapelessRecipe(new ItemStack(Item.EYE_OF_ENDER, 1), Item.ENDER_PEARL, Item.BLAZE_POWDER);
        this.registerShapelessRecipe(new ItemStack(Item.FIREBALL, 3), Item.SULPHUR, Item.BLAZE_POWDER, Item.COAL);
        this.registerShapelessRecipe(new ItemStack(Item.FIREBALL, 3), Item.SULPHUR, Item.BLAZE_POWDER, new ItemStack(Item.COAL, 1, 1));
        this.registerShapedRecipe(new ItemStack(Block.DAYLIGHT_DETECTOR), "GGG", "QQQ", "WWW", Character.valueOf('G'), Block.GLASS, Character.valueOf('Q'), Item.QUARTZ, Character.valueOf('W'), Block.WOOD_STEP);
        this.registerShapedRecipe(new ItemStack(Block.HOPPER), "I I", "ICI", " I ", Character.valueOf('I'), Item.IRON_INGOT, Character.valueOf('C'), Block.CHEST);
        Collections.sort(this.recipes, new RecipeSorter(this));
    }

    ShapedRecipes registerShapedRecipe(ItemStack itemStack, Object ... objectArray) {
        Object object;
        Object object2;
        String string = "";
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (objectArray[n] instanceof String[]) {
            object2 = (String[])objectArray[n++];
            for (int i = 0; i < ((String[])object2).length; ++i) {
                object = object2[i];
                ++n3;
                n2 = ((String)object).length();
                string = string + (String)object;
            }
        } else {
            while (objectArray[n] instanceof String) {
                object2 = (String)objectArray[n++];
                ++n3;
                n2 = ((String)object2).length();
                string = string + (String)object2;
            }
        }
        object2 = new HashMap();
        while (n < objectArray.length) {
            Character c = (Character)objectArray[n];
            object = null;
            if (objectArray[n + 1] instanceof Item) {
                object = new ItemStack((Item)objectArray[n + 1]);
            } else if (objectArray[n + 1] instanceof Block) {
                object = new ItemStack((Block)objectArray[n + 1], 1, Short.MAX_VALUE);
            } else if (objectArray[n + 1] instanceof ItemStack) {
                object = (ItemStack)objectArray[n + 1];
            }
            object2.put(c, object);
            n += 2;
        }
        ItemStack[] itemStackArray = new ItemStack[n2 * n3];
        for (int i = 0; i < n2 * n3; ++i) {
            char c = string.charAt(i);
            itemStackArray[i] = object2.containsKey(Character.valueOf(c)) ? ((ItemStack)object2.get(Character.valueOf(c))).cloneItemStack() : null;
        }
        ShapedRecipes shapedRecipes = new ShapedRecipes(n2, n3, itemStackArray, itemStack);
        this.recipes.add(shapedRecipes);
        return shapedRecipes;
    }

    void registerShapelessRecipe(ItemStack itemStack, Object ... objectArray) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        for (Object object : objectArray) {
            if (object instanceof ItemStack) {
                arrayList.add(((ItemStack)object).cloneItemStack());
                continue;
            }
            if (object instanceof Item) {
                arrayList.add(new ItemStack((Item)object));
                continue;
            }
            if (object instanceof Block) {
                arrayList.add(new ItemStack((Block)object));
                continue;
            }
            throw new RuntimeException("Invalid shapeless recipy!");
        }
        this.recipes.add(new ShapelessRecipes(itemStack, arrayList));
    }

    public ItemStack craft(InventoryCrafting inventoryCrafting, World world) {
        Object object;
        int n;
        int n2 = 0;
        ItemStack itemStack = null;
        ItemStack itemStack2 = null;
        for (n = 0; n < inventoryCrafting.getSize(); ++n) {
            object = inventoryCrafting.getItem(n);
            if (object == null) continue;
            if (n2 == 0) {
                itemStack = object;
            }
            if (n2 == 1) {
                itemStack2 = object;
            }
            ++n2;
        }
        if (n2 == 2 && itemStack.id == itemStack2.id && itemStack.count == 1 && itemStack2.count == 1 && Item.byId[itemStack.id].usesDurability()) {
            Item item = Item.byId[itemStack.id];
            int n3 = item.getMaxDurability() - itemStack.j();
            int n4 = item.getMaxDurability() - itemStack2.j();
            int n5 = n3 + n4 + item.getMaxDurability() * 5 / 100;
            int n6 = item.getMaxDurability() - n5;
            if (n6 < 0) {
                n6 = 0;
            }
            return new ItemStack(itemStack.id, 1, n6);
        }
        for (n = 0; n < this.recipes.size(); ++n) {
            object = (IRecipe)this.recipes.get(n);
            if (!object.a(inventoryCrafting, world)) continue;
            return object.a(inventoryCrafting);
        }
        return null;
    }

    public List getRecipes() {
        return this.recipes;
    }
}

