/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.server.ChatMessage;
import net.minecraft.server.CommandAbstract;
import net.minecraft.server.CommandException;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.ExceptionPlayerNotFound;
import net.minecraft.server.ExceptionUsage;
import net.minecraft.server.ICommandListener;
import net.minecraft.server.Location2D;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerSelector;
import net.minecraft.server.ScoreboardTeamBase;
import net.minecraft.server.World;

public class CommandSpreadPlayers
extends CommandAbstract {
    @Override
    public String c() {
        return "spreadplayers";
    }

    @Override
    public int a() {
        return 2;
    }

    @Override
    public String c(ICommandListener iCommandListener) {
        return "commands.spreadplayers.usage";
    }

    @Override
    public void b(ICommandListener iCommandListener, String[] stringArray) {
        if (stringArray.length < 6) {
            throw new ExceptionUsage("commands.spreadplayers.usage", new Object[0]);
        }
        int n = 0;
        double d = CommandSpreadPlayers.a(iCommandListener, Double.NaN, stringArray[n++]);
        double d2 = CommandSpreadPlayers.a(iCommandListener, Double.NaN, stringArray[n++]);
        double d3 = CommandSpreadPlayers.a(iCommandListener, stringArray[n++], 0.0);
        double d4 = CommandSpreadPlayers.a(iCommandListener, stringArray[n++], d3 + 1.0);
        boolean bl = CommandSpreadPlayers.c(iCommandListener, stringArray[n++]);
        ArrayList<EntityPlayer[]> arrayList = Lists.newArrayList();
        while (n < stringArray.length) {
            Object object;
            String string;
            if (PlayerSelector.isPattern(string = stringArray[n++])) {
                object = PlayerSelector.getPlayers(iCommandListener, string);
                if (object != null && ((EntityPlayer[])object).length != 0) {
                    Collections.addAll(arrayList, object);
                    continue;
                }
                throw new ExceptionPlayerNotFound();
            }
            object = MinecraftServer.getServer().getPlayerList().getPlayer(string);
            if (object != null) {
                arrayList.add((EntityPlayer[])object);
                continue;
            }
            throw new ExceptionPlayerNotFound();
        }
        if (arrayList.isEmpty()) {
            throw new ExceptionPlayerNotFound();
        }
        iCommandListener.sendMessage(ChatMessage.b("commands.spreadplayers.spreading." + (bl ? "teams" : "players"), CommandSpreadPlayers.b(arrayList), d, d2, d3, d4));
        this.a(iCommandListener, arrayList, new Location2D(d, d2), d3, d4, ((EntityLiving)arrayList.get((int)0)).world, bl);
    }

    private void a(ICommandListener iCommandListener, List list, Location2D location2D, double d, double d2, World world, boolean bl) {
        Random random = new Random();
        double d3 = location2D.a - d2;
        double d4 = location2D.b - d2;
        double d5 = location2D.a + d2;
        double d6 = location2D.b + d2;
        Location2D[] location2DArray = this.a(random, bl ? this.a(list) : list.size(), d3, d4, d5, d6);
        int n = this.a(location2D, d, world, random, d3, d4, d5, d6, location2DArray, bl);
        double d7 = this.a(list, world, location2DArray, bl);
        CommandSpreadPlayers.a(iCommandListener, "commands.spreadplayers.success." + (bl ? "teams" : "players"), location2DArray.length, location2D.a, location2D.b);
        if (location2DArray.length > 1) {
            iCommandListener.sendMessage(ChatMessage.b("commands.spreadplayers.info." + (bl ? "teams" : "players"), String.format("%.2f", d7), n));
        }
    }

    private int a(List list) {
        HashSet<ScoreboardTeamBase> hashSet = Sets.newHashSet();
        for (EntityLiving entityLiving : list) {
            if (entityLiving instanceof EntityHuman) {
                hashSet.add(((EntityHuman)entityLiving).getScoreboardTeam());
                continue;
            }
            hashSet.add(null);
        }
        return hashSet.size();
    }

    private int a(Location2D location2D, double d, World world, Random random, double d2, double d3, double d4, double d5, Location2D[] location2DArray, boolean bl) {
        int n;
        boolean bl2 = true;
        double d6 = 3.4028234663852886E38;
        for (n = 0; n < 10000 && bl2; ++n) {
            bl2 = false;
            d6 = 3.4028234663852886E38;
            for (int i = 0; i < location2DArray.length; ++i) {
                Location2D location2D2 = location2DArray[i];
                int n2 = 0;
                Location2D location2D3 = new Location2D();
                for (int j = 0; j < location2DArray.length; ++j) {
                    if (i == j) continue;
                    Location2D location2D4 = location2DArray[j];
                    double d7 = location2D2.a(location2D4);
                    d6 = Math.min(d7, d6);
                    if (!(d7 < d)) continue;
                    ++n2;
                    location2D3.a += location2D4.a - location2D2.a;
                    location2D3.b += location2D4.b - location2D2.b;
                }
                if (n2 > 0) {
                    location2D3.a /= (double)n2;
                    location2D3.b /= (double)n2;
                    double d8 = location2D3.b();
                    if (d8 > 0.0) {
                        location2D3.a();
                        location2D2.b(location2D3);
                    } else {
                        location2D2.a(random, d2, d3, d4, d5);
                    }
                    bl2 = true;
                }
                if (!location2D2.a(d2, d3, d4, d5)) continue;
                bl2 = true;
            }
            if (bl2) continue;
            for (Location2D location2D3 : location2DArray) {
                if (location2D3.b(world)) continue;
                location2D3.a(random, d2, d3, d4, d5);
                bl2 = true;
            }
        }
        if (n >= 10000) {
            throw new CommandException("commands.spreadplayers.failure." + (bl ? "teams" : "players"), location2DArray.length, location2D.a, location2D.b, String.format("%.2f", d6));
        }
        return n;
    }

    private double a(List list, World world, Location2D[] location2DArray, boolean bl) {
        double d = 0.0;
        int n = 0;
        HashMap<ScoreboardTeamBase, Location2D> hashMap = Maps.newHashMap();
        for (int i = 0; i < list.size(); ++i) {
            Location2D location2D;
            EntityLiving entityLiving = (EntityLiving)list.get(i);
            if (bl) {
                ScoreboardTeamBase scoreboardTeamBase;
                ScoreboardTeamBase scoreboardTeamBase2 = scoreboardTeamBase = entityLiving instanceof EntityHuman ? ((EntityHuman)entityLiving).getScoreboardTeam() : null;
                if (!hashMap.containsKey(scoreboardTeamBase)) {
                    hashMap.put(scoreboardTeamBase, location2DArray[n++]);
                }
                location2D = (Location2D)hashMap.get(scoreboardTeamBase);
            } else {
                location2D = location2DArray[n++];
            }
            entityLiving.enderTeleportTo((float)MathHelper.floor(location2D.a) + 0.5f, location2D.a(world), (double)MathHelper.floor(location2D.b) + 0.5);
            double d2 = Double.MAX_VALUE;
            for (int j = 0; j < location2DArray.length; ++j) {
                if (location2D == location2DArray[j]) continue;
                double d3 = location2D.a(location2DArray[j]);
                d2 = Math.min(d3, d2);
            }
            d += d2;
        }
        return d /= (double)list.size();
    }

    private Location2D[] a(Random random, int n, double d, double d2, double d3, double d4) {
        Location2D[] location2DArray = new Location2D[n];
        for (int i = 0; i < location2DArray.length; ++i) {
            Location2D location2D = new Location2D();
            location2D.a(random, d, d2, d3, d4);
            location2DArray[i] = location2D;
        }
        return location2DArray;
    }
}

