/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.server.ChatMessage;
import net.minecraft.server.CommandAbstract;
import net.minecraft.server.CommandException;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EnumChatFormat;
import net.minecraft.server.ExceptionInvalidSyntax;
import net.minecraft.server.ExceptionUsage;
import net.minecraft.server.ICommandListener;
import net.minecraft.server.IScoreboardCriteria;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Scoreboard;
import net.minecraft.server.ScoreboardObjective;
import net.minecraft.server.ScoreboardScore;
import net.minecraft.server.ScoreboardTeam;

public class CommandScoreboard
extends CommandAbstract {
    @Override
    public String c() {
        return "scoreboard";
    }

    @Override
    public int a() {
        return 2;
    }

    @Override
    public String c(ICommandListener iCommandListener) {
        return "commands.scoreboard.usage";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void b(ICommandListener iCommandListener, String[] stringArray) {
        if (stringArray.length < 1) throw new ExceptionUsage("commands.scoreboard.usage", new Object[0]);
        if (stringArray[0].equalsIgnoreCase("objectives")) {
            if (stringArray.length == 1) {
                throw new ExceptionUsage("commands.scoreboard.objectives.usage", new Object[0]);
            }
            if (stringArray[1].equalsIgnoreCase("list")) {
                this.d(iCommandListener);
                return;
            } else if (stringArray[1].equalsIgnoreCase("add")) {
                if (stringArray.length < 4) throw new ExceptionUsage("commands.scoreboard.objectives.add.usage", new Object[0]);
                this.b(iCommandListener, stringArray, 2);
                return;
            } else if (stringArray[1].equalsIgnoreCase("remove")) {
                if (stringArray.length != 3) throw new ExceptionUsage("commands.scoreboard.objectives.remove.usage", new Object[0]);
                this.f(iCommandListener, stringArray[2]);
                return;
            } else {
                if (!stringArray[1].equalsIgnoreCase("setdisplay")) throw new ExceptionUsage("commands.scoreboard.objectives.usage", new Object[0]);
                if (stringArray.length != 3 && stringArray.length != 4) throw new ExceptionUsage("commands.scoreboard.objectives.setdisplay.usage", new Object[0]);
                this.j(iCommandListener, stringArray, 2);
            }
            return;
        }
        if (stringArray[0].equalsIgnoreCase("players")) {
            if (stringArray.length == 1) {
                throw new ExceptionUsage("commands.scoreboard.players.usage", new Object[0]);
            }
            if (stringArray[1].equalsIgnoreCase("list")) {
                if (stringArray.length > 3) throw new ExceptionUsage("commands.scoreboard.players.list.usage", new Object[0]);
                this.k(iCommandListener, stringArray, 2);
                return;
            } else if (stringArray[1].equalsIgnoreCase("add")) {
                if (stringArray.length != 5) throw new ExceptionUsage("commands.scoreboard.players.add.usage", new Object[0]);
                this.l(iCommandListener, stringArray, 2);
                return;
            } else if (stringArray[1].equalsIgnoreCase("remove")) {
                if (stringArray.length != 5) throw new ExceptionUsage("commands.scoreboard.players.remove.usage", new Object[0]);
                this.l(iCommandListener, stringArray, 2);
                return;
            } else if (stringArray[1].equalsIgnoreCase("set")) {
                if (stringArray.length != 5) throw new ExceptionUsage("commands.scoreboard.players.set.usage", new Object[0]);
                this.l(iCommandListener, stringArray, 2);
                return;
            } else {
                if (!stringArray[1].equalsIgnoreCase("reset")) throw new ExceptionUsage("commands.scoreboard.players.usage", new Object[0]);
                if (stringArray.length != 3) throw new ExceptionUsage("commands.scoreboard.players.reset.usage", new Object[0]);
                this.m(iCommandListener, stringArray, 2);
            }
            return;
        }
        if (!stringArray[0].equalsIgnoreCase("teams")) throw new ExceptionUsage("commands.scoreboard.usage", new Object[0]);
        if (stringArray.length == 1) {
            throw new ExceptionUsage("commands.scoreboard.teams.usage", new Object[0]);
        }
        if (stringArray[1].equalsIgnoreCase("list")) {
            if (stringArray.length > 3) throw new ExceptionUsage("commands.scoreboard.teams.list.usage", new Object[0]);
            this.f(iCommandListener, stringArray, 2);
            return;
        } else if (stringArray[1].equalsIgnoreCase("add")) {
            if (stringArray.length < 3) throw new ExceptionUsage("commands.scoreboard.teams.add.usage", new Object[0]);
            this.c(iCommandListener, stringArray, 2);
            return;
        } else if (stringArray[1].equalsIgnoreCase("remove")) {
            if (stringArray.length != 3) throw new ExceptionUsage("commands.scoreboard.teams.remove.usage", new Object[0]);
            this.e(iCommandListener, stringArray, 2);
            return;
        } else if (stringArray[1].equalsIgnoreCase("empty")) {
            if (stringArray.length != 3) throw new ExceptionUsage("commands.scoreboard.teams.empty.usage", new Object[0]);
            this.i(iCommandListener, stringArray, 2);
            return;
        } else if (stringArray[1].equalsIgnoreCase("join")) {
            if (stringArray.length < 4 && (stringArray.length != 3 || !(iCommandListener instanceof EntityHuman))) throw new ExceptionUsage("commands.scoreboard.teams.join.usage", new Object[0]);
            this.g(iCommandListener, stringArray, 2);
            return;
        } else if (stringArray[1].equalsIgnoreCase("leave")) {
            if (stringArray.length < 3 && !(iCommandListener instanceof EntityHuman)) throw new ExceptionUsage("commands.scoreboard.teams.leave.usage", new Object[0]);
            this.h(iCommandListener, stringArray, 2);
            return;
        } else {
            if (!stringArray[1].equalsIgnoreCase("option")) throw new ExceptionUsage("commands.scoreboard.teams.usage", new Object[0]);
            if (stringArray.length != 4 && stringArray.length != 5) throw new ExceptionUsage("commands.scoreboard.teams.option.usage", new Object[0]);
            this.d(iCommandListener, stringArray, 2);
        }
    }

    protected Scoreboard d() {
        return MinecraftServer.getServer().getWorldServer(0).getScoreboard();
    }

    protected ScoreboardObjective a(String string, boolean bl) {
        Scoreboard scoreboard = this.d();
        ScoreboardObjective scoreboardObjective = scoreboard.getObjective(string);
        if (scoreboardObjective == null) {
            throw new CommandException("commands.scoreboard.objectiveNotFound", string);
        }
        if (bl && scoreboardObjective.getCriteria().isReadOnly()) {
            throw new CommandException("commands.scoreboard.objectiveReadOnly", string);
        }
        return scoreboardObjective;
    }

    protected ScoreboardTeam a(String string) {
        Scoreboard scoreboard = this.d();
        ScoreboardTeam scoreboardTeam = scoreboard.getTeam(string);
        if (scoreboardTeam == null) {
            throw new CommandException("commands.scoreboard.teamNotFound", string);
        }
        return scoreboardTeam;
    }

    protected void b(ICommandListener iCommandListener, String[] stringArray, int n) {
        String string = stringArray[n++];
        String string2 = stringArray[n++];
        Scoreboard scoreboard = this.d();
        IScoreboardCriteria iScoreboardCriteria = (IScoreboardCriteria)IScoreboardCriteria.a.get(string2);
        if (iScoreboardCriteria == null) {
            Object[] objectArray = IScoreboardCriteria.a.keySet().toArray(new String[0]);
            throw new ExceptionUsage("commands.scoreboard.objectives.add.wrongType", CommandScoreboard.a(objectArray));
        }
        if (scoreboard.getObjective(string) != null) {
            throw new CommandException("commands.scoreboard.objectives.add.alreadyExists", string);
        }
        if (string.length() > 16) {
            throw new ExceptionInvalidSyntax("commands.scoreboard.objectives.add.tooLong", string, 16);
        }
        if (string.length() == 0) {
            throw new ExceptionUsage("commands.scoreboard.objectives.add.usage", new Object[0]);
        }
        if (stringArray.length > n) {
            String string3 = CommandScoreboard.a(iCommandListener, stringArray, n);
            if (string3.length() > 32) {
                throw new ExceptionInvalidSyntax("commands.scoreboard.objectives.add.displayTooLong", string3, 32);
            }
            if (string3.length() > 0) {
                scoreboard.registerObjective(string, iScoreboardCriteria).setDisplayName(string3);
            } else {
                scoreboard.registerObjective(string, iScoreboardCriteria);
            }
        } else {
            scoreboard.registerObjective(string, iScoreboardCriteria);
        }
        CommandScoreboard.a(iCommandListener, "commands.scoreboard.objectives.add.success", string);
    }

    protected void c(ICommandListener iCommandListener, String[] stringArray, int n) {
        String string = stringArray[n++];
        Scoreboard scoreboard = this.d();
        if (scoreboard.getTeam(string) != null) {
            throw new CommandException("commands.scoreboard.teams.add.alreadyExists", string);
        }
        if (string.length() > 16) {
            throw new ExceptionInvalidSyntax("commands.scoreboard.teams.add.tooLong", string, 16);
        }
        if (string.length() == 0) {
            throw new ExceptionUsage("commands.scoreboard.teams.add.usage", new Object[0]);
        }
        if (stringArray.length > n) {
            String string2 = CommandScoreboard.a(iCommandListener, stringArray, n);
            if (string2.length() > 32) {
                throw new ExceptionInvalidSyntax("commands.scoreboard.teams.add.displayTooLong", string2, 32);
            }
            if (string2.length() > 0) {
                scoreboard.createTeam(string).setDisplayName(string2);
            } else {
                scoreboard.createTeam(string);
            }
        } else {
            scoreboard.createTeam(string);
        }
        CommandScoreboard.a(iCommandListener, "commands.scoreboard.teams.add.success", string);
    }

    protected void d(ICommandListener iCommandListener, String[] stringArray, int n) {
        String string;
        ScoreboardTeam scoreboardTeam = this.a(stringArray[n++]);
        if (!((string = stringArray[n++].toLowerCase()).equalsIgnoreCase("color") || string.equalsIgnoreCase("friendlyfire") || string.equalsIgnoreCase("seeFriendlyInvisibles"))) {
            throw new ExceptionUsage("commands.scoreboard.teams.option.usage", new Object[0]);
        }
        if (stringArray.length == 4) {
            if (string.equalsIgnoreCase("color")) {
                throw new ExceptionUsage("commands.scoreboard.teams.option.noValue", string, CommandScoreboard.a(EnumChatFormat.a(true, false)));
            }
            if (string.equalsIgnoreCase("friendlyfire") || string.equalsIgnoreCase("seeFriendlyInvisibles")) {
                throw new ExceptionUsage("commands.scoreboard.teams.option.noValue", string, CommandScoreboard.a(Arrays.asList("true", "false")));
            }
            throw new ExceptionUsage("commands.scoreboard.teams.option.usage", new Object[0]);
        }
        String string2 = stringArray[n++];
        if (string.equalsIgnoreCase("color")) {
            EnumChatFormat enumChatFormat = EnumChatFormat.b(string2);
            if (string2 == null) {
                throw new ExceptionUsage("commands.scoreboard.teams.option.noValue", string, CommandScoreboard.a(EnumChatFormat.a(true, false)));
            }
            scoreboardTeam.setPrefix(enumChatFormat.toString());
            scoreboardTeam.setSuffix(EnumChatFormat.RESET.toString());
        } else if (string.equalsIgnoreCase("friendlyfire")) {
            if (!string2.equalsIgnoreCase("true") && !string2.equalsIgnoreCase("false")) {
                throw new ExceptionUsage("commands.scoreboard.teams.option.noValue", string, CommandScoreboard.a(Arrays.asList("true", "false")));
            }
            scoreboardTeam.setAllowFriendlyFire(string2.equalsIgnoreCase("true"));
        } else if (string.equalsIgnoreCase("seeFriendlyInvisibles")) {
            if (!string2.equalsIgnoreCase("true") && !string2.equalsIgnoreCase("false")) {
                throw new ExceptionUsage("commands.scoreboard.teams.option.noValue", string, CommandScoreboard.a(Arrays.asList("true", "false")));
            }
            scoreboardTeam.setCanSeeFriendlyInvisibles(string2.equalsIgnoreCase("true"));
        }
        CommandScoreboard.a(iCommandListener, "commands.scoreboard.teams.option.success", string, scoreboardTeam.getName(), string2);
    }

    protected void e(ICommandListener iCommandListener, String[] stringArray, int n) {
        Scoreboard scoreboard = this.d();
        ScoreboardTeam scoreboardTeam = this.a(stringArray[n++]);
        scoreboard.removeTeam(scoreboardTeam);
        CommandScoreboard.a(iCommandListener, "commands.scoreboard.teams.remove.success", scoreboardTeam.getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void f(ICommandListener iCommandListener, String[] stringArray, int n) {
        Scoreboard scoreboard = this.d();
        if (stringArray.length > n) {
            ScoreboardTeam scoreboardTeam;
            Collection collection;
            if ((collection = (scoreboardTeam = this.a(stringArray[n++])).getPlayerNameSet()).size() <= 0) throw new CommandException("commands.scoreboard.teams.list.player.empty", scoreboardTeam.getName());
            iCommandListener.sendMessage(ChatMessage.b("commands.scoreboard.teams.list.player.count", collection.size(), scoreboardTeam.getName()).a(EnumChatFormat.DARK_GREEN));
            iCommandListener.sendMessage(ChatMessage.d(CommandScoreboard.a(collection.toArray())));
            return;
        } else {
            Collection collection = scoreboard.getTeams();
            if (collection.size() <= 0) throw new CommandException("commands.scoreboard.teams.list.empty", new Object[0]);
            iCommandListener.sendMessage(ChatMessage.b("commands.scoreboard.teams.list.count", collection.size()).a(EnumChatFormat.DARK_GREEN));
            for (ScoreboardTeam scoreboardTeam : collection) {
                iCommandListener.sendMessage(ChatMessage.b("commands.scoreboard.teams.list.entry", scoreboardTeam.getName(), scoreboardTeam.getDisplayName(), scoreboardTeam.getPlayerNameSet().size()));
            }
        }
    }

    protected void g(ICommandListener iCommandListener, String[] stringArray, int n) {
        Scoreboard scoreboard = this.d();
        ScoreboardTeam scoreboardTeam = scoreboard.getTeam(stringArray[n++]);
        HashSet<String> hashSet = new HashSet<String>();
        if (iCommandListener instanceof EntityHuman && n == stringArray.length) {
            String string = CommandScoreboard.b(iCommandListener).getLocalizedName();
            scoreboard.addPlayerToTeam(string, scoreboardTeam);
            hashSet.add(string);
        } else {
            while (n < stringArray.length) {
                String string = CommandScoreboard.e(iCommandListener, stringArray[n++]);
                scoreboard.addPlayerToTeam(string, scoreboardTeam);
                hashSet.add(string);
            }
        }
        if (!hashSet.isEmpty()) {
            CommandScoreboard.a(iCommandListener, "commands.scoreboard.teams.join.success", hashSet.size(), scoreboardTeam.getName(), CommandScoreboard.a(hashSet.toArray(new String[0])));
        }
    }

    protected void h(ICommandListener iCommandListener, String[] stringArray, int n) {
        Scoreboard scoreboard = this.d();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        if (iCommandListener instanceof EntityHuman && n == stringArray.length) {
            String string = CommandScoreboard.b(iCommandListener).getLocalizedName();
            if (scoreboard.removePlayerFromTeam(string)) {
                hashSet.add(string);
            } else {
                hashSet2.add(string);
            }
        } else {
            while (n < stringArray.length) {
                String string;
                if (scoreboard.removePlayerFromTeam(string = CommandScoreboard.e(iCommandListener, stringArray[n++]))) {
                    hashSet.add(string);
                    continue;
                }
                hashSet2.add(string);
            }
        }
        if (!hashSet.isEmpty()) {
            CommandScoreboard.a(iCommandListener, "commands.scoreboard.teams.leave.success", hashSet.size(), CommandScoreboard.a(hashSet.toArray(new String[0])));
        }
        if (!hashSet2.isEmpty()) {
            throw new CommandException("commands.scoreboard.teams.leave.failure", hashSet2.size(), CommandScoreboard.a(hashSet2.toArray(new String[0])));
        }
    }

    protected void i(ICommandListener iCommandListener, String[] stringArray, int n) {
        ScoreboardTeam scoreboardTeam;
        ArrayList arrayList;
        Scoreboard scoreboard = this.d();
        if ((arrayList = new ArrayList((scoreboardTeam = this.a(stringArray[n++])).getPlayerNameSet())).isEmpty()) {
            throw new CommandException("commands.scoreboard.teams.empty.alreadyEmpty", scoreboardTeam.getName());
        }
        for (String string : arrayList) {
            scoreboard.removePlayerFromTeam(string, scoreboardTeam);
        }
        CommandScoreboard.a(iCommandListener, "commands.scoreboard.teams.empty.success", arrayList.size(), scoreboardTeam.getName());
    }

    protected void f(ICommandListener iCommandListener, String string) {
        Scoreboard scoreboard = this.d();
        ScoreboardObjective scoreboardObjective = this.a(string, false);
        scoreboard.unregisterObjective(scoreboardObjective);
        CommandScoreboard.a(iCommandListener, "commands.scoreboard.objectives.remove.success", string);
    }

    protected void d(ICommandListener iCommandListener) {
        Scoreboard scoreboard = this.d();
        Collection collection = scoreboard.getObjectives();
        if (collection.size() > 0) {
            iCommandListener.sendMessage(ChatMessage.b("commands.scoreboard.objectives.list.count", collection.size()).a(EnumChatFormat.DARK_GREEN));
            for (ScoreboardObjective scoreboardObjective : collection) {
                iCommandListener.sendMessage(ChatMessage.b("commands.scoreboard.objectives.list.entry", scoreboardObjective.getName(), scoreboardObjective.getDisplayName(), scoreboardObjective.getCriteria().getName()));
            }
        } else {
            throw new CommandException("commands.scoreboard.objectives.list.empty", new Object[0]);
        }
    }

    protected void j(ICommandListener iCommandListener, String[] stringArray, int n) {
        Scoreboard scoreboard = this.d();
        String string = stringArray[n++];
        int n2 = Scoreboard.getSlotForName(string);
        ScoreboardObjective scoreboardObjective = null;
        if (stringArray.length == 4) {
            scoreboardObjective = this.a(stringArray[n++], false);
        }
        if (n2 < 0) {
            throw new CommandException("commands.scoreboard.objectives.setdisplay.invalidSlot", string);
        }
        scoreboard.setDisplaySlot(n2, scoreboardObjective);
        if (scoreboardObjective != null) {
            CommandScoreboard.a(iCommandListener, "commands.scoreboard.objectives.setdisplay.successSet", Scoreboard.getSlotName(n2), scoreboardObjective.getName());
        } else {
            CommandScoreboard.a(iCommandListener, "commands.scoreboard.objectives.setdisplay.successCleared", Scoreboard.getSlotName(n2));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void k(ICommandListener iCommandListener, String[] stringArray, int n) {
        Scoreboard scoreboard = this.d();
        if (stringArray.length > n) {
            String string;
            Map map;
            if ((map = scoreboard.getPlayerObjectives(string = CommandScoreboard.e(iCommandListener, stringArray[n++]))).size() <= 0) throw new CommandException("commands.scoreboard.players.list.player.empty", string);
            iCommandListener.sendMessage(ChatMessage.b("commands.scoreboard.players.list.player.count", map.size(), string).a(EnumChatFormat.DARK_GREEN));
            for (ScoreboardScore scoreboardScore : map.values()) {
                iCommandListener.sendMessage(ChatMessage.b("commands.scoreboard.players.list.player.entry", scoreboardScore.getScore(), scoreboardScore.getObjective().getDisplayName(), scoreboardScore.getObjective().getName()));
            }
            return;
        } else {
            Collection collection = scoreboard.getPlayers();
            if (collection.size() <= 0) throw new CommandException("commands.scoreboard.players.list.empty", new Object[0]);
            iCommandListener.sendMessage(ChatMessage.b("commands.scoreboard.players.list.count", collection.size()).a(EnumChatFormat.DARK_GREEN));
            iCommandListener.sendMessage(ChatMessage.d(CommandScoreboard.a(collection.toArray())));
        }
    }

    protected void l(ICommandListener iCommandListener, String[] stringArray, int n) {
        String string = stringArray[n - 1];
        String string2 = CommandScoreboard.e(iCommandListener, stringArray[n++]);
        ScoreboardObjective scoreboardObjective = this.a(stringArray[n++], true);
        int n2 = string.equalsIgnoreCase("set") ? CommandScoreboard.a(iCommandListener, stringArray[n++]) : CommandScoreboard.a(iCommandListener, stringArray[n++], 1);
        Scoreboard scoreboard = this.d();
        ScoreboardScore scoreboardScore = scoreboard.getPlayerScoreForObjective(string2, scoreboardObjective);
        if (string.equalsIgnoreCase("set")) {
            scoreboardScore.setScore(n2);
        } else if (string.equalsIgnoreCase("add")) {
            scoreboardScore.addScore(n2);
        } else {
            scoreboardScore.removeScore(n2);
        }
        CommandScoreboard.a(iCommandListener, "commands.scoreboard.players.set.success", scoreboardObjective.getName(), string2, scoreboardScore.getScore());
    }

    protected void m(ICommandListener iCommandListener, String[] stringArray, int n) {
        Scoreboard scoreboard = this.d();
        String string = CommandScoreboard.e(iCommandListener, stringArray[n++]);
        scoreboard.resetPlayerScores(string);
        CommandScoreboard.a(iCommandListener, "commands.scoreboard.players.reset.success", string);
    }

    @Override
    public List a(ICommandListener iCommandListener, String[] stringArray) {
        if (stringArray.length == 1) {
            return CommandScoreboard.a(stringArray, "objectives", "players", "teams");
        }
        if (stringArray[0].equalsIgnoreCase("objectives")) {
            if (stringArray.length == 2) {
                return CommandScoreboard.a(stringArray, "list", "add", "remove", "setdisplay");
            }
            if (stringArray[1].equalsIgnoreCase("add")) {
                if (stringArray.length == 4) {
                    return CommandScoreboard.a(stringArray, IScoreboardCriteria.a.keySet());
                }
            } else if (stringArray[1].equalsIgnoreCase("remove")) {
                if (stringArray.length == 3) {
                    return CommandScoreboard.a(stringArray, this.a(false));
                }
            } else if (stringArray[1].equalsIgnoreCase("setdisplay")) {
                if (stringArray.length == 3) {
                    return CommandScoreboard.a(stringArray, "list", "sidebar", "belowName");
                }
                if (stringArray.length == 4) {
                    return CommandScoreboard.a(stringArray, this.a(false));
                }
            }
        } else if (stringArray[0].equalsIgnoreCase("players")) {
            if (stringArray.length == 2) {
                return CommandScoreboard.a(stringArray, "set", "add", "remove", "reset", "list");
            }
            if (stringArray[1].equalsIgnoreCase("set") || stringArray[1].equalsIgnoreCase("add") || stringArray[1].equalsIgnoreCase("remove")) {
                if (stringArray.length == 3) {
                    return CommandScoreboard.a(stringArray, MinecraftServer.getServer().getPlayers());
                }
                if (stringArray.length == 4) {
                    return CommandScoreboard.a(stringArray, this.a(true));
                }
            } else if ((stringArray[1].equalsIgnoreCase("reset") || stringArray[1].equalsIgnoreCase("list")) && stringArray.length == 3) {
                return CommandScoreboard.a(stringArray, this.d().getPlayers());
            }
        } else if (stringArray[0].equalsIgnoreCase("teams")) {
            if (stringArray.length == 2) {
                return CommandScoreboard.a(stringArray, "add", "remove", "join", "leave", "empty", "list", "option");
            }
            if (stringArray[1].equalsIgnoreCase("join")) {
                if (stringArray.length == 3) {
                    return CommandScoreboard.a(stringArray, this.d().getTeamNames());
                }
                if (stringArray.length >= 4) {
                    return CommandScoreboard.a(stringArray, MinecraftServer.getServer().getPlayers());
                }
            } else {
                if (stringArray[1].equalsIgnoreCase("leave")) {
                    return CommandScoreboard.a(stringArray, MinecraftServer.getServer().getPlayers());
                }
                if (stringArray[1].equalsIgnoreCase("empty") || stringArray[1].equalsIgnoreCase("list") || stringArray[1].equalsIgnoreCase("remove")) {
                    if (stringArray.length == 3) {
                        return CommandScoreboard.a(stringArray, this.d().getTeamNames());
                    }
                } else if (stringArray[1].equalsIgnoreCase("option")) {
                    if (stringArray.length == 3) {
                        return CommandScoreboard.a(stringArray, this.d().getTeamNames());
                    }
                    if (stringArray.length == 4) {
                        return CommandScoreboard.a(stringArray, "color", "friendlyfire", "seeFriendlyInvisibles");
                    }
                    if (stringArray.length == 5) {
                        if (stringArray[3].equalsIgnoreCase("color")) {
                            return CommandScoreboard.a(stringArray, EnumChatFormat.a(true, false));
                        }
                        if (stringArray[3].equalsIgnoreCase("friendlyfire") || stringArray[3].equalsIgnoreCase("seeFriendlyInvisibles")) {
                            return CommandScoreboard.a(stringArray, "true", "false");
                        }
                    }
                }
            }
        }
        return null;
    }

    protected List a(boolean bl) {
        Collection collection = this.d().getObjectives();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ScoreboardObjective scoreboardObjective : collection) {
            if (bl && scoreboardObjective.getCriteria().isReadOnly()) continue;
            arrayList.add(scoreboardObjective.getName());
        }
        return arrayList;
    }

    @Override
    public boolean a(String[] stringArray, int n) {
        if (stringArray[0].equalsIgnoreCase("players")) {
            return n == 2;
        }
        if (stringArray[0].equalsIgnoreCase("teams")) {
            return n == 2 || n == 3;
        }
        return false;
    }
}

