/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.server.BanEntry;
import net.minecraft.server.CommandAbstract;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.ExceptionPlayerNotFound;
import net.minecraft.server.ExceptionUsage;
import net.minecraft.server.ICommandListener;
import net.minecraft.server.MinecraftServer;

public class CommandBanIp
extends CommandAbstract {
    public static final Pattern a = Pattern.compile("^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");

    @Override
    public String c() {
        return "ban-ip";
    }

    @Override
    public int a() {
        return 3;
    }

    @Override
    public boolean a(ICommandListener iCommandListener) {
        return MinecraftServer.getServer().getPlayerList().getIPBans().isEnabled() && super.a(iCommandListener);
    }

    @Override
    public String c(ICommandListener iCommandListener) {
        return "commands.banip.usage";
    }

    @Override
    public void b(ICommandListener iCommandListener, String[] stringArray) {
        if (stringArray.length >= 1 && stringArray[0].length() > 1) {
            Matcher matcher = a.matcher(stringArray[0]);
            String string = null;
            if (stringArray.length >= 2) {
                string = CommandBanIp.a(iCommandListener, stringArray, 1);
            }
            if (matcher.matches()) {
                this.a(iCommandListener, stringArray[0], string);
            } else {
                EntityPlayer entityPlayer = MinecraftServer.getServer().getPlayerList().getPlayer(stringArray[0]);
                if (entityPlayer == null) {
                    throw new ExceptionPlayerNotFound("commands.banip.invalid", new Object[0]);
                }
                this.a(iCommandListener, entityPlayer.q(), string);
            }
            return;
        }
        throw new ExceptionUsage("commands.banip.usage", new Object[0]);
    }

    @Override
    public List a(ICommandListener iCommandListener, String[] stringArray) {
        if (stringArray.length == 1) {
            return CommandBanIp.a(stringArray, MinecraftServer.getServer().getPlayers());
        }
        return null;
    }

    protected void a(ICommandListener iCommandListener, String string, String string2) {
        BanEntry banEntry = new BanEntry(string);
        banEntry.setSource(iCommandListener.getName());
        if (string2 != null) {
            banEntry.setReason(string2);
        }
        MinecraftServer.getServer().getPlayerList().getIPBans().add(banEntry);
        List list = MinecraftServer.getServer().getPlayerList().i(string);
        Object[] objectArray = new String[list.size()];
        int n = 0;
        for (EntityPlayer entityPlayer : list) {
            entityPlayer.playerConnection.disconnect("You have been IP banned.");
            objectArray[n++] = entityPlayer.getLocalizedName();
        }
        if (list.isEmpty()) {
            CommandBanIp.a(iCommandListener, "commands.banip.success", string);
        } else {
            CommandBanIp.a(iCommandListener, "commands.banip.success.players", string, CommandBanIp.a(objectArray));
        }
    }
}

