/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.server.CommandException;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.ExceptionInvalidNumber;
import net.minecraft.server.ExceptionPlayerNotFound;
import net.minecraft.server.ICommand;
import net.minecraft.server.ICommandDispatcher;
import net.minecraft.server.ICommandListener;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerSelector;

public abstract class CommandAbstract
implements ICommand {
    private static ICommandDispatcher a;

    public int a() {
        return 4;
    }

    @Override
    public List b() {
        return null;
    }

    @Override
    public boolean a(ICommandListener iCommandListener) {
        return iCommandListener.a(this.a(), this.c());
    }

    @Override
    public List a(ICommandListener iCommandListener, String[] stringArray) {
        return null;
    }

    public static int a(ICommandListener iCommandListener, String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ExceptionInvalidNumber("commands.generic.num.invalid", string);
        }
    }

    public static int a(ICommandListener iCommandListener, String string, int n) {
        return CommandAbstract.a(iCommandListener, string, n, Integer.MAX_VALUE);
    }

    public static int a(ICommandListener iCommandListener, String string, int n, int n2) {
        int n3 = CommandAbstract.a(iCommandListener, string);
        if (n3 < n) {
            throw new ExceptionInvalidNumber("commands.generic.num.tooSmall", n3, n);
        }
        if (n3 > n2) {
            throw new ExceptionInvalidNumber("commands.generic.num.tooBig", n3, n2);
        }
        return n3;
    }

    public static double b(ICommandListener iCommandListener, String string) {
        try {
            double d = Double.parseDouble(string);
            if (!Doubles.isFinite(d)) {
                throw new ExceptionInvalidNumber("commands.generic.double.invalid", string);
            }
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ExceptionInvalidNumber("commands.generic.double.invalid", string);
        }
    }

    public static double a(ICommandListener iCommandListener, String string, double d) {
        return CommandAbstract.a(iCommandListener, string, d, Double.MAX_VALUE);
    }

    public static double a(ICommandListener iCommandListener, String string, double d, double d2) {
        double d3 = CommandAbstract.b(iCommandListener, string);
        if (d3 < d) {
            throw new ExceptionInvalidNumber("commands.generic.double.tooSmall", d3, d);
        }
        if (d3 > d2) {
            throw new ExceptionInvalidNumber("commands.generic.double.tooBig", d3, d2);
        }
        return d3;
    }

    public static boolean c(ICommandListener iCommandListener, String string) {
        if (string.equals("true") || string.equals("1")) {
            return true;
        }
        if (string.equals("false") || string.equals("0")) {
            return false;
        }
        throw new CommandException("commands.generic.boolean.invalid", string);
    }

    public static EntityPlayer b(ICommandListener iCommandListener) {
        if (iCommandListener instanceof EntityPlayer) {
            return (EntityPlayer)iCommandListener;
        }
        throw new ExceptionPlayerNotFound("You must specify which player you wish to perform this action on.", new Object[0]);
    }

    public static EntityPlayer d(ICommandListener iCommandListener, String string) {
        EntityPlayer entityPlayer = PlayerSelector.getPlayer(iCommandListener, string);
        if (entityPlayer != null) {
            return entityPlayer;
        }
        entityPlayer = MinecraftServer.getServer().getPlayerList().getPlayer(string);
        if (entityPlayer == null) {
            throw new ExceptionPlayerNotFound();
        }
        return entityPlayer;
    }

    public static String e(ICommandListener iCommandListener, String string) {
        EntityPlayer entityPlayer = PlayerSelector.getPlayer(iCommandListener, string);
        if (entityPlayer != null) {
            return entityPlayer.getLocalizedName();
        }
        if (PlayerSelector.isPattern(string)) {
            throw new ExceptionPlayerNotFound();
        }
        return string;
    }

    public static String a(ICommandListener iCommandListener, String[] stringArray, int n) {
        return CommandAbstract.a(iCommandListener, stringArray, n, false);
    }

    public static String a(ICommandListener iCommandListener, String[] stringArray, int n, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < stringArray.length; ++i) {
            if (i > n) {
                stringBuilder.append(" ");
            }
            String string = stringArray[i];
            if (bl) {
                String string2 = PlayerSelector.getPlayerNames(iCommandListener, string);
                if (string2 != null) {
                    string = string2;
                } else if (PlayerSelector.isPattern(string)) {
                    throw new ExceptionPlayerNotFound();
                }
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static double a(ICommandListener iCommandListener, double d, String string) {
        return CommandAbstract.a(iCommandListener, d, string, -30000000, 30000000);
    }

    public static double a(ICommandListener iCommandListener, double d, String string, int n, int n2) {
        double d2;
        boolean bl = string.startsWith("~");
        if (bl && Double.isNaN(d)) {
            throw new ExceptionInvalidNumber("commands.generic.num.invalid", d);
        }
        double d3 = d2 = bl ? d : 0.0;
        if (!bl || string.length() > 1) {
            boolean bl2 = string.contains(".");
            if (bl) {
                string = string.substring(1);
            }
            d2 += CommandAbstract.b(iCommandListener, string);
            if (!bl2 && !bl) {
                d2 += 0.5;
            }
        }
        if (n != 0 || n2 != 0) {
            if (d2 < (double)n) {
                throw new ExceptionInvalidNumber("commands.generic.double.tooSmall", d2, n);
            }
            if (d2 > (double)n2) {
                throw new ExceptionInvalidNumber("commands.generic.double.tooBig", d2, n2);
            }
        }
        return d2;
    }

    public static String a(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < objectArray.length; ++i) {
            String string = objectArray[i].toString();
            if (i > 0) {
                if (i == objectArray.length - 1) {
                    stringBuilder.append(" and ");
                } else {
                    stringBuilder.append(", ");
                }
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String a(Collection collection) {
        return CommandAbstract.a(collection.toArray(new String[collection.size()]));
    }

    public static String b(Collection collection) {
        Object[] objectArray = new String[collection.size()];
        int n = 0;
        for (EntityLiving entityLiving : collection) {
            objectArray[n++] = entityLiving.getScoreboardDisplayName();
        }
        return CommandAbstract.a(objectArray);
    }

    public static boolean a(String string, String string2) {
        return string2.regionMatches(true, 0, string, 0, string.length());
    }

    public static List a(String[] stringArray, String ... stringArray2) {
        String string = stringArray[stringArray.length - 1];
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray2) {
            if (!CommandAbstract.a(string, string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static List a(String[] stringArray, Iterable iterable) {
        String string = stringArray[stringArray.length - 1];
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : iterable) {
            if (!CommandAbstract.a(string, string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    @Override
    public boolean a(String[] stringArray, int n) {
        return false;
    }

    public static void a(ICommandListener iCommandListener, String string, Object ... objectArray) {
        CommandAbstract.a(iCommandListener, 0, string, objectArray);
    }

    public static void a(ICommandListener iCommandListener, int n, String string, Object ... objectArray) {
        if (a != null) {
            a.a(iCommandListener, n, string, objectArray);
        }
    }

    public static void a(ICommandDispatcher iCommandDispatcher) {
        a = iCommandDispatcher;
    }

    public int a(ICommand iCommand) {
        return this.c().compareTo(iCommand.c());
    }

    public /* synthetic */ int compareTo(Object object) {
        return this.a((ICommand)object);
    }
}

