/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Block;
import net.minecraft.server.NibbleArray;

public class ChunkSection {
    private int yPos;
    private int nonEmptyBlockCount;
    private int tickingBlockCount;
    private byte[] blockIds;
    private NibbleArray extBlockIds;
    private NibbleArray blockData;
    private NibbleArray emittedLight;
    private NibbleArray skyLight;

    public ChunkSection(int n, boolean bl) {
        this.yPos = n;
        this.blockIds = new byte[4096];
        this.blockData = new NibbleArray(this.blockIds.length, 4);
        this.emittedLight = new NibbleArray(this.blockIds.length, 4);
        if (bl) {
            this.skyLight = new NibbleArray(this.blockIds.length, 4);
        }
    }

    public int getTypeId(int n, int n2, int n3) {
        int n4 = this.blockIds[n2 << 8 | n3 << 4 | n] & 0xFF;
        if (this.extBlockIds != null) {
            return this.extBlockIds.a(n, n2, n3) << 8 | n4;
        }
        return n4;
    }

    public void setTypeId(int n, int n2, int n3, int n4) {
        int n5 = this.blockIds[n2 << 8 | n3 << 4 | n] & 0xFF;
        if (this.extBlockIds != null) {
            n5 = this.extBlockIds.a(n, n2, n3) << 8 | n5;
        }
        if (n5 == 0 && n4 != 0) {
            ++this.nonEmptyBlockCount;
            if (Block.byId[n4] != null && Block.byId[n4].isTicking()) {
                ++this.tickingBlockCount;
            }
        } else if (n5 != 0 && n4 == 0) {
            --this.nonEmptyBlockCount;
            if (Block.byId[n5] != null && Block.byId[n5].isTicking()) {
                --this.tickingBlockCount;
            }
        } else if (Block.byId[n5] != null && Block.byId[n5].isTicking() && (Block.byId[n4] == null || !Block.byId[n4].isTicking())) {
            --this.tickingBlockCount;
        } else if ((Block.byId[n5] == null || !Block.byId[n5].isTicking()) && Block.byId[n4] != null && Block.byId[n4].isTicking()) {
            ++this.tickingBlockCount;
        }
        this.blockIds[n2 << 8 | n3 << 4 | n] = (byte)(n4 & 0xFF);
        if (n4 > 255) {
            if (this.extBlockIds == null) {
                this.extBlockIds = new NibbleArray(this.blockIds.length, 4);
            }
            this.extBlockIds.a(n, n2, n3, (n4 & 0xF00) >> 8);
        } else if (this.extBlockIds != null) {
            this.extBlockIds.a(n, n2, n3, 0);
        }
    }

    public int getData(int n, int n2, int n3) {
        return this.blockData.a(n, n2, n3);
    }

    public void setData(int n, int n2, int n3, int n4) {
        this.blockData.a(n, n2, n3, n4);
    }

    public boolean isEmpty() {
        return this.nonEmptyBlockCount == 0;
    }

    public boolean shouldTick() {
        return this.tickingBlockCount > 0;
    }

    public int getYPosition() {
        return this.yPos;
    }

    public void setSkyLight(int n, int n2, int n3, int n4) {
        this.skyLight.a(n, n2, n3, n4);
    }

    public int getSkyLight(int n, int n2, int n3) {
        return this.skyLight.a(n, n2, n3);
    }

    public void setEmittedLight(int n, int n2, int n3, int n4) {
        this.emittedLight.a(n, n2, n3, n4);
    }

    public int getEmittedLight(int n, int n2, int n3) {
        return this.emittedLight.a(n, n2, n3);
    }

    public void recalcBlockCounts() {
        this.nonEmptyBlockCount = 0;
        this.tickingBlockCount = 0;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    int n = this.getTypeId(i, j, k);
                    if (n <= 0) continue;
                    if (Block.byId[n] == null) {
                        this.blockIds[j << 8 | k << 4 | i] = 0;
                        if (this.extBlockIds == null) continue;
                        this.extBlockIds.a(i, j, k, 0);
                        continue;
                    }
                    ++this.nonEmptyBlockCount;
                    if (!Block.byId[n].isTicking()) continue;
                    ++this.tickingBlockCount;
                }
            }
        }
    }

    public byte[] getIdArray() {
        return this.blockIds;
    }

    public NibbleArray getExtendedIdArray() {
        return this.extBlockIds;
    }

    public NibbleArray getDataArray() {
        return this.blockData;
    }

    public NibbleArray getEmittedLightArray() {
        return this.emittedLight;
    }

    public NibbleArray getSkyLightArray() {
        return this.skyLight;
    }

    public void setIdArray(byte[] byArray) {
        this.blockIds = byArray;
    }

    public void setExtendedIdArray(NibbleArray nibbleArray) {
        this.extBlockIds = nibbleArray;
    }

    public void setDataArray(NibbleArray nibbleArray) {
        this.blockData = nibbleArray;
    }

    public void setEmittedLightArray(NibbleArray nibbleArray) {
        this.emittedLight = nibbleArray;
    }

    public void setSkyLightArray(NibbleArray nibbleArray) {
        this.skyLight = nibbleArray;
    }
}

