/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.server.Chunk;
import net.minecraft.server.ChunkCoordIntPair;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.ChunkPosition;
import net.minecraft.server.CrashReport;
import net.minecraft.server.CrashReportSystemDetails;
import net.minecraft.server.EmptyChunk;
import net.minecraft.server.EnumCreatureType;
import net.minecraft.server.ExceptionWorldConflict;
import net.minecraft.server.IChunkLoader;
import net.minecraft.server.IChunkProvider;
import net.minecraft.server.IProgressUpdate;
import net.minecraft.server.LongHashMap;
import net.minecraft.server.ReportedException;
import net.minecraft.server.World;
import net.minecraft.server.WorldServer;

public class ChunkProviderServer
implements IChunkProvider {
    private Set unloadQueue = new HashSet();
    private Chunk emptyChunk;
    private IChunkProvider chunkProvider;
    private IChunkLoader e;
    public boolean forceChunkLoad = true;
    private LongHashMap chunks = new LongHashMap();
    private List chunkList = new ArrayList();
    private WorldServer world;

    public ChunkProviderServer(WorldServer worldServer, IChunkLoader iChunkLoader, IChunkProvider iChunkProvider) {
        this.emptyChunk = new EmptyChunk(worldServer, 0, 0);
        this.world = worldServer;
        this.e = iChunkLoader;
        this.chunkProvider = iChunkProvider;
    }

    @Override
    public boolean isChunkLoaded(int n, int n2) {
        return this.chunks.contains(ChunkCoordIntPair.a(n, n2));
    }

    public void queueUnload(int n, int n2) {
        if (this.world.worldProvider.e()) {
            ChunkCoordinates chunkCoordinates = this.world.getSpawn();
            int n3 = n * 16 + 8 - chunkCoordinates.x;
            int n4 = n2 * 16 + 8 - chunkCoordinates.z;
            int n5 = 128;
            if (n3 < -n5 || n3 > n5 || n4 < -n5 || n4 > n5) {
                this.unloadQueue.add(ChunkCoordIntPair.a(n, n2));
            }
        } else {
            this.unloadQueue.add(ChunkCoordIntPair.a(n, n2));
        }
    }

    public void a() {
        for (Chunk chunk : this.chunkList) {
            this.queueUnload(chunk.x, chunk.z);
        }
    }

    @Override
    public Chunk getChunkAt(int n, int n2) {
        long l = ChunkCoordIntPair.a(n, n2);
        this.unloadQueue.remove(l);
        Chunk chunk = (Chunk)this.chunks.getEntry(l);
        if (chunk == null) {
            chunk = this.loadChunk(n, n2);
            if (chunk == null) {
                if (this.chunkProvider == null) {
                    chunk = this.emptyChunk;
                } else {
                    try {
                        chunk = this.chunkProvider.getOrCreateChunk(n, n2);
                    }
                    catch (Throwable throwable) {
                        CrashReport crashReport = CrashReport.a(throwable, "Exception generating new chunk");
                        CrashReportSystemDetails crashReportSystemDetails = crashReport.a("Chunk to be generated");
                        crashReportSystemDetails.a("Location", String.format("%d,%d", n, n2));
                        crashReportSystemDetails.a("Position hash", l);
                        crashReportSystemDetails.a("Generator", this.chunkProvider.getName());
                        throw new ReportedException(crashReport);
                    }
                }
            }
            this.chunks.put(l, chunk);
            this.chunkList.add(chunk);
            if (chunk != null) {
                chunk.addEntities();
            }
            chunk.a(this, this, n, n2);
        }
        return chunk;
    }

    @Override
    public Chunk getOrCreateChunk(int n, int n2) {
        Chunk chunk = (Chunk)this.chunks.getEntry(ChunkCoordIntPair.a(n, n2));
        if (chunk == null) {
            if (this.world.isLoading || this.forceChunkLoad) {
                return this.getChunkAt(n, n2);
            }
            return this.emptyChunk;
        }
        return chunk;
    }

    private Chunk loadChunk(int n, int n2) {
        if (this.e == null) {
            return null;
        }
        try {
            Chunk chunk = this.e.a(this.world, n, n2);
            if (chunk != null) {
                chunk.n = this.world.getTime();
                if (this.chunkProvider != null) {
                    this.chunkProvider.recreateStructures(n, n2);
                }
            }
            return chunk;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void saveChunkNOP(Chunk chunk) {
        if (this.e == null) {
            return;
        }
        try {
            this.e.b(this.world, chunk);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void saveChunk(Chunk chunk) {
        if (this.e == null) {
            return;
        }
        try {
            chunk.n = this.world.getTime();
            this.e.a(this.world, chunk);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ExceptionWorldConflict exceptionWorldConflict) {
            exceptionWorldConflict.printStackTrace();
        }
    }

    @Override
    public void getChunkAt(IChunkProvider iChunkProvider, int n, int n2) {
        Chunk chunk = this.getOrCreateChunk(n, n2);
        if (!chunk.done) {
            chunk.done = true;
            if (this.chunkProvider != null) {
                this.chunkProvider.getChunkAt(iChunkProvider, n, n2);
                chunk.e();
            }
        }
    }

    @Override
    public boolean saveChunks(boolean bl, IProgressUpdate iProgressUpdate) {
        int n = 0;
        for (int i = 0; i < this.chunkList.size(); ++i) {
            Chunk chunk = (Chunk)this.chunkList.get(i);
            if (bl) {
                this.saveChunkNOP(chunk);
            }
            if (!chunk.a(bl)) continue;
            this.saveChunk(chunk);
            chunk.l = false;
            if (++n != 24 || bl) continue;
            return false;
        }
        return true;
    }

    @Override
    public void b() {
        if (this.e != null) {
            this.e.b();
        }
    }

    @Override
    public boolean unloadChunks() {
        if (!this.world.savingDisabled) {
            for (int i = 0; i < 100; ++i) {
                if (this.unloadQueue.isEmpty()) continue;
                Long l = (Long)this.unloadQueue.iterator().next();
                Chunk chunk = (Chunk)this.chunks.getEntry(l);
                chunk.removeEntities();
                this.saveChunk(chunk);
                this.saveChunkNOP(chunk);
                this.unloadQueue.remove(l);
                this.chunks.remove(l);
                this.chunkList.remove(chunk);
            }
            if (this.e != null) {
                this.e.a();
            }
        }
        return this.chunkProvider.unloadChunks();
    }

    @Override
    public boolean canSave() {
        return !this.world.savingDisabled;
    }

    @Override
    public String getName() {
        return "ServerChunkCache: " + this.chunks.count() + " Drop: " + this.unloadQueue.size();
    }

    @Override
    public List getMobsFor(EnumCreatureType enumCreatureType, int n, int n2, int n3) {
        return this.chunkProvider.getMobsFor(enumCreatureType, n, n2, n3);
    }

    @Override
    public ChunkPosition findNearestMapFeature(World world, String string, int n, int n2, int n3) {
        return this.chunkProvider.findNearestMapFeature(world, string, n, n2, n3);
    }

    @Override
    public int getLoadedChunks() {
        return this.chunks.count();
    }

    @Override
    public void recreateStructures(int n, int n2) {
    }
}

