/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import java.util.Random;
import net.minecraft.server.BiomeBase;
import net.minecraft.server.Block;
import net.minecraft.server.BlockSand;
import net.minecraft.server.Chunk;
import net.minecraft.server.ChunkPosition;
import net.minecraft.server.EnumCreatureType;
import net.minecraft.server.IChunkProvider;
import net.minecraft.server.IProgressUpdate;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NoiseGeneratorOctaves;
import net.minecraft.server.SpawnerCreature;
import net.minecraft.server.World;
import net.minecraft.server.WorldGenBase;
import net.minecraft.server.WorldGenCanyon;
import net.minecraft.server.WorldGenCaves;
import net.minecraft.server.WorldGenDungeons;
import net.minecraft.server.WorldGenLakes;
import net.minecraft.server.WorldGenLargeFeature;
import net.minecraft.server.WorldGenMineshaft;
import net.minecraft.server.WorldGenStronghold;
import net.minecraft.server.WorldGenVillage;

public class ChunkProviderGenerate
implements IChunkProvider {
    private Random k;
    private NoiseGeneratorOctaves l;
    private NoiseGeneratorOctaves m;
    private NoiseGeneratorOctaves n;
    private NoiseGeneratorOctaves o;
    public NoiseGeneratorOctaves a;
    public NoiseGeneratorOctaves b;
    public NoiseGeneratorOctaves c;
    private World p;
    private final boolean q;
    private double[] r;
    private double[] s = new double[256];
    private WorldGenBase t = new WorldGenCaves();
    private WorldGenStronghold u = new WorldGenStronghold();
    private WorldGenVillage v = new WorldGenVillage();
    private WorldGenMineshaft w = new WorldGenMineshaft();
    private WorldGenLargeFeature x = new WorldGenLargeFeature();
    private WorldGenBase y = new WorldGenCanyon();
    private BiomeBase[] z;
    double[] d;
    double[] e;
    double[] f;
    double[] g;
    double[] h;
    float[] i;
    int[][] j = new int[32][32];

    public ChunkProviderGenerate(World world, long l, boolean bl) {
        this.p = world;
        this.q = bl;
        this.k = new Random(l);
        this.l = new NoiseGeneratorOctaves(this.k, 16);
        this.m = new NoiseGeneratorOctaves(this.k, 16);
        this.n = new NoiseGeneratorOctaves(this.k, 8);
        this.o = new NoiseGeneratorOctaves(this.k, 4);
        this.a = new NoiseGeneratorOctaves(this.k, 10);
        this.b = new NoiseGeneratorOctaves(this.k, 16);
        this.c = new NoiseGeneratorOctaves(this.k, 8);
    }

    public void a(int n, int n2, byte[] byArray) {
        int n3 = 4;
        int n4 = 16;
        int n5 = 63;
        int n6 = n3 + 1;
        int n7 = 17;
        int n8 = n3 + 1;
        this.z = this.p.getWorldChunkManager().getBiomes(this.z, n * 4 - 2, n2 * 4 - 2, n6 + 5, n8 + 5);
        this.r = this.a(this.r, n * n3, 0, n2 * n3, n6, n7, n8);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n4; ++k) {
                    double d = 0.125;
                    double d2 = this.r[((i + 0) * n8 + (j + 0)) * n7 + (k + 0)];
                    double d3 = this.r[((i + 0) * n8 + (j + 1)) * n7 + (k + 0)];
                    double d4 = this.r[((i + 1) * n8 + (j + 0)) * n7 + (k + 0)];
                    double d5 = this.r[((i + 1) * n8 + (j + 1)) * n7 + (k + 0)];
                    double d6 = (this.r[((i + 0) * n8 + (j + 0)) * n7 + (k + 1)] - d2) * d;
                    double d7 = (this.r[((i + 0) * n8 + (j + 1)) * n7 + (k + 1)] - d3) * d;
                    double d8 = (this.r[((i + 1) * n8 + (j + 0)) * n7 + (k + 1)] - d4) * d;
                    double d9 = (this.r[((i + 1) * n8 + (j + 1)) * n7 + (k + 1)] - d5) * d;
                    for (int i2 = 0; i2 < 8; ++i2) {
                        double d10 = 0.25;
                        double d11 = d2;
                        double d12 = d3;
                        double d13 = (d4 - d2) * d10;
                        double d14 = (d5 - d3) * d10;
                        for (int i3 = 0; i3 < 4; ++i3) {
                            int n9 = i3 + i * 4 << 11 | 0 + j * 4 << 7 | k * 8 + i2;
                            int n10 = 128;
                            n9 -= n10;
                            double d15 = 0.25;
                            double d16 = d11;
                            double d17 = (d12 - d11) * d15;
                            d16 -= d17;
                            for (int i4 = 0; i4 < 4; ++i4) {
                                double d18;
                                d16 += d17;
                                byArray[n9 += n10] = d18 > 0.0 ? (byte)Block.STONE.id : (k * 8 + i2 < n5 ? (byte)Block.STATIONARY_WATER.id : (byte)0);
                            }
                            d11 += d13;
                            d12 += d14;
                        }
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                        d5 += d9;
                    }
                }
            }
        }
    }

    public void a(int n, int n2, byte[] byArray, BiomeBase[] biomeBaseArray) {
        int n3 = 63;
        double d = 0.03125;
        this.s = this.o.a(this.s, n * 16, n2 * 16, 0, 16, 16, 1, d * 2.0, d * 2.0, d * 2.0);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                BiomeBase biomeBase = biomeBaseArray[j + i * 16];
                float f = biomeBase.j();
                int n4 = (int)(this.s[i + j * 16] / 3.0 + 3.0 + this.k.nextDouble() * 0.25);
                int n5 = -1;
                byte by = biomeBase.A;
                byte by2 = biomeBase.B;
                for (int k = 127; k >= 0; --k) {
                    int n6 = (j * 16 + i) * 128 + k;
                    if (k <= 0 + this.k.nextInt(5)) {
                        byArray[n6] = (byte)Block.BEDROCK.id;
                        continue;
                    }
                    byte by3 = byArray[n6];
                    if (by3 == 0) {
                        n5 = -1;
                        continue;
                    }
                    if (by3 != Block.STONE.id) continue;
                    if (n5 == -1) {
                        if (n4 <= 0) {
                            by = 0;
                            by2 = (byte)Block.STONE.id;
                        } else if (k >= n3 - 4 && k <= n3 + 1) {
                            by = biomeBase.A;
                            by2 = biomeBase.B;
                        }
                        if (k < n3 && by == 0) {
                            by = f < 0.15f ? (byte)Block.ICE.id : (byte)Block.STATIONARY_WATER.id;
                        }
                        n5 = n4;
                        if (k >= n3 - 1) {
                            byArray[n6] = by;
                            continue;
                        }
                        byArray[n6] = by2;
                        continue;
                    }
                    if (n5 <= 0) continue;
                    byArray[n6] = by2;
                    if (--n5 != 0 || by2 != Block.SAND.id) continue;
                    n5 = this.k.nextInt(4);
                    by2 = (byte)Block.SANDSTONE.id;
                }
            }
        }
    }

    @Override
    public Chunk getChunkAt(int n, int n2) {
        return this.getOrCreateChunk(n, n2);
    }

    @Override
    public Chunk getOrCreateChunk(int n, int n2) {
        this.k.setSeed((long)n * 341873128712L + (long)n2 * 132897987541L);
        byte[] byArray = new byte[32768];
        this.a(n, n2, byArray);
        this.z = this.p.getWorldChunkManager().getBiomeBlock(this.z, n * 16, n2 * 16, 16, 16);
        this.a(n, n2, byArray, this.z);
        this.t.a(this, this.p, n, n2, byArray);
        this.y.a(this, this.p, n, n2, byArray);
        if (this.q) {
            this.w.a(this, this.p, n, n2, byArray);
            this.v.a(this, this.p, n, n2, byArray);
            this.u.a(this, this.p, n, n2, byArray);
            this.x.a(this, this.p, n, n2, byArray);
        }
        Chunk chunk = new Chunk(this.p, byArray, n, n2);
        byte[] byArray2 = chunk.m();
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = (byte)this.z[i].id;
        }
        chunk.initLighting();
        return chunk;
    }

    private double[] a(double[] dArray, int n, int n2, int n3, int n4, int n5, int n6) {
        if (dArray == null) {
            dArray = new double[n4 * n5 * n6];
        }
        if (this.i == null) {
            this.i = new float[25];
            for (int i = -2; i <= 2; ++i) {
                for (int j = -2; j <= 2; ++j) {
                    float f;
                    this.i[i + 2 + (j + 2) * 5] = f = 10.0f / MathHelper.c((float)(i * i + j * j) + 0.2f);
                }
            }
        }
        double d = 684.412;
        double d2 = 684.412;
        this.g = this.a.a(this.g, n, n3, n4, n6, 1.121, 1.121, 0.5);
        this.h = this.b.a(this.h, n, n3, n4, n6, 200.0, 200.0, 0.5);
        this.d = this.n.a(this.d, n, n2, n3, n4, n5, n6, d / 80.0, d2 / 160.0, d / 80.0);
        this.e = this.l.a(this.e, n, n2, n3, n4, n5, n6, d, d2, d);
        this.f = this.m.a(this.f, n, n2, n3, n4, n5, n6, d, d2, d);
        n3 = 0;
        n = 0;
        int n7 = 0;
        int n8 = 0;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n6; ++j) {
                float f = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                int n9 = 2;
                BiomeBase biomeBase = this.z[i + 2 + (j + 2) * (n4 + 5)];
                for (int k = -n9; k <= n9; ++k) {
                    for (int i2 = -n9; i2 <= n9; ++i2) {
                        BiomeBase biomeBase2 = this.z[i + k + 2 + (j + i2 + 2) * (n4 + 5)];
                        float f4 = this.i[k + 2 + (i2 + 2) * 5] / (biomeBase2.D + 2.0f);
                        if (biomeBase2.D > biomeBase.D) {
                            f4 /= 2.0f;
                        }
                        f += biomeBase2.E * f4;
                        f2 += biomeBase2.D * f4;
                        f3 += f4;
                    }
                }
                f /= f3;
                f2 /= f3;
                f = f * 0.9f + 0.1f;
                f2 = (f2 * 4.0f - 1.0f) / 8.0f;
                double d3 = this.h[n8] / 8000.0;
                if (d3 < 0.0) {
                    d3 = -d3 * 0.3;
                }
                if ((d3 = d3 * 3.0 - 2.0) < 0.0) {
                    if ((d3 /= 2.0) < -1.0) {
                        d3 = -1.0;
                    }
                    d3 /= 1.4;
                    d3 /= 2.0;
                } else {
                    if (d3 > 1.0) {
                        d3 = 1.0;
                    }
                    d3 /= 8.0;
                }
                ++n8;
                for (int k = 0; k < n5; ++k) {
                    double d4 = f2;
                    double d5 = f;
                    d4 += d3 * 0.2;
                    d4 = d4 * (double)n5 / 16.0;
                    double d6 = (double)n5 / 2.0 + d4 * 4.0;
                    double d7 = 0.0;
                    double d8 = ((double)k - d6) * 12.0 * 128.0 / 128.0 / d5;
                    if (d8 < 0.0) {
                        d8 *= 4.0;
                    }
                    double d9 = this.e[n7] / 512.0;
                    double d10 = this.f[n7] / 512.0;
                    double d11 = (this.d[n7] / 10.0 + 1.0) / 2.0;
                    d7 = d11 < 0.0 ? d9 : (d11 > 1.0 ? d10 : d9 + (d10 - d9) * d11);
                    d7 -= d8;
                    if (k > n5 - 4) {
                        double d12 = (float)(k - (n5 - 4)) / 3.0f;
                        d7 = d7 * (1.0 - d12) + -10.0 * d12;
                    }
                    dArray[n7] = d7;
                    ++n7;
                }
            }
        }
        return dArray;
    }

    @Override
    public boolean isChunkLoaded(int n, int n2) {
        return true;
    }

    @Override
    public void getChunkAt(IChunkProvider iChunkProvider, int n, int n2) {
        int n3;
        int n4;
        int n5;
        BlockSand.instaFall = true;
        int n6 = n * 16;
        int n7 = n2 * 16;
        BiomeBase biomeBase = this.p.getBiome(n6 + 16, n7 + 16);
        this.k.setSeed(this.p.getSeed());
        long l = this.k.nextLong() / 2L * 2L + 1L;
        long l2 = this.k.nextLong() / 2L * 2L + 1L;
        this.k.setSeed((long)n * l + (long)n2 * l2 ^ this.p.getSeed());
        boolean bl = false;
        if (this.q) {
            this.w.a(this.p, this.k, n, n2);
            bl = this.v.a(this.p, this.k, n, n2);
            this.u.a(this.p, this.k, n, n2);
            this.x.a(this.p, this.k, n, n2);
        }
        if (biomeBase != BiomeBase.DESERT && biomeBase != BiomeBase.DESERT_HILLS && !bl && this.k.nextInt(4) == 0) {
            n5 = n6 + this.k.nextInt(16) + 8;
            n4 = this.k.nextInt(128);
            n3 = n7 + this.k.nextInt(16) + 8;
            new WorldGenLakes(Block.STATIONARY_WATER.id).a(this.p, this.k, n5, n4, n3);
        }
        if (!bl && this.k.nextInt(8) == 0) {
            n5 = n6 + this.k.nextInt(16) + 8;
            n4 = this.k.nextInt(this.k.nextInt(120) + 8);
            n3 = n7 + this.k.nextInt(16) + 8;
            if (n4 < 63 || this.k.nextInt(10) == 0) {
                new WorldGenLakes(Block.STATIONARY_LAVA.id).a(this.p, this.k, n5, n4, n3);
            }
        }
        for (n5 = 0; n5 < 8; ++n5) {
            n4 = n6 + this.k.nextInt(16) + 8;
            n3 = this.k.nextInt(128);
            int n8 = n7 + this.k.nextInt(16) + 8;
            new WorldGenDungeons().a(this.p, this.k, n4, n3, n8);
        }
        biomeBase.a(this.p, this.k, n6, n7);
        SpawnerCreature.a(this.p, biomeBase, n6 + 8, n7 + 8, 16, 16, this.k);
        n6 += 8;
        n7 += 8;
        for (n5 = 0; n5 < 16; ++n5) {
            for (n4 = 0; n4 < 16; ++n4) {
                n3 = this.p.h(n6 + n5, n7 + n4);
                if (this.p.x(n5 + n6, n3 - 1, n4 + n7)) {
                    this.p.setTypeIdAndData(n5 + n6, n3 - 1, n4 + n7, Block.ICE.id, 0, 2);
                }
                if (!this.p.z(n5 + n6, n3, n4 + n7)) continue;
                this.p.setTypeIdAndData(n5 + n6, n3, n4 + n7, Block.SNOW.id, 0, 2);
            }
        }
        BlockSand.instaFall = false;
    }

    @Override
    public boolean saveChunks(boolean bl, IProgressUpdate iProgressUpdate) {
        return true;
    }

    @Override
    public void b() {
    }

    @Override
    public boolean unloadChunks() {
        return false;
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public String getName() {
        return "RandomLevelSource";
    }

    @Override
    public List getMobsFor(EnumCreatureType enumCreatureType, int n, int n2, int n3) {
        BiomeBase biomeBase = this.p.getBiome(n, n3);
        if (biomeBase == null) {
            return null;
        }
        if (enumCreatureType == EnumCreatureType.MONSTER && this.x.a(n, n2, n3)) {
            return this.x.b();
        }
        return biomeBase.getMobs(enumCreatureType);
    }

    @Override
    public ChunkPosition findNearestMapFeature(World world, String string, int n, int n2, int n3) {
        if ("Stronghold".equals(string) && this.u != null) {
            return this.u.getNearestGeneratedFeature(world, n, n2, n3);
        }
        return null;
    }

    @Override
    public int getLoadedChunks() {
        return 0;
    }

    @Override
    public void recreateStructures(int n, int n2) {
        if (this.q) {
            this.w.a(this, this.p, n, n2, null);
            this.v.a(this, this.p, n, n2, null);
            this.u.a(this, this.p, n, n2, null);
            this.x.a(this, this.p, n, n2, null);
        }
    }
}

