/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.server.BiomeBase;
import net.minecraft.server.Block;
import net.minecraft.server.Chunk;
import net.minecraft.server.ChunkPosition;
import net.minecraft.server.ChunkSection;
import net.minecraft.server.EnumCreatureType;
import net.minecraft.server.IChunkProvider;
import net.minecraft.server.IProgressUpdate;
import net.minecraft.server.StructureGenerator;
import net.minecraft.server.World;
import net.minecraft.server.WorldGenDungeons;
import net.minecraft.server.WorldGenFlatInfo;
import net.minecraft.server.WorldGenFlatLayerInfo;
import net.minecraft.server.WorldGenLakes;
import net.minecraft.server.WorldGenLargeFeature;
import net.minecraft.server.WorldGenMineshaft;
import net.minecraft.server.WorldGenStronghold;
import net.minecraft.server.WorldGenVillage;

public class ChunkProviderFlat
implements IChunkProvider {
    private World a;
    private Random b;
    private final byte[] c = new byte[256];
    private final byte[] d = new byte[256];
    private final WorldGenFlatInfo e;
    private final List f = new ArrayList();
    private final boolean g;
    private final boolean h;
    private WorldGenLakes i;
    private WorldGenLakes j;

    public ChunkProviderFlat(World world, long l, boolean bl, String string) {
        this.a = world;
        this.b = new Random(l);
        this.e = WorldGenFlatInfo.a(string);
        if (bl) {
            Map map = this.e.b();
            if (map.containsKey("village")) {
                Object object = (Map)map.get("village");
                if (!object.containsKey("size")) {
                    object.put("size", "1");
                }
                this.f.add(new WorldGenVillage((Map)object));
            }
            if (map.containsKey("biome_1")) {
                this.f.add(new WorldGenLargeFeature((Map)map.get("biome_1")));
            }
            if (map.containsKey("mineshaft")) {
                this.f.add(new WorldGenMineshaft((Map)map.get("mineshaft")));
            }
            if (map.containsKey("stronghold")) {
                this.f.add(new WorldGenStronghold((Map)map.get("stronghold")));
            }
        }
        this.g = this.e.b().containsKey("decoration");
        if (this.e.b().containsKey("lake")) {
            this.i = new WorldGenLakes(Block.STATIONARY_WATER.id);
        }
        if (this.e.b().containsKey("lava_lake")) {
            this.j = new WorldGenLakes(Block.STATIONARY_LAVA.id);
        }
        this.h = this.e.b().containsKey("dungeon");
        for (Object object : this.e.c()) {
            for (int i = ((WorldGenFlatLayerInfo)object).d(); i < ((WorldGenFlatLayerInfo)object).d() + ((WorldGenFlatLayerInfo)object).a(); ++i) {
                this.c[i] = (byte)(((WorldGenFlatLayerInfo)object).b() & 0xFF);
                this.d[i] = (byte)((WorldGenFlatLayerInfo)object).c();
            }
        }
    }

    @Override
    public Chunk getChunkAt(int n, int n2) {
        return this.getOrCreateChunk(n, n2);
    }

    @Override
    public Chunk getOrCreateChunk(int n, int n2) {
        Chunk chunk = new Chunk(this.a, n, n2);
        for (int i = 0; i < this.c.length; ++i) {
            int n3 = i >> 4;
            ChunkSection chunkSection = chunk.i()[n3];
            if (chunkSection == null) {
                chunk.i()[n3] = chunkSection = new ChunkSection(i, !this.a.worldProvider.g);
            }
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    chunkSection.setTypeId(j, i & 0xF, k, this.c[i] & 0xFF);
                    chunkSection.setData(j, i & 0xF, k, this.d[i]);
                }
            }
        }
        chunk.initLighting();
        BiomeBase[] biomeBaseArray = this.a.getWorldChunkManager().getBiomeBlock(null, n * 16, n2 * 16, 16, 16);
        byte[] byArray = chunk.m();
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)biomeBaseArray[i].id;
        }
        for (StructureGenerator structureGenerator : this.f) {
            structureGenerator.a(this, this.a, n, n2, null);
        }
        chunk.initLighting();
        return chunk;
    }

    @Override
    public boolean isChunkLoaded(int n, int n2) {
        return true;
    }

    @Override
    public void getChunkAt(IChunkProvider iChunkProvider, int n, int n2) {
        int n3;
        int n4 = n * 16;
        int n5 = n2 * 16;
        BiomeBase biomeBase = this.a.getBiome(n4 + 16, n5 + 16);
        boolean bl = false;
        this.b.setSeed(this.a.getSeed());
        long l = this.b.nextLong() / 2L * 2L + 1L;
        long l2 = this.b.nextLong() / 2L * 2L + 1L;
        this.b.setSeed((long)n * l + (long)n2 * l2 ^ this.a.getSeed());
        for (StructureGenerator structureGenerator : this.f) {
            n3 = structureGenerator.a(this.a, this.b, n, n2);
            if (!(structureGenerator instanceof WorldGenVillage)) continue;
            bl |= n3;
        }
        if (this.i != null && !bl && this.b.nextInt(4) == 0) {
            int n6 = n4 + this.b.nextInt(16) + 8;
            int n7 = this.b.nextInt(128);
            n3 = n5 + this.b.nextInt(16) + 8;
            this.i.a(this.a, this.b, n6, n7, n3);
        }
        if (this.j != null && !bl && this.b.nextInt(8) == 0) {
            int n8 = n4 + this.b.nextInt(16) + 8;
            int n9 = this.b.nextInt(this.b.nextInt(120) + 8);
            n3 = n5 + this.b.nextInt(16) + 8;
            if (n9 < 63 || this.b.nextInt(10) == 0) {
                this.j.a(this.a, this.b, n8, n9, n3);
            }
        }
        if (this.h) {
            for (int i = 0; i < 8; ++i) {
                int n10 = n4 + this.b.nextInt(16) + 8;
                n3 = this.b.nextInt(128);
                int n11 = n5 + this.b.nextInt(16) + 8;
                new WorldGenDungeons().a(this.a, this.b, n10, n3, n11);
            }
        }
        if (this.g) {
            biomeBase.a(this.a, this.b, n4, n5);
        }
    }

    @Override
    public boolean saveChunks(boolean bl, IProgressUpdate iProgressUpdate) {
        return true;
    }

    @Override
    public void b() {
    }

    @Override
    public boolean unloadChunks() {
        return false;
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public String getName() {
        return "FlatLevelSource";
    }

    @Override
    public List getMobsFor(EnumCreatureType enumCreatureType, int n, int n2, int n3) {
        BiomeBase biomeBase = this.a.getBiome(n, n3);
        if (biomeBase == null) {
            return null;
        }
        return biomeBase.getMobs(enumCreatureType);
    }

    @Override
    public ChunkPosition findNearestMapFeature(World world, String string, int n, int n2, int n3) {
        if ("Stronghold".equals(string)) {
            for (StructureGenerator structureGenerator : this.f) {
                if (!(structureGenerator instanceof WorldGenStronghold)) continue;
                return structureGenerator.getNearestGeneratedFeature(world, n, n2, n3);
            }
        }
        return null;
    }

    @Override
    public int getLoadedChunks() {
        return 0;
    }

    @Override
    public void recreateStructures(int n, int n2) {
        for (StructureGenerator structureGenerator : this.f) {
            structureGenerator.a(this, this.a, n, n2, null);
        }
    }
}

