/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Random;
import net.minecraft.server.Block;
import net.minecraft.server.CreativeModeTab;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityArrow;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityTNTPrimed;
import net.minecraft.server.Explosion;
import net.minecraft.server.Item;
import net.minecraft.server.Material;
import net.minecraft.server.World;

public class BlockTNT
extends Block {
    public BlockTNT(int n) {
        super(n, Material.TNT);
        this.a(CreativeModeTab.d);
    }

    @Override
    public void onPlace(World world, int n, int n2, int n3) {
        super.onPlace(world, n, n2, n3);
        if (world.isBlockIndirectlyPowered(n, n2, n3)) {
            this.postBreak(world, n, n2, n3, 1);
            world.setAir(n, n2, n3);
        }
    }

    @Override
    public void doPhysics(World world, int n, int n2, int n3, int n4) {
        if (world.isBlockIndirectlyPowered(n, n2, n3)) {
            this.postBreak(world, n, n2, n3, 1);
            world.setAir(n, n2, n3);
        }
    }

    @Override
    public int a(Random random) {
        return 1;
    }

    @Override
    public void wasExploded(World world, int n, int n2, int n3, Explosion explosion) {
        if (world.isStatic) {
            return;
        }
        EntityTNTPrimed entityTNTPrimed = new EntityTNTPrimed(world, (float)n + 0.5f, (float)n2 + 0.5f, (float)n3 + 0.5f, explosion.c());
        entityTNTPrimed.fuseTicks = world.random.nextInt(entityTNTPrimed.fuseTicks / 4) + entityTNTPrimed.fuseTicks / 8;
        world.addEntity(entityTNTPrimed);
    }

    @Override
    public void postBreak(World world, int n, int n2, int n3, int n4) {
        this.a(world, n, n2, n3, n4, (EntityLiving)null);
    }

    public void a(World world, int n, int n2, int n3, int n4, EntityLiving entityLiving) {
        if (world.isStatic) {
            return;
        }
        if ((n4 & 1) == 1) {
            EntityTNTPrimed entityTNTPrimed = new EntityTNTPrimed(world, (float)n + 0.5f, (float)n2 + 0.5f, (float)n3 + 0.5f, entityLiving);
            world.addEntity(entityTNTPrimed);
            world.makeSound(entityTNTPrimed, "random.fuse", 1.0f, 1.0f);
        }
    }

    @Override
    public boolean interact(World world, int n, int n2, int n3, EntityHuman entityHuman, int n4, float f, float f2, float f3) {
        if (entityHuman.by() != null && entityHuman.by().id == Item.FLINT_AND_STEEL.id) {
            this.a(world, n, n2, n3, 1, (EntityLiving)entityHuman);
            world.setAir(n, n2, n3);
            entityHuman.by().damage(1, entityHuman);
            return true;
        }
        return super.interact(world, n, n2, n3, entityHuman, n4, f, f2, f3);
    }

    @Override
    public void a(World world, int n, int n2, int n3, Entity entity) {
        EntityArrow entityArrow;
        if (entity instanceof EntityArrow && !world.isStatic && (entityArrow = (EntityArrow)entity).isBurning()) {
            this.a(world, n, n2, n3, 1, entityArrow.shooter instanceof EntityLiving ? (EntityLiving)entityArrow.shooter : null);
            world.setAir(n, n2, n3);
        }
    }

    @Override
    public boolean a(Explosion explosion) {
        return false;
    }
}

