/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Random;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.Material;
import net.minecraft.server.World;

public class BlockSoil
extends Block {
    protected BlockSoil(int n) {
        super(n, Material.EARTH);
        this.b(true);
        this.a(0.0f, 0.0f, 0.0f, 1.0f, 0.9375f, 1.0f);
        this.k(255);
    }

    @Override
    public AxisAlignedBB b(World world, int n, int n2, int n3) {
        return AxisAlignedBB.a().a(n + 0, n2 + 0, n3 + 0, n + 1, n2 + 1, n3 + 1);
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public void a(World world, int n, int n2, int n3, Random random) {
        if (this.m(world, n, n2, n3) || world.isRainingAt(n, n2 + 1, n3)) {
            world.setData(n, n2, n3, 7, 2);
        } else {
            int n4 = world.getData(n, n2, n3);
            if (n4 > 0) {
                world.setData(n, n2, n3, n4 - 1, 2);
            } else if (!this.k(world, n, n2, n3)) {
                world.setTypeIdUpdate(n, n2, n3, Block.DIRT.id);
            }
        }
    }

    @Override
    public void a(World world, int n, int n2, int n3, Entity entity, float f) {
        if (!world.isStatic && world.random.nextFloat() < f - 0.5f) {
            if (!(entity instanceof EntityHuman) && !world.getGameRules().getBoolean("mobGriefing")) {
                return;
            }
            world.setTypeIdUpdate(n, n2, n3, Block.DIRT.id);
        }
    }

    private boolean k(World world, int n, int n2, int n3) {
        int n4 = 0;
        for (int i = n - n4; i <= n + n4; ++i) {
            for (int j = n3 - n4; j <= n3 + n4; ++j) {
                int n5 = world.getTypeId(i, n2 + 1, j);
                if (n5 != Block.CROPS.id && n5 != Block.MELON_STEM.id && n5 != Block.PUMPKIN_STEM.id && n5 != Block.POTATOES.id && n5 != Block.CARROTS.id) continue;
                return true;
            }
        }
        return false;
    }

    private boolean m(World world, int n, int n2, int n3) {
        for (int i = n - 4; i <= n + 4; ++i) {
            for (int j = n2; j <= n2 + 1; ++j) {
                for (int k = n3 - 4; k <= n3 + 4; ++k) {
                    if (world.getMaterial(i, j, k) != Material.WATER) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void doPhysics(World world, int n, int n2, int n3, int n4) {
        super.doPhysics(world, n, n2, n3, n4);
        Material material = world.getMaterial(n, n2 + 1, n3);
        if (material.isBuildable()) {
            world.setTypeIdUpdate(n, n2, n3, Block.DIRT.id);
        }
    }

    @Override
    public int getDropType(int n, Random random, int n2) {
        return Block.DIRT.getDropType(0, random, n2);
    }
}

