/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Random;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.CreativeModeTab;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EnumSkyBlock;
import net.minecraft.server.IBlockAccess;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.StatisticList;
import net.minecraft.server.World;

public class BlockSnow
extends Block {
    protected BlockSnow(int n) {
        super(n, Material.SNOW_LAYER);
        this.a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        this.b(true);
        this.a(CreativeModeTab.c);
        this.d(0);
    }

    @Override
    public AxisAlignedBB b(World world, int n, int n2, int n3) {
        int n4 = world.getData(n, n2, n3) & 7;
        float f = 0.125f;
        return AxisAlignedBB.a().a((double)n + this.minX, (double)n2 + this.minY, (double)n3 + this.minZ, (double)n + this.maxX, (float)n2 + (float)n4 * f, (double)n3 + this.maxZ);
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public void g() {
        this.d(0);
    }

    @Override
    public void updateShape(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        this.d(iBlockAccess.getData(n, n2, n3));
    }

    protected void d(int n) {
        int n2 = n & 7;
        float f = (float)(2 * (1 + n2)) / 16.0f;
        this.a(0.0f, 0.0f, 0.0f, 1.0f, f, 1.0f);
    }

    @Override
    public boolean canPlace(World world, int n, int n2, int n3) {
        int n4 = world.getTypeId(n, n2 - 1, n3);
        if (n4 == 0) {
            return false;
        }
        if (n4 == this.id && (world.getData(n, n2 - 1, n3) & 7) == 7) {
            return true;
        }
        if (n4 != Block.LEAVES.id && !Block.byId[n4].c()) {
            return false;
        }
        return world.getMaterial(n, n2 - 1, n3).isSolid();
    }

    @Override
    public void doPhysics(World world, int n, int n2, int n3, int n4) {
        this.m(world, n, n2, n3);
    }

    private boolean m(World world, int n, int n2, int n3) {
        if (!this.canPlace(world, n, n2, n3)) {
            this.c(world, n, n2, n3, world.getData(n, n2, n3), 0);
            world.setAir(n, n2, n3);
            return false;
        }
        return true;
    }

    @Override
    public void a(World world, EntityHuman entityHuman, int n, int n2, int n3, int n4) {
        int n5 = Item.SNOW_BALL.id;
        int n6 = n4 & 7;
        this.b(world, n, n2, n3, new ItemStack(n5, n6 + 1, 0));
        world.setAir(n, n2, n3);
        entityHuman.a(StatisticList.C[this.id], 1);
    }

    @Override
    public int getDropType(int n, Random random, int n2) {
        return Item.SNOW_BALL.id;
    }

    @Override
    public int a(Random random) {
        return 0;
    }

    @Override
    public void a(World world, int n, int n2, int n3, Random random) {
        if (world.b(EnumSkyBlock.BLOCK, n, n2, n3) > 11) {
            this.c(world, n, n2, n3, world.getData(n, n2, n3), 0);
            world.setAir(n, n2, n3);
        }
    }
}

