/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Random;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.BlockContainer;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityWither;
import net.minecraft.server.IBlockAccess;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.TileEntity;
import net.minecraft.server.TileEntitySkull;
import net.minecraft.server.World;

public class BlockSkull
extends BlockContainer {
    protected BlockSkull(int n) {
        super(n, Material.ORIENTABLE);
        this.a(0.25f, 0.0f, 0.25f, 0.75f, 0.5f, 0.75f);
    }

    @Override
    public int d() {
        return -1;
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public void updateShape(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        int n4 = iBlockAccess.getData(n, n2, n3) & 7;
        switch (n4) {
            default: {
                this.a(0.25f, 0.0f, 0.25f, 0.75f, 0.5f, 0.75f);
                break;
            }
            case 2: {
                this.a(0.25f, 0.25f, 0.5f, 0.75f, 0.75f, 1.0f);
                break;
            }
            case 3: {
                this.a(0.25f, 0.25f, 0.0f, 0.75f, 0.75f, 0.5f);
                break;
            }
            case 4: {
                this.a(0.5f, 0.25f, 0.25f, 1.0f, 0.75f, 0.75f);
                break;
            }
            case 5: {
                this.a(0.0f, 0.25f, 0.25f, 0.5f, 0.75f, 0.75f);
            }
        }
    }

    @Override
    public AxisAlignedBB b(World world, int n, int n2, int n3) {
        this.updateShape(world, n, n2, n3);
        return super.b(world, n, n2, n3);
    }

    @Override
    public void postPlace(World world, int n, int n2, int n3, EntityLiving entityLiving, ItemStack itemStack) {
        int n4 = MathHelper.floor((double)(entityLiving.yaw * 4.0f / 360.0f) + 2.5) & 3;
        world.setData(n, n2, n3, n4, 2);
    }

    @Override
    public TileEntity b(World world) {
        return new TileEntitySkull();
    }

    @Override
    public int getDropData(World world, int n, int n2, int n3) {
        TileEntity tileEntity = world.getTileEntity(n, n2, n3);
        if (tileEntity != null && tileEntity instanceof TileEntitySkull) {
            return ((TileEntitySkull)tileEntity).getSkullType();
        }
        return super.getDropData(world, n, n2, n3);
    }

    @Override
    public int getDropData(int n) {
        return n;
    }

    @Override
    public void dropNaturally(World world, int n, int n2, int n3, int n4, float f, int n5) {
    }

    @Override
    public void a(World world, int n, int n2, int n3, int n4, EntityHuman entityHuman) {
        if (entityHuman.abilities.canInstantlyBuild) {
            world.setData(n, n2, n3, n4 |= 8, 4);
        }
        super.a(world, n, n2, n3, n4, entityHuman);
    }

    @Override
    public void remove(World world, int n, int n2, int n3, int n4, int n5) {
        if (world.isStatic) {
            return;
        }
        if ((n5 & 8) == 0) {
            ItemStack itemStack = new ItemStack(Item.SKULL.id, 1, this.getDropData(world, n, n2, n3));
            TileEntitySkull tileEntitySkull = (TileEntitySkull)world.getTileEntity(n, n2, n3);
            if (tileEntitySkull.getSkullType() == 3 && tileEntitySkull.getExtraType() != null && tileEntitySkull.getExtraType().length() > 0) {
                itemStack.setTag(new NBTTagCompound());
                itemStack.getTag().setString("SkullOwner", tileEntitySkull.getExtraType());
            }
            this.b(world, n, n2, n3, itemStack);
        }
        super.remove(world, n, n2, n3, n4, n5);
    }

    @Override
    public int getDropType(int n, Random random, int n2) {
        return Item.SKULL.id;
    }

    public void a(World world, int n, int n2, int n3, TileEntitySkull tileEntitySkull) {
        if (tileEntitySkull.getSkullType() == 1 && n2 >= 2 && world.difficulty > 0 && !world.isStatic) {
            int n4;
            int n5 = Block.SOUL_SAND.id;
            for (n4 = -2; n4 <= 0; ++n4) {
                if (world.getTypeId(n, n2 - 1, n3 + n4) != n5 || world.getTypeId(n, n2 - 1, n3 + n4 + 1) != n5 || world.getTypeId(n, n2 - 2, n3 + n4 + 1) != n5 || world.getTypeId(n, n2 - 1, n3 + n4 + 2) != n5 || !this.d(world, n, n2, n3 + n4, 1) || !this.d(world, n, n2, n3 + n4 + 1, 1) || !this.d(world, n, n2, n3 + n4 + 2, 1)) continue;
                world.setData(n, n2, n3 + n4, 8, 2);
                world.setData(n, n2, n3 + n4 + 1, 8, 2);
                world.setData(n, n2, n3 + n4 + 2, 8, 2);
                world.setTypeIdAndData(n, n2, n3 + n4, 0, 0, 2);
                world.setTypeIdAndData(n, n2, n3 + n4 + 1, 0, 0, 2);
                world.setTypeIdAndData(n, n2, n3 + n4 + 2, 0, 0, 2);
                world.setTypeIdAndData(n, n2 - 1, n3 + n4, 0, 0, 2);
                world.setTypeIdAndData(n, n2 - 1, n3 + n4 + 1, 0, 0, 2);
                world.setTypeIdAndData(n, n2 - 1, n3 + n4 + 2, 0, 0, 2);
                world.setTypeIdAndData(n, n2 - 2, n3 + n4 + 1, 0, 0, 2);
                if (!world.isStatic) {
                    EntityWither entityWither = new EntityWither(world);
                    entityWither.setPositionRotation((double)n + 0.5, (double)n2 - 1.45, (double)(n3 + n4) + 1.5, 90.0f, 0.0f);
                    entityWither.aN = 90.0f;
                    entityWither.bT();
                    world.addEntity(entityWither);
                }
                for (int i = 0; i < 120; ++i) {
                    world.addParticle("snowballpoof", (double)n + world.random.nextDouble(), (double)(n2 - 2) + world.random.nextDouble() * 3.9, (double)(n3 + n4 + 1) + world.random.nextDouble(), 0.0, 0.0, 0.0);
                }
                world.update(n, n2, n3 + n4, 0);
                world.update(n, n2, n3 + n4 + 1, 0);
                world.update(n, n2, n3 + n4 + 2, 0);
                world.update(n, n2 - 1, n3 + n4, 0);
                world.update(n, n2 - 1, n3 + n4 + 1, 0);
                world.update(n, n2 - 1, n3 + n4 + 2, 0);
                world.update(n, n2 - 2, n3 + n4 + 1, 0);
                return;
            }
            for (n4 = -2; n4 <= 0; ++n4) {
                if (world.getTypeId(n + n4, n2 - 1, n3) != n5 || world.getTypeId(n + n4 + 1, n2 - 1, n3) != n5 || world.getTypeId(n + n4 + 1, n2 - 2, n3) != n5 || world.getTypeId(n + n4 + 2, n2 - 1, n3) != n5 || !this.d(world, n + n4, n2, n3, 1) || !this.d(world, n + n4 + 1, n2, n3, 1) || !this.d(world, n + n4 + 2, n2, n3, 1)) continue;
                world.setData(n + n4, n2, n3, 8, 2);
                world.setData(n + n4 + 1, n2, n3, 8, 2);
                world.setData(n + n4 + 2, n2, n3, 8, 2);
                world.setTypeIdAndData(n + n4, n2, n3, 0, 0, 2);
                world.setTypeIdAndData(n + n4 + 1, n2, n3, 0, 0, 2);
                world.setTypeIdAndData(n + n4 + 2, n2, n3, 0, 0, 2);
                world.setTypeIdAndData(n + n4, n2 - 1, n3, 0, 0, 2);
                world.setTypeIdAndData(n + n4 + 1, n2 - 1, n3, 0, 0, 2);
                world.setTypeIdAndData(n + n4 + 2, n2 - 1, n3, 0, 0, 2);
                world.setTypeIdAndData(n + n4 + 1, n2 - 2, n3, 0, 0, 2);
                if (!world.isStatic) {
                    EntityWither entityWither = new EntityWither(world);
                    entityWither.setPositionRotation((double)(n + n4) + 1.5, (double)n2 - 1.45, (double)n3 + 0.5, 0.0f, 0.0f);
                    entityWither.bT();
                    world.addEntity(entityWither);
                }
                for (int i = 0; i < 120; ++i) {
                    world.addParticle("snowballpoof", (double)(n + n4 + 1) + world.random.nextDouble(), (double)(n2 - 2) + world.random.nextDouble() * 3.9, (double)n3 + world.random.nextDouble(), 0.0, 0.0, 0.0);
                }
                world.update(n + n4, n2, n3, 0);
                world.update(n + n4 + 1, n2, n3, 0);
                world.update(n + n4 + 2, n2, n3, 0);
                world.update(n + n4, n2 - 1, n3, 0);
                world.update(n + n4 + 1, n2 - 1, n3, 0);
                world.update(n + n4 + 2, n2 - 1, n3, 0);
                world.update(n + n4 + 1, n2 - 2, n3, 0);
                return;
            }
        }
    }

    private boolean d(World world, int n, int n2, int n3, int n4) {
        if (world.getTypeId(n, n2, n3) != this.id) {
            return false;
        }
        TileEntity tileEntity = world.getTileEntity(n, n2, n3);
        if (tileEntity == null || !(tileEntity instanceof TileEntitySkull)) {
            return false;
        }
        return ((TileEntitySkull)tileEntity).getSkullType() == n4;
    }
}

