/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.ChunkPosition;
import net.minecraft.server.Direction;
import net.minecraft.server.IBlockAccess;
import net.minecraft.server.Item;
import net.minecraft.server.Material;
import net.minecraft.server.World;

public class BlockRedstoneWire
extends Block {
    private boolean a = true;
    private Set b = new HashSet();

    public BlockRedstoneWire(int n) {
        super(n, Material.ORIENTABLE);
        this.a(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
    }

    @Override
    public AxisAlignedBB b(World world, int n, int n2, int n3) {
        return null;
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public int d() {
        return 5;
    }

    @Override
    public boolean canPlace(World world, int n, int n2, int n3) {
        return world.w(n, n2 - 1, n3) || world.getTypeId(n, n2 - 1, n3) == Block.GLOWSTONE.id;
    }

    private void k(World world, int n, int n2, int n3) {
        this.a(world, n, n2, n3, n, n2, n3);
        ArrayList arrayList = new ArrayList(this.b);
        this.b.clear();
        for (int i = 0; i < arrayList.size(); ++i) {
            ChunkPosition chunkPosition = (ChunkPosition)arrayList.get(i);
            world.applyPhysics(chunkPosition.x, chunkPosition.y, chunkPosition.z, this.id);
        }
    }

    private void a(World world, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = world.getData(n, n2, n3);
        int n8 = 0;
        n8 = this.getPower(world, n4, n5, n6, n8);
        this.a = false;
        int n9 = world.getHighestNeighborSignal(n, n2, n3);
        this.a = true;
        if (n9 > 0 && n9 > n8 - 1) {
            n8 = n9;
        }
        int n10 = 0;
        for (int i = 0; i < 4; ++i) {
            int n11 = n;
            int n12 = n3;
            if (i == 0) {
                --n11;
            }
            if (i == 1) {
                ++n11;
            }
            if (i == 2) {
                --n12;
            }
            if (i == 3) {
                ++n12;
            }
            if (n11 != n4 || n12 != n6) {
                n10 = this.getPower(world, n11, n2, n12, n10);
            }
            if (world.u(n11, n2, n12) && !world.u(n, n2 + 1, n3)) {
                if (n11 == n4 && n12 == n6 || n2 < n5) continue;
                n10 = this.getPower(world, n11, n2 + 1, n12, n10);
                continue;
            }
            if (world.u(n11, n2, n12) || n11 == n4 && n12 == n6 || n2 > n5) continue;
            n10 = this.getPower(world, n11, n2 - 1, n12, n10);
        }
        n8 = n10 > n8 ? n10 - 1 : (n8 > 0 ? --n8 : 0);
        if (n9 > n8 - 1) {
            n8 = n9;
        }
        if (n7 != n8) {
            world.setData(n, n2, n3, n8, 2);
            this.b.add(new ChunkPosition(n, n2, n3));
            this.b.add(new ChunkPosition(n - 1, n2, n3));
            this.b.add(new ChunkPosition(n + 1, n2, n3));
            this.b.add(new ChunkPosition(n, n2 - 1, n3));
            this.b.add(new ChunkPosition(n, n2 + 1, n3));
            this.b.add(new ChunkPosition(n, n2, n3 - 1));
            this.b.add(new ChunkPosition(n, n2, n3 + 1));
        }
    }

    private void m(World world, int n, int n2, int n3) {
        if (world.getTypeId(n, n2, n3) != this.id) {
            return;
        }
        world.applyPhysics(n, n2, n3, this.id);
        world.applyPhysics(n - 1, n2, n3, this.id);
        world.applyPhysics(n + 1, n2, n3, this.id);
        world.applyPhysics(n, n2, n3 - 1, this.id);
        world.applyPhysics(n, n2, n3 + 1, this.id);
        world.applyPhysics(n, n2 - 1, n3, this.id);
        world.applyPhysics(n, n2 + 1, n3, this.id);
    }

    @Override
    public void onPlace(World world, int n, int n2, int n3) {
        super.onPlace(world, n, n2, n3);
        if (world.isStatic) {
            return;
        }
        this.k(world, n, n2, n3);
        world.applyPhysics(n, n2 + 1, n3, this.id);
        world.applyPhysics(n, n2 - 1, n3, this.id);
        this.m(world, n - 1, n2, n3);
        this.m(world, n + 1, n2, n3);
        this.m(world, n, n2, n3 - 1);
        this.m(world, n, n2, n3 + 1);
        if (world.u(n - 1, n2, n3)) {
            this.m(world, n - 1, n2 + 1, n3);
        } else {
            this.m(world, n - 1, n2 - 1, n3);
        }
        if (world.u(n + 1, n2, n3)) {
            this.m(world, n + 1, n2 + 1, n3);
        } else {
            this.m(world, n + 1, n2 - 1, n3);
        }
        if (world.u(n, n2, n3 - 1)) {
            this.m(world, n, n2 + 1, n3 - 1);
        } else {
            this.m(world, n, n2 - 1, n3 - 1);
        }
        if (world.u(n, n2, n3 + 1)) {
            this.m(world, n, n2 + 1, n3 + 1);
        } else {
            this.m(world, n, n2 - 1, n3 + 1);
        }
    }

    @Override
    public void remove(World world, int n, int n2, int n3, int n4, int n5) {
        super.remove(world, n, n2, n3, n4, n5);
        if (world.isStatic) {
            return;
        }
        world.applyPhysics(n, n2 + 1, n3, this.id);
        world.applyPhysics(n, n2 - 1, n3, this.id);
        world.applyPhysics(n + 1, n2, n3, this.id);
        world.applyPhysics(n - 1, n2, n3, this.id);
        world.applyPhysics(n, n2, n3 + 1, this.id);
        world.applyPhysics(n, n2, n3 - 1, this.id);
        this.k(world, n, n2, n3);
        this.m(world, n - 1, n2, n3);
        this.m(world, n + 1, n2, n3);
        this.m(world, n, n2, n3 - 1);
        this.m(world, n, n2, n3 + 1);
        if (world.u(n - 1, n2, n3)) {
            this.m(world, n - 1, n2 + 1, n3);
        } else {
            this.m(world, n - 1, n2 - 1, n3);
        }
        if (world.u(n + 1, n2, n3)) {
            this.m(world, n + 1, n2 + 1, n3);
        } else {
            this.m(world, n + 1, n2 - 1, n3);
        }
        if (world.u(n, n2, n3 - 1)) {
            this.m(world, n, n2 + 1, n3 - 1);
        } else {
            this.m(world, n, n2 - 1, n3 - 1);
        }
        if (world.u(n, n2, n3 + 1)) {
            this.m(world, n, n2 + 1, n3 + 1);
        } else {
            this.m(world, n, n2 - 1, n3 + 1);
        }
    }

    private int getPower(World world, int n, int n2, int n3, int n4) {
        if (world.getTypeId(n, n2, n3) != this.id) {
            return n4;
        }
        int n5 = world.getData(n, n2, n3);
        if (n5 > n4) {
            return n5;
        }
        return n4;
    }

    @Override
    public void doPhysics(World world, int n, int n2, int n3, int n4) {
        if (world.isStatic) {
            return;
        }
        boolean bl = this.canPlace(world, n, n2, n3);
        if (bl) {
            this.k(world, n, n2, n3);
        } else {
            this.c(world, n, n2, n3, 0, 0);
            world.setAir(n, n2, n3);
        }
        super.doPhysics(world, n, n2, n3, n4);
    }

    @Override
    public int getDropType(int n, Random random, int n2) {
        return Item.REDSTONE.id;
    }

    @Override
    public int c(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        if (!this.a) {
            return 0;
        }
        return this.b(iBlockAccess, n, n2, n3, n4);
    }

    @Override
    public int b(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        boolean bl;
        if (!this.a) {
            return 0;
        }
        int n5 = iBlockAccess.getData(n, n2, n3);
        if (n5 == 0) {
            return 0;
        }
        if (n4 == 1) {
            return n5;
        }
        boolean bl2 = BlockRedstoneWire.g(iBlockAccess, n - 1, n2, n3, 1) || !iBlockAccess.u(n - 1, n2, n3) && BlockRedstoneWire.g(iBlockAccess, n - 1, n2 - 1, n3, -1);
        boolean bl3 = BlockRedstoneWire.g(iBlockAccess, n + 1, n2, n3, 3) || !iBlockAccess.u(n + 1, n2, n3) && BlockRedstoneWire.g(iBlockAccess, n + 1, n2 - 1, n3, -1);
        boolean bl4 = BlockRedstoneWire.g(iBlockAccess, n, n2, n3 - 1, 2) || !iBlockAccess.u(n, n2, n3 - 1) && BlockRedstoneWire.g(iBlockAccess, n, n2 - 1, n3 - 1, -1);
        boolean bl5 = bl = BlockRedstoneWire.g(iBlockAccess, n, n2, n3 + 1, 0) || !iBlockAccess.u(n, n2, n3 + 1) && BlockRedstoneWire.g(iBlockAccess, n, n2 - 1, n3 + 1, -1);
        if (!iBlockAccess.u(n, n2 + 1, n3)) {
            if (iBlockAccess.u(n - 1, n2, n3) && BlockRedstoneWire.g(iBlockAccess, n - 1, n2 + 1, n3, -1)) {
                bl2 = true;
            }
            if (iBlockAccess.u(n + 1, n2, n3) && BlockRedstoneWire.g(iBlockAccess, n + 1, n2 + 1, n3, -1)) {
                bl3 = true;
            }
            if (iBlockAccess.u(n, n2, n3 - 1) && BlockRedstoneWire.g(iBlockAccess, n, n2 + 1, n3 - 1, -1)) {
                bl4 = true;
            }
            if (iBlockAccess.u(n, n2, n3 + 1) && BlockRedstoneWire.g(iBlockAccess, n, n2 + 1, n3 + 1, -1)) {
                bl = true;
            }
        }
        if (!(bl4 || bl3 || bl2 || bl || n4 < 2 || n4 > 5)) {
            return n5;
        }
        if (n4 == 2 && bl4 && !bl2 && !bl3) {
            return n5;
        }
        if (n4 == 3 && bl && !bl2 && !bl3) {
            return n5;
        }
        if (n4 == 4 && bl2 && !bl4 && !bl) {
            return n5;
        }
        if (n4 == 5 && bl3 && !bl4 && !bl) {
            return n5;
        }
        return 0;
    }

    @Override
    public boolean isPowerSource() {
        return this.a;
    }

    public static boolean f(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        int n5 = iBlockAccess.getTypeId(n, n2, n3);
        if (n5 == Block.REDSTONE_WIRE.id) {
            return true;
        }
        if (n5 == 0) {
            return false;
        }
        if (Block.DIODE_OFF.g(n5)) {
            int n6 = iBlockAccess.getData(n, n2, n3);
            return n4 == (n6 & 3) || n4 == Direction.f[n6 & 3];
        }
        return Block.byId[n5].isPowerSource() && n4 != -1;
    }

    public static boolean g(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        if (BlockRedstoneWire.f(iBlockAccess, n, n2, n3, n4)) {
            return true;
        }
        int n5 = iBlockAccess.getTypeId(n, n2, n3);
        if (n5 == Block.DIODE_ON.id) {
            int n6 = iBlockAccess.getData(n, n2, n3);
            return n4 == (n6 & 3);
        }
        return false;
    }
}

