/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Block;
import net.minecraft.server.BlockDirectional;
import net.minecraft.server.CreativeModeTab;
import net.minecraft.server.EntityIronGolem;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntitySnowman;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.World;

public class BlockPumpkin
extends BlockDirectional {
    private boolean a;

    protected BlockPumpkin(int n, boolean bl) {
        super(n, Material.PUMPKIN);
        this.b(true);
        this.a = bl;
        this.a(CreativeModeTab.b);
    }

    @Override
    public void onPlace(World world, int n, int n2, int n3) {
        super.onPlace(world, n, n2, n3);
        if (world.getTypeId(n, n2 - 1, n3) == Block.SNOW_BLOCK.id && world.getTypeId(n, n2 - 2, n3) == Block.SNOW_BLOCK.id) {
            if (!world.isStatic) {
                world.setTypeIdAndData(n, n2, n3, 0, 0, 2);
                world.setTypeIdAndData(n, n2 - 1, n3, 0, 0, 2);
                world.setTypeIdAndData(n, n2 - 2, n3, 0, 0, 2);
                EntitySnowman entitySnowman = new EntitySnowman(world);
                entitySnowman.setPositionRotation((double)n + 0.5, (double)n2 - 1.95, (double)n3 + 0.5, 0.0f, 0.0f);
                world.addEntity(entitySnowman);
                world.update(n, n2, n3, 0);
                world.update(n, n2 - 1, n3, 0);
                world.update(n, n2 - 2, n3, 0);
            }
            for (int i = 0; i < 120; ++i) {
                world.addParticle("snowshovel", (double)n + world.random.nextDouble(), (double)(n2 - 2) + world.random.nextDouble() * 2.5, (double)n3 + world.random.nextDouble(), 0.0, 0.0, 0.0);
            }
        } else if (world.getTypeId(n, n2 - 1, n3) == Block.IRON_BLOCK.id && world.getTypeId(n, n2 - 2, n3) == Block.IRON_BLOCK.id) {
            boolean bl;
            boolean bl2 = world.getTypeId(n - 1, n2 - 1, n3) == Block.IRON_BLOCK.id && world.getTypeId(n + 1, n2 - 1, n3) == Block.IRON_BLOCK.id;
            boolean bl3 = bl = world.getTypeId(n, n2 - 1, n3 - 1) == Block.IRON_BLOCK.id && world.getTypeId(n, n2 - 1, n3 + 1) == Block.IRON_BLOCK.id;
            if (bl2 || bl) {
                world.setTypeIdAndData(n, n2, n3, 0, 0, 2);
                world.setTypeIdAndData(n, n2 - 1, n3, 0, 0, 2);
                world.setTypeIdAndData(n, n2 - 2, n3, 0, 0, 2);
                if (bl2) {
                    world.setTypeIdAndData(n - 1, n2 - 1, n3, 0, 0, 2);
                    world.setTypeIdAndData(n + 1, n2 - 1, n3, 0, 0, 2);
                } else {
                    world.setTypeIdAndData(n, n2 - 1, n3 - 1, 0, 0, 2);
                    world.setTypeIdAndData(n, n2 - 1, n3 + 1, 0, 0, 2);
                }
                EntityIronGolem entityIronGolem = new EntityIronGolem(world);
                entityIronGolem.setPlayerCreated(true);
                entityIronGolem.setPositionRotation((double)n + 0.5, (double)n2 - 1.95, (double)n3 + 0.5, 0.0f, 0.0f);
                world.addEntity(entityIronGolem);
                for (int i = 0; i < 120; ++i) {
                    world.addParticle("snowballpoof", (double)n + world.random.nextDouble(), (double)(n2 - 2) + world.random.nextDouble() * 3.9, (double)n3 + world.random.nextDouble(), 0.0, 0.0, 0.0);
                }
                world.update(n, n2, n3, 0);
                world.update(n, n2 - 1, n3, 0);
                world.update(n, n2 - 2, n3, 0);
                if (bl2) {
                    world.update(n - 1, n2 - 1, n3, 0);
                    world.update(n + 1, n2 - 1, n3, 0);
                } else {
                    world.update(n, n2 - 1, n3 - 1, 0);
                    world.update(n, n2 - 1, n3 + 1, 0);
                }
            }
        }
    }

    @Override
    public boolean canPlace(World world, int n, int n2, int n3) {
        int n4 = world.getTypeId(n, n2, n3);
        return (n4 == 0 || Block.byId[n4].material.isReplaceable()) && world.w(n, n2 - 1, n3);
    }

    @Override
    public void postPlace(World world, int n, int n2, int n3, EntityLiving entityLiving, ItemStack itemStack) {
        int n4 = MathHelper.floor((double)(entityLiving.yaw * 4.0f / 360.0f) + 2.5) & 3;
        world.setData(n, n2, n3, n4, 2);
    }
}

