/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.BlockPistonMoving;
import net.minecraft.server.CreativeModeTab;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.Facing;
import net.minecraft.server.IBlockAccess;
import net.minecraft.server.IContainer;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.TileEntity;
import net.minecraft.server.TileEntityPiston;
import net.minecraft.server.World;

public class BlockPiston
extends Block {
    private final boolean a;

    public BlockPiston(int n, boolean bl) {
        super(n, Material.PISTON);
        this.a = bl;
        this.a(k);
        this.c(0.5f);
        this.a(CreativeModeTab.d);
    }

    @Override
    public int d() {
        return 16;
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean interact(World world, int n, int n2, int n3, EntityHuman entityHuman, int n4, float f, float f2, float f3) {
        return false;
    }

    @Override
    public void postPlace(World world, int n, int n2, int n3, EntityLiving entityLiving, ItemStack itemStack) {
        int n4 = BlockPiston.a(world, n, n2, n3, entityLiving);
        world.setData(n, n2, n3, n4, 2);
        if (!world.isStatic) {
            this.k(world, n, n2, n3);
        }
    }

    @Override
    public void doPhysics(World world, int n, int n2, int n3, int n4) {
        if (!world.isStatic) {
            this.k(world, n, n2, n3);
        }
    }

    @Override
    public void onPlace(World world, int n, int n2, int n3) {
        if (!world.isStatic && world.getTileEntity(n, n2, n3) == null) {
            this.k(world, n, n2, n3);
        }
    }

    private void k(World world, int n, int n2, int n3) {
        int n4 = world.getData(n, n2, n3);
        int n5 = BlockPiston.d(n4);
        if (n5 == 7) {
            return;
        }
        boolean bl = this.d(world, n, n2, n3, n5);
        if (bl && !BlockPiston.e(n4)) {
            if (BlockPiston.e(world, n, n2, n3, n5)) {
                world.playNote(n, n2, n3, this.id, 0, n5);
            }
        } else if (!bl && BlockPiston.e(n4)) {
            world.setData(n, n2, n3, n5, 2);
            world.playNote(n, n2, n3, this.id, 1, n5);
        }
    }

    private boolean d(World world, int n, int n2, int n3, int n4) {
        if (n4 != 0 && world.isBlockFacePowered(n, n2 - 1, n3, 0)) {
            return true;
        }
        if (n4 != 1 && world.isBlockFacePowered(n, n2 + 1, n3, 1)) {
            return true;
        }
        if (n4 != 2 && world.isBlockFacePowered(n, n2, n3 - 1, 2)) {
            return true;
        }
        if (n4 != 3 && world.isBlockFacePowered(n, n2, n3 + 1, 3)) {
            return true;
        }
        if (n4 != 5 && world.isBlockFacePowered(n + 1, n2, n3, 5)) {
            return true;
        }
        if (n4 != 4 && world.isBlockFacePowered(n - 1, n2, n3, 4)) {
            return true;
        }
        if (world.isBlockFacePowered(n, n2, n3, 0)) {
            return true;
        }
        if (world.isBlockFacePowered(n, n2 + 2, n3, 1)) {
            return true;
        }
        if (world.isBlockFacePowered(n, n2 + 1, n3 - 1, 2)) {
            return true;
        }
        if (world.isBlockFacePowered(n, n2 + 1, n3 + 1, 3)) {
            return true;
        }
        if (world.isBlockFacePowered(n - 1, n2 + 1, n3, 4)) {
            return true;
        }
        return world.isBlockFacePowered(n + 1, n2 + 1, n3, 5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean b(World world, int n, int n2, int n3, int n4, int n5) {
        if (!world.isStatic) {
            boolean bl = this.d(world, n, n2, n3, n5);
            if (bl && n4 == 1) {
                world.setData(n, n2, n3, n5 | 8, 2);
                return false;
            }
            if (!bl && n4 == 0) {
                return false;
            }
        }
        if (n4 == 0) {
            if (!this.f(world, n, n2, n3, n5)) return false;
            world.setData(n, n2, n3, n5 | 8, 2);
            world.makeSound((double)n + 0.5, (double)n2 + 0.5, (double)n3 + 0.5, "tile.piston.out", 0.5f, world.random.nextFloat() * 0.25f + 0.6f);
            return true;
        } else {
            if (n4 != 1) return true;
            TileEntity tileEntity = world.getTileEntity(n + Facing.b[n5], n2 + Facing.c[n5], n3 + Facing.d[n5]);
            if (tileEntity instanceof TileEntityPiston) {
                ((TileEntityPiston)tileEntity).f();
            }
            world.setTypeIdAndData(n, n2, n3, Block.PISTON_MOVING.id, n5, 3);
            world.setTileEntity(n, n2, n3, BlockPistonMoving.a(this.id, n5, n5, false, true));
            if (this.a) {
                TileEntityPiston tileEntityPiston;
                TileEntity tileEntity2;
                int n6 = n + Facing.b[n5] * 2;
                int n7 = n2 + Facing.c[n5] * 2;
                int n8 = n3 + Facing.d[n5] * 2;
                int n9 = world.getTypeId(n6, n7, n8);
                int n10 = world.getData(n6, n7, n8);
                boolean bl = false;
                if (n9 == Block.PISTON_MOVING.id && (tileEntity2 = world.getTileEntity(n6, n7, n8)) instanceof TileEntityPiston && (tileEntityPiston = (TileEntityPiston)tileEntity2).c() == n5 && tileEntityPiston.b()) {
                    tileEntityPiston.f();
                    n9 = tileEntityPiston.a();
                    n10 = tileEntityPiston.p();
                    bl = true;
                }
                if (!bl && n9 > 0 && BlockPiston.a(n9, world, n6, n7, n8, false) && (Block.byId[n9].h() == 0 || n9 == Block.PISTON.id || n9 == Block.PISTON_STICKY.id)) {
                    world.setTypeIdAndData(n += Facing.b[n5], n2 += Facing.c[n5], n3 += Facing.d[n5], Block.PISTON_MOVING.id, n10, 3);
                    world.setTileEntity(n, n2, n3, BlockPistonMoving.a(n9, n10, n5, false, false));
                    world.setAir(n6, n7, n8);
                } else if (!bl) {
                    world.setAir(n + Facing.b[n5], n2 + Facing.c[n5], n3 + Facing.d[n5]);
                }
            } else {
                world.setAir(n + Facing.b[n5], n2 + Facing.c[n5], n3 + Facing.d[n5]);
            }
            world.makeSound((double)n + 0.5, (double)n2 + 0.5, (double)n3 + 0.5, "tile.piston.in", 0.5f, world.random.nextFloat() * 0.15f + 0.6f);
        }
        return true;
    }

    @Override
    public void updateShape(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        int n4 = iBlockAccess.getData(n, n2, n3);
        if (BlockPiston.e(n4)) {
            float f = 0.25f;
            switch (BlockPiston.d(n4)) {
                case 0: {
                    this.a(0.0f, 0.25f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 1: {
                    this.a(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
                    break;
                }
                case 2: {
                    this.a(0.0f, 0.0f, 0.25f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 3: {
                    this.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.75f);
                    break;
                }
                case 4: {
                    this.a(0.25f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 5: {
                    this.a(0.0f, 0.0f, 0.0f, 0.75f, 1.0f, 1.0f);
                }
            }
        } else {
            this.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @Override
    public void g() {
        this.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void a(World world, int n, int n2, int n3, AxisAlignedBB axisAlignedBB, List list, Entity entity) {
        this.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        super.a(world, n, n2, n3, axisAlignedBB, list, entity);
    }

    @Override
    public AxisAlignedBB b(World world, int n, int n2, int n3) {
        this.updateShape(world, n, n2, n3);
        return super.b(world, n, n2, n3);
    }

    @Override
    public boolean b() {
        return false;
    }

    public static int d(int n) {
        return n & 7;
    }

    public static boolean e(int n) {
        return (n & 8) != 0;
    }

    public static int a(World world, int n, int n2, int n3, EntityLiving entityLiving) {
        int n4;
        if (MathHelper.abs((float)entityLiving.locX - (float)n) < 2.0f && MathHelper.abs((float)entityLiving.locZ - (float)n3) < 2.0f) {
            double d = entityLiving.locY + 1.82 - (double)entityLiving.height;
            if (d - (double)n2 > 2.0) {
                return 1;
            }
            if ((double)n2 - d > 0.0) {
                return 0;
            }
        }
        if ((n4 = MathHelper.floor((double)(entityLiving.yaw * 4.0f / 360.0f) + 0.5) & 3) == 0) {
            return 2;
        }
        if (n4 == 1) {
            return 5;
        }
        if (n4 == 2) {
            return 3;
        }
        if (n4 == 3) {
            return 4;
        }
        return 0;
    }

    private static boolean a(int n, World world, int n2, int n3, int n4, boolean bl) {
        if (n == Block.OBSIDIAN.id) {
            return false;
        }
        if (n == Block.PISTON.id || n == Block.PISTON_STICKY.id) {
            if (BlockPiston.e(world.getData(n2, n3, n4))) {
                return false;
            }
        } else {
            if (Block.byId[n].l(world, n2, n3, n4) == -1.0f) {
                return false;
            }
            if (Block.byId[n].h() == 2) {
                return false;
            }
            if (Block.byId[n].h() == 1) {
                return bl;
            }
        }
        return !(Block.byId[n] instanceof IContainer);
    }

    private static boolean e(World world, int n, int n2, int n3, int n4) {
        int n5 = n + Facing.b[n4];
        int n6 = n2 + Facing.c[n4];
        int n7 = n3 + Facing.d[n4];
        for (int i = 0; i < 13; ++i) {
            if (n6 <= 0 || n6 >= 255) {
                return false;
            }
            int n8 = world.getTypeId(n5, n6, n7);
            if (n8 == 0) break;
            if (!BlockPiston.a(n8, world, n5, n6, n7, true)) {
                return false;
            }
            if (Block.byId[n8].h() == 1) break;
            if (i == 12) {
                return false;
            }
            n5 += Facing.b[n4];
            n6 += Facing.c[n4];
            n7 += Facing.d[n4];
        }
        return true;
    }

    private boolean f(World world, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = n + Facing.b[n4];
        int n11 = n2 + Facing.c[n4];
        int n12 = n3 + Facing.d[n4];
        for (n9 = 0; n9 < 13; ++n9) {
            if (n11 <= 0 || n11 >= 255) {
                return false;
            }
            n8 = world.getTypeId(n10, n11, n12);
            if (n8 == 0) break;
            if (!BlockPiston.a(n8, world, n10, n11, n12, true)) {
                return false;
            }
            if (Block.byId[n8].h() == 1) {
                Block.byId[n8].c(world, n10, n11, n12, world.getData(n10, n11, n12), 0);
                world.setAir(n10, n11, n12);
                break;
            }
            if (n9 == 12) {
                return false;
            }
            n10 += Facing.b[n4];
            n11 += Facing.c[n4];
            n12 += Facing.d[n4];
        }
        n9 = n10;
        n8 = n11;
        int n13 = n12;
        int n14 = 0;
        int[] nArray = new int[13];
        while (n10 != n || n11 != n2 || n12 != n3) {
            n7 = n10 - Facing.b[n4];
            n6 = n11 - Facing.c[n4];
            n5 = n12 - Facing.d[n4];
            int n15 = world.getTypeId(n7, n6, n5);
            int n16 = world.getData(n7, n6, n5);
            if (n15 == this.id && n7 == n && n6 == n2 && n5 == n3) {
                world.setTypeIdAndData(n10, n11, n12, Block.PISTON_MOVING.id, n4 | (this.a ? 8 : 0), 4);
                world.setTileEntity(n10, n11, n12, BlockPistonMoving.a(Block.PISTON_EXTENSION.id, n4 | (this.a ? 8 : 0), n4, true, false));
            } else {
                world.setTypeIdAndData(n10, n11, n12, Block.PISTON_MOVING.id, n16, 4);
                world.setTileEntity(n10, n11, n12, BlockPistonMoving.a(n15, n16, n4, true, false));
            }
            nArray[n14++] = n15;
            n10 = n7;
            n11 = n6;
            n12 = n5;
        }
        n10 = n9;
        n11 = n8;
        n12 = n13;
        n14 = 0;
        while (n10 != n || n11 != n2 || n12 != n3) {
            n7 = n10 - Facing.b[n4];
            n6 = n11 - Facing.c[n4];
            n5 = n12 - Facing.d[n4];
            world.applyPhysics(n7, n6, n5, nArray[n14++]);
            n10 = n7;
            n11 = n6;
            n12 = n5;
        }
        return true;
    }
}

