/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.BlockContainer;
import net.minecraft.server.CreativeModeTab;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.TileEntity;
import net.minecraft.server.TileEntityRecordPlayer;
import net.minecraft.server.World;

public class BlockJukeBox
extends BlockContainer {
    protected BlockJukeBox(int n) {
        super(n, Material.WOOD);
        this.a(CreativeModeTab.c);
    }

    @Override
    public boolean interact(World world, int n, int n2, int n3, EntityHuman entityHuman, int n4, float f, float f2, float f3) {
        if (world.getData(n, n2, n3) == 0) {
            return false;
        }
        this.dropRecord(world, n, n2, n3);
        return true;
    }

    public void a(World world, int n, int n2, int n3, ItemStack itemStack) {
        if (world.isStatic) {
            return;
        }
        TileEntityRecordPlayer tileEntityRecordPlayer = (TileEntityRecordPlayer)world.getTileEntity(n, n2, n3);
        if (tileEntityRecordPlayer == null) {
            return;
        }
        tileEntityRecordPlayer.setRecord(itemStack.cloneItemStack());
        world.setData(n, n2, n3, 1, 2);
    }

    public void dropRecord(World world, int n, int n2, int n3) {
        if (world.isStatic) {
            return;
        }
        TileEntityRecordPlayer tileEntityRecordPlayer = (TileEntityRecordPlayer)world.getTileEntity(n, n2, n3);
        if (tileEntityRecordPlayer == null) {
            return;
        }
        ItemStack itemStack = tileEntityRecordPlayer.getRecord();
        if (itemStack == null) {
            return;
        }
        world.triggerEffect(1005, n, n2, n3, 0);
        world.a((String)null, n, n2, n3);
        tileEntityRecordPlayer.setRecord(null);
        world.setData(n, n2, n3, 0, 2);
        float f = 0.7f;
        double d = (double)(world.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d2 = (double)(world.random.nextFloat() * f) + (double)(1.0f - f) * 0.2 + 0.6;
        double d3 = (double)(world.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        ItemStack itemStack2 = itemStack.cloneItemStack();
        EntityItem entityItem = new EntityItem(world, (double)n + d, (double)n2 + d2, (double)n3 + d3, itemStack2);
        entityItem.pickupDelay = 10;
        world.addEntity(entityItem);
    }

    @Override
    public void remove(World world, int n, int n2, int n3, int n4, int n5) {
        this.dropRecord(world, n, n2, n3);
        super.remove(world, n, n2, n3, n4, n5);
    }

    @Override
    public void dropNaturally(World world, int n, int n2, int n3, int n4, float f, int n5) {
        if (world.isStatic) {
            return;
        }
        super.dropNaturally(world, n, n2, n3, n4, f, 0);
    }

    @Override
    public TileEntity b(World world) {
        return new TileEntityRecordPlayer();
    }

    @Override
    public boolean q_() {
        return true;
    }

    @Override
    public int b_(World world, int n, int n2, int n3, int n4) {
        ItemStack itemStack = ((TileEntityRecordPlayer)world.getTileEntity(n, n2, n3)).getRecord();
        return itemStack == null ? 0 : itemStack.id + 1 - Item.RECORD_1.id;
    }
}

