/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import java.util.Random;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.BlockContainer;
import net.minecraft.server.Container;
import net.minecraft.server.CreativeModeTab;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.Facing;
import net.minecraft.server.IBlockAccess;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.TileEntity;
import net.minecraft.server.TileEntityHopper;
import net.minecraft.server.World;

public class BlockHopper
extends BlockContainer {
    private final Random a = new Random();

    public BlockHopper(int n) {
        super(n, Material.ORE);
        this.a(CreativeModeTab.d);
        this.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void updateShape(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        this.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void a(World world, int n, int n2, int n3, AxisAlignedBB axisAlignedBB, List list, Entity entity) {
        this.a(0.0f, 0.0f, 0.0f, 1.0f, 0.625f, 1.0f);
        super.a(world, n, n2, n3, axisAlignedBB, list, entity);
        float f = 0.125f;
        this.a(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
        super.a(world, n, n2, n3, axisAlignedBB, list, entity);
        this.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
        super.a(world, n, n2, n3, axisAlignedBB, list, entity);
        this.a(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        super.a(world, n, n2, n3, axisAlignedBB, list, entity);
        this.a(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
        super.a(world, n, n2, n3, axisAlignedBB, list, entity);
        this.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public int getPlacedData(World world, int n, int n2, int n3, int n4, float f, float f2, float f3, int n5) {
        int n6 = Facing.OPPOSITE_FACING[n4];
        if (n6 == 1) {
            n6 = 0;
        }
        return n6;
    }

    @Override
    public TileEntity b(World world) {
        return new TileEntityHopper();
    }

    @Override
    public void postPlace(World world, int n, int n2, int n3, EntityLiving entityLiving, ItemStack itemStack) {
        super.postPlace(world, n, n2, n3, entityLiving, itemStack);
        if (itemStack.hasName()) {
            TileEntityHopper tileEntityHopper = BlockHopper.d(world, n, n2, n3);
            tileEntityHopper.a(itemStack.getName());
        }
    }

    @Override
    public void onPlace(World world, int n, int n2, int n3) {
        super.onPlace(world, n, n2, n3);
        this.k(world, n, n2, n3);
    }

    @Override
    public boolean interact(World world, int n, int n2, int n3, EntityHuman entityHuman, int n4, float f, float f2, float f3) {
        if (world.isStatic) {
            return true;
        }
        TileEntityHopper tileEntityHopper = BlockHopper.d(world, n, n2, n3);
        if (tileEntityHopper != null) {
            entityHuman.openHopper(tileEntityHopper);
        }
        return true;
    }

    @Override
    public void doPhysics(World world, int n, int n2, int n3, int n4) {
        this.k(world, n, n2, n3);
    }

    private void k(World world, int n, int n2, int n3) {
        boolean bl;
        int n4 = world.getData(n, n2, n3);
        int n5 = BlockHopper.c(n4);
        boolean bl2 = !world.isBlockIndirectlyPowered(n, n2, n3);
        if (bl2 != (bl = BlockHopper.d(n4))) {
            world.setData(n, n2, n3, n5 | (bl2 ? 0 : 8), 4);
        }
    }

    @Override
    public void remove(World world, int n, int n2, int n3, int n4, int n5) {
        TileEntityHopper tileEntityHopper = (TileEntityHopper)world.getTileEntity(n, n2, n3);
        if (tileEntityHopper != null) {
            for (int i = 0; i < tileEntityHopper.getSize(); ++i) {
                ItemStack itemStack = tileEntityHopper.getItem(i);
                if (itemStack == null) continue;
                float f = this.a.nextFloat() * 0.8f + 0.1f;
                float f2 = this.a.nextFloat() * 0.8f + 0.1f;
                float f3 = this.a.nextFloat() * 0.8f + 0.1f;
                while (itemStack.count > 0) {
                    int n6 = this.a.nextInt(21) + 10;
                    if (n6 > itemStack.count) {
                        n6 = itemStack.count;
                    }
                    itemStack.count -= n6;
                    EntityItem entityItem = new EntityItem(world, (float)n + f, (float)n2 + f2, (float)n3 + f3, new ItemStack(itemStack.id, n6, itemStack.getData()));
                    if (itemStack.hasTag()) {
                        entityItem.getItemStack().setTag((NBTTagCompound)itemStack.getTag().clone());
                    }
                    float f4 = 0.05f;
                    entityItem.motX = (float)this.a.nextGaussian() * f4;
                    entityItem.motY = (float)this.a.nextGaussian() * f4 + 0.2f;
                    entityItem.motZ = (float)this.a.nextGaussian() * f4;
                    world.addEntity(entityItem);
                }
            }
            world.m(n, n2, n3, n4);
        }
        super.remove(world, n, n2, n3, n4, n5);
    }

    @Override
    public int d() {
        return 38;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public boolean c() {
        return false;
    }

    public static int c(int n) {
        return n & 7;
    }

    public static boolean d(int n) {
        return (n & 8) != 8;
    }

    @Override
    public boolean q_() {
        return true;
    }

    @Override
    public int b_(World world, int n, int n2, int n3, int n4) {
        return Container.b(BlockHopper.d(world, n, n2, n3));
    }

    public static TileEntityHopper d(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        return (TileEntityHopper)iBlockAccess.getTileEntity(n, n2, n3);
    }
}

