/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Random;
import net.minecraft.server.Block;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.World;

public class BlockFlowerPot
extends Block {
    public BlockFlowerPot(int n) {
        super(n, Material.ORIENTABLE);
        this.g();
    }

    @Override
    public void g() {
        float f = 0.375f;
        float f2 = f / 2.0f;
        this.a(0.5f - f2, 0.0f, 0.5f - f2, 0.5f + f2, f, 0.5f + f2);
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public int d() {
        return 33;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public boolean interact(World world, int n, int n2, int n3, EntityHuman entityHuman, int n4, float f, float f2, float f3) {
        ItemStack itemStack = entityHuman.inventory.getItemInHand();
        if (itemStack == null) {
            return false;
        }
        if (world.getData(n, n2, n3) != 0) {
            return false;
        }
        int n5 = BlockFlowerPot.a(itemStack);
        if (n5 > 0) {
            world.setData(n, n2, n3, n5, 2);
            if (!entityHuman.abilities.canInstantlyBuild && --itemStack.count <= 0) {
                entityHuman.inventory.setItem(entityHuman.inventory.itemInHandIndex, null);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getDropData(World world, int n, int n2, int n3) {
        ItemStack itemStack = BlockFlowerPot.p_(world.getData(n, n2, n3));
        if (itemStack == null) {
            return Item.FLOWER_POT.id;
        }
        return itemStack.getData();
    }

    @Override
    public boolean canPlace(World world, int n, int n2, int n3) {
        return super.canPlace(world, n, n2, n3) && world.w(n, n2 - 1, n3);
    }

    @Override
    public void doPhysics(World world, int n, int n2, int n3, int n4) {
        if (!world.w(n, n2 - 1, n3)) {
            this.c(world, n, n2, n3, world.getData(n, n2, n3), 0);
            world.setAir(n, n2, n3);
        }
    }

    @Override
    public void dropNaturally(World world, int n, int n2, int n3, int n4, float f, int n5) {
        ItemStack itemStack;
        super.dropNaturally(world, n, n2, n3, n4, f, n5);
        if (n4 > 0 && (itemStack = BlockFlowerPot.p_(n4)) != null) {
            this.b(world, n, n2, n3, itemStack);
        }
    }

    @Override
    public int getDropType(int n, Random random, int n2) {
        return Item.FLOWER_POT.id;
    }

    public static ItemStack p_(int n) {
        switch (n) {
            case 1: {
                return new ItemStack(Block.RED_ROSE);
            }
            case 2: {
                return new ItemStack(Block.YELLOW_FLOWER);
            }
            case 9: {
                return new ItemStack(Block.CACTUS);
            }
            case 8: {
                return new ItemStack(Block.BROWN_MUSHROOM);
            }
            case 7: {
                return new ItemStack(Block.RED_MUSHROOM);
            }
            case 10: {
                return new ItemStack(Block.DEAD_BUSH);
            }
            case 3: {
                return new ItemStack(Block.SAPLING, 1, 0);
            }
            case 5: {
                return new ItemStack(Block.SAPLING, 1, 2);
            }
            case 4: {
                return new ItemStack(Block.SAPLING, 1, 1);
            }
            case 6: {
                return new ItemStack(Block.SAPLING, 1, 3);
            }
            case 11: {
                return new ItemStack(Block.LONG_GRASS, 1, 2);
            }
        }
        return null;
    }

    public static int a(ItemStack itemStack) {
        int n = itemStack.getItem().id;
        if (n == Block.RED_ROSE.id) {
            return 1;
        }
        if (n == Block.YELLOW_FLOWER.id) {
            return 2;
        }
        if (n == Block.CACTUS.id) {
            return 9;
        }
        if (n == Block.BROWN_MUSHROOM.id) {
            return 8;
        }
        if (n == Block.RED_MUSHROOM.id) {
            return 7;
        }
        if (n == Block.DEAD_BUSH.id) {
            return 10;
        }
        if (n == Block.SAPLING.id) {
            switch (itemStack.getData()) {
                case 0: {
                    return 3;
                }
                case 2: {
                    return 5;
                }
                case 1: {
                    return 4;
                }
                case 3: {
                    return 6;
                }
            }
        }
        if (n == Block.LONG_GRASS.id) {
            switch (itemStack.getData()) {
                case 2: {
                    return 11;
                }
            }
        }
        return 0;
    }
}

