/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.BlockDirectional;
import net.minecraft.server.CreativeModeTab;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.IBlockAccess;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.World;

public class BlockFenceGate
extends BlockDirectional {
    public BlockFenceGate(int n) {
        super(n, Material.WOOD);
        this.a(CreativeModeTab.d);
    }

    @Override
    public boolean canPlace(World world, int n, int n2, int n3) {
        if (!world.getMaterial(n, n2 - 1, n3).isBuildable()) {
            return false;
        }
        return super.canPlace(world, n, n2, n3);
    }

    @Override
    public AxisAlignedBB b(World world, int n, int n2, int n3) {
        int n4 = world.getData(n, n2, n3);
        if (BlockFenceGate.m_(n4)) {
            return null;
        }
        if (n4 == 2 || n4 == 0) {
            return AxisAlignedBB.a().a(n, n2, (float)n3 + 0.375f, n + 1, (float)n2 + 1.5f, (float)n3 + 0.625f);
        }
        return AxisAlignedBB.a().a((float)n + 0.375f, n2, n3, (float)n + 0.625f, (float)n2 + 1.5f, n3 + 1);
    }

    @Override
    public void updateShape(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        int n4 = BlockFenceGate.j(iBlockAccess.getData(n, n2, n3));
        if (n4 == 2 || n4 == 0) {
            this.a(0.0f, 0.0f, 0.375f, 1.0f, 1.0f, 0.625f);
        } else {
            this.a(0.375f, 0.0f, 0.0f, 0.625f, 1.0f, 1.0f);
        }
    }

    @Override
    public boolean c() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public boolean b(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        return BlockFenceGate.m_(iBlockAccess.getData(n, n2, n3));
    }

    @Override
    public int d() {
        return 21;
    }

    @Override
    public void postPlace(World world, int n, int n2, int n3, EntityLiving entityLiving, ItemStack itemStack) {
        int n4 = (MathHelper.floor((double)(entityLiving.yaw * 4.0f / 360.0f) + 0.5) & 3) % 4;
        world.setData(n, n2, n3, n4, 2);
    }

    @Override
    public boolean interact(World world, int n, int n2, int n3, EntityHuman entityHuman, int n4, float f, float f2, float f3) {
        int n5 = world.getData(n, n2, n3);
        if (BlockFenceGate.m_(n5)) {
            world.setData(n, n2, n3, n5 & 0xFFFFFFFB, 2);
        } else {
            int n6 = (MathHelper.floor((double)(entityHuman.yaw * 4.0f / 360.0f) + 0.5) & 3) % 4;
            int n7 = BlockFenceGate.j(n5);
            if (n7 == (n6 + 2) % 4) {
                n5 = n6;
            }
            world.setData(n, n2, n3, n5 | 4, 2);
        }
        world.a(entityHuman, 1003, n, n2, n3, 0);
        return true;
    }

    @Override
    public void doPhysics(World world, int n, int n2, int n3, int n4) {
        if (world.isStatic) {
            return;
        }
        int n5 = world.getData(n, n2, n3);
        boolean bl = world.isBlockIndirectlyPowered(n, n2, n3);
        if (bl || n4 > 0 && Block.byId[n4].isPowerSource()) {
            if (bl && !BlockFenceGate.m_(n5)) {
                world.setData(n, n2, n3, n5 | 4, 2);
                world.a(null, 1003, n, n2, n3, 0);
            } else if (!bl && BlockFenceGate.m_(n5)) {
                world.setData(n, n2, n3, n5 & 0xFFFFFFFB, 2);
                world.a(null, 1003, n, n2, n3, 0);
            }
        }
    }

    public static boolean m_(int n) {
        return (n & 4) != 0;
    }
}

