/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.BlockDispenser;
import net.minecraft.server.DispenseBehaviorItem;
import net.minecraft.server.Facing;
import net.minecraft.server.IDispenseBehavior;
import net.minecraft.server.IInventory;
import net.minecraft.server.ItemStack;
import net.minecraft.server.SourceBlock;
import net.minecraft.server.TileEntity;
import net.minecraft.server.TileEntityDispenser;
import net.minecraft.server.TileEntityDropper;
import net.minecraft.server.TileEntityHopper;
import net.minecraft.server.World;

public class BlockDropper
extends BlockDispenser {
    private final IDispenseBehavior cX = new DispenseBehaviorItem();

    protected BlockDropper(int n) {
        super(n);
    }

    @Override
    protected IDispenseBehavior a(ItemStack itemStack) {
        return this.cX;
    }

    @Override
    public TileEntity b(World world) {
        return new TileEntityDropper();
    }

    @Override
    protected void dispense(World world, int n, int n2, int n3) {
        SourceBlock sourceBlock = new SourceBlock(world, n, n2, n3);
        TileEntityDispenser tileEntityDispenser = (TileEntityDispenser)sourceBlock.getTileEntity();
        if (tileEntityDispenser == null) {
            return;
        }
        int n4 = tileEntityDispenser.j();
        if (n4 < 0) {
            world.triggerEffect(1001, n, n2, n3, 0);
        } else {
            ItemStack itemStack;
            ItemStack itemStack2 = tileEntityDispenser.getItem(n4);
            int n5 = world.getData(n, n2, n3) & 7;
            IInventory iInventory = TileEntityHopper.getInventoryAt(world, n + Facing.b[n5], n2 + Facing.c[n5], n3 + Facing.d[n5]);
            if (iInventory != null) {
                itemStack = TileEntityHopper.addItem(iInventory, itemStack2.cloneItemStack().a(1), Facing.OPPOSITE_FACING[n5]);
                if (itemStack == null) {
                    itemStack = itemStack2.cloneItemStack();
                    if (--itemStack.count == 0) {
                        itemStack = null;
                    }
                } else {
                    itemStack = itemStack2.cloneItemStack();
                }
            } else {
                itemStack = this.cX.a(sourceBlock, itemStack2);
                if (itemStack != null && itemStack.count == 0) {
                    itemStack = null;
                }
            }
            tileEntityDispenser.setItem(n4, itemStack);
        }
    }
}

