/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Random;
import net.minecraft.server.Block;
import net.minecraft.server.BlockContainer;
import net.minecraft.server.BlockPiston;
import net.minecraft.server.Container;
import net.minecraft.server.CreativeModeTab;
import net.minecraft.server.DispenseBehaviorItem;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EnumFacing;
import net.minecraft.server.IDispenseBehavior;
import net.minecraft.server.IInventory;
import net.minecraft.server.IPosition;
import net.minecraft.server.IRegistry;
import net.minecraft.server.ISourceBlock;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.Position;
import net.minecraft.server.RegistryDefault;
import net.minecraft.server.SourceBlock;
import net.minecraft.server.TileEntity;
import net.minecraft.server.TileEntityDispenser;
import net.minecraft.server.World;

public class BlockDispenser
extends BlockContainer {
    public static final IRegistry a = new RegistryDefault(new DispenseBehaviorItem());
    protected Random b = new Random();

    protected BlockDispenser(int n) {
        super(n, Material.STONE);
        this.a(CreativeModeTab.d);
    }

    @Override
    public int a(World world) {
        return 4;
    }

    @Override
    public void onPlace(World world, int n, int n2, int n3) {
        super.onPlace(world, n, n2, n3);
        this.k(world, n, n2, n3);
    }

    private void k(World world, int n, int n2, int n3) {
        if (world.isStatic) {
            return;
        }
        int n4 = world.getTypeId(n, n2, n3 - 1);
        int n5 = world.getTypeId(n, n2, n3 + 1);
        int n6 = world.getTypeId(n - 1, n2, n3);
        int n7 = world.getTypeId(n + 1, n2, n3);
        int n8 = 3;
        if (Block.t[n4] && !Block.t[n5]) {
            n8 = 3;
        }
        if (Block.t[n5] && !Block.t[n4]) {
            n8 = 2;
        }
        if (Block.t[n6] && !Block.t[n7]) {
            n8 = 5;
        }
        if (Block.t[n7] && !Block.t[n6]) {
            n8 = 4;
        }
        world.setData(n, n2, n3, n8, 2);
    }

    @Override
    public boolean interact(World world, int n, int n2, int n3, EntityHuman entityHuman, int n4, float f, float f2, float f3) {
        if (world.isStatic) {
            return true;
        }
        TileEntityDispenser tileEntityDispenser = (TileEntityDispenser)world.getTileEntity(n, n2, n3);
        if (tileEntityDispenser != null) {
            entityHuman.openDispenser(tileEntityDispenser);
        }
        return true;
    }

    protected void dispense(World world, int n, int n2, int n3) {
        SourceBlock sourceBlock = new SourceBlock(world, n, n2, n3);
        TileEntityDispenser tileEntityDispenser = (TileEntityDispenser)sourceBlock.getTileEntity();
        if (tileEntityDispenser == null) {
            return;
        }
        int n4 = tileEntityDispenser.j();
        if (n4 < 0) {
            world.triggerEffect(1001, n, n2, n3, 0);
        } else {
            ItemStack itemStack = tileEntityDispenser.getItem(n4);
            IDispenseBehavior iDispenseBehavior = this.a(itemStack);
            if (iDispenseBehavior != IDispenseBehavior.a) {
                ItemStack itemStack2 = iDispenseBehavior.a(sourceBlock, itemStack);
                tileEntityDispenser.setItem(n4, itemStack2.count == 0 ? null : itemStack2);
            }
        }
    }

    protected IDispenseBehavior a(ItemStack itemStack) {
        return (IDispenseBehavior)a.a(itemStack.getItem());
    }

    @Override
    public void doPhysics(World world, int n, int n2, int n3, int n4) {
        boolean bl;
        boolean bl2 = world.isBlockIndirectlyPowered(n, n2, n3) || world.isBlockIndirectlyPowered(n, n2 + 1, n3);
        int n5 = world.getData(n, n2, n3);
        boolean bl3 = bl = (n5 & 8) != 0;
        if (bl2 && !bl) {
            world.a(n, n2, n3, this.id, this.a(world));
            world.setData(n, n2, n3, n5 | 8, 4);
        } else if (!bl2 && bl) {
            world.setData(n, n2, n3, n5 & 0xFFFFFFF7, 4);
        }
    }

    @Override
    public void a(World world, int n, int n2, int n3, Random random) {
        if (!world.isStatic) {
            this.dispense(world, n, n2, n3);
        }
    }

    @Override
    public TileEntity b(World world) {
        return new TileEntityDispenser();
    }

    @Override
    public void postPlace(World world, int n, int n2, int n3, EntityLiving entityLiving, ItemStack itemStack) {
        int n4 = BlockPiston.a(world, n, n2, n3, entityLiving);
        world.setData(n, n2, n3, n4, 2);
        if (itemStack.hasName()) {
            ((TileEntityDispenser)world.getTileEntity(n, n2, n3)).a(itemStack.getName());
        }
    }

    @Override
    public void remove(World world, int n, int n2, int n3, int n4, int n5) {
        TileEntityDispenser tileEntityDispenser = (TileEntityDispenser)world.getTileEntity(n, n2, n3);
        if (tileEntityDispenser != null) {
            for (int i = 0; i < tileEntityDispenser.getSize(); ++i) {
                ItemStack itemStack = tileEntityDispenser.getItem(i);
                if (itemStack == null) continue;
                float f = this.b.nextFloat() * 0.8f + 0.1f;
                float f2 = this.b.nextFloat() * 0.8f + 0.1f;
                float f3 = this.b.nextFloat() * 0.8f + 0.1f;
                while (itemStack.count > 0) {
                    int n6 = this.b.nextInt(21) + 10;
                    if (n6 > itemStack.count) {
                        n6 = itemStack.count;
                    }
                    itemStack.count -= n6;
                    EntityItem entityItem = new EntityItem(world, (float)n + f, (float)n2 + f2, (float)n3 + f3, new ItemStack(itemStack.id, n6, itemStack.getData()));
                    if (itemStack.hasTag()) {
                        entityItem.getItemStack().setTag((NBTTagCompound)itemStack.getTag().clone());
                    }
                    float f4 = 0.05f;
                    entityItem.motX = (float)this.b.nextGaussian() * f4;
                    entityItem.motY = (float)this.b.nextGaussian() * f4 + 0.2f;
                    entityItem.motZ = (float)this.b.nextGaussian() * f4;
                    world.addEntity(entityItem);
                }
            }
            world.m(n, n2, n3, n4);
        }
        super.remove(world, n, n2, n3, n4, n5);
    }

    public static IPosition a(ISourceBlock iSourceBlock) {
        EnumFacing enumFacing = BlockDispenser.l_(iSourceBlock.h());
        double d = iSourceBlock.getX() + 0.7 * (double)enumFacing.c();
        double d2 = iSourceBlock.getY() + 0.7 * (double)enumFacing.d();
        double d3 = iSourceBlock.getZ() + 0.7 * (double)enumFacing.e();
        return new Position(d, d2, d3);
    }

    public static EnumFacing l_(int n) {
        return EnumFacing.a(n & 7);
    }

    @Override
    public boolean q_() {
        return true;
    }

    @Override
    public int b_(World world, int n, int n2, int n3, int n4) {
        return Container.b((IInventory)((Object)world.getTileEntity(n, n2, n3)));
    }
}

