/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Random;
import net.minecraft.server.Block;
import net.minecraft.server.BlockDirectional;
import net.minecraft.server.Direction;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.IBlockAccess;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.World;

public abstract class BlockDiodeAbstract
extends BlockDirectional {
    protected final boolean a;

    protected BlockDiodeAbstract(int n, boolean bl) {
        super(n, Material.ORIENTABLE);
        this.a = bl;
        this.a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public boolean canPlace(World world, int n, int n2, int n3) {
        if (!world.w(n, n2 - 1, n3)) {
            return false;
        }
        return super.canPlace(world, n, n2, n3);
    }

    @Override
    public boolean f(World world, int n, int n2, int n3) {
        if (!world.w(n, n2 - 1, n3)) {
            return false;
        }
        return super.f(world, n, n2, n3);
    }

    @Override
    public void a(World world, int n, int n2, int n3, Random random) {
        int n4 = world.getData(n, n2, n3);
        if (!this.e((IBlockAccess)world, n, n2, n3, n4)) {
            boolean bl = this.d(world, n, n2, n3, n4);
            if (this.a && !bl) {
                world.setTypeIdAndData(n, n2, n3, this.j().id, n4, 2);
            } else if (!this.a) {
                world.setTypeIdAndData(n, n2, n3, this.i().id, n4, 2);
                if (!bl) {
                    world.a(n, n2, n3, this.i().id, this.h(n4), -1);
                }
            }
        }
    }

    @Override
    public int d() {
        return 36;
    }

    protected boolean c(int n) {
        return this.a;
    }

    @Override
    public int c(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        return this.b(iBlockAccess, n, n2, n3, n4);
    }

    @Override
    public int b(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        int n5 = iBlockAccess.getData(n, n2, n3);
        if (!this.c(n5)) {
            return 0;
        }
        int n6 = BlockDiodeAbstract.j(n5);
        if (n6 == 0 && n4 == 3) {
            return this.d(iBlockAccess, n, n2, n3, n5);
        }
        if (n6 == 1 && n4 == 4) {
            return this.d(iBlockAccess, n, n2, n3, n5);
        }
        if (n6 == 2 && n4 == 2) {
            return this.d(iBlockAccess, n, n2, n3, n5);
        }
        if (n6 == 3 && n4 == 5) {
            return this.d(iBlockAccess, n, n2, n3, n5);
        }
        return 0;
    }

    @Override
    public void doPhysics(World world, int n, int n2, int n3, int n4) {
        if (!this.f(world, n, n2, n3)) {
            this.c(world, n, n2, n3, world.getData(n, n2, n3), 0);
            world.setAir(n, n2, n3);
            world.applyPhysics(n + 1, n2, n3, this.id);
            world.applyPhysics(n - 1, n2, n3, this.id);
            world.applyPhysics(n, n2, n3 + 1, this.id);
            world.applyPhysics(n, n2, n3 - 1, this.id);
            world.applyPhysics(n, n2 - 1, n3, this.id);
            world.applyPhysics(n, n2 + 1, n3, this.id);
            return;
        }
        this.f(world, n, n2, n3, n4);
    }

    protected void f(World world, int n, int n2, int n3, int n4) {
        int n5 = world.getData(n, n2, n3);
        if (!this.e((IBlockAccess)world, n, n2, n3, n5)) {
            boolean bl = this.d(world, n, n2, n3, n5);
            if ((this.a && !bl || !this.a && bl) && !world.a(n, n2, n3, this.id)) {
                int n6 = -1;
                if (this.h(world, n, n2, n3, n5)) {
                    n6 = -3;
                } else if (this.a) {
                    n6 = -2;
                }
                world.a(n, n2, n3, this.id, this.k_(n5), n6);
            }
        }
    }

    public boolean e(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        return false;
    }

    protected boolean d(World world, int n, int n2, int n3, int n4) {
        return this.e(world, n, n2, n3, n4) > 0;
    }

    protected int e(World world, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = BlockDiodeAbstract.j(n4);
        int n7 = n + Direction.a[n6];
        int n8 = world.getBlockFacePower(n7, n2, n5 = n3 + Direction.b[n6], Direction.d[n6]);
        if (n8 >= 15) {
            return n8;
        }
        return Math.max(n8, world.getTypeId(n7, n2, n5) == Block.REDSTONE_WIRE.id ? world.getData(n7, n2, n5) : 0);
    }

    protected int f(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        int n5 = BlockDiodeAbstract.j(n4);
        switch (n5) {
            case 0: 
            case 2: {
                return Math.max(this.g(iBlockAccess, n - 1, n2, n3, 4), this.g(iBlockAccess, n + 1, n2, n3, 5));
            }
            case 1: 
            case 3: {
                return Math.max(this.g(iBlockAccess, n, n2, n3 + 1, 3), this.g(iBlockAccess, n, n2, n3 - 1, 2));
            }
        }
        return 0;
    }

    protected int g(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        int n5 = iBlockAccess.getTypeId(n, n2, n3);
        if (this.e(n5)) {
            if (n5 == Block.REDSTONE_WIRE.id) {
                return iBlockAccess.getData(n, n2, n3);
            }
            return iBlockAccess.getBlockPower(n, n2, n3, n4);
        }
        return 0;
    }

    @Override
    public boolean isPowerSource() {
        return true;
    }

    @Override
    public void postPlace(World world, int n, int n2, int n3, EntityLiving entityLiving, ItemStack itemStack) {
        int n4 = ((MathHelper.floor((double)(entityLiving.yaw * 4.0f / 360.0f) + 0.5) & 3) + 2) % 4;
        world.setData(n, n2, n3, n4, 3);
        boolean bl = this.d(world, n, n2, n3, n4);
        if (bl) {
            world.a(n, n2, n3, this.id, 1);
        }
    }

    @Override
    public void onPlace(World world, int n, int n2, int n3) {
        this.h_(world, n, n2, n3);
    }

    protected void h_(World world, int n, int n2, int n3) {
        int n4 = BlockDiodeAbstract.j(world.getData(n, n2, n3));
        if (n4 == 1) {
            world.g(n + 1, n2, n3, this.id);
            world.c(n + 1, n2, n3, this.id, 4);
        }
        if (n4 == 3) {
            world.g(n - 1, n2, n3, this.id);
            world.c(n - 1, n2, n3, this.id, 5);
        }
        if (n4 == 2) {
            world.g(n, n2, n3 + 1, this.id);
            world.c(n, n2, n3 + 1, this.id, 2);
        }
        if (n4 == 0) {
            world.g(n, n2, n3 - 1, this.id);
            world.c(n, n2, n3 - 1, this.id, 3);
        }
    }

    @Override
    public void postBreak(World world, int n, int n2, int n3, int n4) {
        if (this.a) {
            world.applyPhysics(n + 1, n2, n3, this.id);
            world.applyPhysics(n - 1, n2, n3, this.id);
            world.applyPhysics(n, n2, n3 + 1, this.id);
            world.applyPhysics(n, n2, n3 - 1, this.id);
            world.applyPhysics(n, n2 - 1, n3, this.id);
            world.applyPhysics(n, n2 + 1, n3, this.id);
        }
        super.postBreak(world, n, n2, n3, n4);
    }

    @Override
    public boolean c() {
        return false;
    }

    protected boolean e(int n) {
        Block block = Block.byId[n];
        return block != null && block.isPowerSource();
    }

    protected int d(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        return 15;
    }

    public static boolean f(int n) {
        return Block.DIODE_OFF.g(n) || Block.REDSTONE_COMPARATOR_OFF.g(n);
    }

    public boolean g(int n) {
        return n == this.i().id || n == this.j().id;
    }

    public boolean h(World world, int n, int n2, int n3, int n4) {
        int n5 = BlockDiodeAbstract.j(n4);
        if (BlockDiodeAbstract.f(world.getTypeId(n - Direction.a[n5], n2, n3 - Direction.b[n5]))) {
            int n6 = world.getData(n - Direction.a[n5], n2, n3 - Direction.b[n5]);
            int n7 = BlockDiodeAbstract.j(n6);
            return n7 != n5;
        }
        return false;
    }

    protected int h(int n) {
        return this.k_(n);
    }

    protected abstract int k_(int var1);

    protected abstract BlockDiodeAbstract i();

    protected abstract BlockDiodeAbstract j();

    @Override
    public boolean i(int n) {
        return this.g(n);
    }
}

